/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.merge;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.merge.ModelEquality;
import io.openliberty.microprofile.openapi20.internal.merge.NameType;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class NameProcessor {
    private static final TraceComponent tc = Tr.register(NameProcessor.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private final Map<NameType, Map<String, Object>> namesInUse = new HashMap<NameType, Map<String, Object>>();
    static final long serialVersionUID = -231629363155616844L;

    public DocumentNameProcessor createDocumentNameProcessor() {
        return new DocumentNameProcessor();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class DocumentNameProcessor {
        private final Map<NameType, Map<String, String>> renames = new HashMap<NameType, Map<String, String>>();
        private boolean hasRenames = false;
        private static final String NO_VALUE = "NO VALUE";
        static final long serialVersionUID = -4720874936785649768L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private DocumentNameProcessor() {
        }

        @Trivial
        private Map<String, String> getRenameMap(NameType nameType) {
            return this.renames.computeIfAbsent(nameType, k -> new HashMap());
        }

        @Trivial
        private Map<String, Object> getNamesInUse(NameType nameType) {
            return NameProcessor.this.namesInUse.computeIfAbsent(nameType, k -> new HashMap());
        }

        public String createUniqueName(NameType nameType, String oldName, Object value) {
            String newName;
            if (oldName == null) {
                return null;
            }
            Map<String, String> renameMap = this.getRenameMap(nameType);
            String previousRename = renameMap.get(oldName);
            if (previousRename != null) {
                return previousRename;
            }
            Map<String, Object> namesInUse = this.getNamesInUse(nameType);
            Object valueInUse = namesInUse.get(newName = oldName);
            if (!(valueInUse == null || valueInUse != NO_VALUE && ModelEquality.equals(valueInUse, value))) {
                int count = 1;
                newName = oldName + count;
                valueInUse = namesInUse.get(newName);
                while (!(valueInUse == null || valueInUse != NO_VALUE && ModelEquality.equals(valueInUse, value))) {
                    newName = oldName + ++count;
                    valueInUse = namesInUse.get(newName);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Renamed " + (Object)((Object)nameType) + " " + oldName + " -> " + newName), (Object[])new Object[0]);
                }
                this.hasRenames = true;
            }
            namesInUse.put(newName, value == null ? NO_VALUE : value);
            renameMap.put(oldName, newName);
            return newName;
        }

        public String lookupName(NameType nameType, String oldName) {
            return this.getRenameMap(nameType).getOrDefault(oldName, oldName);
        }

        public void registerRename(NameType nameType, String oldName, String newName) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && !oldName.equals(newName)) {
                Tr.event((TraceComponent)tc, (String)("Renamed " + (Object)((Object)nameType) + " " + oldName + " -> " + newName), (Object[])new Object[0]);
            }
            this.hasRenames = true;
            this.getRenameMap(nameType).put(oldName, newName);
        }

        public boolean hasRenames() {
            return this.hasRenames;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.internal.merge.NameProcessor$DocumentNameProcessor", DocumentNameProcessor.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
        }
    }
}

