/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import io.openliberty.microprofile.openapi20.internal.validation.ValidatorUtils;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OperationValidator
extends TypeValidator<Operation> {
    private static final TraceComponent tc = Tr.register(OperationValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final OperationValidator INSTANCE = new OperationValidator();
    static final long serialVersionUID = 5655363186677766372L;

    public static OperationValidator getInstance() {
        return INSTANCE;
    }

    private OperationValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Operation t) {
        if (t != null) {
            String id = t.getOperationId();
            if (id != null && helper.addOperationId(id)) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"operationIdsMustBeUnique", (Object[])new Object[]{id});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("operationId"), message));
            }
            APIResponses responses = t.getResponses();
            ValidatorUtils.validateRequiredField(responses, context, "responses").ifPresent(helper::addValidationEvent);
        }
    }
}

