/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.container.EJBMethodInfoImpl;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.csi.EJBModuleMetaDataImpl;
import com.ibm.ejs.csi.TransactionControlImpl;
import com.ibm.ejs.csi.TxCookieImpl;
import com.ibm.tx.jta.embeddable.EmbeddableTransactionManagerFactory;
import com.ibm.tx.jta.embeddable.LocalTransactionSettings;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSITransactionRequiredException;
import com.ibm.websphere.csi.CSITransactionRolledbackException;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.ExceptionType;
import com.ibm.websphere.csi.MethodInterface;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.uow.UOWSynchronizationRegistry;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.LocalTransaction.RolledbackException;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.traceinfo.ejbcontainer.TETxLifeCycleInfo;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.ws.uow.embeddable.UOWCompensatedException;
import com.ibm.wsspi.uow.UOWManagerFactory;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;

abstract class TranStrategy {
    private static final String CLASS_NAME = TranStrategy.class.getName();
    private static final TraceComponent tc = Tr.register(TranStrategy.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final UOWSynchronizationRegistry svUOWSynchReg = UOWManagerFactory.getUOWManager();
    protected TransactionControlImpl txCtrl;
    protected LocalTransactionCurrent ltcCurrent;
    private EmbeddableWebSphereTransactionManager txManager = EmbeddableTransactionManagerFactory.getTransactionManager();

    protected TranStrategy(TransactionControlImpl txCtrl) {
        this.txCtrl = txCtrl;
        this.ltcCurrent = EmbeddableTransactionManagerFactory.getLocalTransactionCurrent();
    }

    abstract TxCookieImpl preInvoke(EJBKey var1, EJBMethodInfoImpl var2) throws CSIException;

    void postInvoke(EJBKey key, TxCookieImpl cookie, EJBMethodInfoImpl methodInfo) throws CSIException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"postInvoke", (Object[])new Object[0]);
        }
        if (cookie.beginner) {
            if (this.txCtrl.getRollbackOnly()) {
                CSITransactionRolledbackException timeoutEx = null;
                try {
                    this.txCtrl.completeTxTimeout();
                }
                catch (CSITransactionRolledbackException ex) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"tran timed out; will throw ex after rollback", (Object[])new Object[0]);
                    }
                    timeoutEx = ex;
                }
                this.rollback(true, key, methodInfo);
                if (timeoutEx != null) {
                    if (isTraceOn && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("postInvoke : " + timeoutEx));
                    }
                    throw timeoutEx;
                }
                MethodInterface methodType = methodInfo.getInterfaceType();
                BeanMetaData bmd = methodInfo.getBeanMetaData();
                EJBModuleMetaDataImpl mmd = bmd._moduleMetaData;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("EJBModuleMetaDataImpl.ivUseExtendedSetRollbackOnlyBehavior = " + mmd.ivUseExtendedSetRollbackOnlyBehavior), (Object[])new Object[0]);
                }
                if (!mmd.ivUseExtendedSetRollbackOnlyBehavior || methodType == MethodInterface.MESSAGE_LISTENER || methodType == MethodInterface.TIMED_OBJECT) {
                    if (isTraceOn && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"postInvoke : Transaction marked rollbackonly");
                    }
                    throw new CSITransactionRolledbackException("Transaction marked rollbackonly");
                }
            } else {
                this.commit(key, methodInfo);
            }
        } else {
            this.txCtrl.completeTxTimeout();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"postInvoke");
        }
    }

    void handleException(EJBKey key, TxCookieImpl txCookie, ExceptionType type, EJBMethodInfoImpl methodInfo) throws CSIException {
        if (type == ExceptionType.CHECKED_EXCEPTION) {
            this.postInvoke(key, txCookie, methodInfo);
            return;
        }
        if (txCookie.beginner) {
            this.rollback(true, key, methodInfo);
            return;
        }
        if (this.globalTxExists(false)) {
            this.txCtrl.completeTxTimeout();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"handleException: marking client transaction rollbackOnly", (Object[])new Object[0]);
            }
            this.rollback(false, key, methodInfo);
            throw new CSITransactionRolledbackException();
        }
        LocalTransactionCoordinator coord = this.ltcCurrent.getLocalTranCoord();
        if (coord != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"handleException: marking client LTC rollbackOnly", (Object[])new Object[0]);
            }
            coord.setRollbackOnly();
        }
    }

    final TxCookieImpl beginLocalTx(EJBKey ejbKey, EJBMethodInfoImpl methodInfo, Transaction suspendedGlobalTx) throws CSIException {
        LocalTransactionCoordinator suspendedLocalTx;
        BeanMetaData bmd = methodInfo.getBeanMetaData();
        int EJBType2 = bmd.getEJBComponentType();
        LocalTransactionSettings ltcSettings = bmd._localTran;
        boolean ltcBoundaryIsAS = ltcSettings.getBoundary() == 1;
        boolean suspendedLocalTxFound = false;
        LocalTransactionCoordinator savedLocalTx = null;
        boolean begunLocalTx = false;
        if (ltcBoundaryIsAS && (EJBType2 == 4 || EJBType2 == 5 || EJBType2 == 6) && (suspendedLocalTx = (LocalTransactionCoordinator)this.txCtrl.stickyLocalTxTable.remove((Object)ejbKey)) != null) {
            suspendedLocalTxFound = true;
            try {
                savedLocalTx = this.suspendLocalTx();
                this.resumeLocalTx(suspendedLocalTx);
                begunLocalTx = true;
            }
            catch (Throwable ex) {
                block29: {
                    FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".beginLocalTx"), (String)"200", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Local tx resume failed", (Object[])new Object[]{ex});
                    }
                    if (savedLocalTx != null) {
                        try {
                            this.resumeLocalTx(savedLocalTx);
                        }
                        catch (Throwable ex2) {
                            FFDCFilter.processException((Throwable)ex2, (String)(CLASS_NAME + ".beginLocalTx"), (String)"212", (Object)this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block29;
                            Tr.event((TraceComponent)tc, (String)"Saved local tx resume failed", (Object[])new Object[]{ex2});
                        }
                    }
                }
                throw new CSIException("Resume local tx failed", ex);
            }
        }
        if (!suspendedLocalTxFound) {
            try {
                boolean ltcUnresActionIsCommit = ltcSettings.getUnresolvedAction() == 1;
                boolean ltcResolverIsCAB = ltcSettings.getResolver() == 1;
                boolean ltcShareable = ltcSettings.isShareable();
                LocalTransactionCoordinator coord = this.ltcCurrent.getLocalTranCoord();
                if (coord == null) {
                    if (ltcShareable) {
                        this.ltcCurrent.beginShareable(ltcBoundaryIsAS, ltcUnresActionIsCommit, ltcResolverIsCAB);
                    } else {
                        this.ltcCurrent.begin(ltcBoundaryIsAS, ltcUnresActionIsCommit, ltcResolverIsCAB);
                    }
                    svUOWSynchReg.putResource((Object)"com.ibm.websphere.profile", (Object)methodInfo.getJPATaskName());
                    begunLocalTx = true;
                } else if (coord.isShareable() && ltcShareable) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"LTC context shared", (Object[])new Object[0]);
                    }
                } else {
                    savedLocalTx = this.suspendLocalTx();
                    if (ltcShareable) {
                        this.ltcCurrent.beginShareable(ltcBoundaryIsAS, ltcUnresActionIsCommit, ltcResolverIsCAB);
                    } else {
                        this.ltcCurrent.begin(ltcBoundaryIsAS, ltcUnresActionIsCommit, ltcResolverIsCAB);
                    }
                    svUOWSynchReg.putResource((Object)"com.ibm.websphere.profile", (Object)methodInfo.getJPATaskName());
                    begunLocalTx = true;
                }
                if (TraceComponent.isAnyTracingEnabled() && (tc.isEventEnabled() || TETxLifeCycleInfo.isTraceEnabled())) {
                    LocalTransactionCoordinator lCoord = this.txCtrl.getLocalCoord();
                    if (tc.isEventEnabled()) {
                        if (lCoord != null) {
                            Tr.event((TraceComponent)tc, (String)("Began LTC cntxt: tid=" + Integer.toHexString(lCoord.hashCode()) + "(LTC)"), (Object[])new Object[0]);
                        } else {
                            Tr.event((TraceComponent)tc, (String)"Began LTC cntxt: null Coordinator!", (Object[])new Object[0]);
                        }
                        if (begunLocalTx) {
                            Tr.event((TraceComponent)tc, (String)("Set JPA task name: " + methodInfo.getJPATaskName()), (Object[])new Object[0]);
                        }
                    }
                    if (lCoord != null && TETxLifeCycleInfo.isTraceEnabled()) {
                        TETxLifeCycleInfo.traceLocalTxBegin("" + System.identityHashCode(lCoord), "Begin Local Tx");
                    }
                }
            }
            catch (Exception ex) {
                block30: {
                    FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".beginLocalTx"), (String)"217", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Begin local tx failed", (Object[])new Object[]{ex});
                    }
                    if (savedLocalTx != null) {
                        try {
                            this.resumeLocalTx(savedLocalTx);
                        }
                        catch (Throwable ex2) {
                            FFDCFilter.processException((Throwable)ex2, (String)(CLASS_NAME + ".beginLocalTx"), (String)"242", (Object)this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block30;
                            Tr.event((TraceComponent)tc, (String)"Saved local tx resume failed", (Object[])new Object[]{ex2});
                        }
                    }
                }
                throw new CSIException("Begin local tx failed", ex);
            }
        }
        TxCookieImpl cookie = new TxCookieImpl(begunLocalTx, true, this, suspendedGlobalTx);
        cookie.suspendedLocalTx = savedLocalTx;
        return cookie;
    }

    final LocalTransactionCoordinator suspendLocalTx() {
        LocalTransactionCoordinator currentLTC;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEventEnabled() && (currentLTC = this.ltcCurrent.getLocalTranCoord()) != null) {
            Tr.event((TraceComponent)tc, (String)("Suspending LTC cntxt: tid=" + Integer.toHexString(currentLTC.hashCode()) + "(LTC)"), (Object[])new Object[0]);
        }
        LocalTransactionCoordinator suspendedLocalTx = this.ltcCurrent.suspend();
        if (isTraceOn && suspendedLocalTx != null && TETxLifeCycleInfo.isTraceEnabled()) {
            TETxLifeCycleInfo.traceLocalTxSuspend("" + System.identityHashCode(suspendedLocalTx), "Suspend Local Tx");
        }
        return suspendedLocalTx;
    }

    final void resumeLocalTx(LocalTransactionCoordinator lCoord) throws IllegalStateException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEventEnabled()) {
            if (lCoord != null) {
                Tr.event((TraceComponent)tc, (String)("Resuming LTC cntxt: tid=" + Integer.toHexString(lCoord.hashCode()) + "(LTC)"), (Object[])new Object[0]);
            } else {
                Tr.event((TraceComponent)tc, (String)"Resuming LTC cntxt: null Coordinator!", (Object[])new Object[0]);
            }
        }
        this.ltcCurrent.resume(lCoord);
        if (isTraceOn && lCoord != null && TETxLifeCycleInfo.isTraceEnabled()) {
            TETxLifeCycleInfo.traceLocalTxResume("" + System.identityHashCode(lCoord), "Resume Local Tx");
        }
    }

    final boolean globalTxExists(boolean failIfNonInterop) throws CSIException {
        Transaction tx;
        block4: {
            tx = null;
            try {
                tx = this.txManager.getTransaction();
            }
            catch (SystemException se) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                Tr.event((TraceComponent)tc, (String)"Could not determine if there is a global tx active", (Object[])new Object[0]);
            }
        }
        if (failIfNonInterop && tx != null && ((UOWCoordinator)tx).getTxType() == 2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Cannot proceed under a non-interoperable transaction context", (Object[])new Object[0]);
            }
            throw new CSITransactionRequiredException("Interoperable global transaction required");
        }
        return tx != null;
    }

    final void beginGlobalTx(EJBKey key, EJBMethodInfoImpl methodInfo) throws CSIException {
        try {
            this.txCtrl.txService.begin();
            svUOWSynchReg.putResource((Object)"com.ibm.websphere.profile", (Object)methodInfo.getJPATaskName());
            if (TraceComponent.isAnyTracingEnabled()) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Began TX cntxt: " + this.txCtrl.txService.getTransaction()), (Object[])new Object[0]);
                    Tr.event((TraceComponent)tc, (String)("Set JPA task name: " + methodInfo.getJPATaskName()), (Object[])new Object[0]);
                }
                if (TETxLifeCycleInfo.isTraceEnabled()) {
                    int idx;
                    String idStr = this.txCtrl.txService.getTransaction().toString();
                    idStr = idStr != null ? ((idx = idStr.indexOf("(")) != -1 ? idStr.substring(idx + 1, idStr.indexOf(")")) : ((idx = idStr.indexOf("tid=")) != -1 ? idStr.substring(idx + 4) : idStr)) : "NoTx";
                    TETxLifeCycleInfo.traceGlobalTxBegin(idStr, "Begin Global Tx");
                }
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".beginGlobalTx"), (String)"243", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Begin global tx failed", (Object[])new Object[]{ex});
            }
            throw new CSIException("Begin global tx failed", ex);
        }
    }

    final Transaction suspendGlobalTx(int action) throws CSIException {
        Transaction result = this.txCtrl.suspendGlobalTx(action);
        if (TraceComponent.isAnyTracingEnabled() && TETxLifeCycleInfo.isTraceEnabled()) {
            TETxLifeCycleInfo.traceGlobalTxSuspend("NoTx", "Suspend Global Tx");
        }
        return result;
    }

    final void resumeGlobalTx(Transaction control, int action) throws CSIException {
        try {
            this.txCtrl.resumeGlobalTx(control, action);
            if (TraceComponent.isAnyTracingEnabled() && TETxLifeCycleInfo.isTraceEnabled()) {
                int idx;
                String idStr = this.txCtrl.txService.getTransaction().toString();
                idStr = idStr != null ? ((idx = idStr.indexOf("(")) != -1 ? idStr.substring(idx + 1, idStr.indexOf(")")) : ((idx = idStr.indexOf("tid=")) != -1 ? idStr.substring(idx + 4) : idStr)) : "NoTx";
                TETxLifeCycleInfo.traceGlobalTxResume(idStr, "Resume Global Tx");
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".resumeGlobalTx"), (String)"335", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Global tx resume failed", (Object[])new Object[]{ex});
            }
            throw new CSIException("", ex);
        }
    }

    private void endASLocalTx(EJBKey key, EJBMethodInfoImpl methodInfo, LocalTransactionCoordinator lCoord, boolean rollback) {
        int type = methodInfo.getBeanMetaData().getEJBComponentType();
        if (!methodInfo.isHome() && type != 7) {
            if (rollback) {
                lCoord.setRollbackOnly();
            }
            this.suspendLocalTx();
            if (!(type != 4 && type != 5 && type != 6 || methodInfo.isBeanRemove())) {
                this.txCtrl.stickyLocalTxTable.put((Object)key, (Object)lCoord);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void commit(EJBKey key, EJBMethodInfoImpl methodInfo) throws CSITransactionRolledbackException {
        LocalTransactionCoordinator lCoord = this.ltcCurrent.getLocalTranCoord();
        if (lCoord != null) {
            if (lCoord.isASScoped()) {
                this.endASLocalTx(key, methodInfo, lCoord, false);
                return;
            } else {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Completing LTC cntxt: tid=" + Integer.toHexString(lCoord.hashCode()) + "(LTC)"), (Object[])new Object[0]);
                    }
                    lCoord.end(0);
                    if (!TraceComponent.isAnyTracingEnabled() || !TETxLifeCycleInfo.isTraceEnabled()) return;
                    TETxLifeCycleInfo.traceLocalTxCommit("" + System.identityHashCode(lCoord), "Commit Local Tx - end");
                    return;
                }
                catch (Exception ex2) {
                    FFDCFilter.processException((Throwable)ex2, (String)(CLASS_NAME + ".commit"), (String)"277", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Local tx completion failed", (Object[])new Object[]{ex2});
                    }
                    if (!ContainerProperties.ExcludeNestedExceptions) throw new CSITransactionRolledbackException("", ex2);
                    Throwable ex2 = null;
                    throw new CSITransactionRolledbackException("", ex2);
                }
            }
        }
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Committing TX cntxt: " + this.txCtrl.txService.getTransaction()), (Object[])new Object[0]);
            }
            this.txCtrl.txService.commit();
            if (!TraceComponent.isAnyTracingEnabled() || !TETxLifeCycleInfo.isTraceEnabled()) return;
            TETxLifeCycleInfo.traceGlobalTxCommit("NoTx", "Commit Global Tx");
            return;
        }
        catch (HeuristicMixedException hme) {
            FFDCFilter.processException((Throwable)hme, (String)(CLASS_NAME + ".commit"), (String)"856", (Object)this);
            if (!tc.isEventEnabled()) throw new CSITransactionRolledbackException("", hme);
            Tr.event((TraceComponent)tc, (String)"Global tx commit failed Heuristically", (Object[])new Object[]{hme});
            throw new CSITransactionRolledbackException("", hme);
        }
        catch (Exception ex3) {
            FFDCFilter.processException((Throwable)ex3, (String)(CLASS_NAME + ".commit"), (String)"294", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Global tx commit failed", (Object[])new Object[]{ex3});
            }
            if (!ContainerProperties.ExcludeNestedExceptions) throw new CSITransactionRolledbackException("", ex3);
            Throwable ex3 = null;
            throw new CSITransactionRolledbackException("", ex3);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void rollback(boolean beginner, EJBKey key, EJBMethodInfoImpl methodInfo) throws CSIException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        LocalTransactionCoordinator lCoord = this.ltcCurrent.getLocalTranCoord();
        if (lCoord != null) {
            if (lCoord.isASScoped()) {
                this.endASLocalTx(key, methodInfo, lCoord, true);
                return;
            } else {
                try {
                    if (isTraceOn && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Completing LTC cntxt with rollback due to bean exception: tid=" + Integer.toHexString(lCoord.hashCode()) + "(LTC)"), (Object[])new Object[0]);
                    }
                    lCoord.setRollbackOnly();
                    lCoord.end(1);
                    if (!isTraceOn || !TETxLifeCycleInfo.isTraceEnabled()) return;
                    TETxLifeCycleInfo.traceLocalTxRollback("" + System.identityHashCode(lCoord), "Rollback Local Tx - end");
                    return;
                }
                catch (RolledbackException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".rollback"), (String)"375", (Object)this);
                    return;
                }
                catch (UOWCompensatedException ex) {
                    EJSDeployedSupport s = EJSContainer.getMethodContext();
                    if (s.getException() == null) {
                        FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".rollback"), (String)"1129", (Object)this);
                        String errStr = "Could not complete local tx";
                        if (!isTraceOn || !tc.isEventEnabled()) throw new CSIException(errStr, ex);
                        Tr.event((TraceComponent)tc, (String)errStr, (Object[])new Object[]{ex});
                        throw new CSIException(errStr, ex);
                    }
                    if (!isTraceOn || !tc.isDebugEnabled()) return;
                    Tr.debug((TraceComponent)tc, (String)("Ignoring UOWCompensatedException; another exception already reported : " + s.getException()), (Object[])new Object[]{ex});
                    return;
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".rollback"), (String)"378", (Object)this);
                    String errStr = "Could not complete local tx";
                    if (!isTraceOn || !tc.isEventEnabled()) throw new CSIException(errStr, ex);
                    Tr.event((TraceComponent)tc, (String)errStr, (Object[])new Object[]{ex});
                    throw new CSIException(errStr, ex);
                }
            }
        }
        try {
            if (beginner) {
                if (isTraceOn && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Rolling back TX cntxt due to bean exception: " + this.txCtrl.txService.getTransaction()), (Object[])new Object[0]);
                }
                this.txCtrl.txService.rollback();
                if (!isTraceOn || !TETxLifeCycleInfo.isTraceEnabled()) return;
                TETxLifeCycleInfo.traceGlobalTxRollback("NoTx", "Rollback Global Tx");
                return;
            } else {
                if (isTraceOn && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Marking TX cntxt for rollback due to bean exception: " + this.txCtrl.txService.getTransaction()), (Object[])new Object[0]);
                }
                this.txCtrl.txService.setRollbackOnly();
            }
            return;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".rollback"), (String)"405", (Object)this);
            String errStr = "Could not roll back global tx";
            if (!isTraceOn || !tc.isEventEnabled()) throw new CSIException(errStr, ex);
            Tr.event((TraceComponent)tc, (String)errStr, (Object[])new Object[]{ex});
            throw new CSIException(errStr, ex);
        }
    }

    boolean isBmtActive() {
        return false;
    }
}

