/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.cache;

import com.ibm.ejs.util.cache.Bucket;
import com.ibm.ejs.util.cache.Element;
import com.ibm.ejs.util.cache.IllegalOperationException;
import java.util.Arrays;

final class BucketImpl
implements Bucket {
    static final int DEFAULT_CAPACITY = 10;
    private Element[] ivElements;
    private int ivHeadIndex;
    private int ivTailIndex;

    BucketImpl() {
    }

    @Override
    public Element findByKey(Object key) {
        for (int i = this.size() - 1; i >= 0; --i) {
            Element element = this.get(i);
            if (!element.key.equals(key)) continue;
            return element;
        }
        return null;
    }

    @Override
    public Element insertByKey(Object key, Object object) {
        Element element = new Element(this, key, object);
        this.add(element);
        return element;
    }

    @Override
    public Element discardByKey(Object key) {
        int i = this.findIndexByKey(key);
        Element element = null;
        if (i != -1) {
            element = this.get(i);
            if (element.pinned > 0) {
                return null;
            }
            this.remove(i);
        }
        return element;
    }

    @Override
    public Element removeByKey(Object key) {
        return this.removeByKey(key, false);
    }

    @Override
    public Element removeByKey(Object key, boolean dropRef) {
        int i = this.findIndexByKey(key);
        Element element = null;
        if (i != -1) {
            element = this.get(i);
            if (!dropRef && element.pinned > 0 || dropRef && element.pinned > 1) {
                throw new IllegalOperationException(key, element.pinned);
            }
            this.remove(i);
        }
        return element;
    }

    private int findIndexByKey(Object key) {
        for (int i = this.size() - 1; i >= 0; --i) {
            Element element = this.get(i);
            if (!element.key.equals(key)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.ivTailIndex == this.ivHeadIndex;
    }

    @Override
    public int size() {
        return this.ivTailIndex - this.ivHeadIndex;
    }

    @Override
    public void toArray(Element[] dest) {
        if (this.ivElements != null) {
            System.arraycopy(this.ivElements, this.ivHeadIndex, dest, 0, this.size());
        }
    }

    private Element get(int listIndex) {
        return this.ivElements[this.ivHeadIndex + listIndex];
    }

    private void add(Element element) {
        if (this.ivElements == null) {
            this.ivElements = new Element[10];
        } else if (this.ivTailIndex == this.ivElements.length) {
            int size = this.size();
            int halfCapacity = this.ivElements.length >> 1;
            if (this.ivHeadIndex > halfCapacity) {
                System.arraycopy(this.ivElements, this.ivHeadIndex, this.ivElements, 0, size);
                Arrays.fill(this.ivElements, this.ivHeadIndex, this.ivElements.length, null);
            } else {
                Element[] newElements = new Element[this.ivElements.length + halfCapacity];
                System.arraycopy(this.ivElements, this.ivHeadIndex, newElements, 0, size);
                this.ivElements = newElements;
            }
            this.ivHeadIndex = 0;
            this.ivTailIndex = size;
        }
        this.ivElements[this.ivTailIndex++] = element;
    }

    private void remove(int listIndex) {
        if (listIndex == 0) {
            this.ivElements[this.ivHeadIndex++] = null;
        } else if (listIndex == this.ivTailIndex - 1) {
            this.ivElements[--this.ivTailIndex] = null;
        } else {
            int size = this.size();
            int halfSize = size >> 1;
            if (listIndex < halfSize) {
                System.arraycopy(this.ivElements, this.ivHeadIndex, this.ivElements, this.ivHeadIndex + 1, listIndex);
                this.ivElements[this.ivHeadIndex++] = null;
            } else {
                int arrayIndex = this.ivHeadIndex + listIndex;
                System.arraycopy(this.ivElements, arrayIndex + 1, this.ivElements, arrayIndex, size - listIndex - 1);
                this.ivElements[--this.ivTailIndex] = null;
            }
        }
        if (this.isEmpty()) {
            this.ivHeadIndex = 0;
            this.ivTailIndex = 0;
        }
    }
}

