/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejb.portable;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerHelper {
    private static final String CLASS_NAME = LoggerHelper.class.getName();
    private static final Logger svLogger = Logger.getLogger(CLASS_NAME);
    private static volatile boolean svCheckedForWAS;
    private static Method svAddLoggerToGroupMethod;

    public static Logger getLogger(String className, String groupName) {
        Logger logger = Logger.getLogger(className);
        if (!svCheckedForWAS) {
            try {
                Class<?> loggerHelperClass = Class.forName("com.ibm.ws.logging.LoggerHelper");
                svAddLoggerToGroupMethod = loggerHelperClass.getMethod("addLoggerToGroup", Logger.class, String.class);
            }
            catch (Exception ex) {
                svLogger.logp(Level.FINE, CLASS_NAME, "getLogger", "failed to find addLoggerToGroup method", ex);
            }
            svCheckedForWAS = true;
        }
        if (svAddLoggerToGroupMethod != null) {
            try {
                svAddLoggerToGroupMethod.invoke(null, logger, groupName);
            }
            catch (IllegalAccessException ex) {
                svLogger.logp(Level.FINE, CLASS_NAME, "getLogger", "addLoggerToGroup failed", ex);
            }
            catch (InvocationTargetException ex) {
                svLogger.logp(Level.FINE, CLASS_NAME, "getLogger", "addLoggerToGroup failed", ex);
            }
        }
        return logger;
    }
}

