/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.diagnostics;

import com.ibm.ws.ejbcontainer.diagnostics.IntrospectionWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class TextIntrospectionWriter
implements IntrospectionWriter {
    protected static final String HEADING_0 = "----";
    protected static final String HEADING_1 = "****";
    private static final String INDENT = "   ";
    final List<String> titles = new ArrayList<String>();
    boolean previousEnded;
    boolean currentContent;
    final StringBuilder indent = new StringBuilder();

    private void flushNewline(boolean force) {
        if (this.previousEnded || force) {
            this.writeln("");
            this.previousEnded = false;
        }
    }

    @Override
    public final void begin(String title) {
        this.flushNewline(this.currentContent);
        this.currentContent = false;
        if (title != null) {
            if (this.titles.isEmpty()) {
                String line = "---- " + title + ' ' + HEADING_0;
                this.writeln(line);
                char[] separatorline = new char[line.length()];
                Arrays.fill(separatorline, '-');
                this.writeln(new String(separatorline));
            } else {
                String marker = this.titles.size() == 1 ? HEADING_0 : HEADING_1;
                this.writeln(this.indent + marker + ' ' + title + ' ' + marker);
                this.indent.append(INDENT);
            }
        }
        this.titles.add(title);
    }

    @Override
    public final void end() {
        String title = this.titles.remove(this.titles.size() - 1);
        if (title != null) {
            if (this.indent.length() > 0) {
                this.indent.setLength(this.indent.length() - INDENT.length());
            }
            if (this.titles.isEmpty()) {
                this.writeln(this.indent + HEADING_0 + " " + title + " End " + HEADING_0);
            }
        }
        this.previousEnded = true;
    }

    @Override
    public final void println(String line) {
        this.flushNewline(false);
        this.writeln(this.indent + line);
        this.currentContent = true;
    }

    @Override
    public final void dump(String[] dumpData) {
        for (String line : dumpData) {
            this.println(line);
        }
    }

    protected abstract void writeln(String var1);
}

