/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.injection.factory;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJBNotFoundException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSWrapper;
import com.ibm.ejs.container.HomeOfHomes;
import com.ibm.ejs.container.HomeRecord;
import com.ibm.websphere.ejbcontainer.AmbiguousEJBReferenceException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.injection.factory.EJBLinkInfo;
import com.ibm.ws.ejbcontainer.runtime.EJBRuntime;
import com.ibm.wsspi.injectionengine.InjectionException;
import jakarta.ejb.EJBException;
import java.rmi.Remote;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class EJBLinkObjectFactory
implements ObjectFactory {
    private static final TraceComponent tc = Tr.register(EJBLinkObjectFactory.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getObjectInstance : " + obj), (Object[])new Object[0]);
        }
        Object retObj = null;
        if (!(obj instanceof Reference)) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getObjectInstance : null (non-Reference)");
            }
            return null;
        }
        Reference ref = (Reference)obj;
        if (!this.getClass().getName().equals(ref.getFactoryClassName())) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getObjectInstance : null (wrong factory class: " + ref.getFactoryClassName() + ")"));
            }
            return null;
        }
        RefAddr addr = ref.get("EJBLinkInfo");
        if (addr == null) {
            NamingException nex = new NamingException("The address for this Reference is empty (null)");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getObjectInstance : " + nex));
            }
            throw nex;
        }
        EJBLinkInfo info = (EJBLinkInfo)addr.getContent();
        try {
            retObj = this.getObjectInstance(info, info.ivBeanName);
        }
        catch (Exception ex) {
            String component = "";
            if (info.ivComponent != null) {
                component = "in the " + info.ivComponent + " component ";
            }
            String message = "The EJB reference " + component + "in the " + info.ivModule + " module of the " + info.ivApplication + " application could not be resolved";
            if (ex instanceof AmbiguousEJBReferenceException) {
                throw new AmbiguousEJBReferenceException(message + ": " + ex.getMessage());
            }
            throw new EJBException(message, ex);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getObjectInstance : " + retObj.getClass().getName()));
        }
        return retObj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getObjectInstance(EJBLinkInfo info, String beanName) throws Exception {
        Object retObj;
        EJSHome home;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getObjectInstance : " + beanName), (Object[])new Object[0]);
        }
        if ((home = info.ivHome) == null) {
            HomeOfHomes homeOfHomes = EJSContainer.homeOfHomes;
            if (homeOfHomes == null) {
                InjectionException inex = new InjectionException("EJB Container is not started");
                if (!isTraceOn || !tc.isEntryEnabled()) throw inex;
                Tr.exit((TraceComponent)tc, (String)("getObjectInstance : " + (Object)((Object)inex)));
                throw inex;
            }
            EJBNotFoundException ejbNotFound = null;
            if (beanName != null) {
                try {
                    HomeRecord hr = homeOfHomes.resolveEJBLink(info.ivApplication, info.ivModule, beanName);
                    home = hr.getHomeAndInitialize();
                }
                catch (EJBNotFoundException e) {
                    if (!info.ivModule.endsWith(".war")) {
                        throw e;
                    }
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Discarding EJBNotFoundException encountered in WAR.", (Object[])new Object[]{e});
                    }
                    ejbNotFound = e;
                }
            }
            if (home == null) {
                String beanInterface;
                String string = beanInterface = info.ivHomeInterface != null ? info.ivHomeInterface : info.ivBeanInterface;
                if (beanInterface != null) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("bean name not specified, auto-link on " + beanInterface), (Object[])new Object[0]);
                    }
                    try {
                        home = homeOfHomes.getHomeByInterface(info.ivApplication, info.ivModule, beanInterface);
                    }
                    catch (EJBNotFoundException e) {
                        if (ejbNotFound != null) throw new EJBNotFoundException(ejbNotFound.getMessage() + " " + e.getMessage(), e);
                        throw e;
                    }
                    catch (AmbiguousEJBReferenceException e) {
                        if (ejbNotFound != null) throw new EJBNotFoundException(ejbNotFound.getMessage() + " " + e.getMessage(), (Throwable)((Object)e));
                        throw e;
                    }
                }
            }
            if (home == null) {
                if (ejbNotFound != null) {
                    throw ejbNotFound;
                }
                InjectionException inex = new InjectionException("EJB Reference could not be resolved");
                if (!isTraceOn || !tc.isEntryEnabled()) throw inex;
                Tr.exit((TraceComponent)tc, (String)("getObjectInstance : " + (Object)((Object)inex)));
                throw inex;
            }
            info.ivHome = home;
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("home = " + home.getJ2EEName()), (Object[])new Object[0]);
        }
        if (info.ivHomeInterface != null) {
            this.checkHomeSupported(home, info.ivHomeInterface);
            if (info.ivIsLocalRef) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"configured for local home", (Object[])new Object[0]);
                }
                retObj = home.getWrapper().getLocalObject();
            } else {
                if (!info.ivIsRemoteRef) throw new InjectionException("Invalid configuration - home interface from annotation?");
                EJBRuntime runtime = home.getContainer().getEJBRuntime();
                runtime.checkRemoteSupported(home, info.ivHomeInterface);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"configured for remote home", (Object[])new Object[0]);
                }
                EJSWrapper wrapper = home.getWrapper().getRemoteWrapper();
                retObj = runtime.getRemoteReference(wrapper);
            }
        } else {
            boolean useSupporting;
            String businessInterfaceName = info.ivBeanInterface;
            boolean bl = useSupporting = beanName != null;
            if (info.ivIsLocalRef) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"configured for local business interface", (Object[])new Object[0]);
                }
                if ((retObj = home.createLocalBusinessObject(businessInterfaceName, useSupporting)) instanceof Remote) {
                    throw new InjectionException("Use of ejb-local-ref for remote");
                }
            } else if (info.ivIsRemoteRef) {
                home.getContainer().getEJBRuntime().checkRemoteSupported(home, businessInterfaceName);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"configured for remote business interface", (Object[])new Object[0]);
                }
                retObj = home.createRemoteBusinessObject(businessInterfaceName, useSupporting);
            } else {
                BeanMetaData bmd = home.getBeanMetaData();
                if (businessInterfaceName.equals(bmd.localHomeInterfaceClassName)) {
                    this.checkHomeSupported(home, businessInterfaceName);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"match on local home", (Object[])new Object[0]);
                    }
                    retObj = home.getWrapper().getLocalObject();
                } else if (businessInterfaceName.equals(bmd.homeInterfaceClassName)) {
                    this.checkHomeSupported(home, businessInterfaceName);
                    EJBRuntime runtime = home.getContainer().getEJBRuntime();
                    runtime.checkRemoteSupported(home, businessInterfaceName);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"match on remote home", (Object[])new Object[0]);
                    }
                    EJSWrapper wrapper = home.getWrapper().getRemoteWrapper();
                    retObj = runtime.getRemoteReference(wrapper);
                } else {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"looking for match on business interface", (Object[])new Object[0]);
                    }
                    retObj = home.createBusinessObject(businessInterfaceName, useSupporting);
                }
            }
        }
        if (!isTraceOn || !tc.isEntryEnabled()) return retObj;
        Tr.exit((TraceComponent)tc, (String)("getObjectInstance : " + retObj.getClass().getName()));
        return retObj;
    }

    protected void checkHomeSupported(EJSHome home, String homeInterface) throws EJBNotFoundException {
    }
}

