/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.jacc.JaccService;
import com.ibm.ws.webcontainer.osgi.WebContainer;
import com.ibm.ws.webcontainer.security.metadata.MatchResponse;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraint;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraintCollection;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraintCollectionImpl;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.ws.webcontainer.security.metadata.WebResourceCollection;
import com.ibm.ws.webcontainer.webapp.WebAppConfigExtended;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.webcontainer.collaborator.WebAppInitializationCollaborator;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import jakarta.servlet.HttpConstraintElement;
import jakarta.servlet.HttpMethodConstraintElement;
import jakarta.servlet.ServletSecurityElement;
import jakarta.servlet.annotation.ServletSecurity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ServletStartedListener
implements WebAppInitializationCollaborator {
    private static final TraceComponent tc = Tr.register(ServletStartedListener.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    private static final String[] STANDARD_METHODS = new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE"};
    protected static final String KEY_JACC_SERVICE = "jaccService";
    private final AtomicServiceReference<JaccService> jaccService = new AtomicServiceReference("jaccService");
    static final long serialVersionUID = -8552109196587983859L;

    protected void setJaccService(ServiceReference<JaccService> reference) {
        this.jaccService.setReference(reference);
    }

    protected void unsetJaccService(ServiceReference<JaccService> reference) {
        this.jaccService.unsetReference(reference);
    }

    protected void activate(ComponentContext cc) {
        this.jaccService.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        this.jaccService.deactivate(cc);
    }

    public void starting(Container moduleContainer) {
    }

    /*
     * WARNING - void declaration
     */
    public void started(Container moduleContainer) {
        block4: {
            try {
                JaccService js;
                WebAppConfig webAppConfig = (WebAppConfig)moduleContainer.adapt(WebAppConfig.class);
                SecurityMetadata securityMetadataFromDD = this.getSecurityMetadata(webAppConfig);
                this.updateSecurityMetadata(securityMetadataFromDD, webAppConfig);
                this.setModuleSecurityMetaData(moduleContainer, securityMetadataFromDD);
                if (WebContainer.getServletContainerSpecLevel() >= 31) {
                    this.notifyDeployOfUncoveredMethods(webAppConfig);
                }
                if (this.checkDynamicAnnotation(webAppConfig) && (js = (JaccService)this.jaccService.getService()) != null) {
                    js.propagateWebConstraints(webAppConfig.getApplicationName(), webAppConfig.getModuleName(), (Object)webAppConfig);
                }
            }
            catch (UnableToAdaptException webAppConfig) {
                void e;
                FFDCFilter.processException((Throwable)webAppConfig, (String)"com.ibm.ws.webcontainer.security.ServletStartedListener", (String)"103", (Object)this, (Object[])new Object[]{moduleContainer});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"There was a problem setting the security meta data.", (Object[])new Object[]{e});
            }
        }
    }

    public void stopping(Container moduleContainer) {
    }

    public void stopped(Container moduleContainer) {
    }

    /*
     * WARNING - void declaration
     */
    public void notifyDeployOfUncoveredMethods(WebAppConfig webAppConfig) {
        SecurityConstraintCollection secConstraintCollection;
        MatchResponse matchResponse = MatchResponse.NO_MATCH_RESPONSE;
        boolean isDenyUncoveredHttpMethodsSet = false;
        SecurityMetadata secMetaData = this.getSecurityMetadata(webAppConfig);
        if (secMetaData != null && (secConstraintCollection = secMetaData.getSecurityConstraintCollection()) != null) {
            List<SecurityConstraint> secConstraints = secConstraintCollection.getSecurityConstraints();
            ArrayList<String> aggregatedUrlPatterns = new ArrayList<String>();
            for (SecurityConstraint sc : secConstraints) {
                List<WebResourceCollection> webResCollection = sc.getWebResourceCollections();
                for (WebResourceCollection webResourceCollection : webResCollection) {
                    if (!isDenyUncoveredHttpMethodsSet && webResourceCollection.getDenyUncoveredHttpMethods()) {
                        isDenyUncoveredHttpMethodsSet = true;
                    }
                    List<String> urlPatterns = webResourceCollection.getUrlPatterns();
                    for (String uri : urlPatterns) {
                        if (aggregatedUrlPatterns.contains(uri)) continue;
                        aggregatedUrlPatterns.add(uri);
                    }
                }
            }
            for (String uriName : aggregatedUrlPatterns) {
                void var12_16;
                ArrayList<String> uncoveredMethodsWithDeny = new ArrayList<String>();
                ArrayList<String> uncoveredMethodsWithoutDeny = new ArrayList<String>();
                for (String methodName : STANDARD_METHODS) {
                    matchResponse = secConstraintCollection.getMatchResponse(uriName, methodName);
                    if (MatchResponse.DENY_MATCH_RESPONSE.equals(matchResponse)) {
                        uncoveredMethodsWithDeny.add(methodName);
                    }
                    if (!MatchResponse.NO_MATCH_RESPONSE.equals(matchResponse)) continue;
                    uncoveredMethodsWithoutDeny.add(methodName);
                }
                String string = "";
                boolean uncoveredMethodsFoundWithDenySet = false;
                for (String ucm : uncoveredMethodsWithDeny) {
                    String string2 = var12_16.concat(ucm).concat(" ");
                    uncoveredMethodsFoundWithDenySet = true;
                }
                String listUncoveredMethodsWithoutDeny = "";
                boolean uncoveredMethodsFoundWithoutDenySet = false;
                for (String ucm : uncoveredMethodsWithoutDeny) {
                    listUncoveredMethodsWithoutDeny = listUncoveredMethodsWithoutDeny.concat(ucm).concat(" ");
                    uncoveredMethodsFoundWithoutDenySet = true;
                }
                if (WebContainer.getServletContainerSpecLevel() < 31) continue;
                if (isDenyUncoveredHttpMethodsSet) {
                    if (!uncoveredMethodsFoundWithDenySet) continue;
                    Tr.info((TraceComponent)tc, (String)"UNCOVERED_HTTP_METHODS_FOUND", (Object[])new Object[]{uriName, webAppConfig.getApplicationName(), var12_16});
                    continue;
                }
                if (!uncoveredMethodsFoundWithoutDenySet) continue;
                Tr.info((TraceComponent)tc, (String)"UNCOVERED_HTTP_METHODS_FOUND_AND_UNPROTECTED", (Object[])new Object[]{uriName, webAppConfig.getApplicationName(), listUncoveredMethodsWithoutDeny});
            }
        }
    }

    private void updateSecurityMetadata(SecurityMetadata securityMetadataFromDD, WebAppConfig webAppConfig) {
        Iterator it = webAppConfig.getServletInfos();
        while (it.hasNext()) {
            IServletConfig servletConfig = (IServletConfig)it.next();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Updating servlet: " + servletConfig.getServletName()), (Object[])new Object[0]);
            }
            this.updateSecurityMetadataWithRunAs(securityMetadataFromDD, servletConfig);
            this.updateSecurityMetadataWithSecurityConstraints(securityMetadataFromDD, servletConfig);
        }
    }

    public void updateSecurityMetadataWithRunAs(SecurityMetadata securityMetadataFromDD, IServletConfig servletConfig) {
        String runAs = servletConfig.getRunAsRole();
        if (runAs != null) {
            String servletName = servletConfig.getServletName();
            Map<String, String> servletNameToRunAsRole = securityMetadataFromDD.getRunAsMap();
            if (servletNameToRunAsRole.get(servletName) == null) {
                servletNameToRunAsRole.put(servletName, runAs);
                List<String> allRoles = securityMetadataFromDD.getRoles();
                if (!allRoles.contains(runAs)) {
                    allRoles.add(runAs);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Added runAs role: " + runAs), (Object[])new Object[0]);
                }
            }
        }
    }

    public void updateSecurityMetadataWithSecurityConstraints(SecurityMetadata securityMetadataFromDD, IServletConfig servletConfig) {
        List urlPatterns;
        ServletSecurityElement servletSecurity = servletConfig.getServletSecurity();
        if (servletSecurity != null && (urlPatterns = servletConfig.getMappings()) != null) {
            List<SecurityConstraint> securityConstraintsInDD = null;
            SecurityConstraintCollection securityConstraintCollectionInDD = securityMetadataFromDD.getSecurityConstraintCollection();
            HashSet<String> urlPatternsInDD = new HashSet<String>();
            if (securityConstraintCollectionInDD != null) {
                securityConstraintsInDD = securityConstraintCollectionInDD.getSecurityConstraints();
                for (SecurityConstraint secConstraint : securityConstraintCollectionInDD.getSecurityConstraints()) {
                    for (WebResourceCollection webRescColl : secConstraint.getWebResourceCollections()) {
                        urlPatternsInDD.addAll(webRescColl.getUrlPatterns());
                    }
                }
            }
            ArrayList<String> urlPatternsForAnnotations = new ArrayList<String>(urlPatterns);
            urlPatternsForAnnotations.removeAll(urlPatternsInDD);
            List<SecurityConstraint> securityConstraints = this.createSecurityConstraints(securityMetadataFromDD, servletSecurity, urlPatternsForAnnotations);
            if (securityConstraintsInDD == null) {
                securityConstraintsInDD = new ArrayList<SecurityConstraint>();
            }
            securityConstraintsInDD.addAll(securityConstraints);
            if (securityConstraintCollectionInDD == null) {
                securityConstraintCollectionInDD = new SecurityConstraintCollectionImpl(securityConstraintsInDD);
                securityConstraintCollectionInDD.addSecurityConstraints(securityConstraintsInDD);
                securityMetadataFromDD.setSecurityConstraintCollection(securityConstraintCollectionInDD);
            }
        }
    }

    private List<SecurityConstraint> createSecurityConstraints(SecurityMetadata securityMetadataFromDD, ServletSecurityElement servletSecurity, Collection<String> urlPatterns) {
        ArrayList<SecurityConstraint> securityConstraints = new ArrayList<SecurityConstraint>();
        securityConstraints.add(this.getConstraintFromHttpElement(securityMetadataFromDD, urlPatterns, servletSecurity));
        securityConstraints.addAll(this.getConstraintsFromHttpMethodElement(securityMetadataFromDD, urlPatterns, servletSecurity));
        return securityConstraints;
    }

    private SecurityConstraint getConstraintFromHttpElement(SecurityMetadata securityMetadataFromDD, Collection<String> urlPatterns, ServletSecurityElement servletSecurity) {
        ArrayList<String> omissionMethods = new ArrayList<String>();
        if (!servletSecurity.getMethodNames().isEmpty()) {
            omissionMethods.addAll(servletSecurity.getMethodNames());
        }
        WebResourceCollection webResourceCollection = new WebResourceCollection((List)urlPatterns, new ArrayList<String>(), omissionMethods, securityMetadataFromDD.isDenyUncoveredHttpMethods());
        ArrayList<WebResourceCollection> webResourceCollections = new ArrayList<WebResourceCollection>();
        webResourceCollections.add(webResourceCollection);
        return this.createSecurityConstraint(securityMetadataFromDD, webResourceCollections, (HttpConstraintElement)servletSecurity, true);
    }

    private List<SecurityConstraint> getConstraintsFromHttpMethodElement(SecurityMetadata securityMetadataFromDD, Collection<String> urlPatterns, ServletSecurityElement servletSecurity) {
        ArrayList<SecurityConstraint> securityConstraints = new ArrayList<SecurityConstraint>();
        Collection httpMethodConstraints = servletSecurity.getHttpMethodConstraints();
        for (HttpMethodConstraintElement httpMethodConstraint : httpMethodConstraints) {
            String method = httpMethodConstraint.getMethodName();
            ArrayList<String> methods = new ArrayList<String>();
            methods.add(method);
            WebResourceCollection webResourceCollection = new WebResourceCollection((List)urlPatterns, methods, new ArrayList<String>(), securityMetadataFromDD.isDenyUncoveredHttpMethods());
            ArrayList<WebResourceCollection> webResourceCollections = new ArrayList<WebResourceCollection>();
            webResourceCollections.add(webResourceCollection);
            securityConstraints.add(this.createSecurityConstraint(securityMetadataFromDD, webResourceCollections, (HttpConstraintElement)httpMethodConstraint, false));
        }
        return securityConstraints;
    }

    private SecurityConstraint createSecurityConstraint(SecurityMetadata securityMetadataFromDD, List<WebResourceCollection> webResourceCollections, HttpConstraintElement httpConstraint, boolean fromHttpConstraint) {
        List<String> roles = this.createRoles(httpConstraint);
        List<String> allRoles = securityMetadataFromDD.getRoles();
        for (String role : roles) {
            if (allRoles.contains(role)) continue;
            allRoles.add(role);
        }
        boolean sslRequired = this.isSSLRequired(httpConstraint);
        boolean accessPrecluded = this.isAccessPrecluded(httpConstraint);
        boolean accessUncovered = this.isAccessUncovered(httpConstraint);
        return new SecurityConstraint(webResourceCollections, roles, sslRequired, accessPrecluded, fromHttpConstraint, accessUncovered);
    }

    private List<String> createRoles(HttpConstraintElement httpConstraint) {
        String[] rolesFromAnno = httpConstraint.getRolesAllowed();
        ArrayList<String> roles = new ArrayList<String>();
        for (int i = 0; i < rolesFromAnno.length; ++i) {
            roles.add(rolesFromAnno[i]);
        }
        return roles;
    }

    private boolean isSSLRequired(HttpConstraintElement httpConstraint) {
        boolean sslRequired = false;
        ServletSecurity.TransportGuarantee transportGuarantee = httpConstraint.getTransportGuarantee();
        if (transportGuarantee != ServletSecurity.TransportGuarantee.NONE) {
            sslRequired = true;
        }
        return sslRequired;
    }

    private boolean isAccessPrecluded(HttpConstraintElement httpConstraint) {
        boolean accessPrecluded = false;
        String[] roles = httpConstraint.getRolesAllowed();
        if ((roles == null || roles.length == 0) && ServletSecurity.EmptyRoleSemantic.DENY == httpConstraint.getEmptyRoleSemantic()) {
            accessPrecluded = true;
        }
        return accessPrecluded;
    }

    private boolean isAccessUncovered(HttpConstraintElement httpConstraint) {
        boolean accessUncovered = false;
        String[] roles = httpConstraint.getRolesAllowed();
        if ((roles == null || roles.length == 0) && ServletSecurity.EmptyRoleSemantic.PERMIT == httpConstraint.getEmptyRoleSemantic()) {
            accessUncovered = true;
        }
        return accessUncovered;
    }

    /*
     * WARNING - void declaration
     */
    private void setModuleSecurityMetaData(Container moduleContainer, SecurityMetadata securityMetadataFromDD) {
        block2: {
            try {
                WebModuleMetaData wmmd = (WebModuleMetaData)moduleContainer.adapt(WebModuleMetaData.class);
                wmmd.setSecurityMetaData((Object)securityMetadataFromDD);
            }
            catch (UnableToAdaptException wmmd) {
                void e;
                FFDCFilter.processException((Throwable)wmmd, (String)"com.ibm.ws.webcontainer.security.ServletStartedListener", (String)"464", (Object)this, (Object[])new Object[]{moduleContainer, securityMetadataFromDD});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"There was a problem setting the security meta data.", (Object[])new Object[]{e});
            }
        }
    }

    private SecurityMetadata getSecurityMetadata(WebAppConfig webAppConfig) {
        WebModuleMetaData wmmd = ((WebAppConfigExtended)webAppConfig).getMetaData();
        return (SecurityMetadata)wmmd.getSecurityMetaData();
    }

    protected boolean checkDynamicAnnotation(WebAppConfig webAppConfig) {
        boolean result = false;
        Iterator it = webAppConfig.getServletInfos();
        while (it.hasNext()) {
            IServletConfig servletConfig = (IServletConfig)it.next();
            List mappings = servletConfig.getMappings();
            ServletSecurityElement servletSecurity = servletConfig.getServletSecurity();
            if (servletSecurity == null || mappings == null || mappings.isEmpty()) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("*** Found dynamic security constraints for servlet: " + servletConfig.getServletName()), (Object[])new Object[0]);
            }
            result = true;
            break;
        }
        return result;
    }
}

