/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.PasswordExpiredException;
import com.ibm.ws.security.authentication.UserRevokedException;
import com.ibm.ws.security.authentication.WSAuthenticationData;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.SSOCookieHelper;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebAuthenticator;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.ws.webcontainer.security.metadata.LoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BasicAuthAuthenticator
implements WebAuthenticator {
    private static final TraceComponent tc = Tr.register(BasicAuthAuthenticator.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    public static final String BASIC_AUTH_HEADER_NAME = "Authorization";
    private AuthenticationService authenticationService = null;
    private UserRegistry userRegistry = null;
    private SSOCookieHelper ssoCookieHelper = null;
    private WebAppSecurityConfig config = null;
    static final long serialVersionUID = 2206597227363678721L;

    public BasicAuthAuthenticator(AuthenticationService authnServ, UserRegistry ur, SSOCookieHelper ssoCookieHelper, WebAppSecurityConfig config) {
        this.authenticationService = authnServ;
        this.userRegistry = ur;
        this.ssoCookieHelper = ssoCookieHelper;
        this.config = config;
    }

    @Override
    public AuthenticationResult authenticate(WebRequest webRequest) {
        HttpServletRequest req = webRequest.getHttpServletRequest();
        HttpServletResponse res = webRequest.getHttpServletResponse();
        String realm = this.getBasicAuthRealmName(webRequest);
        AuthenticationResult result = null;
        result = this.handleBasicAuth(realm, req, res);
        if (result.getStatus() == AuthResult.SUCCESS) {
            this.ssoCookieHelper.addSSOCookiesToResponse(result.getSubject(), req, res);
        }
        return result;
    }

    @Override
    public AuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res, HashMap<String, Object> props) {
        AuthenticationResult result = null;
        String realm = "defaultRealm";
        if (this.userRegistry != null && this.config.getDisplayAuthenticationRealm()) {
            realm = this.userRegistry.getRealm();
        }
        if ((result = this.handleBasicAuth(realm, req, res)).getStatus() == AuthResult.SUCCESS) {
            this.ssoCookieHelper.addSSOCookiesToResponse(result.getSubject(), req, res);
        }
        return result;
    }

    private AuthenticationResult handleBasicAuth(String inRealm, HttpServletRequest req, HttpServletResponse res) {
        AuthenticationResult result = null;
        String hdrValue = req.getHeader(BASIC_AUTH_HEADER_NAME);
        if (hdrValue == null || !hdrValue.startsWith("Basic ")) {
            result = new AuthenticationResult(AuthResult.SEND_401, inRealm, "BASIC", null, "challenge");
            return result;
        }
        String encoding = req.getHeader("Authorization-Encoding");
        int idx = (hdrValue = this.decodeBasicAuth(hdrValue.substring(6), encoding)).indexOf(58);
        if (idx < 0) {
            result = new AuthenticationResult(AuthResult.SEND_401, inRealm, "BASIC", null, "challenge");
            return result;
        }
        String username = hdrValue.substring(0, idx);
        String password = hdrValue.substring(idx + 1);
        return this.basicAuthenticate(inRealm, username, password, req, res);
    }

    @FFDCIgnore(value={AuthenticationException.class})
    public AuthenticationResult basicAuthenticate(String realm, String username, @Sensitive String password, HttpServletRequest req, HttpServletResponse res) {
        AuthenticationResult authResult;
        block3: {
            authResult = null;
            try {
                String thisAuthMech = "system.WEB_INBOUND";
                AuthenticationData authenticationData = this.createAuthenticationData(realm, username, password, req, res);
                Subject authenticatedSubject = this.authenticationService.authenticate(thisAuthMech, authenticationData, null);
                authResult = new AuthenticationResult(AuthResult.SUCCESS, authenticatedSubject, "BASIC", username, "success");
            }
            catch (AuthenticationException e) {
                authResult = new AuthenticationResult(AuthResult.SEND_401, e.getMessage(), "BASIC", username, "denied");
                if (e instanceof PasswordExpiredException) {
                    authResult.passwordExpired = true;
                }
                if (!(e instanceof UserRevokedException)) break block3;
                authResult.userRevoked = true;
            }
        }
        authResult.realm = realm;
        authResult.username = username;
        authResult.password = password;
        return authResult;
    }

    @Trivial
    protected AuthenticationData createAuthenticationData(String realm, String username, @Sensitive String password, HttpServletRequest req, HttpServletResponse res) {
        WSAuthenticationData authenticationData = new WSAuthenticationData();
        authenticationData.set("USERNAME", (Object)username);
        authenticationData.set("PASSWORD", (Object)password.toCharArray());
        authenticationData.set("HTTP_SERVLET_REQUEST", (Object)req);
        authenticationData.set("HTTP_SERVLET_RESPONSE", (Object)res);
        return authenticationData;
    }

    protected String getBasicAuthRealmName(WebRequest webRequest) {
        SecurityMetadata securityMetadata = webRequest.getSecurityMetadata();
        if (securityMetadata != null) {
            LoginConfiguration loginConfig = securityMetadata.getLoginConfiguration();
            if (loginConfig != null && loginConfig.getRealmName() != null) {
                return loginConfig.getRealmName();
            }
            if (this.config.getDisplayAuthenticationRealm()) {
                return this.userRegistry.getRealm();
            }
        }
        String realm = "defaultRealm";
        return realm;
    }

    /*
     * WARNING - void declaration
     */
    @Sensitive
    protected String decodeBasicAuth(String data, String encoding) {
        String output = "";
        byte[] decodedByte = null;
        decodedByte = Base64Coder.base64DecodeString((String)data);
        if (decodedByte != null && decodedByte.length > 0) {
            boolean decoded;
            block5: {
                decoded = false;
                if (encoding != null) {
                    try {
                        output = new String(decodedByte, encoding);
                        decoded = true;
                    }
                    catch (Exception exception) {
                        void e;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.security.internal.BasicAuthAuthenticator", (String)"191", (Object)this, (Object[])new Object[]{data, encoding});
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                        Tr.debug((TraceComponent)tc, (String)("An exception is caught using the encoder: " + encoding + ". The exception is: " + e.getMessage()), (Object[])new Object[0]);
                    }
                }
            }
            if (!decoded) {
                output = new String(decodedByte);
            }
        }
        return output;
    }
}

