/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.metadata;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collection;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class URLMatchingUtils {
    static final long serialVersionUID = 3150252499482881302L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static String getLongestUrlPattern(String firstUrlPattern, String secondUrlPattern) {
        if (secondUrlPattern == null || firstUrlPattern != null && firstUrlPattern.length() >= secondUrlPattern.length()) {
            return firstUrlPattern;
        }
        return secondUrlPattern;
    }

    static String performUrlMatch(String uri, Collection<String> urlPatterns) {
        String match = null;
        String longestUrlPattern = null;
        for (String urlPattern : urlPatterns) {
            if (URLMatchingUtils.isExactMatch(uri, urlPattern)) {
                return urlPattern;
            }
            if (URLMatchingUtils.isPathNameMatch(uri, urlPattern)) {
                longestUrlPattern = URLMatchingUtils.getLongestUrlPattern(longestUrlPattern, urlPattern);
                continue;
            }
            if (!URLMatchingUtils.isExtensionMatch(uri, urlPattern)) continue;
            match = urlPattern;
        }
        if (longestUrlPattern != null) {
            match = longestUrlPattern;
        }
        return match;
    }

    public static boolean isExactMatch(String uriName, String urlPattern) {
        return urlPattern.equals(uriName);
    }

    public static boolean isPathNameMatch(String uri, String urlPattern) {
        if (urlPattern.startsWith("/") && urlPattern.endsWith("/*")) {
            String s = urlPattern.substring(0, urlPattern.length() - 1);
            if (s.equalsIgnoreCase(uri)) {
                return true;
            }
            if (uri.equalsIgnoreCase(s.substring(0, s.length() - 1))) {
                return true;
            }
            if (uri.startsWith(s)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isExtensionMatch(String uriName, String urlPattern) {
        String ext;
        return urlPattern.startsWith("*.") && uriName.endsWith(ext = urlPattern.substring(1));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.webcontainer.security.metadata.URLMatchingUtils", URLMatchingUtils.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    }
}

