/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.utility.internal.cmdline;

import com.ibm.ws.install.InstallEventListener;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallProgressEvent;
import com.ibm.ws.install.internal.ArchiveUtils;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.asset.ServerAsset;
import com.ibm.ws.install.internal.asset.ServerPackageAsset;
import com.ibm.ws.install.utility.cmdline.ReturnCode;
import com.ibm.ws.install.utility.internal.cmdline.Action;
import com.ibm.ws.install.utility.internal.cmdline.CmdUtils;
import com.ibm.ws.install.utility.internal.cmdline.InstallUtilityExecutor;
import com.ibm.ws.install.utility.internal.cmdline.RequireAcceptLicenseAction;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.feature.internal.cmdline.ArgumentsImpl;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import wlp.lib.extract.SelfExtract;

public class InstallAction
extends RequireAcceptLicenseAction {
    private boolean isBadConnectionFound = false;
    private boolean isServerXmlInstall = false;
    private boolean isAlreadyInstalled = false;
    private String repoType;
    private InstallPackage installPackage = null;
    private Set<String> featureIds = null;
    private Set<ServerAsset> servers = null;
    private Logger logger;
    private InstallEventListener ielistener;
    private InstallEventListener ieNoStepListener;
    private boolean downloadDependencies = false;
    private boolean agreedToDownloadDependencies = false;
    private File esaFile = null;
    private String fromDir;

    /*
     * Loose catch block
     */
    @Override
    ReturnCode initialize(Arguments args) {
        super.initialize(args);
        this.logger = Logger.getLogger("com.ibm.ws.install");
        String downloadDependenciesOption = args.getOption("downloaddependencies");
        boolean bl = this.downloadDependencies = downloadDependenciesOption != null && !downloadDependenciesOption.isEmpty();
        if (this.downloadDependencies) {
            if (downloadDependenciesOption.equalsIgnoreCase("false")) {
                this.agreedToDownloadDependencies = false;
            } else if (downloadDependenciesOption.equalsIgnoreCase("true")) {
                this.agreedToDownloadDependencies = true;
            } else {
                this.logger.log(Level.SEVERE, CmdUtils.getMessage("ERROR_INVALID_DOWNLOAD_DEPENDENCIES_VALUE", downloadDependenciesOption));
                return ReturnCode.BAD_ARGUMENT;
            }
        }
        if (this.argList.isEmpty()) {
            this.logger.log(Level.SEVERE, CmdUtils.getMessage("ERROR_NO_ARGUMENT", "install"));
            Action.help.handleTask((Arguments)new ArgumentsImpl(new String[]{"help", "install"}));
            return ReturnCode.BAD_ARGUMENT;
        }
        this.repoType = args.getOption("to");
        String arg = (String)this.argList.get(0);
        this.featureIds = new HashSet<String>();
        this.servers = new TreeSet<ServerAsset>();
        this.fromDir = args.getOption("from");
        if (this.fromDir != null && this.fromDir.isEmpty()) {
            InstallLogUtils.getInstallLogger().log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_DIRECTORY_REQUIRED", new Object[]{"from"}));
            return ReturnCode.BAD_ARGUMENT;
        }
        try {
            block17: {
                if (this.isPackage(arg)) {
                    this.installPackage = new InstallPackage(arg);
                    if (this.installPackage.isServerPackage()) {
                        // empty if block
                    }
                    return ReturnCode.OK;
                }
                if (this.isServer(arg)) {
                    return this.serverInit(arg);
                }
                if (!this.isValidEsa(arg)) break block17;
                return this.esaInstallInit(arg);
                {
                    catch (InstallException e) {
                        this.logger.log(Level.SEVERE, e.getMessage(), e);
                        return InstallUtilityExecutor.returnCode(e.getRc());
                    }
                }
            }
            try {
                HashSet<String> assetIds = new HashSet<String>(this.argList);
                this.installKernel.checkAssetsNotInstalled(assetIds);
                return this.assetInstallInit(assetIds);
            }
            catch (InstallException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                return InstallUtilityExecutor.returnCode(e.getRc());
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return InstallUtilityExecutor.returnCode(25);
        }
    }

    private ReturnCode assetInstallInit(Collection<String> featureIdSet) {
        this.featureIds.addAll(featureIdSet);
        this.setFeatureNames(this.featureIds);
        try {
            ReturnCode rc = CmdUtils.checkRepositoryStatus(this.installKernel, this.repoProperties, "install", this.fromDir);
            if (rc.equals((Object)ReturnCode.BAD_CONNECTION_FOUND)) {
                rc = ReturnCode.OK;
                this.isBadConnectionFound = true;
            }
            if (rc.equals((Object)ReturnCode.USER_ABORT)) {
                return rc;
            }
        }
        catch (InstallException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return InstallUtilityExecutor.returnCode(e.getRc());
        }
        try {
            this.installKernel.addListener(this.getNoStepListener(), "PROGRESS");
            this.installKernel.resolve(featureIdSet, false);
            this.featureLicenses = this.installKernel.getFeatureLicense(Locale.getDefault());
            this.sampleLicenses = this.installKernel.getSampleLicense(Locale.getDefault());
        }
        catch (InstallException e) {
            InstallException newError = CmdUtils.convertToBadConnectionError(e, this.isBadConnectionFound);
            if (newError.getRc() == 22 && this.isServerXmlInstall) {
                this.isAlreadyInstalled = true;
                return ReturnCode.OK;
            }
            this.logger.log(newError.getRc() == 22 ? Level.INFO : Level.SEVERE, newError.getMessage(), newError);
            return InstallUtilityExecutor.returnCode(newError.getRc());
        }
        return ReturnCode.OK;
    }

    private ReturnCode esaInstallInit(String esaPath) {
        this.esaFile = new File(esaPath);
        try {
            String feature = InstallUtils.getFeatureName((File)this.esaFile);
            HashSet<String> features = new HashSet<String>();
            features.add(feature);
            this.setFeatureNames(features);
            this.installKernel.addListener(this.getNoStepListener(), "PROGRESS");
            this.installKernel.resolve(feature, this.esaFile, this.repoType);
            this.featureLicenses = this.installKernel.getFeatureLicense(Locale.getDefault());
        }
        catch (InstallException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return InstallUtilityExecutor.returnCode(e.getRc());
        }
        return ReturnCode.OK;
    }

    private ReturnCode serverInit(String fileName) throws InstallException, IOException {
        File serverXML;
        File file = serverXML = fileName.toLowerCase().endsWith("server.xml") ? new File(fileName) : new File(InstallUtils.getServersDir(), fileName + File.separator + "server.xml");
        if (!serverXML.isFile()) {
            throw new InstallException(CmdUtils.getMessage("ERROR_UNABLE_TO_FIND_SERVER_XML", serverXML.getParent()), 21);
        }
        this.servers.add(new ServerAsset(serverXML));
        return ReturnCode.OK;
    }

    @Override
    protected ReturnCode handleLicenseAcceptance() {
        ReturnCode rc = super.handleLicenseAcceptance();
        if (!rc.equals((Object)ReturnCode.OK)) {
            return rc;
        }
        if (this.sampleLicenses != null && !this.sampleLicenses.isEmpty()) {
            this.logger.log(Level.INFO, CmdUtils.getMessage("MSG_REQUIRE_DOWNLOAD_DEPENDENCIES", new Object[0]));
            this.logger.log(Level.INFO, "");
            if (this.downloadDependencies) {
                this.logger.log(Level.INFO, CmdUtils.getMessage(this.agreedToDownloadDependencies ? "MSG_DOWNLOAD_DEPENDENCIES" : "MSG_NOT_DOWNLOAD_DEPENDENCIES", "--downloadDependencies", this.agreedToDownloadDependencies));
            } else {
                for (String license : this.sampleLicenses) {
                    this.logger.log(Level.INFO, license);
                    this.logger.log(Level.INFO, "");
                }
                this.agreedToDownloadDependencies = SelfExtract.getResponse((String)SelfExtract.format((String)"externalDepsPrompt", (Object[])new Object[]{"[1]", "[2]"}), (String)"1", (String)"2", (String)"1");
            }
            this.logger.log(Level.INFO, "");
        }
        return ReturnCode.OK;
    }

    @Override
    protected ReturnCode viewLicense(boolean showAgreement) {
        ReturnCode rc = super.viewLicense(showAgreement);
        if (!rc.equals((Object)ReturnCode.OK)) {
            return rc;
        }
        if (showAgreement && this.sampleLicenses != null && !this.sampleLicenses.isEmpty()) {
            this.logger.log(Level.INFO, CmdUtils.getMessage("MSG_REQUIRE_DOWNLOAD_DEPENDENCIES", new Object[0]));
            this.logger.log(Level.INFO, "");
            for (String license : this.sampleLicenses) {
                this.logger.log(Level.INFO, license);
                this.logger.log(Level.INFO, "");
            }
        }
        return ReturnCode.OK;
    }

    private boolean isPackage(String fileName) {
        return ArchiveUtils.ArchiveFileType.ZIP.isType(fileName) || ArchiveUtils.ArchiveFileType.PAX.isType(fileName) || ArchiveUtils.ArchiveFileType.JAR.isType(fileName);
    }

    private boolean isValidEsa(String fileName) {
        return ArchiveUtils.ArchiveFileType.ESA.isType(fileName);
    }

    private boolean isServer(String fileName) {
        return new File(InstallUtils.getServersDir(), fileName).isDirectory() || fileName.toLowerCase().endsWith("server.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReturnCode install() {
        try {
            this.installKernel.checkResources();
        }
        catch (InstallException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return InstallUtilityExecutor.returnCode(e.getRc());
        }
        ReturnCode rc = super.execute();
        if (!rc.equals((Object)ReturnCode.OK)) {
            return rc;
        }
        Map installedAssets = null;
        try {
            this.installKernel.addListener(this.getInstallListener(), "PROGRESS");
            installedAssets = this.installKernel.install(this.repoType, false, this.agreedToDownloadDependencies);
        }
        catch (InstallException ie) {
            this.logger.log(Level.SEVERE, ie.getMessage(), ie);
            ReturnCode returnCode = InstallUtilityExecutor.returnCode(ie.getRc());
            return returnCode;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            ReturnCode returnCode = ReturnCode.RUNTIME_EXCEPTION;
            return returnCode;
        }
        finally {
            this.removeEventListener(true);
        }
        if (installedAssets != null && !installedAssets.isEmpty()) {
            Collection installedOpenSource;
            Collection installedSamples;
            Collection installedAddons;
            Collection installedFeatures = (Collection)installedAssets.get("feature");
            if (installedFeatures != null && !installedFeatures.isEmpty()) {
                this.logger.log(Level.FINE, CmdUtils.getMessage("MSG_INSTALLED_FEATURES", InstallUtils.getFeatureListOutput((Collection)installedFeatures)));
            }
            if ((installedAddons = (Collection)installedAssets.get("addon")) != null && !installedAddons.isEmpty()) {
                this.logger.log(Level.FINE, CmdUtils.getMessage("MSG_INSTALLED_ADDONS", InstallUtils.getFeatureListOutput((Collection)installedAddons)));
            }
            if ((installedSamples = (Collection)installedAssets.get("sample")) != null && !installedSamples.isEmpty()) {
                this.logger.log(Level.FINE, CmdUtils.getMessage("MSG_INSTALLED_SAMPLES", InstallUtils.getFeatureListOutput((Collection)installedSamples)));
            }
            if ((installedOpenSource = (Collection)installedAssets.get("opensource")) != null && !installedOpenSource.isEmpty()) {
                this.logger.log(Level.FINE, CmdUtils.getMessage("MSG_INSTALLED_OPENSOURCE", InstallUtils.getFeatureListOutput((Collection)installedOpenSource)));
            }
            this.logger.log(Level.INFO, "");
            this.logger.log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("TOOL_INSTALLATION_COMPLETED", new Object[0]));
        }
        return ReturnCode.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReturnCode deployServerPackage() {
        ReturnCode rc = super.execute();
        if (!rc.equals((Object)ReturnCode.OK)) {
            return rc;
        }
        try {
            this.installKernel.addListener(this.getListener(4), "PROGRESS");
            ServerPackageAsset spa = this.installKernel.deployServerPackage(this.installPackage.getPackageFile(), this.repoType, this.agreedToDownloadDependencies);
            this.servers.addAll(spa.getServers());
        }
        catch (InstallException ie) {
            this.logger.log(Level.SEVERE, ie.getMessage(), ie);
            ReturnCode returnCode = InstallUtilityExecutor.returnCode(ie.getRc());
            return returnCode;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            ReturnCode returnCode = ReturnCode.RUNTIME_EXCEPTION;
            return returnCode;
        }
        finally {
            this.removeEventListener(true);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReturnCode installServerFeatures() {
        ReturnCode rc = ReturnCode.OK;
        HashSet<String> featuresToInstall = new HashSet<String>();
        this.isServerXmlInstall = true;
        try {
            this.installKernel.addListener(this.getNoStepListener(), "PROGRESS");
            featuresToInstall.addAll(this.installKernel.getServerFeaturesToInstall(this.servers, false));
        }
        catch (InstallException ie) {
            this.logger.log(Level.SEVERE, ie.getMessage(), ie);
            ReturnCode returnCode = InstallUtilityExecutor.returnCode(ie.getRc());
            return returnCode;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            rc = ReturnCode.RUNTIME_EXCEPTION;
        }
        finally {
            this.removeEventListener(false);
        }
        if (featuresToInstall.isEmpty()) {
            this.logger.log(Level.INFO, CmdUtils.getMessage("MSG_SERVER_NEW_FEATURES_NOT_REQUIRED", new Object[0]));
            return rc;
        }
        rc = this.assetInstallInit(featuresToInstall);
        if (this.isAlreadyInstalled) {
            HashSet<String> allServerNames = new HashSet<String>(this.servers.size());
            for (ServerAsset sa : this.servers) {
                allServerNames.add(sa.getServerName());
            }
            this.logger.log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_DEPLOY_NO_ADDITIONAL_FEATURES_REQUIRED", new Object[]{allServerNames}));
        } else {
            this.logger.log(Level.INFO, CmdUtils.getMessage("MSG_SERVER_NEW_FEATURES_REQUIRED", InstallUtils.getFeatureListOutput(featuresToInstall)));
        }
        return rc;
    }

    @Override
    ReturnCode execute() {
        ReturnCode rc = ReturnCode.OK;
        if (this.installPackage != null) {
            rc = this.deployServerPackage();
        }
        if (ReturnCode.OK.equals((Object)rc) && !this.servers.isEmpty()) {
            rc = this.installServerFeatures();
        }
        if (!(!ReturnCode.OK.equals((Object)rc) || this.esaFile == null && this.featureIds.isEmpty() || this.isAlreadyInstalled)) {
            rc = this.install();
        }
        if (ReturnCode.OK.equals((Object)rc)) {
            if (this.installPackage != null && this.installPackage.isServerPackage()) {
                this.logger.log(Level.INFO, CmdUtils.getMessage("MSG_DEPLOY_SERVER_PACKAGE_OK", new Object[0]));
            }
            if (!this.validateProduct()) {
                return ReturnCode.NOT_VALID_FOR_CURRENT_PRODUCT;
            }
        }
        return rc;
    }

    private InstallEventListener getNoStepListener() {
        if (this.ieNoStepListener == null) {
            this.ieNoStepListener = new InstallEventListener(){

                public void handleInstallEvent(InstallProgressEvent event) {
                    if (event.state == 8) {
                        InstallAction.this.logger.log(Level.INFO, event.message);
                    }
                }
            };
        }
        return this.ieNoStepListener;
    }

    private InstallEventListener getInstallListener() {
        int numInstallResources = this.installKernel.getPublicInstallResourcesSize();
        int numInstallAssets = this.installKernel.getPublicLocalInstallAssetsSize();
        return this.getListener(numInstallResources * 2 + numInstallAssets + 1 + 1);
    }

    private InstallEventListener getListener(final int progressSteps) {
        if (this.ielistener == null) {
            this.ielistener = new InstallEventListener(){
                int progressCurrentStep = 0;

                public void handleInstallEvent(InstallProgressEvent event) {
                    if (event.state != 176) {
                        InstallAction.this.logger.log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("PROGRESS_STEP", new Object[]{++this.progressCurrentStep, progressSteps}) + ": " + event.message);
                    }
                }
            };
        }
        return this.ielistener;
    }

    private void removeEventListener(boolean printNewline) {
        if (printNewline) {
            this.logger.log(Level.INFO, "");
        }
        if (null != this.ielistener) {
            this.installKernel.removeListener(this.ielistener);
            this.ielistener = null;
        }
        if (null != this.ieNoStepListener) {
            this.installKernel.removeListener(this.ieNoStepListener);
            this.ieNoStepListener = null;
        }
    }

    @Override
    protected void showMessagesForAdditionalFeatures() {
        boolean show = false;
        if (this.installPackage != null) {
            this.logger.log(Level.INFO, "");
            this.logger.log(Level.INFO, CmdUtils.getMessage("MSG_ADDITIONAL_FEATURES_FOR_SERVER_PACKAGE", new Object[0]));
            show = true;
        } else if (!this.servers.isEmpty()) {
            this.logger.log(Level.INFO, "");
            this.logger.log(Level.INFO, CmdUtils.getMessage("MSG_ADDITIONAL_FEATURES_FOR_SERVER", new Object[0]));
            show = true;
        }
        Collection samplesOrOpenSources = this.installKernel.getSamplesOrOpenSources();
        if (!samplesOrOpenSources.isEmpty()) {
            this.logger.log(Level.INFO, "");
            this.logger.log(Level.INFO, CmdUtils.getMessage("MSG_INSTALL_ADDITIONAL_FEATURES_FOR_SAMPLES", InstallUtils.getFeatureListOutput((Collection)samplesOrOpenSources)));
            show = true;
        }
        if (show) {
            this.logger.log(Level.INFO, "");
            this.logger.log(Level.INFO, CmdUtils.getMessage("MSG_INSTALL_ACCEPT_LICENSE_FOR_ADDITIONAL_FEATURES", new Object[0]));
        }
    }

    class InstallPackage {
        private File packageFile = null;
        private boolean serverPackage = false;

        InstallPackage(String fileName) throws InstallException, Throwable {
            this.initialize(fileName);
        }

        ReturnCode initialize(String fileName) throws InstallException, Throwable {
            this.packageFile = this.getValidPackageFile(fileName);
            if (ArchiveUtils.ArchiveFileType.JAR.isType(fileName)) {
                String license;
                Map manifestAttrs = ArchiveUtils.processArchiveManifest((File)this.packageFile);
                JarContentType jarType = this.determineJarContentType(manifestAttrs);
                if (!jarType.isSupported()) {
                    throw new InstallException(CmdUtils.getMessage("ERROR_ARCHIVE_NOT_SUPPORT", this.packageFile.getAbsolutePath()), 21);
                }
                this.serverPackage = jarType.isServerPackage();
                if (JarContentType.SAMPLE.equals((Object)jarType) && (license = ArchiveUtils.getLicenseAgreement((JarFile)new JarFile(this.packageFile), (Map)manifestAttrs)) != null) {
                    InstallAction.this.sampleLicenses = new HashSet();
                    InstallAction.this.sampleLicenses.add(license);
                }
            } else if (ArchiveUtils.ArchiveFileType.ZIP.isType(fileName) || ArchiveUtils.ArchiveFileType.PAX.isType(fileName)) {
                this.serverPackage = true;
            }
            return ReturnCode.OK;
        }

        private File getValidPackageFile(String fileName) throws InstallException {
            File f = new File(fileName);
            if (!f.exists()) {
                throw new InstallException(CmdUtils.getMessage("ERROR_DEPOLY_SERVER_PACKAGE_FILE_NOTEXIST", f.getAbsolutePath()), 21);
            }
            if (f.isDirectory()) {
                throw new InstallException(CmdUtils.getMessage("ERROR_DEPOLY_DIRECTORY", f.getAbsolutePath()), 21);
            }
            if (InstallAction.this.isPackage(fileName)) {
                return f;
            }
            throw new InstallException(CmdUtils.getMessage("ERROR_ARCHIVE_NOT_SUPPORT", f.getAbsolutePath()), 21);
        }

        boolean isServerPackage() {
            return this.serverPackage;
        }

        File getPackageFile() {
            return this.packageFile;
        }

        private JarContentType determineJarContentType(Map<String, String> manifestAttrs) {
            String archiveContentType = manifestAttrs.get("Archive-Content-Type");
            if (ArchiveUtils.ArchiveContentType.INSTALL.isContentType(archiveContentType)) {
                return JarContentType.INSTALL;
            }
            if (ArchiveUtils.ArchiveContentType.SAMPLE.isContentType(archiveContentType)) {
                return JarContentType.SAMPLE;
            }
            if (ArchiveUtils.ArchiveContentType.ADDON.isContentType(archiveContentType)) {
                return JarContentType.ADDON;
            }
            if (ArchiveUtils.ArchiveContentType.OPENSOURCE.isContentType(archiveContentType)) {
                return JarContentType.OPENSOURCE;
            }
            return JarContentType.UNKNOWN;
        }
    }

    private static enum JarContentType {
        ADDON(ArchiveUtils.ArchiveContentType.ADDON, false),
        INSTALL(ArchiveUtils.ArchiveContentType.INSTALL, true),
        SAMPLE(ArchiveUtils.ArchiveContentType.SAMPLE, true),
        OPENSOURCE(ArchiveUtils.ArchiveContentType.OPENSOURCE, false),
        UNKNOWN(null, false);

        private final ArchiveUtils.ArchiveContentType type;
        private final boolean supported;

        private JarContentType(ArchiveUtils.ArchiveContentType type, boolean supported) {
            this.type = type;
            this.supported = supported;
        }

        boolean isServerPackage() {
            return null == this.type ? false : this.type.isServerPackage();
        }

        boolean isSupported() {
            return this.supported;
        }
    }
}

