/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal.validator;

import com.ibm.websphere.config.ConfigValidationException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.internal.ServerConfiguration;
import com.ibm.ws.config.xml.internal.validator.ConfigKeySelector;
import com.ibm.ws.config.xml.internal.validator.XMLConfigValidator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class EmbeddedXMLConfigValidator
implements XMLConfigValidator {
    private static final String CLASS_NAME = EmbeddedXMLConfigValidator.class.getName();
    private static final TraceComponent tc = Tr.register(EmbeddedXMLConfigValidator.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private static final String LIBERTY_CERTIFICATE = "-----BEGIN CERTIFICATE-----\nMIIDqDCCApCgAwIBAgIEUMJaljANBgkqhkiG9w0BAQsFADCBlTELMAkGA1UEBhMCVVMxETAPBgNV\nBAgTCE5ldyBZb3JrMQ8wDQYDVQQHEwZBcm1vbmsxEjAQBgNVBAoTCUlCTSBDb3JwLjEXMBUGA1UE\nCxMOU29mdHdhcmUgR3JvdXAxNTAzBgNVBAMTLFdlYlNwaGVyZSBBcHBsaWNhdGlvbiBTZXJ2ZXIg\nTGliZXJ0eSBQcm9maWxlMB4XDTEyMTIwNzIxMDczNFoXDTMyMTIwMjIxMDczNFowgZUxCzAJBgNV\nBAYTAlVTMREwDwYDVQQIEwhOZXcgWW9yazEPMA0GA1UEBxMGQXJtb25rMRIwEAYDVQQKEwlJQk0g\nQ29ycC4xFzAVBgNVBAsTDlNvZnR3YXJlIEdyb3VwMTUwMwYDVQQDEyxXZWJTcGhlcmUgQXBwbGlj\nYXRpb24gU2VydmVyIExpYmVydHkgUHJvZmlsZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC\nggEBAJ8l5a67C3jNwuS9g0rYYJ3dDjnykECQGXgQ7sP5i9ixF0Gg6NYesjn6VUBhf8ziC/4R4yrf\nlPID+C1nM9SsUQld5QyAjbboRCXbW6+oIofzQKzWUHQQavXOXkH3i765GlsuME2qHYT+H8SQ0S0Z\n2ZMQGr8PXA8lzTSvExozx+oXRXaqG97cpfNDjVZVswxR9QL5h5GdZ7INtN6OcNiKalz5cF95G4Vv\nL1sjtRkPaupNV7C09hnw+UzdPjmxmIOkw6BbS/J0gkE+NSDjQCt1O4EalCOy1ERKMZIb3QsKyYQv\nebaXCm7u3aEy/yszaCwIIldSjYjM15SUQw20L5vbn/UCAwEAATANBgkqhkiG9w0BAQsFAAOCAQEA\neJICZmkkBYgMqcq17+GRTWaDvKkcmBdBaIi6DDuRM31FNI7AzB2uLX2vJzXrrxPW41YturXKAZf2\n5uKbgZOikO8e3djjCUhiLYhIm4aTJxPlrh+MejaNAwAVeZBunNrZL9VI8jtU/a1Vd9bEdQ305yXW\nzt5c5mfJB3Yrn0LmwYKiSfG2pERy0TVnCpNLM6iQ7O2lQLVXXwlxNthWyOavEqlK54LR1GoklhC4\nk1r4d/5Cc2tjsoIi1y9gZj0qZptJCM2o1RtWf/xa+MgIavH+M/FqLzphvGOoxkPOqOfgpLPhM7bp\nLM6xqhiqexE5Xxq0JiNaxDi5iVUoDDxXG8ZslA==\n-----END CERTIFICATE-----\n";
    private final DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
    private final XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance();
    private boolean errorMsgIssued = false;
    static final long serialVersionUID = -4198416263458732881L;

    protected EmbeddedXMLConfigValidator() {
        this.dbFactory.setNamespaceAware(true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InputStream validateResource(InputStream configDocInputStream, String docLocation) throws ConfigValidationException {
        this.errorMsgIssued = false;
        ByteArrayInputStream returnInputStream = null;
        try {
            byte[] bfr = new byte[4096];
            int len = 0;
            ByteArrayOutputStream bfrOutputStream = new ByteArrayOutputStream();
            while ((len = configDocInputStream.read(bfr, 0, bfr.length)) > -1) {
                bfrOutputStream.write(bfr, 0, len);
            }
            configDocInputStream.close();
            bfrOutputStream.close();
            ByteArrayInputStream validatorInputStream = new ByteArrayInputStream(bfrOutputStream.toByteArray());
            returnInputStream = new ByteArrayInputStream(bfrOutputStream.toByteArray());
            Document document = this.dbFactory.newDocumentBuilder().parse(validatorInputStream);
            this.verifyDocument(document, docLocation);
        }
        catch (Throwable bfr) {
            void t;
            FFDCFilter.processException((Throwable)bfr, (String)"com.ibm.ws.config.xml.internal.validator.EmbeddedXMLConfigValidator", (String)"146", (Object)this, (Object[])new Object[]{configDocInputStream, docLocation});
            if (!this.errorMsgIssued) {
                if (t instanceof SAXException) {
                    this.printErrorMessage("error.configValidator.parseFailed", docLocation, t.getMessage());
                } else if (t instanceof MarshalException) {
                    this.printErrorMessage("error.configValidator.unmarshalFailed", docLocation, t.getMessage());
                } else {
                    this.printErrorMessage("error.configValidator.error", docLocation, t.getMessage());
                }
            }
            FFDCFilter.processException((Throwable)t, (String)CLASS_NAME, (String)"138", (Object)this, (Object[])new Object[]{docLocation});
            returnInputStream = null;
            throw new ConfigValidationException("Configuration parsing encountered an invalid document", docLocation);
        }
        return returnInputStream;
    }

    /*
     * WARNING - void declaration
     */
    private void verifyDocument(Document document, String docLocation) throws Exception {
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList.getLength() == 0) {
            this.printErrorMessage("error.configValidator.signatureMissing", docLocation);
            throw new IllegalStateException("Unable to find the Signature element in " + docLocation);
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(LIBERTY_CERTIFICATE.getBytes());
        CertificateFactory certFactory = CertificateFactory.getInstance("X509");
        X509Certificate libertyCertificate = (X509Certificate)certFactory.generateCertificate(inStream);
        PublicKey libertyPublicKey = libertyCertificate.getPublicKey();
        ConfigKeySelector keySelector = new ConfigKeySelector();
        DOMValidateContext valContext = new DOMValidateContext(keySelector, nodeList.item(0));
        XMLSignature signature = this.sigFactory.unmarshalXMLSignature(valContext);
        boolean sigValid = signature.validate(valContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("verifyDocument():  sigValid = " + sigValid), (Object[])new Object[0]);
        }
        if (sigValid) {
            KeyInfo keyInfo;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"verifyDocument():  Signature passed core validation", (Object[])new Object[0]);
            }
            if ((keyInfo = signature.getKeyInfo()) == null) {
                this.printErrorMessage("error.configValidator.keyInfoMissing", docLocation);
                throw new IllegalStateException("Unable to find KeyInfo");
            }
            X509Data x509Data = null;
            X509Certificate cert = null;
            List<XMLStructure> keyInfoContent = keyInfo.getContent();
            block2: for (XMLStructure xmlStructure : keyInfoContent) {
                if (x509Data != null) break;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("verifyDocument():  xmlStructure = " + xmlStructure), (Object[])new Object[0]);
                }
                if (!(xmlStructure instanceof X509Data)) continue;
                x509Data = (X509Data)xmlStructure;
                for (Object obj : x509Data.getContent()) {
                    if (cert != null) continue block2;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("verifyDocument():  obj = " + obj), (Object[])new Object[0]);
                    }
                    if (!(obj instanceof X509Certificate)) continue;
                    cert = (X509Certificate)obj;
                    PublicKey signerPublicKey = cert.getPublicKey();
                    if (signerPublicKey.equals(libertyPublicKey)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Document signed by Liberty organization", (Object[])new Object[]{docLocation});
                        }
                        Tr.info((TraceComponent)tc, (String)"info.configValidator.documentValid", (Object[])new Object[]{docLocation});
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"verifyDocument():  Document was not signed by Liberty organization", (Object[])new Object[]{docLocation});
                    }
                    try {
                        cert.verify(libertyPublicKey);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"verifyDocument():  Liberty organization is the CA for document signer", (Object[])new Object[]{docLocation});
                        }
                        Tr.info((TraceComponent)tc, (String)"info.configValidator.documentValid", (Object[])new Object[]{docLocation});
                    }
                    catch (Throwable throwable) {
                        void t;
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.xml.internal.validator.EmbeddedXMLConfigValidator", (String)"285", (Object)this, (Object[])new Object[]{document, docLocation});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"verifyDocument():  Liberty organization is not the CA for document signer", (Object[])new Object[]{docLocation});
                        }
                        this.printErrorMessage("error.configValidator.signerNotAuthorized", docLocation);
                        FFDCFilter.processException((Throwable)t, (String)CLASS_NAME, (String)"282", (Object)this, (Object[])new Object[]{docLocation});
                        throw new IllegalStateException("Signer certificate not issued by Liberty", (Throwable)t);
                    }
                }
            }
            if (x509Data == null) {
                this.printErrorMessage("error.configValidator.x509DataMissing", docLocation);
                throw new IllegalStateException("Unable to find X509Data");
            }
            if (cert == null) {
                this.printErrorMessage("error.configValidator.x509CertificateMissing", docLocation);
                throw new IllegalStateException("Unable to find X509Certificate");
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"verifyDocument():  Signature failed core validation", (Object[])new Object[]{docLocation});
            }
            sigValid = signature.getSignatureValue().validate(valContext);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("verifyDocument():  sigValid = " + sigValid), (Object[])new Object[0]);
            }
            if (sigValid) {
                this.printErrorMessage("error.configValidator.protectedSectionModified", docLocation);
                throw new IllegalStateException("Protectioned section of config document modified");
            }
            this.printErrorMessage("error.configValidator.signatureNotValid", docLocation);
            throw new IllegalStateException("Config document contains invalid signature");
        }
    }

    @Override
    public void validateConfig(ServerConfiguration configuration) throws ConfigValidationException {
        boolean dropinsEnabled = configuration.isDropinsEnabled();
        if (dropinsEnabled) {
            Tr.fatal((TraceComponent)tc, (String)"fatal.configValidator.dropinsEnabled", (Object[])new Object[0]);
            throw new ConfigValidationException("Drop-ins enabled in embedded environment");
        }
    }

    private void printErrorMessage(String key, Object ... substitutions) {
        Tr.error((TraceComponent)tc, (String)key, (Object[])substitutions);
        this.errorMsgIssued = true;
    }
}

