/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.internal.classloader;

import com.ibm.ws.kernel.internal.classloader.JarFileClassLoader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public final class BootstrapChildFirstJarClassloader
extends JarFileClassLoader {
    static final String KERNEL_BOOT_CLASS_PREFIX = "com.ibm.ws.kernel.boot.";
    static final String KERNEL_BOOT_RESOURCE_PREFIX = "com/ibm/ws/kernel/boot/";
    static final int KERNEL_BOOT_PREFIX_LENGTH;
    private final ClassLoader parent;

    static <E> Enumeration<E> compoundEnumerations(Enumeration<E> e1, Enumeration<E> e2) {
        if (e2 == null || !e2.hasMoreElements()) {
            return e1;
        }
        if (e1 == null || !e1.hasMoreElements()) {
            return e2;
        }
        ArrayList<E> compoundResults = new ArrayList<E>();
        while (e1.hasMoreElements()) {
            compoundResults.add(e1.nextElement());
        }
        while (e2.hasMoreElements()) {
            E item = e2.nextElement();
            if (compoundResults.contains(item)) continue;
            compoundResults.add(item);
        }
        return Collections.enumeration(compoundResults);
    }

    public BootstrapChildFirstJarClassloader(URL[] urls, ClassLoader parent) {
        super(urls, false, parent);
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (name.regionMatches(0, KERNEL_BOOT_CLASS_PREFIX, 0, KERNEL_BOOT_PREFIX_LENGTH)) {
            return super.loadClass(name, resolve);
        }
        Class<?> result = null;
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            result = this.findLoadedClass(name);
            if (result == null) {
                result = this.findClass(name, true);
            }
        }
        if (result == null) {
            result = this.parent.loadClass(name);
        }
        return result;
    }

    @Override
    public URL getResource(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        URL result = null;
        if (name.regionMatches(0, KERNEL_BOOT_RESOURCE_PREFIX, 0, KERNEL_BOOT_PREFIX_LENGTH)) {
            result = super.getResource(name);
        } else {
            result = super.findResource(name);
            if (result == null) {
                result = super.getResource(name);
            }
        }
        return result;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (name == null || name.length() == 0) {
            return Collections.enumeration(Collections.emptyList());
        }
        Enumeration<URL> parentResources = super.getResources(name);
        Enumeration<URL> localResources = super.findResources(name);
        if (name.regionMatches(0, KERNEL_BOOT_RESOURCE_PREFIX, 0, KERNEL_BOOT_PREFIX_LENGTH)) {
            return BootstrapChildFirstJarClassloader.compoundEnumerations(parentResources, localResources);
        }
        return BootstrapChildFirstJarClassloader.compoundEnumerations(localResources, parentResources);
    }

    @Override
    public Enumeration<URL> findResources(String resourceName) throws IOException {
        return Collections.enumeration(Collections.emptyList());
    }

    static {
        ClassLoader.registerAsParallelCapable();
        KERNEL_BOOT_PREFIX_LENGTH = KERNEL_BOOT_CLASS_PREFIX.length();
    }
}

