/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import com.ibm.websphere.ras.TruncatableThrowable;
import com.ibm.ws.logging.hpel.DeserializerException;
import com.ibm.ws.logging.hpel.LogRecordSerializer;
import com.ibm.ws.logging.hpel.impl.HpelMessageConverter;
import com.ibm.ws.logging.object.hpel.RepositoryLogRecordImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class BinaryLogRecordSerializerVersion2Impl
implements LogRecordSerializer {
    private static final byte[] EYE_CATCHER = new byte[]{72, 80, 69, 76};
    private static final char RECORD_TYPE = '0';
    private static final char HEADER_TYPE = '1';
    private static final byte VERSION = 2;
    private static final Field[] ALL_FIELDS = new Field[]{new Field(){

        @Override
        String get(RepositoryLogRecord r) {
            return r.getRawMessage();
        }

        @Override
        void set(RepositoryLogRecordImpl r, String v) {
            r.setMessage(v);
        }
    }, new Field(){

        @Override
        String get(RepositoryLogRecord r) {
            return r.getLocalizedMessage();
        }

        @Override
        void set(RepositoryLogRecordImpl r, String v) {
            r.setLocalizedMessage(v);
        }
    }, new Field(){

        @Override
        String get(RepositoryLogRecord r) {
            return r.getLoggerName();
        }

        @Override
        void set(RepositoryLogRecordImpl r, String v) {
            r.setLoggerName(v);
        }
    }, new Field(){

        @Override
        String get(RepositoryLogRecord r) {
            return r.getResourceBundleName();
        }

        @Override
        void set(RepositoryLogRecordImpl r, String v) {
            r.setResourceBundleName(v);
        }
    }, new Field(){

        @Override
        String get(RepositoryLogRecord r) {
            return r.getSourceClassName();
        }

        @Override
        void set(RepositoryLogRecordImpl r, String v) {
            r.setSourceClassName(v);
        }
    }, new Field(){

        @Override
        String get(RepositoryLogRecord r) {
            return r.getSourceMethodName();
        }

        @Override
        void set(RepositoryLogRecordImpl r, String v) {
            r.setSourceMethodName(v);
        }
    }, new Field(){

        @Override
        String get(RepositoryLogRecord r) {
            return r.getStackTrace();
        }

        @Override
        void set(RepositoryLogRecordImpl r, String v) {
            r.setStackTrace(v);
        }
    }, new Field(){

        @Override
        String get(RepositoryLogRecord r) {
            return r.getExtension("UOW");
        }

        @Override
        void set(RepositoryLogRecordImpl r, String v) {
            r.setExtension("UOW", v);
        }
    }, new Field(){

        @Override
        String get(RepositoryLogRecord r) {
            return r.getExtension("component");
        }

        @Override
        void set(RepositoryLogRecordImpl r, String v) {
            r.setExtension("component", v);
        }
    }, new Field(){

        @Override
        String get(RepositoryLogRecord r) {
            return r.getExtension("prod");
        }

        @Override
        void set(RepositoryLogRecordImpl r, String v) {
            r.setExtension("prod", v);
        }
    }, new Field(){

        @Override
        String get(RepositoryLogRecord r) {
            return r.getExtension("org");
        }

        @Override
        void set(RepositoryLogRecordImpl r, String v) {
            r.setExtension("org", v);
        }
    }, new Field(){

        @Override
        String get(RepositoryLogRecord r) {
            return r.getExtension("thread");
        }

        @Override
        void set(RepositoryLogRecordImpl r, String v) {
            r.setExtension("thread", v);
        }
    }, new Field(){

        @Override
        String get(RepositoryLogRecord r) {
            return r.getExtension(BinaryLogRecordSerializerVersion2Impl.REQUESTID);
        }

        @Override
        void set(RepositoryLogRecordImpl r, String v) {
            r.setExtension(BinaryLogRecordSerializerVersion2Impl.REQUESTID, v);
        }
    }, new Field(){

        @Override
        String get(RepositoryLogRecord r) {
            return r.getExtension(BinaryLogRecordSerializerVersion2Impl.APPNAME);
        }

        @Override
        void set(RepositoryLogRecordImpl r, String v) {
            r.setExtension(BinaryLogRecordSerializerVersion2Impl.APPNAME, v);
        }
    }};
    private static final String REQUESTID = "requestID";
    private static final String APPNAME = "appName";
    private static final String[] SPECIAL_EXTENSIONS = new String[]{"UOW", "component", "prod", "org", "thread", "requestID", "appName"};
    private static final String[] locales = new String[]{"cs_CZ", "de_DE", "en_GB", "en_US", "es_ES", "fr_FR", "hu_HU", "it_IT", "ja_JP", "ko_KR", "pl_PL", "pt_BR", "ro_RO", "ru_RU", "zh_TW", "zh_CN"};
    private static long counter = 0L;
    private static final int BUFFER_SIZE = 1024;
    private static final char BYTE_ID = 'B';
    private static final char SHORT_ID = 'S';
    private static final char INTEGER_ID = 'I';
    private static final char CHAR_ID = 'C';
    private static final char LONG_ID = 'L';
    private static final char FLOAT_ID = 'F';
    private static final char DOUBLE_ID = 'D';
    private static final char DATE_ID = 'T';
    private static final char STRING_ID = 'O';
    private static final char NULL_ID = 'N';

    private void writeHeader(char type, DataOutput writer) throws IOException {
        BinaryLogRecordSerializerVersion2Impl.serializeEyeCatcher(writer);
        writer.writeByte(2);
        writer.writeByte(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFixedFields(long millis, Level level, int threadId, long seq, DataOutput writer) throws IOException {
        writer.writeLong(millis);
        Class<BinaryLogRecordSerializerVersion2Impl> clazz = BinaryLogRecordSerializerVersion2Impl.class;
        synchronized (BinaryLogRecordSerializerVersion2Impl.class) {
            long seqNumber = counter++;
            // ** MonitorExit[var10_6] (shouldn't be in output)
            writer.writeLong(seqNumber);
            writer.writeShort(level.intValue());
            writer.writeInt(threadId);
            writer.writeLong(seq);
            return;
        }
    }

    @Override
    public void serialize(RepositoryLogRecord logRecord, DataOutput writer) throws IOException {
        byte[] rawData;
        Map<String, String> extensionsMap;
        Object[] params;
        this.writeHeader('0', writer);
        this.writeFixedFields(logRecord.getMillis(), logRecord.getLevel(), logRecord.getThreadID(), logRecord.getSequence(), writer);
        byte bitmapKey = (byte)(ALL_FIELDS.length + 7 >> 5);
        byte[] bitmap = new byte[(bitmapKey + 1) * 4];
        Arrays.fill(bitmap, (byte)0);
        bitmap[0] = (byte)(bitmap[0] | bitmapKey << 6);
        bitmap[0] = (byte)(bitmap[0] | logRecord.getLocalizable() << 4);
        String locale = logRecord.getMessageLocale();
        if (locale == null) {
            locale = Locale.getDefault().toString();
        }
        int localeId = -1;
        for (int i = 0; i < locales.length; ++i) {
            if (!locales[i].equals(locale)) continue;
            localeId = i;
            bitmap[0] = (byte)(bitmap[0] | 8);
            break;
        }
        if ((params = logRecord.getParameters()) != null) {
            bitmap[0] = (byte)(bitmap[0] | 4);
        }
        if ((extensionsMap = logRecord.getExtensions()) != null) {
            HashMap<String, String> extensionsCopy = null;
            for (String key : SPECIAL_EXTENSIONS) {
                if (!extensionsMap.containsKey(key)) continue;
                if (extensionsCopy == null) {
                    extensionsCopy = new HashMap<String, String>(extensionsMap);
                }
                extensionsCopy.remove(key);
            }
            if (extensionsCopy != null) {
                extensionsMap = extensionsCopy;
            }
            if (extensionsMap != null) {
                bitmap[0] = (byte)(bitmap[0] | 2);
            }
        }
        if ((rawData = logRecord.getRawData()) != null) {
            bitmap[0] = (byte)(bitmap[0] | 1);
        }
        String[] fields = new String[ALL_FIELDS.length];
        int count = 0;
        for (int id = 0; id < ALL_FIELDS.length; id = (int)((byte)(id + 1))) {
            String value = ALL_FIELDS[id].get(logRecord);
            if (value == null) continue;
            int n = (id >> 3) + 1;
            bitmap[n] = (byte)(bitmap[n] | 1 << (id & 7));
            fields[count++] = value;
        }
        writer.write(bitmap);
        if (localeId < 0) {
            BinaryLogRecordSerializerVersion2Impl.writeString(locale, writer);
        } else {
            writer.writeByte(localeId);
        }
        if (params != null) {
            writer.writeInt(params.length);
            for (int i = 0; i < params.length; ++i) {
                BinaryLogRecordSerializerVersion2Impl.writeParam(params[i], writer);
            }
        }
        if (extensionsMap != null) {
            writer.writeInt(extensionsMap.size());
            for (Map.Entry<String, String> entry : extensionsMap.entrySet()) {
                BinaryLogRecordSerializerVersion2Impl.writeString(entry.getKey(), writer);
                BinaryLogRecordSerializerVersion2Impl.writeString(entry.getValue(), writer);
            }
        }
        if (rawData != null) {
            writer.writeInt(rawData.length);
            writer.write(rawData);
        }
        for (int i = 0; i < count; ++i) {
            BinaryLogRecordSerializerVersion2Impl.writeString(fields[i], writer);
        }
    }

    @Override
    public void serializeFileHeader(Properties header, DataOutput writer) throws IOException {
        this.writeHeader('1', writer);
        for (Map.Entry<Object, Object> entry : header.entrySet()) {
            if (entry.getKey() == null) continue;
            BinaryLogRecordSerializerVersion2Impl.writeString((String)entry.getKey(), writer);
            BinaryLogRecordSerializerVersion2Impl.writeString((String)entry.getValue(), writer);
        }
        BinaryLogRecordSerializerVersion2Impl.writeString(null, writer);
    }

    @Override
    public RepositoryLogRecordImpl deserializeLogTime(DataInput reader) throws IOException {
        RepositoryLogRecordImpl logRecord = new RepositoryLogRecordImpl();
        logRecord.setMillis(reader.readLong());
        logRecord.setInternalSeqNumber(reader.readLong());
        return logRecord;
    }

    @Override
    public void deserializeLogHead(RepositoryLogRecordImpl logRecord, DataInput reader) throws IOException {
        logRecord.setLevel(reader.readShort());
        logRecord.setThreadID(reader.readInt());
        logRecord.setSequence(reader.readLong());
    }

    @Override
    public void deserializeLogRecord(RepositoryLogRecordImpl logRecord, DataInput reader) throws IOException {
        int size;
        int firstByte = reader.readUnsignedByte();
        byte bitmapKey = (byte)(firstByte >>> 6);
        byte[] bitmap = new byte[(bitmapKey + 1) * 4];
        bitmap[0] = (byte)(0x3F & firstByte);
        reader.readFully(bitmap, 1, bitmap.length - 1);
        logRecord.setLocalizable(3 & bitmap[0] >>> 4);
        if ((bitmap[0] & 8) != 0) {
            int localeId = reader.readUnsignedByte();
            if (localeId < 0 || localeId >= locales.length) {
                throw new DeserializerException("Incorrect locale indicator", "[0," + (locales.length - 1) + "]", Integer.toString(localeId));
            }
            logRecord.setMessageLocale(locales[localeId]);
        } else {
            logRecord.setMessageLocale(BinaryLogRecordSerializerVersion2Impl.readString(reader));
        }
        if ((bitmap[0] & 4) != 0) {
            Object[] params;
            size = reader.readInt();
            if (size < 0) {
                throw new DeserializerException("Incorrect number of parameters", "positive integer", Integer.toString(size));
            }
            if (size <= 1024) {
                params = new Object[size];
                for (int i = 0; i < size; ++i) {
                    params[i] = BinaryLogRecordSerializerVersion2Impl.readParam(reader);
                }
            } else {
                ParamChunk start = new ParamChunk(reader, 1024);
                start.readAll(reader, size);
                params = new Object[size];
                start.copyAll(params);
            }
            logRecord.setParameters(params);
        } else {
            logRecord.setParameters(null);
        }
        if ((bitmap[0] & 2) != 0) {
            size = reader.readInt();
            if (size >= 0) {
                for (int i = 0; i < size; ++i) {
                    String key = BinaryLogRecordSerializerVersion2Impl.readString(reader);
                    String value = BinaryLogRecordSerializerVersion2Impl.readString(reader);
                    logRecord.setExtension(key, value);
                }
            } else {
                throw new DeserializerException("Incorrect number of extensions", "positive integer", Integer.toString(size));
            }
        }
        if ((bitmap[0] & 1) != 0) {
            byte[] rawData;
            size = reader.readInt();
            if (size < 0) {
                throw new DeserializerException("Incorrect size of rawData", "positive integer", Integer.toString(size));
            }
            if (size <= 1024) {
                rawData = new byte[size];
                reader.readFully(rawData);
            } else {
                RawDataChunk start = new RawDataChunk(reader, 1024);
                start.readAll(reader, size);
                rawData = new byte[size];
                start.copyAll(rawData);
            }
            logRecord.setRawData(rawData);
        } else {
            logRecord.setRawData(null);
        }
        int bitsToCheck = Math.min(bitmap.length - 1 << 3, ALL_FIELDS.length);
        for (int id = 0; id < bitsToCheck; id = (int)((byte)(id + 1))) {
            if ((bitmap[(id >> 3) + 1] & 1 << (id & 7)) == 0) continue;
            ALL_FIELDS[id].set(logRecord, BinaryLogRecordSerializerVersion2Impl.readString(reader));
        }
        String result = logRecord.getLocalizedMessage() != null ? logRecord.getLocalizedMessage() : logRecord.getRawMessage();
        logRecord.setMessageID(HpelMessageConverter.getMessageId(result));
        try {
            byte value = reader.readByte();
            throw new DeserializerException("Unexpected bytes in the stream", "nothing", Byte.toString(value));
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    @Override
    public Properties deserializeFileHeader(DataInput reader) throws IOException {
        Properties header = new Properties();
        String key = BinaryLogRecordSerializerVersion2Impl.readString(reader);
        while (key != null) {
            header.put(key, BinaryLogRecordSerializerVersion2Impl.readString(reader));
            key = BinaryLogRecordSerializerVersion2Impl.readString(reader);
        }
        try {
            byte value = reader.readByte();
            throw new DeserializerException("Unexpected bytes in the stream", "nothing", Byte.toString(value));
        }
        catch (EOFException eOFException) {
            return header;
        }
    }

    private static void serializeEyeCatcher(DataOutput writer) throws IOException {
        writer.write(EYE_CATCHER);
    }

    @Override
    public int getEyeCatcherSize() {
        return EYE_CATCHER.length;
    }

    @Override
    public int getType(DataInput reader) throws IOException {
        BinaryLogRecordSerializerVersion2Impl.deserializeEyeCatcher(reader);
        byte version = reader.readByte();
        if (2 != version) {
            throw new DeserializerException("Wrong version of the log format", Byte.toString((byte)2), Byte.toString(version));
        }
        char c = (char)reader.readByte();
        switch (c) {
            case '1': {
                return 0;
            }
            case '0': {
                return 1;
            }
        }
        throw new DeserializerException("Unknown log record type.", "0x" + Integer.toHexString(49) + " or 0x" + Integer.toHexString(48), "0x" + Integer.toHexString(c));
    }

    private static void deserializeEyeCatcher(DataInput reader) throws IOException {
        byte[] catchedEye = new byte[EYE_CATCHER.length];
        reader.readFully(catchedEye);
        for (int i = 0; i < EYE_CATCHER.length; ++i) {
            if (EYE_CATCHER[i] == catchedEye[i]) continue;
            throw new DeserializerException("Failed to find an eyeCatcher in a log record file.", BinaryLogRecordSerializerVersion2Impl.displayBytes(EYE_CATCHER), BinaryLogRecordSerializerVersion2Impl.displayBytes(catchedEye));
        }
    }

    private static String displayBytes(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder("[");
        for (int i = 0; i < bytes.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append("0x");
            buffer.append(Integer.toHexString(bytes[i]));
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public int findFirstEyeCatcher(byte[] buffer, int off, int len) {
        if (off < 0 || off >= buffer.length) {
            throw new IllegalArgumentException("Offset should be in the buffer boundaries");
        }
        if (off + len > buffer.length) {
            len = buffer.length - off;
        }
        int p = off + EYE_CATCHER.length - 1;
        int i = EYE_CATCHER.length - 1;
        while (i >= 0) {
            if (p >= off + len) {
                return -1;
            }
            byte b = buffer[p];
            if (b != EYE_CATCHER[i]) {
                if (i == EYE_CATCHER.length - 1) {
                    --i;
                    while (i >= 0 && b != EYE_CATCHER[i]) {
                        --i;
                    }
                    p += EYE_CATCHER.length - i;
                } else {
                    p += EYE_CATCHER.length * 2 - i;
                }
                i = EYE_CATCHER.length;
            }
            --i;
            --p;
        }
        return p + 1;
    }

    @Override
    public int findLastEyeCatcher(byte[] buffer, int off, int len) {
        if (off < 0 || off >= buffer.length) {
            throw new IllegalArgumentException("Offset should be in the buffer boundaries");
        }
        if (off + len > buffer.length) {
            len = buffer.length - off;
        }
        int p = off + len - EYE_CATCHER.length;
        int i = 0;
        while (i < EYE_CATCHER.length) {
            if (p < off) {
                return -1;
            }
            byte b = buffer[p];
            if (b != EYE_CATCHER[i]) {
                if (i == 0) {
                    ++i;
                    while (i < EYE_CATCHER.length && b != EYE_CATCHER[i]) {
                        ++i;
                    }
                    p -= i + 1;
                } else {
                    p -= EYE_CATCHER.length + i + 1;
                }
                i = -1;
            }
            ++i;
            ++p;
        }
        return p - EYE_CATCHER.length;
    }

    private static void writeString(String str, DataOutput writer) throws IOException {
        if (str == null) {
            writer.writeByte(0);
        } else {
            int blocks = str.length() >> 15;
            if (blocks > 0x3FFFFF) {
                writer.writeByte(0xC0 | blocks >> 24);
                writer.writeByte(0xFF & blocks >> 16);
                writer.writeByte(0xFF & blocks >> 8);
            } else if (blocks > 16383) {
                writer.writeByte(0x80 | blocks >> 16);
                writer.writeByte(0xFF & blocks >> 8);
            } else if (blocks > 63) {
                writer.writeByte(0x40 | blocks >> 8);
            }
            writer.writeByte(0xFF & blocks + 1);
            int end = 0;
            for (int i = 0; i < blocks; ++i) {
                int start = end;
                end = i + 1 << 15;
                writer.writeUTF(str.substring(start, end));
            }
            writer.writeUTF(str.substring(end));
        }
    }

    private static String readString(DataInput reader) throws IOException {
        String result;
        int blocks = reader.readUnsignedByte();
        int bitMask = blocks & 0xC0;
        if (bitMask == 64) {
            blocks = (0x3F & blocks) << 8 | reader.readUnsignedByte();
        } else if (bitMask == 128) {
            blocks = (0x3F & blocks) << 16 | reader.readUnsignedByte() << 8 | reader.readUnsignedByte();
        } else if (bitMask == 192) {
            blocks = (0x3F & blocks) << 24 | reader.readUnsignedByte() << 16 | reader.readUnsignedByte() << 8 | reader.readUnsignedByte();
        }
        if (blocks == 0) {
            result = null;
        } else {
            if (blocks < 0) {
                throw new DeserializerException("Wrong 'null' indicator for a string", "0", Integer.toString(blocks));
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < blocks; ++i) {
                sb.append(reader.readUTF());
            }
            result = sb.toString();
        }
        return result;
    }

    private static void writeParam(Object v, DataOutput writer) throws IOException {
        if (v instanceof Byte) {
            writer.write(66);
            writer.writeByte(((Byte)v).byteValue());
        } else if (v instanceof Short) {
            writer.write(83);
            writer.writeShort(((Short)v).shortValue());
        } else if (v instanceof Integer) {
            writer.write(73);
            writer.writeInt((Integer)v);
        } else if (v instanceof Character) {
            writer.write(67);
            writer.writeChar(((Character)v).charValue());
        } else if (v instanceof Long) {
            writer.write(76);
            writer.writeLong((Long)v);
        } else if (v instanceof Float) {
            writer.write(70);
            writer.writeFloat(((Float)v).floatValue());
        } else if (v instanceof Double) {
            writer.write(68);
            writer.writeDouble((Double)v);
        } else if (v instanceof Date) {
            writer.write(84);
            writer.writeLong(((Date)v).getTime());
        } else if (v != null) {
            writer.write(79);
            if (v instanceof Throwable) {
                if (v instanceof TruncatableThrowable) {
                    BinaryLogRecordSerializerVersion2Impl.writeString(RasHelper.throwableToString((Throwable)((TruncatableThrowable)v).getWrappedException()), writer);
                } else {
                    BinaryLogRecordSerializerVersion2Impl.writeString(RasHelper.throwableToString((Throwable)((Throwable)v)), writer);
                }
            } else {
                BinaryLogRecordSerializerVersion2Impl.writeString(v.toString(), writer);
            }
        } else {
            writer.write(78);
        }
    }

    private static Object readParam(DataInput reader) throws IOException {
        int type = reader.readUnsignedByte();
        switch (type) {
            case 66: {
                return reader.readByte();
            }
            case 83: {
                return reader.readShort();
            }
            case 73: {
                return reader.readInt();
            }
            case 67: {
                return Character.valueOf(reader.readChar());
            }
            case 76: {
                return reader.readLong();
            }
            case 70: {
                return Float.valueOf(reader.readFloat());
            }
            case 68: {
                return reader.readDouble();
            }
            case 84: {
                return new Date(reader.readLong());
            }
            case 79: {
                return BinaryLogRecordSerializerVersion2Impl.readString(reader);
            }
            case 78: {
                return null;
            }
        }
        throw new DeserializerException("Wrong type of a parameter", "one of the B,S,I,C,L,F,D,T,O,N", Character.toString((char)type));
    }

    private static class RawDataChunk
    extends Chunk {
        RawDataChunk(DataInput reader, int len) throws IOException {
            super(new byte[1024], len);
            byte[] buffer = (byte[])this.buffer;
            reader.readFully(buffer, 0, len);
        }

        @Override
        Chunk readNext(DataInput reader, int len) throws IOException {
            return new RawDataChunk(reader, len);
        }
    }

    private static class ParamChunk
    extends Chunk {
        ParamChunk(DataInput reader, int len) throws IOException {
            super(new Object[1024], len);
            Object[] buffer = (Object[])this.buffer;
            for (int i = 0; i < len; ++i) {
                buffer[i] = BinaryLogRecordSerializerVersion2Impl.readParam(reader);
            }
        }

        @Override
        Chunk readNext(DataInput reader, int len) throws IOException {
            return new ParamChunk(reader, len);
        }
    }

    private static abstract class Chunk {
        Chunk next = null;
        final Object buffer;
        final int len;

        Chunk(Object buffer, int len) {
            this.buffer = buffer;
            this.len = len;
        }

        void readAll(DataInput reader, int size) throws IOException {
            Chunk current = this;
            for (int remind = size - 1024; remind > 0; remind -= current.len) {
                current = current.next = this.readNext(reader, remind < 1024 ? remind : 1024);
            }
        }

        void copyAll(Object dst) {
            Chunk current = this;
            int offset = 0;
            while (current != null) {
                System.arraycopy(current.buffer, 0, dst, offset, current.len);
                offset += current.len;
                current = current.next;
            }
        }

        abstract Chunk readNext(DataInput var1, int var2) throws IOException;
    }

    private static abstract class Field {
        private Field() {
        }

        abstract String get(RepositoryLogRecord var1);

        abstract void set(RepositoryLogRecordImpl var1, String var2);
    }
}

