/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.websphere.logging.hpel.reader.GenericFile;
import com.ibm.ws.logging.hpel.LogFileReader;
import com.ibm.ws.logging.hpel.impl.AccessHelper;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class LogFileReaderImpl
implements LogFileReader {
    public static final int MAXSIZE = 0x4000000;
    private int pointer = 0;
    private byte[] buffer;
    private final byte[] size = new byte[4];

    public LogFileReaderImpl(File file) throws IOException {
        if (!AccessHelper.isFile(file)) {
            throw new IOException("File \"" + file.getAbsolutePath() + "\" is not an existing file.");
        }
        long length = AccessHelper.getFileLength(file);
        if (length > 0x4000000L) {
            throw new IOException("File \"" + file.getAbsolutePath() + "\" is " + length + " bytes long which is too big for a WBL file");
        }
        if (length < 4L) {
            throw new IOException("File \"" + file.getAbsolutePath() + "\" is " + length + " bytes long which is too small for a WBL file");
        }
        this.buffer = new byte[(int)length];
        if (length > 0L) {
            int read;
            InputStream fis = file instanceof GenericFile ? ((GenericFile)((Object)file)).getInputStream() : AccessHelper.createFileInputStream(file);
            int offset = 0;
            while ((read = fis.read(this.buffer, offset, this.buffer.length - offset)) > 0 && (offset += read) < this.buffer.length) {
            }
            fis.close();
            if (offset < this.buffer.length) {
                throw new IllegalArgumentException("Failed to read all " + this.buffer.length + " bytes from file \"" + file.getAbsolutePath() + "\". Only " + this.buffer.length + "bytes were read.");
            }
        }
    }

    public LogFileReaderImpl(LogFileReaderImpl other) throws IOException {
        this.pointer = other.pointer;
        this.buffer = other.buffer == null ? null : Arrays.copyOf(other.buffer, other.buffer.length);
    }

    @Override
    public int readLength() throws IOException {
        this.readFully(this.size, 0, 4);
        return (0xFF & this.size[0]) << 24 | (0xFF & this.size[1]) << 16 | (0xFF & this.size[2]) << 8 | 0xFF & this.size[3];
    }

    @Override
    public void close() throws IOException {
        this.buffer = null;
    }

    @Override
    public boolean isOpen() {
        return this.buffer != null;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.pointer;
    }

    @Override
    public long length() throws IOException {
        if (this.buffer == null) {
            throw new EOFException();
        }
        return this.buffer.length;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.buffer == null || pos > (long)this.buffer.length || pos < 0L) {
            throw new EOFException();
        }
        this.pointer = (int)pos;
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new IllegalArgumentException("Argument 'b' can't be 'null");
        }
        if (off < 0 || len < 0) {
            throw new IllegalArgumentException("Neither 'off' (" + off + ") nor 'len' (" + len + ") can have negative value.");
        }
        if (off + len > b.length) {
            throw new IllegalArgumentException("Sum of 'off' (" + off + ") and 'len' (" + len + ") can't be bigger than 'b.length' (" + b.length + ").");
        }
        if (this.buffer == null || this.pointer + len > this.buffer.length) {
            throw new EOFException();
        }
        System.arraycopy(this.buffer, this.pointer, b, off, len);
        this.pointer += len;
    }
}

