/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cloud.productinsights;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AggregationMethodDescriptor<T extends AggregationMethodDescriptor<?>> {
    protected Set<SliceAggregationMethod> sliceAggregationMethods;
    protected Set<RangeAggregationMethod> rangeAggregationMethods;

    public Set<SliceAggregationMethod> getSliceAggregationMethods() {
        return this.sliceAggregationMethods;
    }

    public Set<String> getSliceAggregationMethodNames() {
        if (this.sliceAggregationMethods != null) {
            if (this.sliceAggregationMethods.contains((Object)SliceAggregationMethod.NONE)) {
                return Collections.emptySet();
            }
            HashSet<String> names = new HashSet<String>();
            for (SliceAggregationMethod slice : this.sliceAggregationMethods) {
                names.add(slice.toString());
            }
            return names;
        }
        return null;
    }

    public Set<RangeAggregationMethod> getRangeAggregationMethods() {
        return this.rangeAggregationMethods;
    }

    public Set<String> getRangeAggregationMethodNames() {
        if (this.rangeAggregationMethods != null) {
            if (this.rangeAggregationMethods.contains((Object)RangeAggregationMethod.NONE)) {
                return Collections.emptySet();
            }
            HashSet<String> names = new HashSet<String>();
            for (RangeAggregationMethod range : this.rangeAggregationMethods) {
                names.add(range.toString());
            }
            return names;
        }
        return null;
    }

    public AggregationMethodDescriptor<T> setSliceAggregationMethods(SliceAggregationMethod ... aggregationMethods) {
        if (aggregationMethods != null && aggregationMethods.length > 0) {
            this.sliceAggregationMethods = new HashSet<SliceAggregationMethod>(Arrays.asList(aggregationMethods));
            if (this.sliceAggregationMethods.contains((Object)SliceAggregationMethod.NONE) && this.sliceAggregationMethods.size() != 1) {
                throw new IllegalArgumentException("NONE cannot be combined with other values");
            }
        } else {
            this.sliceAggregationMethods = null;
        }
        return this;
    }

    public AggregationMethodDescriptor<T> setRangeAggregationMethods(RangeAggregationMethod ... aggregationMethods) {
        if (aggregationMethods != null && aggregationMethods.length > 0) {
            this.rangeAggregationMethods = new HashSet<RangeAggregationMethod>(Arrays.asList(aggregationMethods));
            if (this.rangeAggregationMethods.contains((Object)RangeAggregationMethod.NONE) && this.rangeAggregationMethods.size() != 1) {
                throw new IllegalArgumentException("NONE cannot be combined with other values");
            }
        } else {
            this.rangeAggregationMethods = null;
        }
        return this;
    }

    public static enum SliceAggregationMethod {
        NONE,
        MIN,
        MAX,
        AVG,
        SUM,
        LAST;

    }

    public static enum RangeAggregationMethod {
        NONE,
        MIN,
        MAX,
        AVG,
        SUM,
        LAST,
        AVG_SUM,
        MIN_SUM,
        MAX_SUM,
        AVG_AVG;

    }
}

