/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.usage.metering;

public class MetricCapDescriptor {
    public static final String CAP_ALGORITHM_CONCURRENT = "concurrent_duration_cap";
    public static final String CAP_ALGORITHM_SHARED = "shared_duration_cap";
    public static final String CAP_ALGORITHM_CONCURRENT_MAX = "concurrent_max_cap";
    private static final String CAP_ALGORITHM_DEFAULT = "concurrent_duration_cap";
    private final String capMetricType;
    private final Number cap;
    private final String capAlgorithm;
    private final String capGroupId;

    public MetricCapDescriptor(String capMetricType, Number cap) {
        this(capMetricType, cap, "concurrent_duration_cap", null);
    }

    public MetricCapDescriptor(String capMetricType, Number cap, String capAlgorithm, String capGroupId) {
        if (capMetricType == null || capMetricType.equals("")) {
            throw new IllegalArgumentException("capMetricType cannot be null or an empty string.");
        }
        if (capAlgorithm == null || capAlgorithm.equals("")) {
            throw new IllegalArgumentException("capAlgorithm cannot be null or an empty string.");
        }
        if (capGroupId != null && capGroupId.equals("")) {
            throw new IllegalArgumentException("capGroupId cannot be an empty string.");
        }
        this.capMetricType = capMetricType;
        this.cap = cap;
        this.capAlgorithm = capAlgorithm;
        this.capGroupId = capGroupId;
    }

    public String getCapMetricType() {
        return this.capMetricType;
    }

    public Number getCap() {
        return this.cap;
    }

    public String getCapAlgorithm() {
        return this.capAlgorithm;
    }

    public String getCapGroupId() {
        return this.capGroupId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode()) + "(capMetricType: " + this.capMetricType + ", cap: " + this.cap + ", capAlgorithm: " + this.capAlgorithm + ", capGroup: " + this.capGroupId + ")";
    }
}

