/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdkhttp;

import com.sun.net.httpserver.HttpServer;
import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.Application;
import java.util.concurrent.CompletableFuture;
import org.glassfish.jersey.jdkhttp.JdkHttpHandlerContainer;
import org.glassfish.jersey.jdkhttp.JdkHttpServerFactory;
import org.glassfish.jersey.server.JerseySeBootstrapConfiguration;
import org.glassfish.jersey.server.spi.WebServer;

final class JdkHttpServer
implements WebServer {
    private final JdkHttpHandlerContainer container;
    private final HttpServer httpServer;

    JdkHttpServer(Application application, JerseySeBootstrapConfiguration configuration) {
        this(new JdkHttpHandlerContainer(application), configuration);
    }

    JdkHttpServer(Class<? extends Application> applicationClass, JerseySeBootstrapConfiguration configuration) {
        this(new JdkHttpHandlerContainer(applicationClass), configuration);
    }

    JdkHttpServer(JdkHttpHandlerContainer container, JerseySeBootstrapConfiguration configuration) {
        SeBootstrap.Configuration.SSLClientAuthentication sslClientAuthentication = configuration.sslClientAuthentication();
        this.container = container;
        this.httpServer = JdkHttpServerFactory.createHttpServer(configuration.uri(true), this.container, configuration.sslContext(), sslClientAuthentication == SeBootstrap.Configuration.SSLClientAuthentication.OPTIONAL, sslClientAuthentication == SeBootstrap.Configuration.SSLClientAuthentication.MANDATORY, configuration.autoStart());
    }

    @Override
    public final JdkHttpHandlerContainer container() {
        return this.container;
    }

    @Override
    public final int port() {
        return this.httpServer.getAddress().getPort();
    }

    public final CompletableFuture<Void> start() {
        return CompletableFuture.runAsync(this.httpServer::start);
    }

    public final CompletableFuture<Void> stop() {
        return CompletableFuture.runAsync(() -> this.httpServer.stop(0));
    }

    @Override
    public final <T> T unwrap(Class<T> nativeClass) {
        return nativeClass.cast(this.httpServer);
    }
}

