/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.mvngolang.AbstractGoDependencyAwareMojo;
import com.igormaznitsa.mvngolang.utils.ProxySettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.zeroturnaround.exec.ProcessExecutor;

@Mojo(name="jfrog-cli", defaultPhase=LifecyclePhase.NONE, threadSafe=true)
public class GolangJfrogCliMojo
extends AbstractGoDependencyAwareMojo {
    @Parameter(name="cliPath", required=true)
    private String cliPath;
    @Parameter(name="target", defaultValue="rt")
    private String target = "rt";
    @Parameter(name="command", defaultValue="go")
    private String command = "go";
    @Parameter(name="arguments")
    private List<String> arguments = new ArrayList<String>();

    @Nonnull
    @MustNotContainNull
    public List<String> getArguments() {
        return this.arguments;
    }

    @Nonnull
    public String getCliPath() {
        return this.cliPath;
    }

    @Nonnull
    public String getTarget() {
        return this.target;
    }

    @Nonnull
    public String getCommand() {
        return this.command;
    }

    @Override
    @Nullable
    protected String getSkipMojoPropertySuffix() {
        return "jfrog";
    }

    @Override
    @Nonnull
    protected ProcessExecutor prepareExecutor(@Nullable ProxySettings proxySettings) throws IOException, MojoFailureException, MojoExecutionException {
        this.initConsoleBuffers();
        File goRoot = this.findGoRoot(proxySettings);
        String gobin = this.getGoBin();
        String gocache = this.getGoCache();
        File[] gopathParts = this.findGoPath(true);
        ArrayList<String> cliList = new ArrayList<String>();
        cliList.add(this.getCliPath());
        cliList.add(this.getTarget());
        cliList.add(this.getCommand());
        this.getLog().info((CharSequence)("JFrog CLI: " + this.getCliPath()));
        this.getLog().info((CharSequence)("   Target: " + this.getTarget()));
        this.getLog().info((CharSequence)("  Command: " + this.getCommand()));
        cliList.addAll(this.getArguments());
        this.getLog().debug((CharSequence)("Prepared CLI: " + cliList));
        ProcessExecutor result = new ProcessExecutor(cliList);
        File sourcesFile = this.getSources(this.isSourceFolderRequired());
        this.logOptionally("GoLang project sources folder : " + sourcesFile);
        if (sourcesFile.isDirectory()) {
            result.directory(sourcesFile);
        }
        this.registerEnvVars(result, goRoot, gobin, gocache, sourcesFile, gopathParts);
        this.registerOutputBuffers(result);
        return result;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public String[] getTailArguments() {
        throw new NotImplementedException("Must not be called");
    }

    @Override
    @Nonnull
    public String getGoCommand() {
        throw new NotImplementedException("Must not be called");
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public String[] getCommandFlags() {
        throw new NotImplementedException("Must not be called");
    }
}

