/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.mvngolang.AbstractGoDependencyAwareMojo;
import com.igormaznitsa.mvngolang.utils.IOUtils;
import com.igormaznitsa.mvngolang.utils.MavenUtils;
import com.igormaznitsa.mvngolang.utils.ProxySettings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Model;
import org.apache.maven.model.Resource;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.transfer.artifact.install.ArtifactInstaller;
import org.apache.maven.shared.transfer.repository.RepositoryManager;
import org.zeroturnaround.zip.ZipUtil;

@Mojo(name="mvninstall", defaultPhase=LifecyclePhase.INSTALL, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GolangMvnInstallMojo
extends AbstractGoDependencyAwareMojo {
    public static final String MVNGOLANG_DEPENDENCIES_FILE = ".mvn-golang-dependencies";
    public static final String MVNGOLANG_BUILD_FOLDERS_FILE = ".mvn-golang-build-folders";
    @Component
    protected RepositoryManager repositoryManager;
    @Component
    protected ArtifactInstaller installer;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(name="compression", defaultValue="9")
    private int compression;

    public void setCompression(int level) {
        this.compression = level;
    }

    public int getCompression() {
        return this.compression;
    }

    @Override
    @Nullable
    protected String getSkipMojoPropertySuffix() {
        return "install";
    }

    @Override
    public boolean isSkip() {
        return super.isSkip() || Boolean.parseBoolean(MavenUtils.findProperty(this.getSession(), this.getProject(), "maven.install.skip", "false"));
    }

    @Override
    protected boolean doMainBusiness(@Nonnull ProxySettings proxySettings, int maxAttempts) throws InterruptedException, MojoFailureException, MojoExecutionException, IOException {
        File archive = this.compressProjectFiles();
        this.getProject().getArtifact().setFile(archive);
        return false;
    }

    private void safeCopyDirectory(@Nullable String src, @Nonnull File dst, @Nullable @MustNotContainNull List<File> dstList) throws IOException {
        File srcFile;
        if (src != null && !src.isEmpty() && (srcFile = new File(src)).isDirectory()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)String.format("Copying %s => %s", srcFile.getAbsolutePath(), dst.getAbsolutePath()));
            }
            FileUtils.copyDirectoryToDirectory((File)srcFile, (File)dst);
            if (dstList != null) {
                dstList.add(new File(dst, srcFile.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEffectivePom(@Nonnull File folder) throws IOException {
        Model model = this.getProject().getModel();
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(folder, "pom.xml"), false), StandardCharsets.UTF_8);
            new MavenXpp3Writer().write((Writer)writer, model);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Effective pom has been written");
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeSilently(writer);
            throw throwable;
        }
        IOUtils.closeSilently(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private File compressProjectFiles() throws IOException {
        Artifact artifact = this.getProject().getArtifact();
        File buildFolder = new File(this.getProject().getBuild().getDirectory());
        if (!buildFolder.isDirectory() && !buildFolder.mkdirs()) {
            this.getLog().error((CharSequence)("Can't create build folder: " + buildFolder));
            throw new IOException("Can't create build folder: " + buildFolder);
        }
        File resultZip = new File(buildFolder, artifact.getArtifactId() + '-' + artifact.getVersion() + '.' + artifact.getType());
        if (resultZip.isFile() && !resultZip.delete()) {
            throw new IOException("Can't delete file : " + resultZip);
        }
        File folderToPack = new File(".tmp_pack_folder_" + Long.toHexString(System.currentTimeMillis()).toUpperCase(Locale.ENGLISH));
        if (folderToPack.isDirectory()) {
            FileUtils.deleteDirectory((File)folderToPack);
        }
        if (!folderToPack.mkdirs()) {
            throw new IOException("Can't create temp folder : " + folderToPack);
        }
        File mvnGolangDependencyListFile = new File(folderToPack, MVNGOLANG_DEPENDENCIES_FILE);
        File mvnGolangBuildFolderListFile = new File(folderToPack, MVNGOLANG_BUILD_FOLDERS_FILE);
        try {
            this.saveEffectivePom(folderToPack);
            ArrayList<File> buildFolders = new ArrayList<File>();
            FileUtils.copyFileToDirectory((File)this.getProject().getFile(), (File)folderToPack);
            this.safeCopyDirectory(this.getProject().getBuild().getTestSourceDirectory(), folderToPack, null);
            for (Resource res : this.getProject().getBuild().getTestResources()) {
                this.safeCopyDirectory(res.getDirectory(), folderToPack, null);
            }
            for (Resource res : this.getProject().getBuild().getResources()) {
                this.safeCopyDirectory(res.getDirectory(), folderToPack, buildFolders);
            }
            this.safeCopyDirectory(this.getSources(false).getAbsolutePath(), folderToPack, buildFolders);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)String.format("Packing folder %s to %s", folderToPack.getAbsolutePath(), resultZip.getAbsolutePath()));
            }
            if (mvnGolangBuildFolderListFile.isFile()) {
                this.getLog().warn((CharSequence)"Skip build source folder list descriptor create because detected existing one: .mvn-golang-build-folders");
            } else if (buildFolders.isEmpty()) {
                this.getLog().warn((CharSequence)"Skip build source folder list descriptor because there is not any source or resource folders to be used for build");
            } else {
                String rooPath = FilenameUtils.separatorsToUnix((String)FilenameUtils.normalize((String)folderToPack.getAbsolutePath()));
                StringBuilder buffer = new StringBuilder();
                for (File file : buildFolders) {
                    String relativePath = FilenameUtils.separatorsToUnix((String)FilenameUtils.normalize((String)file.getAbsolutePath())).substring(rooPath.length() + 1);
                    if (buffer.length() > 0) {
                        buffer.append('\n');
                    }
                    this.getLog().debug((CharSequence)("Add build folder into descriptor: " + relativePath));
                    buffer.append(relativePath);
                }
                String fileContent = buffer.toString();
                this.getLog().debug((CharSequence)("Formed list of mvn-golang project source and resource build folders\n---------" + fileContent + "---------"));
                FileUtils.writeStringToFile((File)mvnGolangBuildFolderListFile, (String)fileContent, (Charset)StandardCharsets.UTF_8);
            }
            if (mvnGolangDependencyListFile.isFile()) {
                this.getLog().warn((CharSequence)"Skip dependency descriptor create because detected existing one: .mvn-golang-dependencies");
            } else {
                ArrayList<Artifact> golangDependencies = new ArrayList<Artifact>();
                for (MavenProject currentProject = this.getProject(); currentProject != null && !Thread.currentThread().isInterrupted(); currentProject = currentProject.getParent()) {
                    Set dependencies = currentProject.getDependencyArtifacts();
                    if (dependencies == null) continue;
                    for (Artifact a : dependencies) {
                        if (!"mvn-golang".equals(a.getType())) continue;
                        golangDependencies.add(a);
                    }
                }
                StringBuilder buffer = new StringBuilder();
                for (Artifact a : golangDependencies) {
                    buffer.append(MavenUtils.makeArtifactRecord(a)).append('\n');
                }
                String string = buffer.toString();
                this.getLog().debug((CharSequence)("Formed list of mvn-golang dependencies\n---------" + string + "---------"));
                FileUtils.writeStringToFile((File)mvnGolangDependencyListFile, (String)string, (Charset)StandardCharsets.UTF_8);
            }
            this.getLog().debug((CharSequence)"Restoring all backup go.mod in prepared folder to pack");
            this.restoreAllBackupGoMod(folderToPack);
            ZipUtil.pack((File)folderToPack, (File)resultZip, (int)Math.min(9, Math.max(1, this.compression)));
        }
        finally {
            FileUtils.deleteQuietly((File)folderToPack);
        }
        return resultZip;
    }

    private void restoreAllBackupGoMod(@Nonnull File folder) throws IOException {
        File backup = new File(folder, ".#go.mod.mvn.orig");
        if (backup.isFile()) {
            File gomod = new File(folder, "go.mod");
            if (gomod.isFile() && !gomod.delete()) {
                throw new IOException("Can't delete " + gomod);
            }
            if (!backup.renameTo(gomod)) {
                throw new IOException("Can't rename " + backup);
            }
        }
        for (File f : folder.listFiles(pathname -> pathname.isDirectory() && !Files.isSymbolicLink(pathname.toPath()))) {
            this.restoreAllBackupGoMod(f);
        }
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public String[] getTailArguments() {
        throw new NotImplementedException("Must not be called");
    }

    @Override
    @Nonnull
    public String getGoCommand() {
        throw new NotImplementedException("Must not be called");
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public String[] getCommandFlags() {
        throw new NotImplementedException("Must not be called");
    }
}

