/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang.utils;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.SystemUtils;

public final class SysUtils {
    private SysUtils() {
    }

    @Nullable
    public static String findGoSdkOsType() {
        String result = SystemUtils.IS_OS_WINDOWS ? "windows" : (SystemUtils.IS_OS_FREE_BSD ? "freebsd" : (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX ? "darwin" : (SystemUtils.IS_OS_LINUX ? "linux" : null)));
        return result;
    }

    @Nullable
    public static String decodeGoSdkArchType(@Nonnull String osArchProperty) {
        String arch = osArchProperty.toLowerCase(Locale.ENGLISH);
        if (arch.contains("ppc64le")) {
            return "ppc64le";
        }
        if (arch.contains("armv6l")) {
            return "armv6l";
        }
        if (arch.contains("arm64")) {
            return "arm64";
        }
        if (arch.contains("s390")) {
            return "s390x";
        }
        if (arch.matches("^(x8632|x86|i[3-6]86|ia32|x32)$")) {
            return "386";
        }
        if (arch.contains("em64t") || arch.contains("x8664") || arch.contains("ia32e") || arch.contains("x64") || arch.contains("amd64") || arch.contains("x86_64")) {
            return "amd64";
        }
        return null;
    }
}

