/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang.utils;

import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public final class WildCardMatcher {
    private final Pattern pattern;
    private final String addressPattern;

    public WildCardMatcher(@Nonnull String txt) {
        this.addressPattern = txt.trim();
        StringBuilder builder = new StringBuilder();
        block4: for (char c : this.addressPattern.toCharArray()) {
            switch (c) {
                case '*': {
                    builder.append(".*");
                    continue block4;
                }
                case '?': {
                    builder.append('.');
                    continue block4;
                }
                default: {
                    String code = Integer.toHexString(c).toUpperCase(Locale.ENGLISH);
                    builder.append("\\u").append("0000", 0, 4 - code.length()).append(code);
                }
            }
        }
        this.pattern = Pattern.compile(builder.toString());
    }

    public boolean match(@Nonnull String txt) {
        return this.pattern.matcher(txt).matches();
    }

    @Nonnull
    public String toString() {
        return this.addressPattern;
    }
}

