/*
 * Decompiled with CFR 0.152.
 */
package com.iluwatar.urm;

import com.iluwatar.urm.DomainClassFinder;
import com.iluwatar.urm.domain.DomainClass;
import com.iluwatar.urm.domain.Edge;
import com.iluwatar.urm.presenters.Presenter;
import com.iluwatar.urm.presenters.Representation;
import com.iluwatar.urm.scanners.FieldScanner;
import com.iluwatar.urm.scanners.HierarchyScanner;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainMapper {
    private static final Logger log = LoggerFactory.getLogger(DomainMapper.class);
    private final FieldScanner fieldScanner;
    private final HierarchyScanner hierarchyScanner;
    private final List<Class<?>> classes;
    private final Presenter presenter;

    DomainMapper(Presenter presenter, List<Class<?>> classes) {
        this.presenter = presenter;
        this.classes = classes;
        this.fieldScanner = new FieldScanner(classes);
        this.hierarchyScanner = new HierarchyScanner(classes);
    }

    public Representation describeDomain() throws ClassNotFoundException {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        edges.addAll(this.fieldScanner.getEdges());
        edges.addAll(this.hierarchyScanner.getEdges());
        List<DomainClass> domainObjects = this.classes.stream().map(DomainClass::new).collect(Collectors.toList());
        return this.presenter.describe(domainObjects, edges);
    }

    public List<Class<?>> getClasses() {
        return this.classes;
    }

    public static DomainMapper create(Presenter presenter, List<String> packages, List<String> ignores, URLClassLoader classLoader) throws ClassNotFoundException {
        List<Class<?>> allClasses = DomainClassFinder.findClasses(packages, ignores, classLoader);
        return new DomainMapper(presenter, allClasses);
    }

    public static DomainMapper create(Presenter presenter, List<String> packages, List<String> ignores) throws ClassNotFoundException {
        return DomainMapper.create(presenter, packages, ignores, null);
    }

    public static DomainMapper create(Presenter presenter, List<String> packages) throws ClassNotFoundException {
        return DomainMapper.create(presenter, packages, new ArrayList<String>(), null);
    }
}

