/*
 * Decompiled with CFR 0.152.
 */
package com.iluwatar.urm.presenters;

import com.iluwatar.urm.domain.DomainClass;
import com.iluwatar.urm.domain.DomainClassType;
import com.iluwatar.urm.domain.Edge;
import com.iluwatar.urm.domain.EdgeType;
import com.iluwatar.urm.domain.Visibility;
import com.iluwatar.urm.presenters.Presenter;
import com.iluwatar.urm.presenters.Representation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PlantUMLPresenter
implements Presenter {
    public static final String FILE_PREAMBLE = "@startuml";
    public static final String FILE_POSTAMBLE = "@enduml";
    private transient List<DomainClass> domainClasses;

    private String describeInheritance(List<Edge> edges) {
        return edges.stream().filter(e -> e.type == EdgeType.EXTENDS).map(this::describeInheritance).collect(Collectors.joining());
    }

    private String describeInheritance(Edge hierarchyEdge) {
        String arrow = "--|>";
        if (hierarchyEdge.target.getClassType() == DomainClassType.INTERFACE && hierarchyEdge.source.getClassType() != DomainClassType.INTERFACE) {
            arrow = "..|>";
        }
        return String.format("%s %s %s \n", hierarchyEdge.source.getClassName(), arrow, hierarchyEdge.target.getClassName());
    }

    private String describePackages(List<DomainClass> domainClasss) {
        return domainClasss.stream().collect(Collectors.groupingBy(DomainClass::getPackageName)).entrySet().stream().map(this::describePackage).collect(Collectors.joining());
    }

    private String describePackage(Map.Entry<String, List<DomainClass>> entry) {
        return String.format("package %s {\n%s}\n", entry.getKey(), this.listDomainClasses(entry.getValue()));
    }

    private String listDomainClasses(List<DomainClass> domainClasses) {
        return domainClasses.stream().map(this::describeDomainClass).distinct().collect(Collectors.joining());
    }

    private String describeDomainClass(DomainClass domainClass) {
        return String.format("  %s {%s%s%s\n  }\n", this.describeDomainClassType(domainClass), this.describeDomainClassFields(domainClass), this.describeDomainClassConstructors(domainClass), this.describeDomainClassMethods(domainClass));
    }

    private String describeDomainClassType(DomainClass domainClass) {
        String visi = "";
        if (domainClass.getVisibility() != Visibility.PUBLIC) {
            visi = domainClass.getVisibility().toString();
        }
        String className = domainClass.getUmlName();
        switch (domainClass.getClassType()) {
            case CLASS: {
                return (domainClass.isAbstract() ? "abstract " : "") + visi + "class " + className;
            }
            case INTERFACE: {
                return visi + "interface " + className;
            }
            case ENUM: {
                return visi + "enum " + className;
            }
            case ANNOTATION: {
                return visi + "annotation " + className;
            }
        }
        return className;
    }

    private String describeDomainClassFields(DomainClass domainClass) {
        String description = domainClass.getFields().stream().map(f -> (Object)((Object)f.getVisibility()) + " " + f.getUmlName() + (f.isStatic() ? " {static}" : "") + (f.isAbstract() ? " {abstract}" : "")).collect(Collectors.joining("\n    "));
        return !description.equals("") ? "\n    " + description : "";
    }

    private String describeDomainClassConstructors(DomainClass domainClass) {
        String description = domainClass.getConstructors().stream().map(c -> (Object)((Object)c.getVisibility()) + " " + c.getUmlName()).collect(Collectors.joining("\n    "));
        return !description.equals("") ? "\n    " + description : "";
    }

    private String describeDomainClassMethods(DomainClass domainClass) {
        String description = domainClass.getMethods().stream().map(m -> (Object)((Object)m.getVisibility()) + " " + m.getUmlName() + (m.isStatic() ? " {static}" : "") + (m.isAbstract() ? " {abstract}" : "")).collect(Collectors.joining("\n    "));
        return !description.equals("") ? "\n    " + description : "";
    }

    private String describeCompositions(List<Edge> edges) {
        return edges.stream().filter(e -> e.type != EdgeType.EXTENDS).map(this::describeComposition).collect(Collectors.joining());
    }

    private String describeComposition(Edge compositionEdge) {
        return String.format("%s\n", this.describeEdge(compositionEdge));
    }

    private String describeEdge(Edge edge) {
        String sourceName = edge.source.getClassName();
        String targetName = edge.target.getClassName();
        String arrow = "--";
        String arrowDescription = null;
        switch (edge.type) {
            case STATIC_INNER_CLASS: {
                arrow = "+..";
                break;
            }
            case INNER_CLASS: {
                arrow = "+--";
                break;
            }
            default: {
                arrow = "-->";
            }
        }
        if (edge.source.getDescription() == null) {
            arrow = PlantUMLPresenter.flip(arrow);
        } else {
            targetName = " \"-" + edge.source.getDescription() + "\" " + targetName;
        }
        return String.format("%s %s %s", sourceName, arrow, targetName) + (arrowDescription != null ? " : " + arrowDescription : "");
    }

    @Override
    public Representation describe(List<DomainClass> domainClasses, List<Edge> edges) {
        this.domainClasses = domainClasses;
        String content = "@startuml\n" + this.describePackages(domainClasses) + this.describeCompositions(edges) + this.describeInheritance(edges) + FILE_POSTAMBLE;
        return new Representation(content, "puml");
    }

    @Override
    public String getFileEnding() {
        return "puml";
    }

    private static String flip(String s) {
        String reversedString = new StringBuilder(s).reverse().toString();
        return reversedString.replaceAll("<", ">").replaceAll(">", "<");
    }
}

