/*
 * Decompiled with CFR 0.152.
 */
package com.iluwatar.urm.scanners;

import com.google.common.collect.Lists;
import com.iluwatar.urm.domain.Direction;
import com.iluwatar.urm.domain.DomainClass;
import com.iluwatar.urm.domain.Edge;
import com.iluwatar.urm.domain.EdgeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class EdgeOperations {
    public static Edge createEdge(Class<?> sourceClass, Class<?> field, EdgeType type, String name) {
        DomainClass source = new DomainClass(sourceClass, name);
        DomainClass target = new DomainClass(field);
        return new Edge(source, target, type, Direction.UNI_DIRECTIONAL);
    }

    public static List<Edge> mergeBiDirectionals(List<Edge> edges) {
        HashSet<Edge> noDuplicateSet = new HashSet<Edge>(edges);
        Collection<List<Edge>> groupedEdges = EdgeOperations.groupEdges(noDuplicateSet);
        List<Edge> uniDirectionals = EdgeOperations.takeSingleItemsGroups(groupedEdges);
        List<Edge> biDirectionals = EdgeOperations.mergeNonSingleGroups(groupedEdges);
        ArrayList<Edge> mergedEdges = Lists.newArrayList();
        mergedEdges.addAll(uniDirectionals);
        mergedEdges.addAll(biDirectionals);
        return mergedEdges;
    }

    private static List<Edge> takeSingleItemsGroups(Collection<List<Edge>> groupedEdges) {
        return groupedEdges.stream().filter(edgeGroup -> edgeGroup.size() == 1 || 1L == edgeGroup.stream().filter(e -> e.type.isCardinality()).count()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<Edge> mergeNonSingleGroups(Collection<List<Edge>> groupedEdges) {
        List edgeGroups = groupedEdges.stream().filter(edgeGroup -> edgeGroup.size() > 1 && 1L < edgeGroup.stream().filter(e -> e.type.isCardinality()).count()).map(EdgeOperations::groupBySource).collect(Collectors.toList());
        List multiReferenceUniDirectionals = edgeGroups.stream().filter(sourceGroups -> sourceGroups.size() == 1).flatMap(Collection::stream).flatMap(Collection::stream).collect(Collectors.toList());
        List biDirectionals = edgeGroups.stream().filter(sourceGroups -> sourceGroups.size() == 2).map(Tuple::createPairs).flatMap(Collection::stream).map(EdgeOperations::mergeEdges).collect(Collectors.toList());
        ArrayList<Edge> newEdges = Lists.newArrayList();
        newEdges.addAll(multiReferenceUniDirectionals);
        newEdges.addAll(biDirectionals);
        return newEdges;
    }

    private static Collection<List<Edge>> groupEdges(Set<Edge> edges) {
        return edges.stream().collect(Collectors.groupingBy(EdgeOperations::sameSourceAndTarget)).values();
    }

    private static List<List<Edge>> groupBySource(List<Edge> edges) {
        return Lists.newArrayList(edges.stream().collect(Collectors.groupingBy(edge -> edge.source.getClassName())).values());
    }

    private static Edge mergeEdges(Tuple<Edge, Edge> edgePair) {
        Edge source = (Edge)edgePair.left;
        Edge target = (Edge)edgePair.right;
        return new Edge(source.source, target.source, EdgeType.resolveEdgeType(source.type, target.type), Direction.BI_DIRECTIONAL);
    }

    private static UnorderedTuple<?, ?> sameSourceAndTarget(Edge edge) {
        String sourceId = edge.source.getPackageName() + "." + edge.source.getClassName();
        String targetId = edge.target.getPackageName() + "." + edge.target.getClassName();
        return UnorderedTuple.of(sourceId, targetId);
    }

    public static boolean relationAlreadyExists(List<Edge> fieldEdges, Edge e) {
        return fieldEdges.stream().anyMatch(d -> EdgeOperations.isSameRelation(d, e));
    }

    public static Optional<Edge> getMatchingRelation(List<Edge> fieldEdges, Edge e) {
        List edges = fieldEdges.stream().filter(d -> EdgeOperations.isSameRelation(d, e)).collect(Collectors.toList());
        if (edges.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(edges.get(0));
    }

    private static boolean isSameRelation(Edge d, Edge e) {
        return d.source.getPackageName().equals(e.source.getPackageName()) && d.source.getClassName().equals(e.source.getClassName()) && d.target.getPackageName().equals(e.target.getPackageName()) && d.target.getClassName().equals(e.target.getClassName()) && d.type.equals((Object)e.type) && d.direction.equals((Object)e.direction);
    }

    private static class Tuple<X, Y> {
        protected final X left;
        protected final Y right;

        public Tuple(X left, Y right) {
            this.left = left;
            this.right = right;
        }

        public static <T> List<Tuple<T, T>> createPairs(List<List<T>> listOfTwoGroups) {
            List<T> a = listOfTwoGroups.get(0);
            List<T> b = listOfTwoGroups.get(1);
            return Tuple.makePairs(a, b);
        }

        private static <T> List<Tuple<T, T>> makePairs(List<T> a, List<T> b) {
            ArrayList<Tuple<T, T>> pairs = Lists.newArrayList();
            if (a.size() > b.size()) {
                for (int i = 0; i < a.size(); ++i) {
                    pairs.add(new Tuple<T, T>(a.get(i), b.get(i % b.size())));
                }
            } else {
                for (int i = 0; i < b.size(); ++i) {
                    pairs.add(new Tuple<T, T>(a.get(i % a.size()), b.get(i)));
                }
            }
            return pairs;
        }
    }

    private static class UnorderedTuple<X, Y>
    extends Tuple<X, Y> {
        public UnorderedTuple(X left, Y right) {
            super(left, right);
        }

        public int hashCode() {
            return this.left.hashCode() + this.right.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof UnorderedTuple) {
                UnorderedTuple tuple = (UnorderedTuple)obj;
                return this.left.equals(tuple.left) && this.right.equals(tuple.right) || this.left.equals(tuple.right) && this.right.equals(tuple.left);
            }
            return false;
        }

        public static <X, Y> UnorderedTuple<X, Y> of(X source, Y target) {
            return new UnorderedTuple<X, Y>(source, target);
        }
    }
}

