/*
 * Decompiled with CFR 0.152.
 */
package com.iluwatar.urm.scanners;

import com.iluwatar.urm.domain.DomainClass;
import com.iluwatar.urm.domain.Edge;
import com.iluwatar.urm.domain.EdgeType;
import com.iluwatar.urm.scanners.AbstractScanner;
import java.util.ArrayList;
import java.util.List;

public class HierarchyScanner
extends AbstractScanner {
    public HierarchyScanner(List<Class<?>> classes) {
        super(classes);
    }

    public List<Edge> getEdges() {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Class clazz : this.classes) {
            Class<?>[] interfaces;
            for (Class<?> interfaze : interfaces = clazz.getInterfaces()) {
                if (!this.isDomainClass(interfaze)) continue;
                DomainClass child = new DomainClass(clazz);
                DomainClass parent = new DomainClass(interfaze);
                edges.add(new Edge(child, parent, EdgeType.EXTENDS));
            }
            Class superclass = clazz.getSuperclass();
            if (!this.isDomainClass(superclass)) continue;
            DomainClass child = new DomainClass(clazz);
            DomainClass parent = new DomainClass(superclass);
            edges.add(new Edge(child, parent, EdgeType.EXTENDS));
        }
        return edges;
    }
}

