/*
 * Decompiled with CFR 0.152.
 */
package com.iluwatar.urm.domain;

import com.iluwatar.urm.domain.DomainConstructor;
import com.iluwatar.urm.domain.TypeUtils;
import com.iluwatar.urm.domain.Visibility;
import com.thoughtworks.paranamer.AdaptiveParanamer;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.DefaultParanamer;
import com.thoughtworks.paranamer.NullParanamer;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;

public abstract class DomainExecutable<T extends Executable> {
    private static final boolean useParameterNames = Boolean.parseBoolean(System.getProperty("useParameterNames", "true"));
    private static final String JAVA_IDENTIFIER_REGEX = "([a-zA-Z_$][a-zA-Z\\d_$]*)";
    private static final Paranamer PARANAMER = new AdaptiveParanamer(new DefaultParanamer(), new BytecodeReadingParanamer(), new NullParanamer());
    private T executable;

    public DomainExecutable(T executable) {
        this.executable = executable;
    }

    protected T getExecutable() {
        return this.executable;
    }

    protected String getName() {
        return ((Executable)this.executable).getName();
    }

    public String getUmlName() {
        String[] parameterNames = PARANAMER.lookupParameterNames((AccessibleObject)this.executable, false);
        Parameter[] parameters = ((Executable)this.executable).getParameters();
        Class<?> declaringClass = ((Executable)this.executable).getDeclaringClass();
        if ((declaringClass.isLocalClass() || declaringClass.isMemberClass()) && !Modifier.isStatic(declaringClass.getModifiers()) && this instanceof DomainConstructor) {
            parameters = Arrays.copyOfRange(parameters, 1, parameters.length);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parameters.length; ++i) {
            String paraName = parameterNames.length != 0 && useParameterNames ? parameterNames[i] + " : " : "";
            sb.append(paraName + TypeUtils.getSimpleName(parameters[i].getParameterizedType()));
            if (i == parameters.length - 1) continue;
            sb.append(", ");
        }
        return this.getName() + "(" + sb.toString() + ")";
    }

    public Class<?> getDeclaringClass() {
        return ((Executable)this.executable).getDeclaringClass();
    }

    public Visibility getVisibility() {
        return TypeUtils.getVisibility(((Executable)this.executable).getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(((Executable)this.executable).getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(((Executable)this.executable).getModifiers());
    }

    public String toString() {
        return this.getUmlName();
    }
}

