/*
 * Decompiled with CFR 0.152.
 */
package com.iluwatar.urm.scanners;

import com.iluwatar.urm.DomainClassFinder;
import com.iluwatar.urm.domain.Edge;
import com.iluwatar.urm.domain.EdgeType;
import com.iluwatar.urm.scanners.AbstractScanner;
import com.iluwatar.urm.scanners.EdgeOperations;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldScanner
extends AbstractScanner {
    private static final String NAME_FOR_INNERCLASS = null;
    private static final String innerClassFieldReferenceInBytecode = "this$0";
    private final Logger logger = LoggerFactory.getLogger(FieldScanner.class);

    public FieldScanner(List<Class<?>> classes) {
        super(classes);
    }

    public List<Edge> getEdges() {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Class clazz : this.classes) {
            edges.addAll(this.extractFieldEdges(clazz));
        }
        return EdgeOperations.mergeBiDirectionals(edges);
    }

    private List<Edge> extractFieldEdges(final Class<?> clazz) {
        final ArrayList<Edge> fieldEdges = new ArrayList<Edge>();
        try {
            InputStream is = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace(".", "/") + ".class");
            ClassReader reader = new ClassReader(is);
            reader.accept(new ClassVisitor(458752){

                @Override
                public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                    try {
                        Optional<Edge> fieldEdge = FieldScanner.this.createFieldEdge(clazz, clazz.getDeclaredField(name));
                        if (fieldEdge.isPresent()) {
                            if (EdgeOperations.relationAlreadyExists(fieldEdges, fieldEdge.get())) {
                                Optional<Edge> relation = EdgeOperations.getMatchingRelation(fieldEdges, fieldEdge.get());
                                if (relation.isPresent()) {
                                    fieldEdges.remove(relation.get());
                                    fieldEdges.add(new Edge(relation.get().source, relation.get().target, EdgeType.ONE_TO_MANY, relation.get().direction));
                                }
                            } else {
                                fieldEdges.add(fieldEdge.get());
                            }
                        }
                    }
                    catch (NoSuchFieldException fieldEdge) {
                    }
                    catch (NoClassDefFoundError e) {
                        FieldScanner.this.logger.warn("Skipped field " + name + " in class " + clazz.getName() + " because it's type class is not available. Field description: " + desc);
                    }
                    return super.visitField(access, name, desc, signature, value);
                }

                @Override
                public void visitInnerClass(String name, String outerName, String innerName, int access) {
                    if (innerName == null || outerName == null || name.startsWith("java/")) {
                        return;
                    }
                    Class<?> outerClass = ReflectionUtils.forName(outerName.replaceAll("/", "."), DomainClassFinder.classLoaders);
                    Class<?> innerClass = ReflectionUtils.forName(name.replaceAll("/", "."), DomainClassFinder.classLoaders);
                    if (innerClass.equals(outerClass) || clazz.equals(outerClass)) {
                        return;
                    }
                    Edge innerClassEdge = (innerClass.getModifiers() & 8) > 0 ? EdgeOperations.createEdge(innerClass, outerClass, EdgeType.STATIC_INNER_CLASS, NAME_FOR_INNERCLASS) : EdgeOperations.createEdge(innerClass, outerClass, EdgeType.INNER_CLASS, NAME_FOR_INNERCLASS);
                    if (innerClassEdge != null && !EdgeOperations.relationAlreadyExists(fieldEdges, innerClassEdge)) {
                        fieldEdges.add(innerClassEdge);
                    }
                    super.visitInnerClass(name, outerName, innerName, access);
                }
            }, 1);
        }
        catch (IOException e) {
            this.logger.warn("Failed to read bytecode for class " + clazz.getName(), e);
        }
        return fieldEdges;
    }

    private Optional<Edge> createFieldEdge(Class<?> clazz, Field field) {
        Optional<Class<?>> classInCollection;
        if (field.isEnumConstant()) {
            return Optional.empty();
        }
        if (this.isDomainClass(field.getType()) && !innerClassFieldReferenceInBytecode.equals(field.getName())) {
            return Optional.of(EdgeOperations.createEdge(clazz, field.getType(), EdgeType.ONE_TO_ONE, field.getName()));
        }
        if (this.isCollection(field) && (classInCollection = this.getDomainClassFromCollection(field)).isPresent() && this.isDomainClass(classInCollection.get())) {
            return Optional.of(EdgeOperations.createEdge(clazz, classInCollection.get(), EdgeType.ONE_TO_MANY, field.getName()));
        }
        return Optional.empty();
    }

    private Optional<Class<?>> getDomainClassFromCollection(Field field) {
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            for (Type t : pt.getActualTypeArguments()) {
                if (!this.isDomainClass(t.toString())) continue;
                return Optional.of((Class)t);
            }
        }
        return Optional.empty();
    }

    private boolean isCollection(Field field) {
        return Collection.class.isAssignableFrom(field.getType());
    }
}

