/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.RequestDefinition;
import com.infobip.model.CallsClickToCallMessageBody;
import com.infobip.model.CallsVoiceResponse;
import java.util.Objects;
import okhttp3.Call;

public class ClickToCallApi {
    private final ApiClient apiClient;

    public ClickToCallApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition sendClickToCallMessageDefinition(CallsClickToCallMessageBody callsClickToCallMessageBody) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/voice/ctc/1/send").body(callsClickToCallMessageBody).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendClickToCallMessageRequest sendClickToCallMessage(CallsClickToCallMessageBody callsClickToCallMessageBody) {
        return new SendClickToCallMessageRequest(callsClickToCallMessageBody);
    }

    public class SendClickToCallMessageRequest {
        private final CallsClickToCallMessageBody callsClickToCallMessageBody;

        private SendClickToCallMessageRequest(CallsClickToCallMessageBody callsClickToCallMessageBody) {
            this.callsClickToCallMessageBody = Objects.requireNonNull(callsClickToCallMessageBody, "The required parameter 'callsClickToCallMessageBody' is missing.");
        }

        public CallsVoiceResponse execute() throws ApiException {
            RequestDefinition sendClickToCallMessageDefinition = ClickToCallApi.this.sendClickToCallMessageDefinition(this.callsClickToCallMessageBody);
            return (CallsVoiceResponse)ClickToCallApi.this.apiClient.execute(sendClickToCallMessageDefinition, new TypeReference<CallsVoiceResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsVoiceResponse> callback) {
            RequestDefinition sendClickToCallMessageDefinition = ClickToCallApi.this.sendClickToCallMessageDefinition(this.callsClickToCallMessageBody);
            return ClickToCallApi.this.apiClient.executeAsync(sendClickToCallMessageDefinition, new TypeReference<CallsVoiceResponse>(){}.getType(), callback);
        }
    }
}

