/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.Parameter;
import com.infobip.RequestDefinition;
import com.infobip.model.EmailAddDomainRequest;
import com.infobip.model.EmailAllDomainsResponse;
import com.infobip.model.EmailBulkRescheduleRequest;
import com.infobip.model.EmailBulkRescheduleResponse;
import com.infobip.model.EmailBulkScheduleResponse;
import com.infobip.model.EmailBulkStatusResponse;
import com.infobip.model.EmailBulkUpdateStatusRequest;
import com.infobip.model.EmailBulkUpdateStatusResponse;
import com.infobip.model.EmailDomainIpRequest;
import com.infobip.model.EmailDomainIpResponse;
import com.infobip.model.EmailDomainResponse;
import com.infobip.model.EmailLogsResponse;
import com.infobip.model.EmailReportsResult;
import com.infobip.model.EmailReturnPathAddressRequest;
import com.infobip.model.EmailSendResponse;
import com.infobip.model.EmailSimpleApiResponse;
import com.infobip.model.EmailTrackingEventRequest;
import com.infobip.model.EmailValidationRequest;
import com.infobip.model.EmailValidationResponse;
import java.io.File;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import okhttp3.Call;

public class EmailApi {
    private final ApiClient apiClient;

    public EmailApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition addDomainDefinition(EmailAddDomainRequest emailAddDomainRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/email/1/domains").body(emailAddDomainRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public AddDomainRequest addDomain(EmailAddDomainRequest emailAddDomainRequest) {
        return new AddDomainRequest(emailAddDomainRequest);
    }

    private RequestDefinition assignIpToDomainDefinition(EmailDomainIpRequest emailDomainIpRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/email/1/domain-ips").body(emailDomainIpRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public AssignIpToDomainRequest assignIpToDomain(EmailDomainIpRequest emailDomainIpRequest) {
        return new AssignIpToDomainRequest(emailDomainIpRequest);
    }

    private RequestDefinition deleteDomainDefinition(String domainName) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/email/1/domains/{domainName}").requiresAuthentication(true).accept("application/json");
        if (domainName != null) {
            builder.addPathParameter(new Parameter("domainName", domainName));
        }
        return builder.build();
    }

    public DeleteDomainRequest deleteDomain(String domainName) {
        return new DeleteDomainRequest(domainName);
    }

    private RequestDefinition getAllDomainIpsDefinition(String domainName) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/domain-ips").requiresAuthentication(true).accept("application/json");
        if (domainName != null) {
            builder.addQueryParameter(new Parameter("domainName", domainName));
        }
        return builder.build();
    }

    public GetAllDomainIpsRequest getAllDomainIps(String domainName) {
        return new GetAllDomainIpsRequest(domainName);
    }

    private RequestDefinition getAllDomainsDefinition(Integer size, Integer page) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/domains").requiresAuthentication(true).accept("application/json");
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        return builder.build();
    }

    public GetAllDomainsRequest getAllDomains() {
        return new GetAllDomainsRequest();
    }

    private RequestDefinition getAllIpsDefinition() {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/ips").requiresAuthentication(true).accept("application/json");
        return builder.build();
    }

    public GetAllIpsRequest getAllIps() {
        return new GetAllIpsRequest();
    }

    private RequestDefinition getDomainDetailsDefinition(String domainName) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/domains/{domainName}").requiresAuthentication(true).accept("application/json");
        if (domainName != null) {
            builder.addPathParameter(new Parameter("domainName", domainName));
        }
        return builder.build();
    }

    public GetDomainDetailsRequest getDomainDetails(String domainName) {
        return new GetDomainDetailsRequest(domainName);
    }

    private RequestDefinition getEmailDeliveryReportsDefinition(String bulkId, String messageId, Integer limit, String applicationId, String entityId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/reports").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        if (messageId != null) {
            builder.addQueryParameter(new Parameter("messageId", messageId));
        }
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (entityId != null) {
            builder.addQueryParameter(new Parameter("entityId", entityId));
        }
        return builder.build();
    }

    public GetEmailDeliveryReportsRequest getEmailDeliveryReports() {
        return new GetEmailDeliveryReportsRequest();
    }

    private RequestDefinition getEmailLogsDefinition(String messageId, String from, String to, String bulkId, String generalStatus, OffsetDateTime sentSince, OffsetDateTime sentUntil, Integer limit, String applicationId, String entityId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/logs").requiresAuthentication(true).accept("application/json");
        if (messageId != null) {
            builder.addQueryParameter(new Parameter("messageId", messageId));
        }
        if (from != null) {
            builder.addQueryParameter(new Parameter("from", from));
        }
        if (to != null) {
            builder.addQueryParameter(new Parameter("to", to));
        }
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        if (generalStatus != null) {
            builder.addQueryParameter(new Parameter("generalStatus", generalStatus));
        }
        if (sentSince != null) {
            builder.addQueryParameter(new Parameter("sentSince", sentSince));
        }
        if (sentUntil != null) {
            builder.addQueryParameter(new Parameter("sentUntil", sentUntil));
        }
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (entityId != null) {
            builder.addQueryParameter(new Parameter("entityId", entityId));
        }
        return builder.build();
    }

    public GetEmailLogsRequest getEmailLogs() {
        return new GetEmailLogsRequest();
    }

    private RequestDefinition getScheduledEmailStatusesDefinition(String bulkId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/bulks/status").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public GetScheduledEmailStatusesRequest getScheduledEmailStatuses(String bulkId) {
        return new GetScheduledEmailStatusesRequest(bulkId);
    }

    private RequestDefinition getScheduledEmailsDefinition(String bulkId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/email/1/bulks").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public GetScheduledEmailsRequest getScheduledEmails(String bulkId) {
        return new GetScheduledEmailsRequest(bulkId);
    }

    private RequestDefinition removeIpFromDomainDefinition(String domainName, String ipAddress) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/email/1/domain-ips").requiresAuthentication(true).accept("application/json");
        if (domainName != null) {
            builder.addQueryParameter(new Parameter("domainName", domainName));
        }
        if (ipAddress != null) {
            builder.addQueryParameter(new Parameter("ipAddress", ipAddress));
        }
        return builder.build();
    }

    public RemoveIpFromDomainRequest removeIpFromDomain(String domainName, String ipAddress) {
        return new RemoveIpFromDomainRequest(domainName, ipAddress);
    }

    private RequestDefinition rescheduleEmailsDefinition(String bulkId, EmailBulkRescheduleRequest emailBulkRescheduleRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/email/1/bulks").body(emailBulkRescheduleRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public RescheduleEmailsRequest rescheduleEmails(String bulkId, EmailBulkRescheduleRequest emailBulkRescheduleRequest) {
        return new RescheduleEmailsRequest(bulkId, emailBulkRescheduleRequest);
    }

    private RequestDefinition sendEmailDefinition(List<String> to, String from, List<String> cc, List<String> bcc, String subject, String text, String html, String ampHtml, Long templateId, List<File> attachment, List<File> inlineImage, Boolean intermediateReport, String notifyUrl, String notifyContentType, String callbackData, Boolean track, Boolean trackClicks, Boolean trackOpens, String trackingUrl, String bulkId, String messageId, String replyTo, String defaultPlaceholders, Boolean preserveRecipients, OffsetDateTime sendAt, String landingPagePlaceholders, String landingPageId, String templateLanguageVersion, String applicationId, String entityId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/email/3/send").requiresAuthentication(true).accept("application/json").contentType("multipart/form-data");
        if (from != null) {
            builder.addFormParameter(new Parameter("from", from));
        }
        if (to != null) {
            builder.addFormParameter(new Parameter("to", to));
        }
        if (cc != null) {
            builder.addFormParameter(new Parameter("cc", cc));
        }
        if (bcc != null) {
            builder.addFormParameter(new Parameter("bcc", bcc));
        }
        if (subject != null) {
            builder.addFormParameter(new Parameter("subject", subject));
        }
        if (text != null) {
            builder.addFormParameter(new Parameter("text", text));
        }
        if (html != null) {
            builder.addFormParameter(new Parameter("html", html));
        }
        if (ampHtml != null) {
            builder.addFormParameter(new Parameter("ampHtml", ampHtml));
        }
        if (templateId != null) {
            builder.addFormParameter(new Parameter("templateId", templateId));
        }
        if (attachment != null) {
            builder.addFormParameter(new Parameter("attachment", attachment));
        }
        if (inlineImage != null) {
            builder.addFormParameter(new Parameter("inlineImage", inlineImage));
        }
        if (intermediateReport != null) {
            builder.addFormParameter(new Parameter("intermediateReport", intermediateReport));
        }
        if (notifyUrl != null) {
            builder.addFormParameter(new Parameter("notifyUrl", notifyUrl));
        }
        if (notifyContentType != null) {
            builder.addFormParameter(new Parameter("notifyContentType", notifyContentType));
        }
        if (callbackData != null) {
            builder.addFormParameter(new Parameter("callbackData", callbackData));
        }
        if (track != null) {
            builder.addFormParameter(new Parameter("track", track));
        }
        if (trackClicks != null) {
            builder.addFormParameter(new Parameter("trackClicks", trackClicks));
        }
        if (trackOpens != null) {
            builder.addFormParameter(new Parameter("trackOpens", trackOpens));
        }
        if (trackingUrl != null) {
            builder.addFormParameter(new Parameter("trackingUrl", trackingUrl));
        }
        if (bulkId != null) {
            builder.addFormParameter(new Parameter("bulkId", bulkId));
        }
        if (messageId != null) {
            builder.addFormParameter(new Parameter("messageId", messageId));
        }
        if (replyTo != null) {
            builder.addFormParameter(new Parameter("replyTo", replyTo));
        }
        if (defaultPlaceholders != null) {
            builder.addFormParameter(new Parameter("defaultPlaceholders", defaultPlaceholders));
        }
        if (preserveRecipients != null) {
            builder.addFormParameter(new Parameter("preserveRecipients", preserveRecipients));
        }
        if (sendAt != null) {
            builder.addFormParameter(new Parameter("sendAt", sendAt));
        }
        if (landingPagePlaceholders != null) {
            builder.addFormParameter(new Parameter("landingPagePlaceholders", landingPagePlaceholders));
        }
        if (landingPageId != null) {
            builder.addFormParameter(new Parameter("landingPageId", landingPageId));
        }
        if (templateLanguageVersion != null) {
            builder.addFormParameter(new Parameter("templateLanguageVersion", templateLanguageVersion));
        }
        if (applicationId != null) {
            builder.addFormParameter(new Parameter("applicationId", applicationId));
        }
        if (entityId != null) {
            builder.addFormParameter(new Parameter("entityId", entityId));
        }
        return builder.build();
    }

    public SendEmailRequest sendEmail(List<String> to) {
        return new SendEmailRequest(to);
    }

    private RequestDefinition updateReturnPathDefinition(String domainName, EmailReturnPathAddressRequest emailReturnPathAddressRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/email/1/domains/{domainName}/return-path").body(emailReturnPathAddressRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (domainName != null) {
            builder.addPathParameter(new Parameter("domainName", domainName));
        }
        return builder.build();
    }

    public UpdateReturnPathRequest updateReturnPath(String domainName, EmailReturnPathAddressRequest emailReturnPathAddressRequest) {
        return new UpdateReturnPathRequest(domainName, emailReturnPathAddressRequest);
    }

    private RequestDefinition updateScheduledEmailStatusesDefinition(String bulkId, EmailBulkUpdateStatusRequest emailBulkUpdateStatusRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/email/1/bulks/status").body(emailBulkUpdateStatusRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public UpdateScheduledEmailStatusesRequest updateScheduledEmailStatuses(String bulkId, EmailBulkUpdateStatusRequest emailBulkUpdateStatusRequest) {
        return new UpdateScheduledEmailStatusesRequest(bulkId, emailBulkUpdateStatusRequest);
    }

    private RequestDefinition updateTrackingEventsDefinition(String domainName, EmailTrackingEventRequest emailTrackingEventRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/email/1/domains/{domainName}/tracking").body(emailTrackingEventRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (domainName != null) {
            builder.addPathParameter(new Parameter("domainName", domainName));
        }
        return builder.build();
    }

    public UpdateTrackingEventsRequest updateTrackingEvents(String domainName, EmailTrackingEventRequest emailTrackingEventRequest) {
        return new UpdateTrackingEventsRequest(domainName, emailTrackingEventRequest);
    }

    private RequestDefinition validateEmailAddressesDefinition(EmailValidationRequest emailValidationRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/email/2/validation").body(emailValidationRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public ValidateEmailAddressesRequest validateEmailAddresses(EmailValidationRequest emailValidationRequest) {
        return new ValidateEmailAddressesRequest(emailValidationRequest);
    }

    private RequestDefinition verifyDomainDefinition(String domainName) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/email/1/domains/{domainName}/verify").requiresAuthentication(true).accept("application/json");
        if (domainName != null) {
            builder.addPathParameter(new Parameter("domainName", domainName));
        }
        return builder.build();
    }

    public VerifyDomainRequest verifyDomain(String domainName) {
        return new VerifyDomainRequest(domainName);
    }

    public class VerifyDomainRequest {
        private final String domainName;

        private VerifyDomainRequest(String domainName) {
            this.domainName = Objects.requireNonNull(domainName, "The required parameter 'domainName' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition verifyDomainDefinition = EmailApi.this.verifyDomainDefinition(this.domainName);
            EmailApi.this.apiClient.execute(verifyDomainDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition verifyDomainDefinition = EmailApi.this.verifyDomainDefinition(this.domainName);
            return EmailApi.this.apiClient.executeAsync(verifyDomainDefinition, callback);
        }
    }

    public class ValidateEmailAddressesRequest {
        private final EmailValidationRequest emailValidationRequest;

        private ValidateEmailAddressesRequest(EmailValidationRequest emailValidationRequest) {
            this.emailValidationRequest = Objects.requireNonNull(emailValidationRequest, "The required parameter 'emailValidationRequest' is missing.");
        }

        public EmailValidationResponse execute() throws ApiException {
            RequestDefinition validateEmailAddressesDefinition = EmailApi.this.validateEmailAddressesDefinition(this.emailValidationRequest);
            return (EmailValidationResponse)EmailApi.this.apiClient.execute(validateEmailAddressesDefinition, new TypeReference<EmailValidationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailValidationResponse> callback) {
            RequestDefinition validateEmailAddressesDefinition = EmailApi.this.validateEmailAddressesDefinition(this.emailValidationRequest);
            return EmailApi.this.apiClient.executeAsync(validateEmailAddressesDefinition, new TypeReference<EmailValidationResponse>(){}.getType(), callback);
        }
    }

    public class UpdateTrackingEventsRequest {
        private final String domainName;
        private final EmailTrackingEventRequest emailTrackingEventRequest;

        private UpdateTrackingEventsRequest(String domainName, EmailTrackingEventRequest emailTrackingEventRequest) {
            this.domainName = Objects.requireNonNull(domainName, "The required parameter 'domainName' is missing.");
            this.emailTrackingEventRequest = Objects.requireNonNull(emailTrackingEventRequest, "The required parameter 'emailTrackingEventRequest' is missing.");
        }

        public EmailDomainResponse execute() throws ApiException {
            RequestDefinition updateTrackingEventsDefinition = EmailApi.this.updateTrackingEventsDefinition(this.domainName, this.emailTrackingEventRequest);
            return (EmailDomainResponse)EmailApi.this.apiClient.execute(updateTrackingEventsDefinition, new TypeReference<EmailDomainResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailDomainResponse> callback) {
            RequestDefinition updateTrackingEventsDefinition = EmailApi.this.updateTrackingEventsDefinition(this.domainName, this.emailTrackingEventRequest);
            return EmailApi.this.apiClient.executeAsync(updateTrackingEventsDefinition, new TypeReference<EmailDomainResponse>(){}.getType(), callback);
        }
    }

    public class UpdateScheduledEmailStatusesRequest {
        private final String bulkId;
        private final EmailBulkUpdateStatusRequest emailBulkUpdateStatusRequest;

        private UpdateScheduledEmailStatusesRequest(String bulkId, EmailBulkUpdateStatusRequest emailBulkUpdateStatusRequest) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
            this.emailBulkUpdateStatusRequest = Objects.requireNonNull(emailBulkUpdateStatusRequest, "The required parameter 'emailBulkUpdateStatusRequest' is missing.");
        }

        public EmailBulkUpdateStatusResponse execute() throws ApiException {
            RequestDefinition updateScheduledEmailStatusesDefinition = EmailApi.this.updateScheduledEmailStatusesDefinition(this.bulkId, this.emailBulkUpdateStatusRequest);
            return (EmailBulkUpdateStatusResponse)EmailApi.this.apiClient.execute(updateScheduledEmailStatusesDefinition, new TypeReference<EmailBulkUpdateStatusResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailBulkUpdateStatusResponse> callback) {
            RequestDefinition updateScheduledEmailStatusesDefinition = EmailApi.this.updateScheduledEmailStatusesDefinition(this.bulkId, this.emailBulkUpdateStatusRequest);
            return EmailApi.this.apiClient.executeAsync(updateScheduledEmailStatusesDefinition, new TypeReference<EmailBulkUpdateStatusResponse>(){}.getType(), callback);
        }
    }

    public class UpdateReturnPathRequest {
        private final String domainName;
        private final EmailReturnPathAddressRequest emailReturnPathAddressRequest;

        private UpdateReturnPathRequest(String domainName, EmailReturnPathAddressRequest emailReturnPathAddressRequest) {
            this.domainName = Objects.requireNonNull(domainName, "The required parameter 'domainName' is missing.");
            this.emailReturnPathAddressRequest = Objects.requireNonNull(emailReturnPathAddressRequest, "The required parameter 'emailReturnPathAddressRequest' is missing.");
        }

        public EmailDomainResponse execute() throws ApiException {
            RequestDefinition updateReturnPathDefinition = EmailApi.this.updateReturnPathDefinition(this.domainName, this.emailReturnPathAddressRequest);
            return (EmailDomainResponse)EmailApi.this.apiClient.execute(updateReturnPathDefinition, new TypeReference<EmailDomainResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailDomainResponse> callback) {
            RequestDefinition updateReturnPathDefinition = EmailApi.this.updateReturnPathDefinition(this.domainName, this.emailReturnPathAddressRequest);
            return EmailApi.this.apiClient.executeAsync(updateReturnPathDefinition, new TypeReference<EmailDomainResponse>(){}.getType(), callback);
        }
    }

    public class SendEmailRequest {
        private final List<String> to;
        private String from;
        private List<String> cc;
        private List<String> bcc;
        private String subject;
        private String text;
        private String html;
        private String ampHtml;
        private Long templateId;
        private List<File> attachment;
        private List<File> inlineImage;
        private Boolean intermediateReport;
        private String notifyUrl;
        private String notifyContentType;
        private String callbackData;
        private Boolean track;
        private Boolean trackClicks;
        private Boolean trackOpens;
        private String trackingUrl;
        private String bulkId;
        private String messageId;
        private String replyTo;
        private String defaultPlaceholders;
        private Boolean preserveRecipients;
        private OffsetDateTime sendAt;
        private String landingPagePlaceholders;
        private String landingPageId;
        private String templateLanguageVersion;
        private String applicationId;
        private String entityId;

        private SendEmailRequest(List<String> to) {
            this.to = Objects.requireNonNull(to, "The required parameter 'to' is missing.");
        }

        public SendEmailRequest from(String from) {
            this.from = from;
            return this;
        }

        public SendEmailRequest cc(List<String> cc) {
            this.cc = cc;
            return this;
        }

        public SendEmailRequest bcc(List<String> bcc) {
            this.bcc = bcc;
            return this;
        }

        public SendEmailRequest subject(String subject) {
            this.subject = subject;
            return this;
        }

        public SendEmailRequest text(String text) {
            this.text = text;
            return this;
        }

        public SendEmailRequest html(String html) {
            this.html = html;
            return this;
        }

        public SendEmailRequest ampHtml(String ampHtml) {
            this.ampHtml = ampHtml;
            return this;
        }

        public SendEmailRequest templateId(Long templateId) {
            this.templateId = templateId;
            return this;
        }

        public SendEmailRequest attachment(List<File> attachment) {
            this.attachment = attachment;
            return this;
        }

        public SendEmailRequest inlineImage(List<File> inlineImage) {
            this.inlineImage = inlineImage;
            return this;
        }

        public SendEmailRequest intermediateReport(Boolean intermediateReport) {
            this.intermediateReport = intermediateReport;
            return this;
        }

        public SendEmailRequest notifyUrl(String notifyUrl) {
            this.notifyUrl = notifyUrl;
            return this;
        }

        public SendEmailRequest notifyContentType(String notifyContentType) {
            this.notifyContentType = notifyContentType;
            return this;
        }

        public SendEmailRequest callbackData(String callbackData) {
            this.callbackData = callbackData;
            return this;
        }

        public SendEmailRequest track(Boolean track) {
            this.track = track;
            return this;
        }

        public SendEmailRequest trackClicks(Boolean trackClicks) {
            this.trackClicks = trackClicks;
            return this;
        }

        public SendEmailRequest trackOpens(Boolean trackOpens) {
            this.trackOpens = trackOpens;
            return this;
        }

        public SendEmailRequest trackingUrl(String trackingUrl) {
            this.trackingUrl = trackingUrl;
            return this;
        }

        public SendEmailRequest bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public SendEmailRequest messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public SendEmailRequest replyTo(String replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendEmailRequest defaultPlaceholders(String defaultPlaceholders) {
            this.defaultPlaceholders = defaultPlaceholders;
            return this;
        }

        public SendEmailRequest preserveRecipients(Boolean preserveRecipients) {
            this.preserveRecipients = preserveRecipients;
            return this;
        }

        public SendEmailRequest sendAt(OffsetDateTime sendAt) {
            this.sendAt = sendAt;
            return this;
        }

        public SendEmailRequest landingPagePlaceholders(String landingPagePlaceholders) {
            this.landingPagePlaceholders = landingPagePlaceholders;
            return this;
        }

        public SendEmailRequest landingPageId(String landingPageId) {
            this.landingPageId = landingPageId;
            return this;
        }

        public SendEmailRequest templateLanguageVersion(String templateLanguageVersion) {
            this.templateLanguageVersion = templateLanguageVersion;
            return this;
        }

        public SendEmailRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public SendEmailRequest entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public EmailSendResponse execute() throws ApiException {
            RequestDefinition sendEmailDefinition = EmailApi.this.sendEmailDefinition(this.to, this.from, this.cc, this.bcc, this.subject, this.text, this.html, this.ampHtml, this.templateId, this.attachment, this.inlineImage, this.intermediateReport, this.notifyUrl, this.notifyContentType, this.callbackData, this.track, this.trackClicks, this.trackOpens, this.trackingUrl, this.bulkId, this.messageId, this.replyTo, this.defaultPlaceholders, this.preserveRecipients, this.sendAt, this.landingPagePlaceholders, this.landingPageId, this.templateLanguageVersion, this.applicationId, this.entityId);
            return (EmailSendResponse)EmailApi.this.apiClient.execute(sendEmailDefinition, new TypeReference<EmailSendResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailSendResponse> callback) {
            RequestDefinition sendEmailDefinition = EmailApi.this.sendEmailDefinition(this.to, this.from, this.cc, this.bcc, this.subject, this.text, this.html, this.ampHtml, this.templateId, this.attachment, this.inlineImage, this.intermediateReport, this.notifyUrl, this.notifyContentType, this.callbackData, this.track, this.trackClicks, this.trackOpens, this.trackingUrl, this.bulkId, this.messageId, this.replyTo, this.defaultPlaceholders, this.preserveRecipients, this.sendAt, this.landingPagePlaceholders, this.landingPageId, this.templateLanguageVersion, this.applicationId, this.entityId);
            return EmailApi.this.apiClient.executeAsync(sendEmailDefinition, new TypeReference<EmailSendResponse>(){}.getType(), callback);
        }
    }

    public class RescheduleEmailsRequest {
        private final String bulkId;
        private final EmailBulkRescheduleRequest emailBulkRescheduleRequest;

        private RescheduleEmailsRequest(String bulkId, EmailBulkRescheduleRequest emailBulkRescheduleRequest) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
            this.emailBulkRescheduleRequest = Objects.requireNonNull(emailBulkRescheduleRequest, "The required parameter 'emailBulkRescheduleRequest' is missing.");
        }

        public EmailBulkRescheduleResponse execute() throws ApiException {
            RequestDefinition rescheduleEmailsDefinition = EmailApi.this.rescheduleEmailsDefinition(this.bulkId, this.emailBulkRescheduleRequest);
            return (EmailBulkRescheduleResponse)EmailApi.this.apiClient.execute(rescheduleEmailsDefinition, new TypeReference<EmailBulkRescheduleResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailBulkRescheduleResponse> callback) {
            RequestDefinition rescheduleEmailsDefinition = EmailApi.this.rescheduleEmailsDefinition(this.bulkId, this.emailBulkRescheduleRequest);
            return EmailApi.this.apiClient.executeAsync(rescheduleEmailsDefinition, new TypeReference<EmailBulkRescheduleResponse>(){}.getType(), callback);
        }
    }

    public class RemoveIpFromDomainRequest {
        private final String domainName;
        private final String ipAddress;

        private RemoveIpFromDomainRequest(String domainName, String ipAddress) {
            this.domainName = Objects.requireNonNull(domainName, "The required parameter 'domainName' is missing.");
            this.ipAddress = Objects.requireNonNull(ipAddress, "The required parameter 'ipAddress' is missing.");
        }

        public EmailSimpleApiResponse execute() throws ApiException {
            RequestDefinition removeIpFromDomainDefinition = EmailApi.this.removeIpFromDomainDefinition(this.domainName, this.ipAddress);
            return (EmailSimpleApiResponse)EmailApi.this.apiClient.execute(removeIpFromDomainDefinition, new TypeReference<EmailSimpleApiResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailSimpleApiResponse> callback) {
            RequestDefinition removeIpFromDomainDefinition = EmailApi.this.removeIpFromDomainDefinition(this.domainName, this.ipAddress);
            return EmailApi.this.apiClient.executeAsync(removeIpFromDomainDefinition, new TypeReference<EmailSimpleApiResponse>(){}.getType(), callback);
        }
    }

    public class GetScheduledEmailsRequest {
        private final String bulkId;

        private GetScheduledEmailsRequest(String bulkId) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
        }

        public EmailBulkScheduleResponse execute() throws ApiException {
            RequestDefinition getScheduledEmailsDefinition = EmailApi.this.getScheduledEmailsDefinition(this.bulkId);
            return (EmailBulkScheduleResponse)EmailApi.this.apiClient.execute(getScheduledEmailsDefinition, new TypeReference<EmailBulkScheduleResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailBulkScheduleResponse> callback) {
            RequestDefinition getScheduledEmailsDefinition = EmailApi.this.getScheduledEmailsDefinition(this.bulkId);
            return EmailApi.this.apiClient.executeAsync(getScheduledEmailsDefinition, new TypeReference<EmailBulkScheduleResponse>(){}.getType(), callback);
        }
    }

    public class GetScheduledEmailStatusesRequest {
        private final String bulkId;

        private GetScheduledEmailStatusesRequest(String bulkId) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
        }

        public EmailBulkStatusResponse execute() throws ApiException {
            RequestDefinition getScheduledEmailStatusesDefinition = EmailApi.this.getScheduledEmailStatusesDefinition(this.bulkId);
            return (EmailBulkStatusResponse)EmailApi.this.apiClient.execute(getScheduledEmailStatusesDefinition, new TypeReference<EmailBulkStatusResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailBulkStatusResponse> callback) {
            RequestDefinition getScheduledEmailStatusesDefinition = EmailApi.this.getScheduledEmailStatusesDefinition(this.bulkId);
            return EmailApi.this.apiClient.executeAsync(getScheduledEmailStatusesDefinition, new TypeReference<EmailBulkStatusResponse>(){}.getType(), callback);
        }
    }

    public class GetEmailLogsRequest {
        private String messageId;
        private String from;
        private String to;
        private String bulkId;
        private String generalStatus;
        private OffsetDateTime sentSince;
        private OffsetDateTime sentUntil;
        private Integer limit;
        private String applicationId;
        private String entityId;

        private GetEmailLogsRequest() {
        }

        public GetEmailLogsRequest messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public GetEmailLogsRequest from(String from) {
            this.from = from;
            return this;
        }

        public GetEmailLogsRequest to(String to) {
            this.to = to;
            return this;
        }

        public GetEmailLogsRequest bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public GetEmailLogsRequest generalStatus(String generalStatus) {
            this.generalStatus = generalStatus;
            return this;
        }

        public GetEmailLogsRequest sentSince(OffsetDateTime sentSince) {
            this.sentSince = sentSince;
            return this;
        }

        public GetEmailLogsRequest sentUntil(OffsetDateTime sentUntil) {
            this.sentUntil = sentUntil;
            return this;
        }

        public GetEmailLogsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetEmailLogsRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetEmailLogsRequest entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public EmailLogsResponse execute() throws ApiException {
            RequestDefinition getEmailLogsDefinition = EmailApi.this.getEmailLogsDefinition(this.messageId, this.from, this.to, this.bulkId, this.generalStatus, this.sentSince, this.sentUntil, this.limit, this.applicationId, this.entityId);
            return (EmailLogsResponse)EmailApi.this.apiClient.execute(getEmailLogsDefinition, new TypeReference<EmailLogsResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailLogsResponse> callback) {
            RequestDefinition getEmailLogsDefinition = EmailApi.this.getEmailLogsDefinition(this.messageId, this.from, this.to, this.bulkId, this.generalStatus, this.sentSince, this.sentUntil, this.limit, this.applicationId, this.entityId);
            return EmailApi.this.apiClient.executeAsync(getEmailLogsDefinition, new TypeReference<EmailLogsResponse>(){}.getType(), callback);
        }
    }

    public class GetEmailDeliveryReportsRequest {
        private String bulkId;
        private String messageId;
        private Integer limit;
        private String applicationId;
        private String entityId;

        private GetEmailDeliveryReportsRequest() {
        }

        public GetEmailDeliveryReportsRequest bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public GetEmailDeliveryReportsRequest messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public GetEmailDeliveryReportsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetEmailDeliveryReportsRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetEmailDeliveryReportsRequest entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public EmailReportsResult execute() throws ApiException {
            RequestDefinition getEmailDeliveryReportsDefinition = EmailApi.this.getEmailDeliveryReportsDefinition(this.bulkId, this.messageId, this.limit, this.applicationId, this.entityId);
            return (EmailReportsResult)EmailApi.this.apiClient.execute(getEmailDeliveryReportsDefinition, new TypeReference<EmailReportsResult>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailReportsResult> callback) {
            RequestDefinition getEmailDeliveryReportsDefinition = EmailApi.this.getEmailDeliveryReportsDefinition(this.bulkId, this.messageId, this.limit, this.applicationId, this.entityId);
            return EmailApi.this.apiClient.executeAsync(getEmailDeliveryReportsDefinition, new TypeReference<EmailReportsResult>(){}.getType(), callback);
        }
    }

    public class GetDomainDetailsRequest {
        private final String domainName;

        private GetDomainDetailsRequest(String domainName) {
            this.domainName = Objects.requireNonNull(domainName, "The required parameter 'domainName' is missing.");
        }

        public EmailDomainResponse execute() throws ApiException {
            RequestDefinition getDomainDetailsDefinition = EmailApi.this.getDomainDetailsDefinition(this.domainName);
            return (EmailDomainResponse)EmailApi.this.apiClient.execute(getDomainDetailsDefinition, new TypeReference<EmailDomainResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailDomainResponse> callback) {
            RequestDefinition getDomainDetailsDefinition = EmailApi.this.getDomainDetailsDefinition(this.domainName);
            return EmailApi.this.apiClient.executeAsync(getDomainDetailsDefinition, new TypeReference<EmailDomainResponse>(){}.getType(), callback);
        }
    }

    public class GetAllIpsRequest {
        private GetAllIpsRequest() {
        }

        public EmailDomainIpResponse execute() throws ApiException {
            RequestDefinition getAllIpsDefinition = EmailApi.this.getAllIpsDefinition();
            return (EmailDomainIpResponse)EmailApi.this.apiClient.execute(getAllIpsDefinition, new TypeReference<EmailDomainIpResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailDomainIpResponse> callback) {
            RequestDefinition getAllIpsDefinition = EmailApi.this.getAllIpsDefinition();
            return EmailApi.this.apiClient.executeAsync(getAllIpsDefinition, new TypeReference<EmailDomainIpResponse>(){}.getType(), callback);
        }
    }

    public class GetAllDomainsRequest {
        private Integer size;
        private Integer page;

        private GetAllDomainsRequest() {
        }

        public GetAllDomainsRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public GetAllDomainsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public EmailAllDomainsResponse execute() throws ApiException {
            RequestDefinition getAllDomainsDefinition = EmailApi.this.getAllDomainsDefinition(this.size, this.page);
            return (EmailAllDomainsResponse)EmailApi.this.apiClient.execute(getAllDomainsDefinition, new TypeReference<EmailAllDomainsResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailAllDomainsResponse> callback) {
            RequestDefinition getAllDomainsDefinition = EmailApi.this.getAllDomainsDefinition(this.size, this.page);
            return EmailApi.this.apiClient.executeAsync(getAllDomainsDefinition, new TypeReference<EmailAllDomainsResponse>(){}.getType(), callback);
        }
    }

    public class GetAllDomainIpsRequest {
        private final String domainName;

        private GetAllDomainIpsRequest(String domainName) {
            this.domainName = Objects.requireNonNull(domainName, "The required parameter 'domainName' is missing.");
        }

        public EmailDomainIpResponse execute() throws ApiException {
            RequestDefinition getAllDomainIpsDefinition = EmailApi.this.getAllDomainIpsDefinition(this.domainName);
            return (EmailDomainIpResponse)EmailApi.this.apiClient.execute(getAllDomainIpsDefinition, new TypeReference<EmailDomainIpResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailDomainIpResponse> callback) {
            RequestDefinition getAllDomainIpsDefinition = EmailApi.this.getAllDomainIpsDefinition(this.domainName);
            return EmailApi.this.apiClient.executeAsync(getAllDomainIpsDefinition, new TypeReference<EmailDomainIpResponse>(){}.getType(), callback);
        }
    }

    public class DeleteDomainRequest {
        private final String domainName;

        private DeleteDomainRequest(String domainName) {
            this.domainName = Objects.requireNonNull(domainName, "The required parameter 'domainName' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition deleteDomainDefinition = EmailApi.this.deleteDomainDefinition(this.domainName);
            EmailApi.this.apiClient.execute(deleteDomainDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition deleteDomainDefinition = EmailApi.this.deleteDomainDefinition(this.domainName);
            return EmailApi.this.apiClient.executeAsync(deleteDomainDefinition, callback);
        }
    }

    public class AssignIpToDomainRequest {
        private final EmailDomainIpRequest emailDomainIpRequest;

        private AssignIpToDomainRequest(EmailDomainIpRequest emailDomainIpRequest) {
            this.emailDomainIpRequest = Objects.requireNonNull(emailDomainIpRequest, "The required parameter 'emailDomainIpRequest' is missing.");
        }

        public EmailSimpleApiResponse execute() throws ApiException {
            RequestDefinition assignIpToDomainDefinition = EmailApi.this.assignIpToDomainDefinition(this.emailDomainIpRequest);
            return (EmailSimpleApiResponse)EmailApi.this.apiClient.execute(assignIpToDomainDefinition, new TypeReference<EmailSimpleApiResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailSimpleApiResponse> callback) {
            RequestDefinition assignIpToDomainDefinition = EmailApi.this.assignIpToDomainDefinition(this.emailDomainIpRequest);
            return EmailApi.this.apiClient.executeAsync(assignIpToDomainDefinition, new TypeReference<EmailSimpleApiResponse>(){}.getType(), callback);
        }
    }

    public class AddDomainRequest {
        private final EmailAddDomainRequest emailAddDomainRequest;

        private AddDomainRequest(EmailAddDomainRequest emailAddDomainRequest) {
            this.emailAddDomainRequest = Objects.requireNonNull(emailAddDomainRequest, "The required parameter 'emailAddDomainRequest' is missing.");
        }

        public EmailDomainResponse execute() throws ApiException {
            RequestDefinition addDomainDefinition = EmailApi.this.addDomainDefinition(this.emailAddDomainRequest);
            return (EmailDomainResponse)EmailApi.this.apiClient.execute(addDomainDefinition, new TypeReference<EmailDomainResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<EmailDomainResponse> callback) {
            RequestDefinition addDomainDefinition = EmailApi.this.addDomainDefinition(this.emailAddDomainRequest);
            return EmailApi.this.apiClient.executeAsync(addDomainDefinition, new TypeReference<EmailDomainResponse>(){}.getType(), callback);
        }
    }
}

