/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.Beta;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.RequestDefinition;
import com.infobip.model.MessagesApiEventRequest;
import com.infobip.model.MessagesApiRequest;
import com.infobip.model.MessagesApiResponse;
import java.util.Objects;
import okhttp3.Call;

public class MessagesApi {
    private final ApiClient apiClient;

    public MessagesApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition sendMessagesApiEventsDefinition(MessagesApiEventRequest messagesApiEventRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/messages-api/1/events").body(messagesApiEventRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    @Beta
    public SendMessagesApiEventsRequest sendMessagesApiEvents(MessagesApiEventRequest messagesApiEventRequest) {
        return new SendMessagesApiEventsRequest(messagesApiEventRequest);
    }

    private RequestDefinition sendMessagesApiMessageDefinition(MessagesApiRequest messagesApiRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/messages-api/1/messages").body(messagesApiRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    @Beta
    public SendMessagesApiMessageRequest sendMessagesApiMessage(MessagesApiRequest messagesApiRequest) {
        return new SendMessagesApiMessageRequest(messagesApiRequest);
    }

    public class SendMessagesApiMessageRequest {
        private final MessagesApiRequest messagesApiRequest;

        private SendMessagesApiMessageRequest(MessagesApiRequest messagesApiRequest) {
            this.messagesApiRequest = Objects.requireNonNull(messagesApiRequest, "The required parameter 'messagesApiRequest' is missing.");
        }

        public MessagesApiResponse execute() throws ApiException {
            RequestDefinition sendMessagesApiMessageDefinition = MessagesApi.this.sendMessagesApiMessageDefinition(this.messagesApiRequest);
            return (MessagesApiResponse)MessagesApi.this.apiClient.execute(sendMessagesApiMessageDefinition, new TypeReference<MessagesApiResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<MessagesApiResponse> callback) {
            RequestDefinition sendMessagesApiMessageDefinition = MessagesApi.this.sendMessagesApiMessageDefinition(this.messagesApiRequest);
            return MessagesApi.this.apiClient.executeAsync(sendMessagesApiMessageDefinition, new TypeReference<MessagesApiResponse>(){}.getType(), callback);
        }
    }

    public class SendMessagesApiEventsRequest {
        private final MessagesApiEventRequest messagesApiEventRequest;

        private SendMessagesApiEventsRequest(MessagesApiEventRequest messagesApiEventRequest) {
            this.messagesApiEventRequest = Objects.requireNonNull(messagesApiEventRequest, "The required parameter 'messagesApiEventRequest' is missing.");
        }

        public MessagesApiResponse execute() throws ApiException {
            RequestDefinition sendMessagesApiEventsDefinition = MessagesApi.this.sendMessagesApiEventsDefinition(this.messagesApiEventRequest);
            return (MessagesApiResponse)MessagesApi.this.apiClient.execute(sendMessagesApiEventsDefinition, new TypeReference<MessagesApiResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<MessagesApiResponse> callback) {
            RequestDefinition sendMessagesApiEventsDefinition = MessagesApi.this.sendMessagesApiEventsDefinition(this.messagesApiEventRequest);
            return MessagesApi.this.apiClient.executeAsync(sendMessagesApiEventsDefinition, new TypeReference<MessagesApiResponse>(){}.getType(), callback);
        }
    }
}

