/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.Parameter;
import com.infobip.RequestDefinition;
import com.infobip.model.ViberBulkMessageInfo;
import com.infobip.model.ViberBulkTextMessage;
import com.infobip.model.ViberFileMessage;
import com.infobip.model.ViberImageMessage;
import com.infobip.model.ViberLogsResponse;
import com.infobip.model.ViberMessageGeneralStatus;
import com.infobip.model.ViberRequest;
import com.infobip.model.ViberResponse;
import com.infobip.model.ViberSingleMessageInfo;
import com.infobip.model.ViberVideoMessage;
import com.infobip.model.ViberWebhookReportsResponse;
import java.util.Objects;
import okhttp3.Call;

public class ViberApi {
    private final ApiClient apiClient;

    public ViberApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition getOutboundViberMessageDeliveryReportsDefinition(String bulkId, String messageId, Integer limit, String entityId, String applicationId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/viber/2/reports").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        if (messageId != null) {
            builder.addQueryParameter(new Parameter("messageId", messageId));
        }
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        if (entityId != null) {
            builder.addQueryParameter(new Parameter("entityId", entityId));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        return builder.build();
    }

    public GetOutboundViberMessageDeliveryReportsRequest getOutboundViberMessageDeliveryReports() {
        return new GetOutboundViberMessageDeliveryReportsRequest();
    }

    private RequestDefinition getOutboundViberMessageLogsDefinition(String sender, String destination, String bulkId, String messageId, ViberMessageGeneralStatus generalStatus, String sentSince, String sentUntil, String limit, String entityId, String applicationId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/viber/2/logs").requiresAuthentication(true).accept("application/json");
        if (sender != null) {
            builder.addQueryParameter(new Parameter("sender", sender));
        }
        if (destination != null) {
            builder.addQueryParameter(new Parameter("destination", destination));
        }
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        if (messageId != null) {
            builder.addQueryParameter(new Parameter("messageId", messageId));
        }
        if (generalStatus != null) {
            builder.addQueryParameter(new Parameter("generalStatus", (Object)generalStatus));
        }
        if (sentSince != null) {
            builder.addQueryParameter(new Parameter("sentSince", sentSince));
        }
        if (sentUntil != null) {
            builder.addQueryParameter(new Parameter("sentUntil", sentUntil));
        }
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        if (entityId != null) {
            builder.addQueryParameter(new Parameter("entityId", entityId));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        return builder.build();
    }

    public GetOutboundViberMessageLogsRequest getOutboundViberMessageLogs() {
        return new GetOutboundViberMessageLogsRequest();
    }

    private RequestDefinition sendViberFileMessageDefinition(ViberFileMessage viberFileMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/viber/1/message/file").body(viberFileMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    @Deprecated
    public SendViberFileMessageRequest sendViberFileMessage(ViberFileMessage viberFileMessage) {
        return new SendViberFileMessageRequest(viberFileMessage);
    }

    private RequestDefinition sendViberImageMessageDefinition(ViberImageMessage viberImageMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/viber/1/message/image").body(viberImageMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    @Deprecated
    public SendViberImageMessageRequest sendViberImageMessage(ViberImageMessage viberImageMessage) {
        return new SendViberImageMessageRequest(viberImageMessage);
    }

    private RequestDefinition sendViberMessagesDefinition(ViberRequest viberRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/viber/2/messages").body(viberRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendViberMessagesRequest sendViberMessages(ViberRequest viberRequest) {
        return new SendViberMessagesRequest(viberRequest);
    }

    private RequestDefinition sendViberTextMessageDefinition(ViberBulkTextMessage viberBulkTextMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/viber/1/message/text").body(viberBulkTextMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    @Deprecated
    public SendViberTextMessageRequest sendViberTextMessage(ViberBulkTextMessage viberBulkTextMessage) {
        return new SendViberTextMessageRequest(viberBulkTextMessage);
    }

    private RequestDefinition sendViberVideoMessageDefinition(ViberVideoMessage viberVideoMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/viber/1/message/video").body(viberVideoMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    @Deprecated
    public SendViberVideoMessageRequest sendViberVideoMessage(ViberVideoMessage viberVideoMessage) {
        return new SendViberVideoMessageRequest(viberVideoMessage);
    }

    public class SendViberVideoMessageRequest {
        private final ViberVideoMessage viberVideoMessage;

        private SendViberVideoMessageRequest(ViberVideoMessage viberVideoMessage) {
            this.viberVideoMessage = Objects.requireNonNull(viberVideoMessage, "The required parameter 'viberVideoMessage' is missing.");
        }

        @Deprecated
        public ViberSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendViberVideoMessageDefinition = ViberApi.this.sendViberVideoMessageDefinition(this.viberVideoMessage);
            return (ViberSingleMessageInfo)ViberApi.this.apiClient.execute(sendViberVideoMessageDefinition, new TypeReference<ViberSingleMessageInfo>(){}.getType());
        }

        @Deprecated
        public Call executeAsync(ApiCallback<ViberSingleMessageInfo> callback) {
            RequestDefinition sendViberVideoMessageDefinition = ViberApi.this.sendViberVideoMessageDefinition(this.viberVideoMessage);
            return ViberApi.this.apiClient.executeAsync(sendViberVideoMessageDefinition, new TypeReference<ViberSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendViberTextMessageRequest {
        private final ViberBulkTextMessage viberBulkTextMessage;

        private SendViberTextMessageRequest(ViberBulkTextMessage viberBulkTextMessage) {
            this.viberBulkTextMessage = Objects.requireNonNull(viberBulkTextMessage, "The required parameter 'viberBulkTextMessage' is missing.");
        }

        @Deprecated
        public ViberBulkMessageInfo execute() throws ApiException {
            RequestDefinition sendViberTextMessageDefinition = ViberApi.this.sendViberTextMessageDefinition(this.viberBulkTextMessage);
            return (ViberBulkMessageInfo)ViberApi.this.apiClient.execute(sendViberTextMessageDefinition, new TypeReference<ViberBulkMessageInfo>(){}.getType());
        }

        @Deprecated
        public Call executeAsync(ApiCallback<ViberBulkMessageInfo> callback) {
            RequestDefinition sendViberTextMessageDefinition = ViberApi.this.sendViberTextMessageDefinition(this.viberBulkTextMessage);
            return ViberApi.this.apiClient.executeAsync(sendViberTextMessageDefinition, new TypeReference<ViberBulkMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendViberMessagesRequest {
        private final ViberRequest viberRequest;

        private SendViberMessagesRequest(ViberRequest viberRequest) {
            this.viberRequest = Objects.requireNonNull(viberRequest, "The required parameter 'viberRequest' is missing.");
        }

        public ViberResponse execute() throws ApiException {
            RequestDefinition sendViberMessagesDefinition = ViberApi.this.sendViberMessagesDefinition(this.viberRequest);
            return (ViberResponse)ViberApi.this.apiClient.execute(sendViberMessagesDefinition, new TypeReference<ViberResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<ViberResponse> callback) {
            RequestDefinition sendViberMessagesDefinition = ViberApi.this.sendViberMessagesDefinition(this.viberRequest);
            return ViberApi.this.apiClient.executeAsync(sendViberMessagesDefinition, new TypeReference<ViberResponse>(){}.getType(), callback);
        }
    }

    public class SendViberImageMessageRequest {
        private final ViberImageMessage viberImageMessage;

        private SendViberImageMessageRequest(ViberImageMessage viberImageMessage) {
            this.viberImageMessage = Objects.requireNonNull(viberImageMessage, "The required parameter 'viberImageMessage' is missing.");
        }

        @Deprecated
        public ViberSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendViberImageMessageDefinition = ViberApi.this.sendViberImageMessageDefinition(this.viberImageMessage);
            return (ViberSingleMessageInfo)ViberApi.this.apiClient.execute(sendViberImageMessageDefinition, new TypeReference<ViberSingleMessageInfo>(){}.getType());
        }

        @Deprecated
        public Call executeAsync(ApiCallback<ViberSingleMessageInfo> callback) {
            RequestDefinition sendViberImageMessageDefinition = ViberApi.this.sendViberImageMessageDefinition(this.viberImageMessage);
            return ViberApi.this.apiClient.executeAsync(sendViberImageMessageDefinition, new TypeReference<ViberSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendViberFileMessageRequest {
        private final ViberFileMessage viberFileMessage;

        private SendViberFileMessageRequest(ViberFileMessage viberFileMessage) {
            this.viberFileMessage = Objects.requireNonNull(viberFileMessage, "The required parameter 'viberFileMessage' is missing.");
        }

        @Deprecated
        public ViberSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendViberFileMessageDefinition = ViberApi.this.sendViberFileMessageDefinition(this.viberFileMessage);
            return (ViberSingleMessageInfo)ViberApi.this.apiClient.execute(sendViberFileMessageDefinition, new TypeReference<ViberSingleMessageInfo>(){}.getType());
        }

        @Deprecated
        public Call executeAsync(ApiCallback<ViberSingleMessageInfo> callback) {
            RequestDefinition sendViberFileMessageDefinition = ViberApi.this.sendViberFileMessageDefinition(this.viberFileMessage);
            return ViberApi.this.apiClient.executeAsync(sendViberFileMessageDefinition, new TypeReference<ViberSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class GetOutboundViberMessageLogsRequest {
        private String sender;
        private String destination;
        private String bulkId;
        private String messageId;
        private ViberMessageGeneralStatus generalStatus;
        private String sentSince;
        private String sentUntil;
        private String limit;
        private String entityId;
        private String applicationId;

        private GetOutboundViberMessageLogsRequest() {
        }

        public GetOutboundViberMessageLogsRequest sender(String sender) {
            this.sender = sender;
            return this;
        }

        public GetOutboundViberMessageLogsRequest destination(String destination) {
            this.destination = destination;
            return this;
        }

        public GetOutboundViberMessageLogsRequest bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public GetOutboundViberMessageLogsRequest messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public GetOutboundViberMessageLogsRequest generalStatus(ViberMessageGeneralStatus generalStatus) {
            this.generalStatus = generalStatus;
            return this;
        }

        public GetOutboundViberMessageLogsRequest sentSince(String sentSince) {
            this.sentSince = sentSince;
            return this;
        }

        public GetOutboundViberMessageLogsRequest sentUntil(String sentUntil) {
            this.sentUntil = sentUntil;
            return this;
        }

        public GetOutboundViberMessageLogsRequest limit(String limit) {
            this.limit = limit;
            return this;
        }

        public GetOutboundViberMessageLogsRequest entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public GetOutboundViberMessageLogsRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public ViberLogsResponse execute() throws ApiException {
            RequestDefinition getOutboundViberMessageLogsDefinition = ViberApi.this.getOutboundViberMessageLogsDefinition(this.sender, this.destination, this.bulkId, this.messageId, this.generalStatus, this.sentSince, this.sentUntil, this.limit, this.entityId, this.applicationId);
            return (ViberLogsResponse)ViberApi.this.apiClient.execute(getOutboundViberMessageLogsDefinition, new TypeReference<ViberLogsResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<ViberLogsResponse> callback) {
            RequestDefinition getOutboundViberMessageLogsDefinition = ViberApi.this.getOutboundViberMessageLogsDefinition(this.sender, this.destination, this.bulkId, this.messageId, this.generalStatus, this.sentSince, this.sentUntil, this.limit, this.entityId, this.applicationId);
            return ViberApi.this.apiClient.executeAsync(getOutboundViberMessageLogsDefinition, new TypeReference<ViberLogsResponse>(){}.getType(), callback);
        }
    }

    public class GetOutboundViberMessageDeliveryReportsRequest {
        private String bulkId;
        private String messageId;
        private Integer limit;
        private String entityId;
        private String applicationId;

        private GetOutboundViberMessageDeliveryReportsRequest() {
        }

        public GetOutboundViberMessageDeliveryReportsRequest bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public GetOutboundViberMessageDeliveryReportsRequest messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public GetOutboundViberMessageDeliveryReportsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetOutboundViberMessageDeliveryReportsRequest entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public GetOutboundViberMessageDeliveryReportsRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public ViberWebhookReportsResponse execute() throws ApiException {
            RequestDefinition getOutboundViberMessageDeliveryReportsDefinition = ViberApi.this.getOutboundViberMessageDeliveryReportsDefinition(this.bulkId, this.messageId, this.limit, this.entityId, this.applicationId);
            return (ViberWebhookReportsResponse)ViberApi.this.apiClient.execute(getOutboundViberMessageDeliveryReportsDefinition, new TypeReference<ViberWebhookReportsResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<ViberWebhookReportsResponse> callback) {
            RequestDefinition getOutboundViberMessageDeliveryReportsDefinition = ViberApi.this.getOutboundViberMessageDeliveryReportsDefinition(this.bulkId, this.messageId, this.limit, this.entityId, this.applicationId);
            return ViberApi.this.apiClient.executeAsync(getOutboundViberMessageDeliveryReportsDefinition, new TypeReference<ViberWebhookReportsResponse>(){}.getType(), callback);
        }
    }
}

