/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.infobip.model.CallEndpoint;
import com.infobip.model.CallRecordingRequest;
import com.infobip.model.CallsMachineDetectionRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CallRequest {
    private CallEndpoint endpoint;
    private String from;
    private String fromDisplayName;
    private Integer connectTimeout;
    private CallRecordingRequest recording;
    private CallsMachineDetectionRequest machineDetection;
    private Integer maxDuration;
    private Map<String, String> customData = null;
    private String applicationId;
    private String parentCallId;

    public CallRequest endpoint(CallEndpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @JsonProperty(value="endpoint")
    public CallEndpoint getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty(value="endpoint")
    public void setEndpoint(CallEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public CallRequest from(String from) {
        this.from = from;
        return this;
    }

    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonProperty(value="from")
    public void setFrom(String from) {
        this.from = from;
    }

    public CallRequest fromDisplayName(String fromDisplayName) {
        this.fromDisplayName = fromDisplayName;
        return this;
    }

    @JsonProperty(value="fromDisplayName")
    public String getFromDisplayName() {
        return this.fromDisplayName;
    }

    @JsonProperty(value="fromDisplayName")
    public void setFromDisplayName(String fromDisplayName) {
        this.fromDisplayName = fromDisplayName;
    }

    public CallRequest connectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @JsonProperty(value="connectTimeout")
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @JsonProperty(value="connectTimeout")
    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public CallRequest recording(CallRecordingRequest recording) {
        this.recording = recording;
        return this;
    }

    @JsonProperty(value="recording")
    public CallRecordingRequest getRecording() {
        return this.recording;
    }

    @JsonProperty(value="recording")
    public void setRecording(CallRecordingRequest recording) {
        this.recording = recording;
    }

    public CallRequest machineDetection(CallsMachineDetectionRequest machineDetection) {
        this.machineDetection = machineDetection;
        return this;
    }

    @JsonProperty(value="machineDetection")
    public CallsMachineDetectionRequest getMachineDetection() {
        return this.machineDetection;
    }

    @JsonProperty(value="machineDetection")
    public void setMachineDetection(CallsMachineDetectionRequest machineDetection) {
        this.machineDetection = machineDetection;
    }

    public CallRequest maxDuration(Integer maxDuration) {
        this.maxDuration = maxDuration;
        return this;
    }

    @JsonProperty(value="maxDuration")
    public Integer getMaxDuration() {
        return this.maxDuration;
    }

    @JsonProperty(value="maxDuration")
    public void setMaxDuration(Integer maxDuration) {
        this.maxDuration = maxDuration;
    }

    public CallRequest customData(Map<String, String> customData) {
        this.customData = customData;
        return this;
    }

    public CallRequest putCustomDataItem(String key, String customDataItem) {
        if (this.customData == null) {
            this.customData = new HashMap<String, String>();
        }
        this.customData.put(key, customDataItem);
        return this;
    }

    @JsonProperty(value="customData")
    public Map<String, String> getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(Map<String, String> customData) {
        this.customData = customData;
    }

    public CallRequest applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @JsonProperty(value="applicationId")
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonProperty(value="applicationId")
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public CallRequest parentCallId(String parentCallId) {
        this.parentCallId = parentCallId;
        return this;
    }

    @JsonProperty(value="parentCallId")
    public String getParentCallId() {
        return this.parentCallId;
    }

    @JsonProperty(value="parentCallId")
    public void setParentCallId(String parentCallId) {
        this.parentCallId = parentCallId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallRequest callRequest = (CallRequest)o;
        return Objects.equals(this.endpoint, callRequest.endpoint) && Objects.equals(this.from, callRequest.from) && Objects.equals(this.fromDisplayName, callRequest.fromDisplayName) && Objects.equals(this.connectTimeout, callRequest.connectTimeout) && Objects.equals(this.recording, callRequest.recording) && Objects.equals(this.machineDetection, callRequest.machineDetection) && Objects.equals(this.maxDuration, callRequest.maxDuration) && Objects.equals(this.customData, callRequest.customData) && Objects.equals(this.applicationId, callRequest.applicationId) && Objects.equals(this.parentCallId, callRequest.parentCallId);
    }

    public int hashCode() {
        return Objects.hash(this.endpoint, this.from, this.fromDisplayName, this.connectTimeout, this.recording, this.machineDetection, this.maxDuration, this.customData, this.applicationId, this.parentCallId);
    }

    public String toString() {
        String newLine = System.lineSeparator();
        return "class CallRequest {" + newLine + "    endpoint: " + this.toIndentedString(this.endpoint) + newLine + "    from: " + this.toIndentedString(this.from) + newLine + "    fromDisplayName: " + this.toIndentedString(this.fromDisplayName) + newLine + "    connectTimeout: " + this.toIndentedString(this.connectTimeout) + newLine + "    recording: " + this.toIndentedString(this.recording) + newLine + "    machineDetection: " + this.toIndentedString(this.machineDetection) + newLine + "    maxDuration: " + this.toIndentedString(this.maxDuration) + newLine + "    customData: " + this.toIndentedString(this.customData) + newLine + "    applicationId: " + this.toIndentedString(this.applicationId) + newLine + "    parentCallId: " + this.toIndentedString(this.parentCallId) + newLine + "}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        String lineSeparator = System.lineSeparator();
        String lineSeparatorFollowedByIndentation = lineSeparator + "    ";
        return o.toString().replace(lineSeparator, lineSeparatorFollowedByIndentation);
    }
}

