/*
 * Decompiled with CFR 0.152.
 */
package com.ip2location;

import com.ip2location.IPResult;
import com.ip2location.MetaData;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IP2Location {
    private static final Pattern pattern = Pattern.compile("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
    private static final Pattern pattern2 = Pattern.compile("^([0-9A-F]{1,4}:){6}(0[0-9]+\\.|.*?\\.0[0-9]+).*$", 2);
    private static final Pattern pattern3 = Pattern.compile("^[0-9]+$");
    private static final Pattern pattern4 = Pattern.compile("^(.*:)(([0-9]+\\.){3}[0-9]+)$");
    private static final Pattern pattern5 = Pattern.compile("^.*((:[0-9A-F]{1,4}){2})$");
    private static final Pattern pattern6 = Pattern.compile("^[0:]+((:[0-9A-F]{1,4}){1,2})$", 2);
    private static final BigInteger MAX_IPV4_RANGE = new BigInteger("4294967295");
    private static final BigInteger MAX_IPV6_RANGE = new BigInteger("340282366920938463463374607431768211455");
    private static final BigInteger FROM_6TO4 = new BigInteger("42545680458834377588178886921629466624");
    private static final BigInteger TO_6TO4 = new BigInteger("42550872755692912415807417417958686719");
    private static final BigInteger FROM_TEREDO = new BigInteger("42540488161975842760550356425300246528");
    private static final BigInteger TO_TEREDO = new BigInteger("42540488241204005274814694018844196863");
    private static final BigInteger LAST_32BITS = new BigInteger("4294967295");
    private static final int[] COUNTRY_POSITION = new int[]{0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
    private static final int[] REGION_POSITION = new int[]{0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
    private static final int[] CITY_POSITION = new int[]{0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] ISP_POSITION = new int[]{0, 0, 3, 0, 5, 0, 7, 5, 7, 0, 8, 0, 9, 0, 9, 0, 9, 0, 9, 7, 9, 0, 9, 7, 9};
    private static final int[] LATITUDE_POSITION = new int[]{0, 0, 0, 0, 0, 5, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5};
    private static final int[] LONGITUDE_POSITION = new int[]{0, 0, 0, 0, 0, 6, 6, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
    private static final int[] DOMAIN_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 6, 8, 0, 9, 0, 10, 0, 10, 0, 10, 0, 10, 8, 10, 0, 10, 8, 10};
    private static final int[] ZIPCODE_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 7, 7, 0, 7, 7, 7, 0, 7, 0, 7, 7, 7, 0, 7};
    private static final int[] TIMEZONE_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 7, 8, 8, 8, 7, 8, 0, 8, 8, 8, 0, 8};
    private static final int[] NETSPEED_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 11, 0, 11, 8, 11, 0, 11, 0, 11, 0, 11};
    private static final int[] IDDCODE_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 12, 0, 12, 0, 12, 9, 12, 0, 12};
    private static final int[] AREACODE_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 13, 0, 13, 0, 13, 10, 13, 0, 13};
    private static final int[] WEATHERSTATIONCODE_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 14, 0, 14, 0, 14, 0, 14};
    private static final int[] WEATHERSTATIONNAME_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 15, 0, 15, 0, 15, 0, 15};
    private static final int[] MCC_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 16, 0, 16, 9, 16};
    private static final int[] MNC_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 17, 0, 17, 10, 17};
    private static final int[] MOBILEBRAND_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 18, 0, 18, 11, 18};
    private static final int[] ELEVATION_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 19, 0, 19};
    private static final int[] USAGETYPE_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 20};
    private MetaData _MetaData = null;
    private MappedByteBuffer _IPv4Buffer = null;
    private MappedByteBuffer _IPv6Buffer = null;
    private MappedByteBuffer _MapDataBuffer = null;
    private int[][] _IndexArrayIPv4 = new int[65536][2];
    private int[][] _IndexArrayIPv6 = new int[65536][2];
    private long _IPv4Offset = 0L;
    private long _IPv6Offset = 0L;
    private long _MapDataOffset = 0L;
    private int _IPv4ColumnSize = 0;
    private int _IPv6ColumnSize = 0;
    public boolean UseMemoryMappedFile = false;
    public String IPDatabasePath = "";
    public String IPLicensePath = "";
    private boolean gotdelay = false;
    private boolean _alreadyCheckedKey = false;
    private int COUNTRY_POSITION_OFFSET;
    private int REGION_POSITION_OFFSET;
    private int CITY_POSITION_OFFSET;
    private int ISP_POSITION_OFFSET;
    private int DOMAIN_POSITION_OFFSET;
    private int ZIPCODE_POSITION_OFFSET;
    private int LATITUDE_POSITION_OFFSET;
    private int LONGITUDE_POSITION_OFFSET;
    private int TIMEZONE_POSITION_OFFSET;
    private int NETSPEED_POSITION_OFFSET;
    private int IDDCODE_POSITION_OFFSET;
    private int AREACODE_POSITION_OFFSET;
    private int WEATHERSTATIONCODE_POSITION_OFFSET;
    private int WEATHERSTATIONNAME_POSITION_OFFSET;
    private int MCC_POSITION_OFFSET;
    private int MNC_POSITION_OFFSET;
    private int MOBILEBRAND_POSITION_OFFSET;
    private int ELEVATION_POSITION_OFFSET;
    private int USAGETYPE_POSITION_OFFSET;
    private boolean COUNTRY_ENABLED;
    private boolean REGION_ENABLED;
    private boolean CITY_ENABLED;
    private boolean ISP_ENABLED;
    private boolean LATITUDE_ENABLED;
    private boolean LONGITUDE_ENABLED;
    private boolean DOMAIN_ENABLED;
    private boolean ZIPCODE_ENABLED;
    private boolean TIMEZONE_ENABLED;
    private boolean NETSPEED_ENABLED;
    private boolean IDDCODE_ENABLED;
    private boolean AREACODE_ENABLED;
    private boolean WEATHERSTATIONCODE_ENABLED;
    private boolean WEATHERSTATIONNAME_ENABLED;
    private boolean MCC_ENABLED;
    private boolean MNC_ENABLED;
    private boolean MOBILEBRAND_ENABLED;
    private boolean ELEVATION_ENABLED;
    private boolean USAGETYPE_ENABLED;

    public void Close() {
        if (this._MetaData != null) {
            this._MetaData = null;
        }
        this.DestroyMappedBytes();
    }

    private void DestroyMappedBytes() {
        if (this._IPv4Buffer != null) {
            this._IPv4Buffer = null;
        }
        if (this._IPv6Buffer != null) {
            this._IPv6Buffer = null;
        }
        if (this._MapDataBuffer != null) {
            this._MapDataBuffer = null;
        }
    }

    private void CreateMappedBytes() throws IOException {
        RandomAccessFile aFile = null;
        try {
            aFile = new RandomAccessFile(this.IPDatabasePath, "r");
            FileChannel inChannel = aFile.getChannel();
            this.CreateMappedBytes(inChannel);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (aFile != null) {
                aFile.close();
                aFile = null;
            }
        }
    }

    private void CreateMappedBytes(FileChannel inChannel) throws IOException {
        if (this._IPv4Buffer == null) {
            long _IPv4Bytes = (long)this._IPv4ColumnSize * (long)this._MetaData.getDBCount();
            this._IPv4Offset = this._MetaData.getBaseAddr() - 1;
            this._IPv4Buffer = inChannel.map(FileChannel.MapMode.READ_ONLY, this._IPv4Offset, _IPv4Bytes);
            this._IPv4Buffer.order(ByteOrder.LITTLE_ENDIAN);
            this._MapDataOffset = this._IPv4Offset + _IPv4Bytes;
        }
        if (!this._MetaData.getOldBIN() && this._IPv6Buffer == null) {
            long _IPv6Bytes = (long)this._IPv6ColumnSize * (long)this._MetaData.getDBCountIPv6();
            this._IPv6Offset = this._MetaData.getBaseAddrIPv6() - 1;
            this._IPv6Buffer = inChannel.map(FileChannel.MapMode.READ_ONLY, this._IPv6Offset, _IPv6Bytes);
            this._IPv6Buffer.order(ByteOrder.LITTLE_ENDIAN);
            this._MapDataOffset = this._IPv6Offset + _IPv6Bytes;
        }
        if (this._MapDataBuffer == null) {
            this._MapDataBuffer = inChannel.map(FileChannel.MapMode.READ_ONLY, this._MapDataOffset, inChannel.size() - this._MapDataOffset);
            this._MapDataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    private boolean LoadBIN() throws IOException {
        boolean loadOK = false;
        RandomAccessFile aFile = null;
        try {
            if (this.IPDatabasePath.length() > 0) {
                aFile = new RandomAccessFile(this.IPDatabasePath, "r");
                FileChannel inChannel = aFile.getChannel();
                MappedByteBuffer _HeaderBuffer = inChannel.map(FileChannel.MapMode.READ_ONLY, 0L, 64L);
                _HeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this._MetaData = new MetaData();
                this._MetaData.setDBType(_HeaderBuffer.get(0));
                this._MetaData.setDBColumn(_HeaderBuffer.get(1));
                this._MetaData.setDBYear(_HeaderBuffer.get(2));
                this._MetaData.setDBMonth(_HeaderBuffer.get(3));
                this._MetaData.setDBDay(_HeaderBuffer.get(4));
                this._MetaData.setDBCount(_HeaderBuffer.getInt(5));
                this._MetaData.setBaseAddr(_HeaderBuffer.getInt(9));
                this._MetaData.setDBCountIPv6(_HeaderBuffer.getInt(13));
                this._MetaData.setBaseAddrIPv6(_HeaderBuffer.getInt(17));
                this._MetaData.setIndexBaseAddr(_HeaderBuffer.getInt(21));
                this._MetaData.setIndexBaseAddrIPv6(_HeaderBuffer.getInt(25));
                if (this._MetaData.getIndexBaseAddr() > 0) {
                    this._MetaData.setIndexed(true);
                }
                if (this._MetaData.getDBCountIPv6() == 0) {
                    this._MetaData.setOldBIN(true);
                } else if (this._MetaData.getIndexBaseAddrIPv6() > 0) {
                    this._MetaData.setIndexedIPv6(true);
                }
                int dbcoll = this._MetaData.getDBColumn();
                this._IPv4ColumnSize = dbcoll << 2;
                this._IPv6ColumnSize = 16 + (dbcoll - 1 << 2);
                int dbtype = this._MetaData.getDBType();
                this.COUNTRY_POSITION_OFFSET = COUNTRY_POSITION[dbtype] != 0 ? COUNTRY_POSITION[dbtype] - 2 << 2 : 0;
                this.REGION_POSITION_OFFSET = REGION_POSITION[dbtype] != 0 ? REGION_POSITION[dbtype] - 2 << 2 : 0;
                this.CITY_POSITION_OFFSET = CITY_POSITION[dbtype] != 0 ? CITY_POSITION[dbtype] - 2 << 2 : 0;
                this.ISP_POSITION_OFFSET = ISP_POSITION[dbtype] != 0 ? ISP_POSITION[dbtype] - 2 << 2 : 0;
                this.DOMAIN_POSITION_OFFSET = DOMAIN_POSITION[dbtype] != 0 ? DOMAIN_POSITION[dbtype] - 2 << 2 : 0;
                this.ZIPCODE_POSITION_OFFSET = ZIPCODE_POSITION[dbtype] != 0 ? ZIPCODE_POSITION[dbtype] - 2 << 2 : 0;
                this.LATITUDE_POSITION_OFFSET = LATITUDE_POSITION[dbtype] != 0 ? LATITUDE_POSITION[dbtype] - 2 << 2 : 0;
                this.LONGITUDE_POSITION_OFFSET = LONGITUDE_POSITION[dbtype] != 0 ? LONGITUDE_POSITION[dbtype] - 2 << 2 : 0;
                this.TIMEZONE_POSITION_OFFSET = TIMEZONE_POSITION[dbtype] != 0 ? TIMEZONE_POSITION[dbtype] - 2 << 2 : 0;
                this.NETSPEED_POSITION_OFFSET = NETSPEED_POSITION[dbtype] != 0 ? NETSPEED_POSITION[dbtype] - 2 << 2 : 0;
                this.IDDCODE_POSITION_OFFSET = IDDCODE_POSITION[dbtype] != 0 ? IDDCODE_POSITION[dbtype] - 2 << 2 : 0;
                this.AREACODE_POSITION_OFFSET = AREACODE_POSITION[dbtype] != 0 ? AREACODE_POSITION[dbtype] - 2 << 2 : 0;
                this.WEATHERSTATIONCODE_POSITION_OFFSET = WEATHERSTATIONCODE_POSITION[dbtype] != 0 ? WEATHERSTATIONCODE_POSITION[dbtype] - 2 << 2 : 0;
                this.WEATHERSTATIONNAME_POSITION_OFFSET = WEATHERSTATIONNAME_POSITION[dbtype] != 0 ? WEATHERSTATIONNAME_POSITION[dbtype] - 2 << 2 : 0;
                this.MCC_POSITION_OFFSET = MCC_POSITION[dbtype] != 0 ? MCC_POSITION[dbtype] - 2 << 2 : 0;
                this.MNC_POSITION_OFFSET = MNC_POSITION[dbtype] != 0 ? MNC_POSITION[dbtype] - 2 << 2 : 0;
                this.MOBILEBRAND_POSITION_OFFSET = MOBILEBRAND_POSITION[dbtype] != 0 ? MOBILEBRAND_POSITION[dbtype] - 2 << 2 : 0;
                this.ELEVATION_POSITION_OFFSET = ELEVATION_POSITION[dbtype] != 0 ? ELEVATION_POSITION[dbtype] - 2 << 2 : 0;
                this.USAGETYPE_POSITION_OFFSET = USAGETYPE_POSITION[dbtype] != 0 ? USAGETYPE_POSITION[dbtype] - 2 << 2 : 0;
                this.COUNTRY_ENABLED = COUNTRY_POSITION[dbtype] != 0;
                this.REGION_ENABLED = REGION_POSITION[dbtype] != 0;
                this.CITY_ENABLED = CITY_POSITION[dbtype] != 0;
                this.ISP_ENABLED = ISP_POSITION[dbtype] != 0;
                this.LATITUDE_ENABLED = LATITUDE_POSITION[dbtype] != 0;
                this.LONGITUDE_ENABLED = LONGITUDE_POSITION[dbtype] != 0;
                this.DOMAIN_ENABLED = DOMAIN_POSITION[dbtype] != 0;
                this.ZIPCODE_ENABLED = ZIPCODE_POSITION[dbtype] != 0;
                this.TIMEZONE_ENABLED = TIMEZONE_POSITION[dbtype] != 0;
                this.NETSPEED_ENABLED = NETSPEED_POSITION[dbtype] != 0;
                this.IDDCODE_ENABLED = IDDCODE_POSITION[dbtype] != 0;
                this.AREACODE_ENABLED = AREACODE_POSITION[dbtype] != 0;
                this.WEATHERSTATIONCODE_ENABLED = WEATHERSTATIONCODE_POSITION[dbtype] != 0;
                this.WEATHERSTATIONNAME_ENABLED = WEATHERSTATIONNAME_POSITION[dbtype] != 0;
                this.MCC_ENABLED = MCC_POSITION[dbtype] != 0;
                this.MNC_ENABLED = MNC_POSITION[dbtype] != 0;
                this.MOBILEBRAND_ENABLED = MOBILEBRAND_POSITION[dbtype] != 0;
                this.ELEVATION_ENABLED = ELEVATION_POSITION[dbtype] != 0;
                boolean bl = this.USAGETYPE_ENABLED = USAGETYPE_POSITION[dbtype] != 0;
                if (this._MetaData.getIndexed()) {
                    int x;
                    MappedByteBuffer _IndexBuffer = inChannel.map(FileChannel.MapMode.READ_ONLY, this._MetaData.getIndexBaseAddr() - 1, this._MetaData.getBaseAddr() - this._MetaData.getIndexBaseAddr());
                    _IndexBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    int pointer = 0;
                    for (x = 0; x < this._IndexArrayIPv4.length; ++x) {
                        this._IndexArrayIPv4[x][0] = _IndexBuffer.getInt(pointer);
                        this._IndexArrayIPv4[x][1] = _IndexBuffer.getInt(pointer + 4);
                        pointer += 8;
                    }
                    if (this._MetaData.getIndexedIPv6()) {
                        for (x = 0; x < this._IndexArrayIPv6.length; ++x) {
                            this._IndexArrayIPv6[x][0] = _IndexBuffer.getInt(pointer);
                            this._IndexArrayIPv6[x][1] = _IndexBuffer.getInt(pointer + 4);
                            pointer += 8;
                        }
                    }
                }
                if (this.UseMemoryMappedFile) {
                    this.CreateMappedBytes(inChannel);
                } else {
                    this.DestroyMappedBytes();
                }
                loadOK = true;
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (aFile != null) {
                aFile.close();
                aFile = null;
            }
        }
        return loadOK;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public IPResult IPQuery(String IPAddress) throws IOException {
        IPAddress = IPAddress.trim();
        IPResult record = new IPResult(IPAddress);
        RandomAccessFile filehandle = null;
        ByteBuffer mybuffer = null;
        ByteBuffer mydatabuffer = null;
        try {
            BigInteger ipno;
            if (IPAddress == null || IPAddress.length() == 0) {
                record.status = "EMPTY_IP_ADDRESS";
                IPResult iPResult = record;
                return iPResult;
            }
            int indexaddr = 0;
            int actualiptype = 0;
            int myiptype = 0;
            boolean mydbtype = false;
            int mybaseaddr = 0;
            boolean mydbcolumn = false;
            int mycolumnsize = 0;
            int mybufcapacity = 0;
            BigInteger MAX_IP_RANGE = BigInteger.ZERO;
            long rowoffset = 0L;
            long rowoffset2 = 0L;
            boolean overcapacity = false;
            try {
                BigInteger[] bi = this.ip2no(IPAddress);
                myiptype = bi[0].intValue();
                ipno = bi[1];
                actualiptype = bi[2].intValue();
                if (actualiptype == 6) {
                    String[] retarr = this.ExpandIPv6(IPAddress, myiptype);
                    record.ip_address = retarr[0];
                    myiptype = Integer.parseInt(retarr[1]);
                }
            }
            catch (UnknownHostException e) {
                record.status = "INVALID_IP_ADDRESS";
                IPResult iPResult = record;
                if (filehandle != null) {
                    filehandle.close();
                    filehandle = null;
                }
                return iPResult;
            }
            long low = 0L;
            long high = 0L;
            long mid = 0L;
            long position = 0L;
            BigInteger ipfrom = BigInteger.ZERO;
            BigInteger ipto = BigInteger.ZERO;
            if (this._MetaData == null && !this.LoadBIN()) {
                record.status = "MISSING_FILE";
                IPResult iPResult = record;
                return iPResult;
            }
            if (this.UseMemoryMappedFile) {
                if (this._IPv4Buffer == null || !this._MetaData.getOldBIN() && this._IPv6Buffer == null || this._MapDataBuffer == null) {
                    this.CreateMappedBytes();
                }
            } else {
                this.DestroyMappedBytes();
                filehandle = new RandomAccessFile(this.IPDatabasePath, "r");
                if (filehandle == null) {
                    record.status = "MISSING_FILE";
                    IPResult iPResult = record;
                    return iPResult;
                }
            }
            if (myiptype == 4) {
                MAX_IP_RANGE = MAX_IPV4_RANGE;
                high = this._MetaData.getDBCount();
                if (this.UseMemoryMappedFile) {
                    mybuffer = this._IPv4Buffer.duplicate();
                    mybuffer.order(ByteOrder.LITTLE_ENDIAN);
                    mybufcapacity = mybuffer.capacity();
                } else {
                    mybaseaddr = this._MetaData.getBaseAddr();
                }
                mycolumnsize = this._IPv4ColumnSize;
                if (this._MetaData.getIndexed()) {
                    indexaddr = ipno.shiftRight(16).intValue();
                    low = this._IndexArrayIPv4[indexaddr][0];
                    high = this._IndexArrayIPv4[indexaddr][1];
                }
            } else {
                if (this._MetaData.getOldBIN()) {
                    record.status = "IPV6_NOT_SUPPORTED";
                    IPResult iPResult = record;
                    return iPResult;
                }
                MAX_IP_RANGE = MAX_IPV6_RANGE;
                high = this._MetaData.getDBCountIPv6();
                if (this.UseMemoryMappedFile) {
                    mybuffer = this._IPv6Buffer.duplicate();
                    mybuffer.order(ByteOrder.LITTLE_ENDIAN);
                    mybufcapacity = mybuffer.capacity();
                } else {
                    mybaseaddr = this._MetaData.getBaseAddrIPv6();
                }
                mycolumnsize = this._IPv6ColumnSize;
                if (this._MetaData.getIndexedIPv6()) {
                    indexaddr = ipno.shiftRight(112).intValue();
                    low = this._IndexArrayIPv6[indexaddr][0];
                    high = this._IndexArrayIPv6[indexaddr][1];
                }
            }
            if (ipno.compareTo(MAX_IP_RANGE) == 0) {
                ipno = ipno.subtract(BigInteger.ONE);
            }
            while (low <= high) {
                mid = (low + high) / 2L;
                rowoffset = (long)mybaseaddr + mid * (long)mycolumnsize;
                rowoffset2 = rowoffset + (long)mycolumnsize;
                if (this.UseMemoryMappedFile) {
                    overcapacity = rowoffset2 >= (long)mybufcapacity;
                }
                ipfrom = this.read32or128(rowoffset, myiptype, mybuffer, filehandle);
                BigInteger bigInteger = ipto = overcapacity ? BigInteger.ZERO : this.read32or128(rowoffset2, myiptype, mybuffer, filehandle);
                if (ipno.compareTo(ipfrom) >= 0 && ipno.compareTo(ipto) < 0) {
                    int firstcol = 4;
                    if (myiptype == 6) {
                        firstcol = 16;
                    }
                    int rowlen = mycolumnsize - firstcol;
                    byte[] row = this.readrow(rowoffset + (long)firstcol, rowlen, mybuffer, filehandle);
                    if (this.UseMemoryMappedFile) {
                        mydatabuffer = this._MapDataBuffer.duplicate();
                        mydatabuffer.order(ByteOrder.LITTLE_ENDIAN);
                    }
                    if (this.COUNTRY_ENABLED) {
                        position = this.read32_row(row, this.COUNTRY_POSITION_OFFSET).longValue();
                        record.country_short = this.readStr(position, mydatabuffer, filehandle);
                        record.country_long = this.readStr(position += 3L, mydatabuffer, filehandle);
                    } else {
                        record.country_short = "Not_Supported";
                        record.country_long = "Not_Supported";
                    }
                    if (this.REGION_ENABLED) {
                        position = this.read32_row(row, this.REGION_POSITION_OFFSET).longValue();
                        record.region = this.readStr(position, mydatabuffer, filehandle);
                    } else {
                        record.region = "Not_Supported";
                    }
                    if (this.CITY_ENABLED) {
                        position = this.read32_row(row, this.CITY_POSITION_OFFSET).longValue();
                        record.city = this.readStr(position, mydatabuffer, filehandle);
                    } else {
                        record.city = "Not_Supported";
                    }
                    if (this.ISP_ENABLED) {
                        position = this.read32_row(row, this.ISP_POSITION_OFFSET).longValue();
                        record.isp = this.readStr(position, mydatabuffer, filehandle);
                    } else {
                        record.isp = "Not_Supported";
                    }
                    record.latitude = this.LATITUDE_ENABLED ? Float.parseFloat(this.setDecimalPlaces(this.readFloat_row(row, this.LATITUDE_POSITION_OFFSET))) : 0.0f;
                    record.longitude = this.LONGITUDE_ENABLED ? Float.parseFloat(this.setDecimalPlaces(this.readFloat_row(row, this.LONGITUDE_POSITION_OFFSET))) : 0.0f;
                    if (this.DOMAIN_ENABLED) {
                        position = this.read32_row(row, this.DOMAIN_POSITION_OFFSET).longValue();
                        record.domain = this.readStr(position, mydatabuffer, filehandle);
                    } else {
                        record.domain = "Not_Supported";
                    }
                    if (this.ZIPCODE_ENABLED) {
                        position = this.read32_row(row, this.ZIPCODE_POSITION_OFFSET).longValue();
                        record.zipcode = this.readStr(position, mydatabuffer, filehandle);
                    } else {
                        record.zipcode = "Not_Supported";
                    }
                    if (this.TIMEZONE_ENABLED) {
                        position = this.read32_row(row, this.TIMEZONE_POSITION_OFFSET).longValue();
                        record.timezone = this.readStr(position, mydatabuffer, filehandle);
                    } else {
                        record.timezone = "Not_Supported";
                    }
                    if (this.NETSPEED_ENABLED) {
                        position = this.read32_row(row, this.NETSPEED_POSITION_OFFSET).longValue();
                        record.netspeed = this.readStr(position, mydatabuffer, filehandle);
                    } else {
                        record.netspeed = "Not_Supported";
                    }
                    if (this.IDDCODE_ENABLED) {
                        position = this.read32_row(row, this.IDDCODE_POSITION_OFFSET).longValue();
                        record.iddcode = this.readStr(position, mydatabuffer, filehandle);
                    } else {
                        record.iddcode = "Not_Supported";
                    }
                    if (this.AREACODE_ENABLED) {
                        position = this.read32_row(row, this.AREACODE_POSITION_OFFSET).longValue();
                        record.areacode = this.readStr(position, mydatabuffer, filehandle);
                    } else {
                        record.areacode = "Not_Supported";
                    }
                    if (this.WEATHERSTATIONCODE_ENABLED) {
                        position = this.read32_row(row, this.WEATHERSTATIONCODE_POSITION_OFFSET).longValue();
                        record.weatherstationcode = this.readStr(position, mydatabuffer, filehandle);
                    } else {
                        record.weatherstationcode = "Not_Supported";
                    }
                    if (this.WEATHERSTATIONNAME_ENABLED) {
                        position = this.read32_row(row, this.WEATHERSTATIONNAME_POSITION_OFFSET).longValue();
                        record.weatherstationname = this.readStr(position, mydatabuffer, filehandle);
                    } else {
                        record.weatherstationname = "Not_Supported";
                    }
                    if (this.MCC_ENABLED) {
                        position = this.read32_row(row, this.MCC_POSITION_OFFSET).longValue();
                        record.mcc = this.readStr(position, mydatabuffer, filehandle);
                    } else {
                        record.mcc = "Not_Supported";
                    }
                    if (this.MNC_ENABLED) {
                        position = this.read32_row(row, this.MNC_POSITION_OFFSET).longValue();
                        record.mnc = this.readStr(position, mydatabuffer, filehandle);
                    } else {
                        record.mnc = "Not_Supported";
                    }
                    if (this.MOBILEBRAND_ENABLED) {
                        position = this.read32_row(row, this.MOBILEBRAND_POSITION_OFFSET).longValue();
                        record.mobilebrand = this.readStr(position, mydatabuffer, filehandle);
                    } else {
                        record.mobilebrand = "Not_Supported";
                    }
                    if (this.ELEVATION_ENABLED) {
                        position = this.read32_row(row, this.ELEVATION_POSITION_OFFSET).longValue();
                        record.elevation = this.convertFloat(this.readStr(position, mydatabuffer, filehandle));
                    } else {
                        record.elevation = 0.0f;
                    }
                    if (this.USAGETYPE_ENABLED) {
                        position = this.read32_row(row, this.USAGETYPE_POSITION_OFFSET).longValue();
                        record.usagetype = this.readStr(position, mydatabuffer, filehandle);
                    } else {
                        record.usagetype = "Not_Supported";
                    }
                    record.status = "OK";
                    break;
                }
                if (ipno.compareTo(ipfrom) < 0) {
                    high = mid - 1L;
                    continue;
                }
                low = mid + 1L;
            }
            IPResult iPResult = record;
            return iPResult;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (filehandle != null) {
                filehandle.close();
                filehandle = null;
            }
        }
    }

    private String[] ExpandIPv6(String myIP, int myiptype) {
        Matcher mat;
        String tmp = "0000:0000:0000:0000:0000:";
        String padme = "0000";
        long hexoffset = 255L;
        String myIP2 = myIP.toUpperCase();
        String rettype = String.valueOf(myiptype);
        if (myiptype == 4) {
            if (pattern4.matcher(myIP2).matches()) {
                myIP2 = myIP2.replaceAll("::", "0000:0000:0000:0000:0000:");
            } else {
                mat = pattern5.matcher(myIP2);
                if (mat.matches()) {
                    String mymatch = mat.group(1);
                    String[] myarr = mymatch.replaceAll("^:+", "").replaceAll(":+$", "").split(":");
                    int len = myarr.length;
                    StringBuffer bf = new StringBuffer(32);
                    for (int x = 0; x < len; ++x) {
                        String unpadded = myarr[x];
                        bf.append("0000".substring(unpadded.length()) + unpadded);
                    }
                    long mylong = new BigInteger(bf.toString(), 16).longValue();
                    long[] b = new long[]{0L, 0L, 0L, 0L};
                    for (int x = 0; x < 4; ++x) {
                        b[x] = mylong & 0xFFL;
                        mylong >>= 8;
                    }
                    myIP2 = myIP2.replaceAll(mymatch + "$", ":" + b[3] + "." + b[2] + "." + b[1] + "." + b[0]);
                    myIP2 = myIP2.replaceAll("::", "0000:0000:0000:0000:0000:");
                }
            }
        } else if (myiptype == 6) {
            if (myIP2.equals("::")) {
                myIP2 = myIP2 + "0.0.0.0";
                myIP2 = myIP2.replaceAll("::", "0000:0000:0000:0000:0000:FFFF:");
                rettype = "4";
            } else {
                mat = pattern4.matcher(myIP2);
                if (mat.matches()) {
                    int totalsegmentsleft;
                    int x;
                    String v6part = mat.group(1);
                    String v4part = mat.group(2);
                    String[] v4arr = v4part.split("\\.");
                    int[] v4intarr = new int[4];
                    int len = v4intarr.length;
                    for (int x2 = 0; x2 < len; ++x2) {
                        v4intarr[x2] = Integer.parseInt(v4arr[x2]);
                    }
                    int part1 = (v4intarr[0] << 8) + v4intarr[1];
                    int part2 = (v4intarr[2] << 8) + v4intarr[3];
                    String part1hex = Integer.toHexString(part1);
                    String part2hex = Integer.toHexString(part2);
                    StringBuffer bf = new StringBuffer(v6part.length() + 9);
                    bf.append(v6part);
                    bf.append("0000".substring(part1hex.length()));
                    bf.append(part1hex);
                    bf.append(":");
                    bf.append("0000".substring(part2hex.length()));
                    bf.append(part2hex);
                    myIP2 = bf.toString().toUpperCase();
                    String[] myarr = myIP2.split("::");
                    String[] leftside = myarr[0].split(":");
                    StringBuffer bf2 = new StringBuffer(40);
                    StringBuffer bf3 = new StringBuffer(40);
                    StringBuffer bf4 = new StringBuffer(40);
                    len = leftside.length;
                    int totalsegments = 0;
                    for (int x3 = 0; x3 < len; ++x3) {
                        if (leftside[x3].length() <= 0) continue;
                        ++totalsegments;
                        bf2.append("0000".substring(leftside[x3].length()));
                        bf2.append(leftside[x3]);
                        bf2.append(":");
                    }
                    if (myarr.length > 1) {
                        String[] rightside = myarr[1].split(":");
                        len = rightside.length;
                        for (x = 0; x < len; ++x) {
                            if (rightside[x].length() <= 0) continue;
                            ++totalsegments;
                            bf3.append("0000".substring(rightside[x].length()));
                            bf3.append(rightside[x]);
                            bf3.append(":");
                        }
                    }
                    if ((totalsegmentsleft = 8 - totalsegments) == 6) {
                        for (x = 1; x < totalsegmentsleft; ++x) {
                            bf4.append("0000");
                            bf4.append(":");
                        }
                        bf4.append("FFFF:");
                        bf4.append(v4part);
                        rettype = "4";
                        myIP2 = bf4.toString();
                    } else {
                        for (x = 0; x < totalsegmentsleft; ++x) {
                            bf4.append("0000");
                            bf4.append(":");
                        }
                        bf2.append(bf4).append(bf3);
                        myIP2 = bf2.toString().replaceAll(":$", "");
                    }
                } else {
                    Matcher mat2 = pattern6.matcher(myIP2);
                    if (mat2.matches()) {
                        String mymatch = mat2.group(1);
                        String[] myarr = mymatch.replaceAll("^:+", "").replaceAll(":+$", "").split(":");
                        int len = myarr.length;
                        StringBuffer bf = new StringBuffer(32);
                        for (int x = 0; x < len; ++x) {
                            String unpadded = myarr[x];
                            bf.append("0000".substring(unpadded.length()) + unpadded);
                        }
                        long mylong = new BigInteger(bf.toString(), 16).longValue();
                        long[] b = new long[]{0L, 0L, 0L, 0L};
                        for (int x = 0; x < 4; ++x) {
                            b[x] = mylong & 0xFFL;
                            mylong >>= 8;
                        }
                        myIP2 = myIP2.replaceAll(mymatch + "$", ":" + b[3] + "." + b[2] + "." + b[1] + "." + b[0]);
                        myIP2 = myIP2.replaceAll("::", "0000:0000:0000:0000:0000:FFFF:");
                        rettype = "4";
                    } else {
                        int x;
                        String[] myarr = myIP2.split("::");
                        String[] leftside = myarr[0].split(":");
                        StringBuffer bf2 = new StringBuffer(40);
                        StringBuffer bf3 = new StringBuffer(40);
                        StringBuffer bf4 = new StringBuffer(40);
                        int len = leftside.length;
                        int totalsegments = 0;
                        for (int x4 = 0; x4 < len; ++x4) {
                            if (leftside[x4].length() <= 0) continue;
                            ++totalsegments;
                            bf2.append("0000".substring(leftside[x4].length()));
                            bf2.append(leftside[x4]);
                            bf2.append(":");
                        }
                        if (myarr.length > 1) {
                            String[] rightside = myarr[1].split(":");
                            len = rightside.length;
                            for (x = 0; x < len; ++x) {
                                if (rightside[x].length() <= 0) continue;
                                ++totalsegments;
                                bf3.append("0000".substring(rightside[x].length()));
                                bf3.append(rightside[x]);
                                bf3.append(":");
                            }
                        }
                        int totalsegmentsleft = 8 - totalsegments;
                        for (x = 0; x < totalsegmentsleft; ++x) {
                            bf4.append("0000");
                            bf4.append(":");
                        }
                        bf2.append(bf4).append(bf3);
                        myIP2 = bf2.toString().replaceAll(":$", "");
                    }
                }
            }
        }
        String[] retarr = new String[]{myIP2, rettype};
        return retarr;
    }

    private float convertFloat(String mystr) {
        try {
            return Float.parseFloat(mystr);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    private void reverse(byte[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    private byte[] readrow(long position, long mylen, ByteBuffer mybuffer, RandomAccessFile filehandle) throws IOException {
        byte[] row = new byte[(int)mylen];
        if (this.UseMemoryMappedFile) {
            mybuffer.position((int)position);
            mybuffer.get(row, 0, (int)mylen);
        } else {
            filehandle.seek(position - 1L);
            filehandle.read(row, 0, (int)mylen);
        }
        return row;
    }

    private BigInteger read32or128(long position, int myiptype, ByteBuffer mybuffer, RandomAccessFile filehandle) throws IOException {
        if (myiptype == 4) {
            return this.read32(position, mybuffer, filehandle);
        }
        if (myiptype == 6) {
            return this.read128(position, mybuffer, filehandle);
        }
        return BigInteger.ZERO;
    }

    private BigInteger read128(long position, ByteBuffer mybuffer, RandomAccessFile filehandle) throws IOException {
        BigInteger retval = BigInteger.ZERO;
        int bsize = 16;
        byte[] buf = new byte[16];
        if (this.UseMemoryMappedFile) {
            mybuffer.position((int)position);
            mybuffer.get(buf, 0, 16);
        } else {
            filehandle.seek(position - 1L);
            filehandle.read(buf, 0, 16);
        }
        this.reverse(buf);
        retval = new BigInteger(1, buf);
        return retval;
    }

    private BigInteger read32_row(byte[] row, int from) throws IOException {
        int len = 4;
        byte[] buf = new byte[4];
        System.arraycopy(row, from, buf, 0, 4);
        this.reverse(buf);
        return new BigInteger(1, buf);
    }

    private BigInteger read32(long position, ByteBuffer mybuffer, RandomAccessFile filehandle) throws IOException {
        if (this.UseMemoryMappedFile) {
            return BigInteger.valueOf((long)mybuffer.getInt((int)position) & 0xFFFFFFFFL);
        }
        int bsize = 4;
        filehandle.seek(position - 1L);
        byte[] buf = new byte[4];
        filehandle.read(buf, 0, 4);
        this.reverse(buf);
        return new BigInteger(1, buf);
    }

    private String readStr(long position, ByteBuffer mydatabuffer, RandomAccessFile filehandle) throws IOException {
        byte[] buf = null;
        if (this.UseMemoryMappedFile) {
            byte size = this._MapDataBuffer.get((int)(position -= this._MapDataOffset));
            try {
                buf = new byte[size];
                mydatabuffer.position((int)position + 1);
                mydatabuffer.get(buf, 0, size);
            }
            catch (NegativeArraySizeException e) {
                return null;
            }
        }
        filehandle.seek(position);
        int size = filehandle.read();
        try {
            buf = new byte[size];
            filehandle.read(buf, 0, size);
        }
        catch (NegativeArraySizeException e) {
            return null;
        }
        String s = new String(buf);
        return s;
    }

    private float readFloat_row(byte[] row, int from) {
        int len = 4;
        byte[] buf = new byte[4];
        System.arraycopy(row, from, buf, 0, 4);
        return Float.intBitsToFloat((buf[3] & 0xFF) << 24 | (buf[2] & 0xFF) << 16 | (buf[1] & 0xFF) << 8 | buf[0] & 0xFF);
    }

    private float readFloat(long position, MappedByteBuffer mybuffer, RandomAccessFile filehandle) throws IOException {
        if (this.UseMemoryMappedFile) {
            return mybuffer.getFloat((int)position);
        }
        int bsize = 4;
        filehandle.seek(position - 1L);
        int[] ptr = new int[4];
        for (int x = 0; x < 4; ++x) {
            ptr[x] = filehandle.read();
        }
        return Float.intBitsToFloat(ptr[3] << 24 | ptr[2] << 16 | ptr[1] << 8 | ptr[0]);
    }

    private String setDecimalPlaces(float myfloat) {
        Locale currentLocale = Locale.getDefault();
        NumberFormat nf = NumberFormat.getNumberInstance(currentLocale);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern("###.######");
        String fstr = df.format(myfloat).replace(',', '.');
        return fstr;
    }

    private BigInteger[] ip2no(String ipstring) throws UnknownHostException {
        BigInteger a1 = BigInteger.ZERO;
        BigInteger a2 = BigInteger.ZERO;
        BigInteger a3 = new BigInteger("4");
        if (pattern.matcher(ipstring).matches()) {
            a1 = new BigInteger("4");
            a2 = new BigInteger(String.valueOf(this.ipv4no(ipstring)));
        } else {
            if (pattern2.matcher(ipstring).matches() || pattern3.matcher(ipstring).matches()) {
                throw new UnknownHostException();
            }
            a3 = new BigInteger("6");
            InetAddress ia = InetAddress.getByName(ipstring);
            byte[] byteArr = ia.getAddress();
            String myiptype = "0";
            if (ia instanceof Inet6Address) {
                myiptype = "6";
            } else if (ia instanceof Inet4Address) {
                myiptype = "4";
            }
            a2 = new BigInteger(1, byteArr);
            if (a2.compareTo(FROM_6TO4) >= 0 && a2.compareTo(TO_6TO4) <= 0) {
                myiptype = "4";
                a2 = a2.shiftRight(80);
                a2 = a2.and(LAST_32BITS);
                a3 = new BigInteger("4");
            } else if (a2.compareTo(FROM_TEREDO) >= 0 && a2.compareTo(TO_TEREDO) <= 0) {
                myiptype = "4";
                a2 = a2.not();
                a2 = a2.and(LAST_32BITS);
                a3 = new BigInteger("4");
            }
            a1 = new BigInteger(myiptype);
        }
        BigInteger[] bi = new BigInteger[]{a1, a2, a3};
        return bi;
    }

    private long ipv4no(String ipstring) {
        String[] ipAddressInArray = ipstring.split("\\.");
        long result = 0L;
        long ip = 0L;
        for (int x = 3; x >= 0; --x) {
            ip = Long.parseLong(ipAddressInArray[3 - x]);
            result |= ip << (x << 3);
        }
        return result;
    }
}

