/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.renderer;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.PdfTextFormField;
import com.itextpdf.forms.fields.TextFormFieldBuilder;
import com.itextpdf.forms.form.element.InputField;
import com.itextpdf.forms.form.renderer.AbstractOneLineTextFieldRenderer;
import com.itextpdf.forms.form.renderer.FormFieldValueNonTrimmingTextRenderer;
import com.itextpdf.forms.util.FormFieldRendererUtil;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.properties.BoxSizingPropertyValue;
import com.itextpdf.layout.properties.TextAlignment;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import com.itextpdf.layout.tagging.IAccessibleElement;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputFieldRenderer
extends AbstractOneLineTextFieldRenderer {
    private static final float DEFAULT_COMB_PADDING = 0.0f;

    public InputFieldRenderer(InputField modelElement) {
        super(modelElement);
    }

    public IRenderer getNextRenderer() {
        return new InputFieldRenderer((InputField)this.modelElement);
    }

    public int getSize() {
        Integer size = this.getPropertyAsInteger(0x200002);
        return size == null ? ((Integer)this.modelElement.getDefaultProperty(0x200002)).intValue() : size.intValue();
    }

    public boolean isPassword() {
        Boolean password = this.getPropertyAsBoolean(0x200004);
        return password == null ? ((Boolean)this.modelElement.getDefaultProperty(0x200004)).booleanValue() : password.booleanValue();
    }

    @Override
    IRenderer createParagraphRenderer(String defaultValue) {
        IRenderer flatRenderer;
        if (defaultValue.isEmpty() && null != ((InputField)this.modelElement).getPlaceholder() && !((InputField)this.modelElement).getPlaceholder().isEmpty()) {
            return ((InputField)this.modelElement).getPlaceholder().createRendererSubTree();
        }
        if (defaultValue.isEmpty()) {
            defaultValue = "\u00a0";
        }
        if (this.isComb()) {
            int i;
            int start;
            this.setProperty(48, UnitValue.createPointValue((float)0.0f));
            this.setProperty(49, UnitValue.createPointValue((float)0.0f));
            int maxLen = this.getMaxLen();
            int numberOfCharacters = Math.min(maxLen, defaultValue.length());
            TextAlignment textAlignment = (TextAlignment)this.getProperty(70, TextAlignment.LEFT);
            switch (textAlignment) {
                case RIGHT: {
                    start = maxLen - numberOfCharacters;
                    break;
                }
                case CENTER: {
                    start = (maxLen - numberOfCharacters) / 2;
                    break;
                }
                default: {
                    start = 0;
                }
            }
            Paragraph paragraph = new Paragraph();
            for (i = 0; i < start; ++i) {
                paragraph.add((IBlockElement)InputFieldRenderer.getSubParagraph("", maxLen));
            }
            for (i = 0; i < numberOfCharacters; ++i) {
                paragraph.add((IBlockElement)InputFieldRenderer.getSubParagraph(defaultValue.substring(i, i + 1), maxLen));
            }
            for (i = start + numberOfCharacters; i < maxLen; ++i) {
                paragraph.add((IBlockElement)InputFieldRenderer.getSubParagraph("", maxLen));
            }
            flatRenderer = ((Paragraph)paragraph.setMargin(0.0f)).createRendererSubTree();
        } else {
            Text text = new Text(defaultValue);
            FormFieldValueNonTrimmingTextRenderer nextRenderer = new FormFieldValueNonTrimmingTextRenderer(text);
            text.setNextRenderer((IRenderer)nextRenderer);
            flatRenderer = ((Paragraph)new Paragraph(text).setMargin(0.0f)).createRendererSubTree();
        }
        flatRenderer.setProperty(118, (Object)true);
        if (flatRenderer.getModelElement() instanceof IAccessibleElement) {
            ((IAccessibleElement)flatRenderer.getModelElement()).getAccessibilityProperties().setRole("Lbl");
        }
        return flatRenderer;
    }

    @Override
    protected void adjustFieldLayout(LayoutContext layoutContext) {
        List flatLines = ((ParagraphRenderer)this.flatRenderer).getLines();
        Rectangle flatBBox = this.flatRenderer.getOccupiedArea().getBBox();
        this.updatePdfFont((ParagraphRenderer)this.flatRenderer);
        if (flatLines.isEmpty() || this.font == null) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(MessageFormatUtil.format((String)"Error during layout of form field with type {0}.", (Object[])new Object[]{"text input"}));
            this.setProperty(0x200001, true);
            flatBBox.setY(flatBBox.getTop()).setHeight(0.0f);
        } else {
            this.cropContentLines(flatLines, flatBBox);
        }
        flatBBox.setWidth(this.retrieveWidth(layoutContext.getArea().getBBox().getWidth()).floatValue());
    }

    @Override
    protected IRenderer createFlatRenderer() {
        String defaultValue = this.getDefaultValue();
        boolean flatten = this.isFlatten();
        boolean password = this.isPassword();
        if (flatten && password) {
            defaultValue = this.obfuscatePassword(defaultValue);
        }
        return this.createParagraphRenderer(defaultValue);
    }

    @Override
    protected void applyAcroField(DrawContext drawContext) {
        int rotation;
        this.font.setSubset(false);
        boolean password = this.isPassword();
        String value = password ? "" : this.getDefaultValue();
        String name = this.getModelId();
        UnitValue fontSize = this.getPropertyAsUnitValue(24);
        if (!fontSize.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(InputFieldRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
        }
        PdfDocument doc = drawContext.getDocument();
        Rectangle area = this.getOccupiedArea().getBBox().clone();
        this.applyMargins(area, false);
        Map<Integer, Object> properties = FormFieldRendererUtil.removeProperties(this.modelElement);
        PdfPage page = doc.getPage(this.occupiedArea.getPageNumber());
        float fontSizeValue = fontSize.getValue();
        this.modelElement.setProperty(91, this.getProperty(91));
        this.modelElement.setProperty(123, this.getProperty(123));
        this.modelElement.setProperty(105, (Object)BoxSizingPropertyValue.BORDER_BOX);
        PdfTextFormField inputField = ((TextFormFieldBuilder)((TextFormFieldBuilder)((TextFormFieldBuilder)new TextFormFieldBuilder(doc, name).setWidgetRectangle(area)).setFont(this.font)).setConformance(this.getConformance(doc))).createText();
        inputField.disableFieldRegeneration();
        inputField.setValue(value);
        inputField.setFontSize(fontSizeValue);
        if (password) {
            inputField.setPassword(true);
        } else {
            inputField.setDefaultValue((PdfObject)new PdfString(value));
        }
        if (this.isComb()) {
            inputField.setComb(true);
            inputField.setMaxLen(this.getMaxLen());
        }
        if ((rotation = ((InputField)this.modelElement).getRotation()) != 0) {
            inputField.getFirstFormAnnotation().setRotation(rotation);
        }
        this.applyDefaultFieldProperties(inputField);
        this.applyAccessibilityProperties(inputField, doc);
        inputField.getFirstFormAnnotation().setFormFieldElement((InputField)this.modelElement);
        inputField.enableFieldRegeneration();
        PdfFormCreator.getAcroForm(doc, true).addField(inputField, page);
        FormFieldRendererUtil.reapplyProperties(this.modelElement, properties);
    }

    public <T1> T1 getProperty(int key) {
        if (key == 77) {
            Object width = super.getProperty(77);
            if (width == null) {
                UnitValue fontSize = this.getPropertyAsUnitValue(24);
                if (!fontSize.isPointValue()) {
                    Logger logger = LoggerFactory.getLogger(InputFieldRenderer.class);
                    logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
                }
                int size = this.getSize();
                return (T1)UnitValue.createPointValue((float)this.updateHtmlColsSizeBasedWidth(fontSize.getValue() * ((float)size * 0.5f + 2.0f) + 2.0f));
            }
            return (T1)width;
        }
        return (T1)super.getProperty(key);
    }

    protected boolean setMinMaxWidthBasedOnFixedWidth(MinMaxWidth minMaxWidth) {
        boolean result = false;
        if (this.hasRelativeUnitValue(77)) {
            UnitValue widthUV = (UnitValue)this.getProperty(77);
            boolean restoreWidth = this.hasOwnProperty(77);
            this.setProperty(77, null);
            Float width = this.retrieveWidth(0.0f);
            if (width != null) {
                minMaxWidth.setChildrenMaxWidth(width.floatValue());
                result = true;
            }
            if (restoreWidth) {
                this.setProperty(77, widthUV);
            } else {
                this.deleteOwnProperty(77);
            }
        } else {
            result = super.setMinMaxWidthBasedOnFixedWidth(minMaxWidth);
        }
        return result;
    }

    private static Paragraph getSubParagraph(String value, int maxLen) {
        Text text = new Text(value);
        FormFieldValueNonTrimmingTextRenderer nextRenderer = new FormFieldValueNonTrimmingTextRenderer(text);
        text.setNextRenderer((IRenderer)nextRenderer);
        return (Paragraph)((Paragraph)((Paragraph)((Paragraph)new Paragraph(text).setTextAlignment(TextAlignment.CENTER)).setWidth(UnitValue.createPercentValue((float)(100.0f / (float)maxLen)))).setHeight(UnitValue.createPercentValue((float)100.0f))).setMargin(0.0f);
    }

    private boolean isComb() {
        return (Boolean)this.getProperty(0x200011, false);
    }

    private int getMaxLen() {
        return (Integer)this.getProperty(0x200012, 0);
    }

    private String obfuscatePassword(String text) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            builder.append('*');
        }
        return builder.toString();
    }
}

