/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.DisplayTableRowTagWorker;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.attach.impl.tags.SpanTagWorker;
import com.itextpdf.html2pdf.attach.util.WaitingInlineElementsHelper;
import com.itextpdf.html2pdf.attach.wrapelement.TableRowWrapper;
import com.itextpdf.html2pdf.attach.wrapelement.TableWrapper;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.ILeafElement;

public class DisplayTableTagWorker
implements ITagWorker {
    private IPropertyContainer table;
    private TableWrapper tableWrapper = new TableWrapper();
    private WaitingInlineElementsHelper inlineHelper;
    private Cell waitingCell = null;
    private boolean currentRowIsFinished = false;

    public DisplayTableTagWorker(IElementNode element, ProcessorContext context) {
        this.inlineHelper = new WaitingInlineElementsHelper(element.getStyles().get("white-space"), element.getStyles().get("text-transform"));
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        this.flushWaitingCell();
        this.table = this.tableWrapper.toTable(null);
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        this.inlineHelper.add(content);
        return true;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        boolean displayTableCell;
        boolean bl = displayTableCell = childTagWorker instanceof IDisplayAware && "table-cell".equals(((IDisplayAware)((Object)childTagWorker)).getDisplay());
        if (this.currentRowIsFinished) {
            this.tableWrapper.newRow();
        }
        if (childTagWorker instanceof DisplayTableRowTagWorker) {
            this.flushWaitingCell();
            if (!this.currentRowIsFinished) {
                this.tableWrapper.newRow();
            }
            TableRowWrapper wrapper = ((DisplayTableRowTagWorker)childTagWorker).getTableRowWrapper();
            for (Cell cell : wrapper.getCells()) {
                this.tableWrapper.addCell(cell);
            }
            this.currentRowIsFinished = true;
            return true;
        }
        if (childTagWorker.getElementResult() instanceof IBlockElement) {
            IBlockElement childResult = (IBlockElement)childTagWorker.getElementResult();
            Cell curCell = childResult instanceof Cell ? (Cell)childResult : this.createWrapperCell().add(childResult);
            this.processCell(curCell, displayTableCell);
            this.currentRowIsFinished = false;
            return true;
        }
        if (childTagWorker.getElementResult() instanceof ILeafElement) {
            this.inlineHelper.add((ILeafElement)childTagWorker.getElementResult());
            this.currentRowIsFinished = false;
            return true;
        }
        if (childTagWorker instanceof SpanTagWorker) {
            if (displayTableCell) {
                this.flushWaitingCell();
            }
            boolean allChildrenProcessed = true;
            for (IPropertyContainer propertyContainer : ((SpanTagWorker)childTagWorker).getAllElements()) {
                if (propertyContainer instanceof ILeafElement) {
                    this.inlineHelper.add((ILeafElement)propertyContainer);
                    continue;
                }
                allChildrenProcessed = false;
            }
            if (displayTableCell) {
                this.flushWaitingCell();
            }
            this.currentRowIsFinished = false;
            return allChildrenProcessed;
        }
        return false;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.table;
    }

    private void processCell(Cell cell, boolean displayTableCell) {
        if (displayTableCell) {
            if (this.waitingCell != cell) {
                this.flushWaitingCell();
                this.tableWrapper.addCell(cell);
            } else if (!cell.isEmpty()) {
                this.tableWrapper.addCell(cell);
                this.waitingCell = null;
            }
        } else {
            this.flushInlineElementsToWaitingCell();
            this.waitingCell.add((IBlockElement)cell);
        }
    }

    private void flushInlineElementsToWaitingCell() {
        if (null == this.waitingCell) {
            this.waitingCell = this.createWrapperCell();
        }
        this.inlineHelper.flushHangingLeaves((IPropertyContainer)this.waitingCell);
    }

    private void flushWaitingCell() {
        this.flushInlineElementsToWaitingCell();
        if (null != this.waitingCell) {
            this.processCell(this.waitingCell, true);
        }
    }

    private Cell createWrapperCell() {
        return (Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setPadding(0.0f);
    }
}

