/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Image;

public class ImgTagWorker
implements ITagWorker {
    private HtmlImage image;
    private String display;

    public ImgTagWorker(IElementNode element, ProcessorContext context) {
        PdfImageXObject imageXObject = context.getResourceResolver().retrieveImage(element.getAttribute("src"));
        if (imageXObject != null) {
            this.image = new HtmlImage(imageXObject);
            String altText = element.getAttribute("alt");
            if (altText != null) {
                this.image.setAltText(altText);
            }
        }
        String string = this.display = element.getStyles() != null ? element.getStyles().get("display") : null;
        if (element.getStyles() != null && "absolute".equals(element.getStyles().get("position"))) {
            this.display = "block";
        }
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        return false;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        return false;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.image;
    }

    String getDisplay() {
        return this.display;
    }

    private class HtmlImage
    extends Image {
        private double pxToPt;

        public HtmlImage(PdfImageXObject xObject) {
            super(xObject);
            this.pxToPt = 0.75;
        }

        public float getImageWidth() {
            return (float)((double)this.xObject.getWidth() * this.pxToPt);
        }

        public float getImageHeight() {
            return (float)((double)this.xObject.getHeight() * this.pxToPt);
        }

        void setAltText(String altText) {
            this.getAccessibilityProperties().setAlternateDescription(altText);
        }
    }
}

