/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.css.CssConstants;
import com.itextpdf.html2pdf.css.util.CssUtils;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.html2pdf.html.node.IStylesContainer;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.color.ColorConstants;
import com.itextpdf.kernel.color.DeviceRgb;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.property.BaseDirection;
import com.itextpdf.layout.property.HorizontalAlignment;
import com.itextpdf.layout.property.Leading;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.layout.property.TransparentColor;
import com.itextpdf.layout.property.Underline;
import com.itextpdf.layout.property.UnitValue;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FontStyleApplierUtil {
    private static final Logger logger = LoggerFactory.getLogger(FontStyleApplierUtil.class);

    private FontStyleApplierUtil() {
    }

    public static void applyFontStyles(Map<String, String> cssProps, ProcessorContext context, IStylesContainer stylesContainer, IPropertyContainer element) {
        String lineHeight;
        UnitValue wordSpacingValue;
        String wordSpacing;
        UnitValue letterSpacingValue;
        String letterSpacing;
        UnitValue textIndentValue;
        String textIndent;
        String align;
        String direction;
        String cssColorPropValue;
        float em = CssUtils.parseAbsoluteLength(cssProps.get("font-size"));
        float rem = context.getCssContext().getRootFontSize();
        if (em != 0.0f) {
            element.setProperty(24, (Object)Float.valueOf(em));
        }
        if (cssProps.get("font-family") != null) {
            element.setProperty(20, (Object)cssProps.get("font-family"));
        }
        if (cssProps.get("font-weight") != null) {
            element.setProperty(95, (Object)cssProps.get("font-weight"));
        }
        if (cssProps.get("font-style") != null) {
            element.setProperty(94, (Object)cssProps.get("font-style"));
        }
        if ((cssColorPropValue = cssProps.get("color")) != null) {
            TransparentColor transparentColor;
            if (!"transparent".equals(cssColorPropValue)) {
                float[] rgbaColor = CssUtils.parseRgbaColor(cssColorPropValue);
                DeviceRgb color = new DeviceRgb(rgbaColor[0], rgbaColor[1], rgbaColor[2]);
                float opacity = rgbaColor[3];
                transparentColor = new TransparentColor((Color)color, opacity);
            } else {
                transparentColor = new TransparentColor(ColorConstants.BLACK, 0.0f);
            }
            element.setProperty(21, (Object)transparentColor);
        }
        if ("rtl".equals(direction = cssProps.get("direction"))) {
            element.setProperty(7, (Object)BaseDirection.RIGHT_TO_LEFT);
            element.setProperty(70, (Object)TextAlignment.RIGHT);
        } else if ("ltr".equals(direction)) {
            element.setProperty(7, (Object)BaseDirection.LEFT_TO_RIGHT);
            element.setProperty(70, (Object)TextAlignment.LEFT);
        }
        if (stylesContainer instanceof IElementNode && ((IElementNode)stylesContainer).parentNode() instanceof IElementNode && "rtl".equals(((IElementNode)((IElementNode)stylesContainer).parentNode()).getStyles().get("direction"))) {
            element.setProperty(28, (Object)HorizontalAlignment.RIGHT);
        }
        if ("left".equals(align = cssProps.get("text-align"))) {
            element.setProperty(70, (Object)TextAlignment.LEFT);
        } else if ("right".equals(align)) {
            element.setProperty(70, (Object)TextAlignment.RIGHT);
        } else if ("center".equals(align)) {
            element.setProperty(70, (Object)TextAlignment.CENTER);
        } else if ("justify".equals(align)) {
            element.setProperty(70, (Object)TextAlignment.JUSTIFIED);
            element.setProperty(61, (Object)Float.valueOf(1.0f));
        }
        String textDecorationProp = cssProps.get("text-decoration");
        if (textDecorationProp != null) {
            String[] textDecorations = textDecorationProp.split("\\s+");
            ArrayList<Underline> underlineList = new ArrayList<Underline>();
            for (String textDecoration : textDecorations) {
                if ("blink".equals(textDecoration)) {
                    logger.error("text-decoration: blink not supported");
                    continue;
                }
                if ("line-through".equals(textDecoration)) {
                    underlineList.add(new Underline(null, 0.75f, 0.0f, 0.0f, 0.25f, 0));
                    continue;
                }
                if ("overline".equals(textDecoration)) {
                    underlineList.add(new Underline(null, 0.75f, 0.0f, 0.0f, 0.9f, 0));
                    continue;
                }
                if ("underline".equals(textDecoration)) {
                    underlineList.add(new Underline(null, 0.75f, 0.0f, 0.0f, -0.1f, 0));
                    continue;
                }
                if (!"none".equals(textDecoration)) continue;
                underlineList = null;
                break;
            }
            element.setProperty(74, underlineList);
        }
        if ((textIndent = cssProps.get("text-indent")) != null && (textIndentValue = CssUtils.parseLengthValueToPt(textIndent, em, rem)) != null) {
            if (textIndentValue.isPointValue()) {
                element.setProperty(18, (Object)Float.valueOf(textIndentValue.getValue()));
            } else {
                logger.error(MessageFormatUtil.format((String)"Css property {0} in percents is not supported", (Object[])new Object[]{"text-indent"}));
            }
        }
        if ((letterSpacing = cssProps.get("letter-spacing")) != null && !letterSpacing.equals("normal") && (letterSpacingValue = CssUtils.parseLengthValueToPt(letterSpacing, em, rem)).isPointValue()) {
            element.setProperty(15, (Object)Float.valueOf(letterSpacingValue.getValue()));
        }
        if ((wordSpacing = cssProps.get("word-spacing")) != null && (wordSpacingValue = CssUtils.parseLengthValueToPt(wordSpacing, em, rem)) != null && wordSpacingValue.isPointValue()) {
            element.setProperty(78, (Object)Float.valueOf(wordSpacingValue.getValue()));
        }
        if ((lineHeight = cssProps.get("line-height")) != null && !"normal".equals(lineHeight)) {
            if (CssUtils.isNumericValue(lineHeight)) {
                Float mult = CssUtils.parseFloat(lineHeight);
                if (mult != null) {
                    element.setProperty(33, (Object)new Leading(2, mult.floatValue()));
                }
            } else {
                UnitValue lineHeightValue = CssUtils.parseLengthValueToPt(lineHeight, em, rem);
                if (lineHeightValue != null && lineHeightValue.isPointValue()) {
                    element.setProperty(33, (Object)new Leading(1, lineHeightValue.getValue()));
                } else if (lineHeightValue != null) {
                    element.setProperty(33, (Object)new Leading(2, lineHeightValue.getValue() / 100.0f));
                }
            }
        } else {
            element.setProperty(33, (Object)new Leading(2, 1.2f));
        }
    }

    public static float parseAbsoluteFontSize(String fontSizeValue) {
        if (CssConstants.FONT_ABSOLUTE_SIZE_KEYWORDS.contains(fontSizeValue)) {
            switch (fontSizeValue) {
                case "xx-small": {
                    fontSizeValue = "9px";
                    break;
                }
                case "x-small": {
                    fontSizeValue = "10px";
                    break;
                }
                case "small": {
                    fontSizeValue = "13px";
                    break;
                }
                case "medium": {
                    fontSizeValue = "16px";
                    break;
                }
                case "large": {
                    fontSizeValue = "18px";
                    break;
                }
                case "x-large": {
                    fontSizeValue = "24px";
                    break;
                }
                case "xx-large": {
                    fontSizeValue = "32px";
                    break;
                }
                default: {
                    fontSizeValue = "16px";
                }
            }
        }
        return CssUtils.parseAbsoluteLength(fontSizeValue);
    }

    public static float parseRelativeFontSize(String relativeFontSizeValue, float baseValue) {
        if ("smaller".equals(relativeFontSizeValue)) {
            return (float)((double)baseValue / 1.2);
        }
        if ("larger".equals(relativeFontSizeValue)) {
            return (float)((double)baseValue * 1.2);
        }
        return CssUtils.parseRelativeValue(relativeFontSizeValue, baseValue);
    }
}

