/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.parse;

import com.itextpdf.html2pdf.PortUtil;
import com.itextpdf.html2pdf.css.CssStyleSheet;
import com.itextpdf.html2pdf.css.parse.syntax.CssParserStateController;
import com.itextpdf.kernel.Version;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;

public final class CssStyleSheetParser {
    private CssStyleSheetParser() {
    }

    public static CssStyleSheet parse(InputStream stream, String baseUrl) throws IOException {
        int length;
        block4: {
            String licenseKeyClassName = "com.itextpdf.licensekey.LicenseKey";
            String licenseKeyProductClassName = "com.itextpdf.licensekey.LicenseKeyProduct";
            String licenseKeyFeatureClassName = "com.itextpdf.licensekey.LicenseKeyProductFeature";
            String checkLicenseKeyMethodName = "scheduledCheck";
            try {
                Class<?> licenseKeyClass = Class.forName(licenseKeyClassName);
                Class<?> licenseKeyProductClass = Class.forName(licenseKeyProductClassName);
                Class<?> licenseKeyProductFeatureClass = Class.forName(licenseKeyFeatureClassName);
                Object licenseKeyProductFeatureArray = Array.newInstance(licenseKeyProductFeatureClass, 0);
                Class[] params = new Class[]{String.class, Integer.TYPE, Integer.TYPE, licenseKeyProductFeatureArray.getClass()};
                Constructor<?> licenseKeyProductConstructor = licenseKeyProductClass.getConstructor(params);
                Object licenseKeyProductObject = licenseKeyProductConstructor.newInstance("pdfHtml", 1, 0, licenseKeyProductFeatureArray);
                Method method = licenseKeyClass.getMethod(checkLicenseKeyMethodName, licenseKeyProductClass);
                method.invoke(null, licenseKeyProductObject);
            }
            catch (Exception e) {
                if (Version.isAGPLVersion()) break block4;
                throw new RuntimeException(e.getCause());
            }
        }
        CssParserStateController controller = new CssParserStateController(baseUrl);
        Reader br = PortUtil.wrapInBufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        char[] buffer = new char[8192];
        while ((length = br.read(buffer, 0, buffer.length)) > 0) {
            for (int i = 0; i < length; ++i) {
                controller.process(buffer[i]);
            }
        }
        return controller.getParsingResult();
    }

    public static CssStyleSheet parse(InputStream stream) throws IOException {
        return CssStyleSheetParser.parse(stream, null);
    }

    public static CssStyleSheet parse(String data, String baseUrl) {
        ByteArrayInputStream stream = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
        try {
            return CssStyleSheetParser.parse(stream, baseUrl);
        }
        catch (IOException exc) {
            return null;
        }
    }

    public static CssStyleSheet parse(String data) {
        return CssStyleSheetParser.parse(data, null);
    }
}

