/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ITagWorkerFactory;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.DefaultTagWorkerMapping;
import com.itextpdf.html2pdf.exception.TagWorkerInitializationException;
import com.itextpdf.html2pdf.util.TagProcessorMapping;
import com.itextpdf.styledxmlparser.node.IElementNode;
import java.lang.reflect.Constructor;

public class DefaultTagWorkerFactory
implements ITagWorkerFactory {
    private static final ITagWorkerFactory INSTANCE = new DefaultTagWorkerFactory();
    private TagProcessorMapping defaultMapping = DefaultTagWorkerMapping.getDefaultTagWorkerMapping();

    public static ITagWorkerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public final ITagWorker getTagWorker(IElementNode tag, ProcessorContext context) {
        ITagWorker tagWorker = this.getCustomTagWorker(tag, context);
        if (tagWorker == null) {
            Class<?> tagWorkerClass = this.getTagWorkerClass(this.defaultMapping, tag);
            if (tagWorkerClass == null) {
                return null;
            }
            try {
                Constructor<?> ctor = tagWorkerClass.getDeclaredConstructor(IElementNode.class, ProcessorContext.class);
                ITagWorker res = (ITagWorker)ctor.newInstance(tag, context);
                return res;
            }
            catch (Exception e) {
                throw new TagWorkerInitializationException("Could not instantiate TagWorker-class {0} for tag {1}.", tagWorkerClass.getName(), tag.name(), e);
            }
        }
        return tagWorker;
    }

    private Class<?> getTagWorkerClass(TagProcessorMapping mapping, IElementNode tag) {
        String display;
        Class<?> tagWorkerClass = null;
        String string = display = tag.getStyles() != null ? (String)tag.getStyles().get("display") : null;
        if (display != null) {
            tagWorkerClass = mapping.getMapping(tag.name(), display);
        }
        if (tagWorkerClass == null) {
            tagWorkerClass = mapping.getMapping(tag.name());
        }
        return tagWorkerClass;
    }

    public ITagWorker getCustomTagWorker(IElementNode tag, ProcessorContext context) {
        return null;
    }
}

