/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.util;

import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.CssRuleSet;
import com.itextpdf.styledxmlparser.css.CssStatement;
import com.itextpdf.styledxmlparser.css.CssStyleSheet;
import com.itextpdf.styledxmlparser.css.media.CssMediaRule;
import com.itextpdf.styledxmlparser.css.page.CssMarginRule;
import com.itextpdf.styledxmlparser.css.page.CssPageRule;
import com.itextpdf.styledxmlparser.css.parse.CssDeclarationValueTokenizer;
import java.util.Collection;

public class CssStyleSheetAnalyzer {
    private static final int TARGET_COUNTER_MIN_PARAMS_SIZE = 2;
    private static final int TARGET_COUNTERS_MIN_PARAMS_SIZE = 3;

    private CssStyleSheetAnalyzer() {
    }

    public static boolean checkNonPagesTargetCounterPresence(CssStyleSheet styleSheet) {
        return CssStyleSheetAnalyzer.checkNonPagesTargetCounterPresence(styleSheet.getStatements());
    }

    private static boolean checkNonPagesTargetCounterPresence(Collection<CssStatement> statements) {
        boolean nonPagesTargetCounterPresent = false;
        for (CssStatement statement : statements) {
            boolean checkNonPagesTargetCounterPresenceResult = false;
            if (statement instanceof CssMarginRule) {
                checkNonPagesTargetCounterPresenceResult = CssStyleSheetAnalyzer.checkNonPagesTargetCounterPresence(((CssMarginRule)statement).getStatements());
            } else if (statement instanceof CssMediaRule) {
                checkNonPagesTargetCounterPresenceResult = CssStyleSheetAnalyzer.checkNonPagesTargetCounterPresence(((CssMediaRule)statement).getStatements());
            } else if (statement instanceof CssPageRule) {
                checkNonPagesTargetCounterPresenceResult = CssStyleSheetAnalyzer.checkNonPagesTargetCounterPresence(((CssPageRule)statement).getStatements());
            } else if (statement instanceof CssRuleSet) {
                checkNonPagesTargetCounterPresenceResult = CssStyleSheetAnalyzer.checkNonPagesTargetCounterPresence((CssRuleSet)statement);
            }
            nonPagesTargetCounterPresent = nonPagesTargetCounterPresent || checkNonPagesTargetCounterPresenceResult;
        }
        return nonPagesTargetCounterPresent;
    }

    private static boolean checkNonPagesTargetCounterPresence(CssRuleSet ruleSet) {
        boolean pagesCounterPresent = false;
        for (CssDeclaration declaration : ruleSet.getImportantDeclarations()) {
            pagesCounterPresent = pagesCounterPresent || CssStyleSheetAnalyzer.checkNonPagesTargetCounterPresence(declaration);
        }
        for (CssDeclaration declaration : ruleSet.getNormalDeclarations()) {
            pagesCounterPresent = pagesCounterPresent || CssStyleSheetAnalyzer.checkNonPagesTargetCounterPresence(declaration);
        }
        return pagesCounterPresent;
    }

    private static boolean checkNonPagesTargetCounterPresence(CssDeclaration declaration) {
        boolean nonPagesTargetCounterPresent = false;
        if ("content".equals(declaration.getProperty())) {
            CssDeclarationValueTokenizer.Token token;
            CssDeclarationValueTokenizer tokenizer = new CssDeclarationValueTokenizer(declaration.getExpression());
            while ((token = tokenizer.getNextValidToken()) != null) {
                String[] params;
                String paramsStr;
                if (token.isString()) continue;
                if (token.getValue().startsWith("target-counter(")) {
                    paramsStr = token.getValue().substring("target-counter".length() + 1, token.getValue().length() - 1);
                    params = paramsStr.split(",");
                    nonPagesTargetCounterPresent = nonPagesTargetCounterPresent || params.length >= 2 && !CssStyleSheetAnalyzer.checkTargetCounterParamsForPageOrPagesReferencePresence(params);
                    continue;
                }
                if (!token.getValue().startsWith("target-counters(")) continue;
                paramsStr = token.getValue().substring("target-counters".length() + 1, token.getValue().length() - 1);
                params = paramsStr.split(",");
                nonPagesTargetCounterPresent = nonPagesTargetCounterPresent || params.length >= 3 && !CssStyleSheetAnalyzer.checkTargetCounterParamsForPageOrPagesReferencePresence(params);
            }
        }
        return nonPagesTargetCounterPresent;
    }

    public static boolean checkPagesCounterPresence(CssStyleSheet styleSheet) {
        return CssStyleSheetAnalyzer.checkPagesCounterPresence(styleSheet.getStatements());
    }

    private static boolean checkPagesCounterPresence(Collection<CssStatement> statements) {
        boolean pagesCounterPresent = false;
        for (CssStatement statement : statements) {
            if (statement instanceof CssMarginRule) {
                pagesCounterPresent = pagesCounterPresent || CssStyleSheetAnalyzer.checkPagesCounterPresence(((CssMarginRule)statement).getStatements());
                continue;
            }
            if (statement instanceof CssMediaRule) {
                pagesCounterPresent = pagesCounterPresent || CssStyleSheetAnalyzer.checkPagesCounterPresence(((CssMediaRule)statement).getStatements());
                continue;
            }
            if (statement instanceof CssPageRule) {
                pagesCounterPresent = pagesCounterPresent || CssStyleSheetAnalyzer.checkPagesCounterPresence(((CssPageRule)statement).getStatements());
                continue;
            }
            if (!(statement instanceof CssRuleSet)) continue;
            pagesCounterPresent = pagesCounterPresent || CssStyleSheetAnalyzer.checkPagesCounterPresence((CssRuleSet)statement);
        }
        return pagesCounterPresent;
    }

    private static boolean checkPagesCounterPresence(CssRuleSet ruleSet) {
        boolean pagesCounterPresent = false;
        for (CssDeclaration declaration : ruleSet.getImportantDeclarations()) {
            pagesCounterPresent = pagesCounterPresent || CssStyleSheetAnalyzer.checkPagesCounterPresence(declaration);
        }
        for (CssDeclaration declaration : ruleSet.getNormalDeclarations()) {
            pagesCounterPresent = pagesCounterPresent || CssStyleSheetAnalyzer.checkPagesCounterPresence(declaration);
        }
        return pagesCounterPresent;
    }

    private static boolean checkPagesCounterPresence(CssDeclaration declaration) {
        boolean pagesCounterPresent = false;
        if ("content".equals(declaration.getProperty())) {
            CssDeclarationValueTokenizer.Token token;
            CssDeclarationValueTokenizer tokenizer = new CssDeclarationValueTokenizer(declaration.getExpression());
            while ((token = tokenizer.getNextValidToken()) != null) {
                String[] params;
                String paramsStr;
                if (token.isString()) continue;
                if (token.getValue().startsWith("counters(")) {
                    paramsStr = token.getValue().substring("counters".length() + 1, token.getValue().length() - 1);
                    params = paramsStr.split(",");
                    pagesCounterPresent = pagesCounterPresent || CssStyleSheetAnalyzer.checkCounterFunctionParamsForPagesReferencePresence(params);
                    continue;
                }
                if (token.getValue().startsWith("counter(")) {
                    paramsStr = token.getValue().substring("counter".length() + 1, token.getValue().length() - 1);
                    params = paramsStr.split(",");
                    pagesCounterPresent = pagesCounterPresent || CssStyleSheetAnalyzer.checkCounterFunctionParamsForPagesReferencePresence(params);
                    continue;
                }
                if (token.getValue().startsWith("target-counter(")) {
                    paramsStr = token.getValue().substring("target-counter".length() + 1, token.getValue().length() - 1);
                    params = paramsStr.split(",");
                    pagesCounterPresent = pagesCounterPresent || params.length >= 2 && CssStyleSheetAnalyzer.checkTargetCounterParamsForPageOrPagesReferencePresence(params);
                    continue;
                }
                if (!token.getValue().startsWith("target-counters(")) continue;
                paramsStr = token.getValue().substring("target-counters".length() + 1, token.getValue().length() - 1);
                params = paramsStr.split(",");
                pagesCounterPresent = pagesCounterPresent || params.length >= 3 && CssStyleSheetAnalyzer.checkTargetCounterParamsForPageOrPagesReferencePresence(params);
            }
        }
        return pagesCounterPresent;
    }

    private static boolean checkCounterFunctionParamsForPagesReferencePresence(String[] params) {
        return params.length > 0 && "pages".equals(params[0].trim());
    }

    private static boolean checkTargetCounterParamsForPageOrPagesReferencePresence(String[] params) {
        return "page".equals(params[1].trim()) || "pages".equals(params[1].trim());
    }
}

