/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.resolve.func.counter;

import com.itextpdf.html2pdf.css.resolve.func.counter.CounterDigitsGlyphStyle;
import com.itextpdf.html2pdf.html.HtmlUtils;
import com.itextpdf.styledxmlparser.node.IElementNode;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CssCounterManager {
    private static final int DEFAULT_COUNTER_VALUE = 0;
    private static final int DEFAULT_INCREMENT_VALUE = 1;
    private final Map<String, Map<String, Integer>> targetCounterMap = new HashMap<String, Map<String, Integer>>();
    private final Map<String, Map<String, String>> targetCountersMap = new HashMap<String, Map<String, String>>();
    private final Map<String, Deque<Integer>> counters = new HashMap<String, Deque<Integer>>();
    private final Map<String, Integer> counterValues = new HashMap<String, Integer>();
    private final Map<IElementNode, List<String>> pushedCountersMap = new HashMap<IElementNode, List<String>>();

    public void clearManager() {
        this.counters.clear();
    }

    public void pushEveryCounterToCounters(IElementNode element) {
        ArrayList<String> pushedCounters = new ArrayList<String>();
        for (Map.Entry<String, Integer> counter : new HashSet<Map.Entry<String, Integer>>(this.counterValues.entrySet())) {
            if (counter.getValue() == null) continue;
            this.pushCounter(counter.getKey(), counter.getValue());
            pushedCounters.add(counter.getKey());
            this.counterValues.put(counter.getKey(), null);
        }
        this.pushedCountersMap.put(element, pushedCounters);
    }

    public void popEveryCounterFromCounters(IElementNode element) {
        this.counterValues.clear();
        if (this.pushedCountersMap.get(element) != null) {
            for (String pushedCounter : this.pushedCountersMap.get(element)) {
                this.counterValues.put(pushedCounter, this.popCounter(pushedCounter));
            }
            this.pushedCountersMap.remove(element);
        }
    }

    public String resolveTargetCounter(String id, String counterName, CounterDigitsGlyphStyle listSymbolType) {
        Integer counterValue = null;
        if (this.targetCounterMap.containsKey(id)) {
            Map<String, Integer> countersForThisId = this.targetCounterMap.get(id);
            if (countersForThisId.containsKey(counterName)) {
                counterValue = countersForThisId.get(counterName);
            } else {
                countersForThisId.put(counterName, null);
            }
        } else {
            this.targetCounterMap.put(id, new HashMap());
            this.targetCounterMap.get(id).put(counterName, null);
        }
        return counterValue == null ? null : HtmlUtils.convertNumberAccordingToGlyphStyle(listSymbolType, counterValue);
    }

    public String resolveTargetCounters(String id, String counterName, String counterSeparatorStr, CounterDigitsGlyphStyle listSymbolType) {
        String countersStr = null;
        if (this.targetCountersMap.containsKey(id)) {
            Map<String, String> countersForThisId = this.targetCountersMap.get(id);
            if (countersForThisId.containsKey(counterName)) {
                countersStr = countersForThisId.get(counterName);
            } else {
                countersForThisId.put(counterName, null);
            }
        } else {
            this.targetCountersMap.put(id, new HashMap());
            this.targetCountersMap.get(id).put(counterName, null);
        }
        if (countersStr == null) {
            return null;
        }
        String[] resolvedCounters = countersStr.split("\\.");
        ArrayList<String> convertedCounters = new ArrayList<String>();
        for (String counter : resolvedCounters) {
            convertedCounters.add(HtmlUtils.convertNumberAccordingToGlyphStyle(listSymbolType, Integer.parseInt(counter)));
        }
        return CssCounterManager.buildCountersStringFromList(convertedCounters, counterSeparatorStr);
    }

    public void addTargetCounterIfRequired(IElementNode node) {
        String id = node.getAttribute("id");
        if (id != null && this.targetCounterMap.containsKey(id)) {
            for (Map.Entry<String, Integer> targetCounter : new HashSet<Map.Entry<String, Integer>>(this.targetCounterMap.get(id).entrySet())) {
                String counterName = targetCounter.getKey();
                String counterStr = this.resolveCounter(counterName, CounterDigitsGlyphStyle.DEFAULT);
                if (counterStr == null) continue;
                this.targetCounterMap.get(id).put(counterName, Integer.parseInt(counterStr));
            }
        }
    }

    public void addTargetCountersIfRequired(IElementNode node) {
        String id = node.getAttribute("id");
        if (id != null && this.targetCountersMap.containsKey(id)) {
            for (Map.Entry<String, String> targetCounter : new HashSet<Map.Entry<String, String>>(this.targetCountersMap.get(id).entrySet())) {
                String counterName = targetCounter.getKey();
                String resolvedCounters = this.resolveCounters(counterName, ".", CounterDigitsGlyphStyle.DEFAULT);
                if (resolvedCounters == null) continue;
                this.targetCountersMap.get(id).put(counterName, resolvedCounters);
            }
        }
    }

    public String resolveCounter(String counterName, CounterDigitsGlyphStyle listSymbolType) {
        Integer result = this.counterValues.get(counterName);
        if (result == null) {
            result = !this.counters.containsKey(counterName) || this.counters.get(counterName).isEmpty() ? Integer.valueOf(0) : this.counters.get(counterName).getLast();
        }
        return HtmlUtils.convertNumberAccordingToGlyphStyle(listSymbolType, result);
    }

    public String resolveCounters(String counterName, String counterSeparatorStr, CounterDigitsGlyphStyle listSymbolType) {
        Integer currentValue;
        ArrayList<String> resolvedCounters = new ArrayList<String>();
        if (this.counters.containsKey(counterName)) {
            for (Integer value : this.counters.get(counterName)) {
                resolvedCounters.add(HtmlUtils.convertNumberAccordingToGlyphStyle(listSymbolType, value));
            }
        }
        if ((currentValue = this.counterValues.get(counterName)) != null) {
            resolvedCounters.add(HtmlUtils.convertNumberAccordingToGlyphStyle(listSymbolType, currentValue));
        }
        if (resolvedCounters.isEmpty()) {
            return HtmlUtils.convertNumberAccordingToGlyphStyle(listSymbolType, 0);
        }
        return CssCounterManager.buildCountersStringFromList(resolvedCounters, counterSeparatorStr);
    }

    public void resetCounter(String counterName) {
        this.resetCounter(counterName, 0);
    }

    public void resetCounter(String counterName, int value) {
        this.counterValues.put(counterName, value);
    }

    public void incrementCounter(String counterName) {
        this.incrementCounter(counterName, 1);
    }

    public void incrementCounter(String counterName, int incrementValue) {
        Integer currentValue = this.counterValues.get(counterName);
        if (currentValue == null) {
            Deque<Integer> counterStack = this.counters.get(counterName);
            if (counterStack == null || counterStack.isEmpty()) {
                currentValue = 0;
                this.resetCounter(counterName, currentValue);
                this.counterValues.put(counterName, currentValue + incrementValue);
            } else {
                currentValue = counterStack.getLast();
                counterStack.removeLast();
                counterStack.addLast(currentValue + incrementValue);
            }
        } else {
            this.counterValues.put(counterName, currentValue + incrementValue);
        }
    }

    private Integer popCounter(String counterName) {
        if (this.counters.containsKey(counterName) && !this.counters.get(counterName).isEmpty()) {
            Integer last = this.counters.get(counterName).getLast();
            this.counters.get(counterName).removeLast();
            return last;
        }
        return null;
    }

    private void pushCounter(String counterName, Integer value) {
        if (!this.counters.containsKey(counterName)) {
            this.counters.put(counterName, new LinkedList());
        }
        this.counters.get(counterName).addLast((int)value);
    }

    private static String buildCountersStringFromList(List<String> resolvedCounters, String counterSeparatorStr) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < resolvedCounters.size(); ++i) {
            sb.append(resolvedCounters.get(i));
            if (i == resolvedCounters.size() - 1) continue;
            sb.append(counterSeparatorStr);
        }
        return sb.toString();
    }
}

