/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.ActualTextIterator;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.OpenTableLookup;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import com.itextpdf.io.util.TextUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GlyphLine {
    private int start;
    private int end;
    private int idx;
    protected List<Glyph> glyphs;
    protected List<ActualText> actualText;

    public GlyphLine() {
        this.glyphs = new ArrayList<Glyph>();
    }

    public GlyphLine(List<Glyph> glyphs) {
        this.glyphs = glyphs;
        this.start = 0;
        this.end = glyphs.size();
    }

    public GlyphLine(List<Glyph> glyphs, int start, int end) {
        this.glyphs = glyphs;
        this.start = start;
        this.end = end;
    }

    protected GlyphLine(List<Glyph> glyphs, List<ActualText> actualText, int start, int end) {
        this(glyphs, start, end);
        this.actualText = actualText;
    }

    public GlyphLine(GlyphLine other) {
        this.glyphs = other.glyphs;
        this.actualText = other.actualText;
        this.start = other.start;
        this.end = other.end;
        this.idx = other.idx;
    }

    public GlyphLine(GlyphLine other, int start, int end) {
        this.glyphs = other.glyphs.subList(start, end);
        if (other.actualText != null) {
            this.actualText = other.actualText.subList(start, end);
        }
        this.start = 0;
        this.end = end - start;
        this.idx = other.idx - start;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int getIdx() {
        return this.idx;
    }

    public void setIdx(int idx) {
        this.idx = idx;
    }

    public String toUnicodeString(int start, int end) {
        ActualTextIterator iter = new ActualTextIterator(this, start, end);
        StringBuilder str = new StringBuilder();
        while (iter.hasNext()) {
            GlyphLinePart part = iter.next();
            if (part.getActualText() != null) {
                str.append(part.getActualText());
                continue;
            }
            for (int i = part.getStart(); i < part.getEnd(); ++i) {
                str.append(this.glyphs.get(i).getUnicodeChars());
            }
        }
        return str.toString();
    }

    public String toString() {
        return this.toUnicodeString(this.start, this.end);
    }

    public GlyphLine copy(int left, int right) {
        GlyphLine glyphLine = new GlyphLine();
        glyphLine.setStart(0);
        glyphLine.setEnd(right - left);
        glyphLine.setGlyphs(new ArrayList<Glyph>(this.glyphs.subList(left, right)));
        glyphLine.actualText = this.actualText == null ? null : new ArrayList<ActualText>(this.actualText.subList(left, right));
        return glyphLine;
    }

    public Glyph get(int index) {
        return this.glyphs.get(index);
    }

    public Glyph set(int index, Glyph glyph) {
        return this.glyphs.set(index, glyph);
    }

    public void add(Glyph glyph) {
        this.glyphs.add(glyph);
        if (this.actualText != null) {
            this.actualText.add(null);
        }
    }

    public void add(int index, Glyph glyph) {
        this.glyphs.add(index, glyph);
        if (this.actualText != null) {
            this.actualText.add(index, null);
        }
    }

    public void setGlyphs(List<Glyph> replacementGlyphs) {
        this.glyphs = new ArrayList<Glyph>(replacementGlyphs);
        this.start = 0;
        this.end = replacementGlyphs.size();
        this.actualText = null;
    }

    public void add(GlyphLine other) {
        if (other.actualText != null) {
            if (this.actualText == null) {
                this.actualText = new ArrayList<ActualText>(this.glyphs.size());
                for (int i = 0; i < this.glyphs.size(); ++i) {
                    this.actualText.add(null);
                }
            }
            this.actualText.addAll(other.actualText.subList(other.getStart(), other.getEnd()));
        }
        this.glyphs.addAll(other.glyphs.subList(other.getStart(), other.getEnd()));
        if (null != this.actualText) {
            while (this.actualText.size() < this.glyphs.size()) {
                this.actualText.add(null);
            }
        }
    }

    public void replaceContent(GlyphLine other) {
        this.glyphs.clear();
        this.glyphs.addAll(other.glyphs);
        if (other.actualText != null) {
            if (this.actualText == null) {
                this.actualText = new ArrayList<ActualText>();
            } else {
                this.actualText.clear();
            }
            this.actualText.addAll(other.actualText);
        } else {
            this.actualText = null;
        }
        this.start = other.getStart();
        this.end = other.getEnd();
    }

    public int size() {
        return this.glyphs.size();
    }

    public void substituteManyToOne(OpenTypeFontTableReader tableReader, int lookupFlag, int rightPartLen, int substitutionGlyphIndex) {
        OpenTableLookup.GlyphIndexer gidx = new OpenTableLookup.GlyphIndexer();
        gidx.setLine(this);
        gidx.setIdx(this.idx);
        StringBuilder chars = new StringBuilder();
        Glyph currentGlyph = this.glyphs.get(this.idx);
        if (currentGlyph.getChars() != null) {
            chars.append(currentGlyph.getChars());
        } else if (currentGlyph.hasValidUnicode()) {
            chars.append(TextUtil.convertFromUtf32(currentGlyph.getUnicode()));
        }
        for (int j = 0; j < rightPartLen; ++j) {
            gidx.nextGlyph(tableReader, lookupFlag);
            currentGlyph = this.glyphs.get(gidx.getIdx());
            if (currentGlyph.getChars() != null) {
                chars.append(currentGlyph.getChars());
            } else if (currentGlyph.hasValidUnicode()) {
                chars.append(TextUtil.convertFromUtf32(currentGlyph.getUnicode()));
            }
            this.removeGlyph(gidx.getIdx());
            gidx.setIdx(gidx.getIdx() - 1);
        }
        char[] newChars = new char[chars.length()];
        chars.getChars(0, chars.length(), newChars, 0);
        Glyph newGlyph = tableReader.getGlyph(substitutionGlyphIndex);
        newGlyph.setChars(newChars);
        this.glyphs.set(this.idx, newGlyph);
        this.end -= rightPartLen;
    }

    public void substituteOneToOne(OpenTypeFontTableReader tableReader, int substitutionGlyphIndex) {
        Glyph oldGlyph = this.glyphs.get(this.idx);
        Glyph newGlyph = tableReader.getGlyph(substitutionGlyphIndex);
        if (oldGlyph.getChars() != null) {
            newGlyph.setChars(oldGlyph.getChars());
        } else if (newGlyph.hasValidUnicode()) {
            newGlyph.setChars(TextUtil.convertFromUtf32(newGlyph.getUnicode()));
        } else if (oldGlyph.hasValidUnicode()) {
            newGlyph.setChars(TextUtil.convertFromUtf32(oldGlyph.getUnicode()));
        }
        this.glyphs.set(this.idx, newGlyph);
    }

    public void substituteOneToMany(OpenTypeFontTableReader tableReader, int[] substGlyphIds) {
        int substCode = substGlyphIds[0];
        Glyph oldGlyph = this.glyphs.get(this.idx);
        Glyph glyph = tableReader.getGlyph(substCode);
        this.glyphs.set(this.idx, glyph);
        if (substGlyphIds.length > 1) {
            int i;
            ArrayList<Glyph> additionalGlyphs = new ArrayList<Glyph>(substGlyphIds.length - 1);
            for (i = 1; i < substGlyphIds.length; ++i) {
                substCode = substGlyphIds[i];
                glyph = tableReader.getGlyph(substCode);
                additionalGlyphs.add(glyph);
            }
            this.addAllGlyphs(this.idx + 1, additionalGlyphs);
            if (null != this.actualText) {
                if (null == this.actualText.get(this.idx)) {
                    this.actualText.set(this.idx, new ActualText(oldGlyph.getUnicodeString()));
                }
                for (i = 0; i < additionalGlyphs.size(); ++i) {
                    this.actualText.set(this.idx + 1 + i, this.actualText.get(this.idx));
                }
            }
            this.idx += substGlyphIds.length - 1;
            this.end += substGlyphIds.length - 1;
        }
    }

    public GlyphLine filter(IGlyphLineFilter filter) {
        boolean anythingFiltered = false;
        ArrayList<Glyph> filteredGlyphs = new ArrayList<Glyph>(this.end - this.start);
        ArrayList<ActualText> filteredActualText = this.actualText != null ? new ArrayList<ActualText>(this.end - this.start) : null;
        for (int i = this.start; i < this.end; ++i) {
            if (filter.accept(this.glyphs.get(i))) {
                filteredGlyphs.add(this.glyphs.get(i));
                if (filteredActualText == null) continue;
                filteredActualText.add(this.actualText.get(i));
                continue;
            }
            anythingFiltered = true;
        }
        if (anythingFiltered) {
            return new GlyphLine(filteredGlyphs, filteredActualText, 0, filteredGlyphs.size());
        }
        return this;
    }

    public void setActualText(int left, int right, String text) {
        if (this.actualText == null) {
            this.actualText = new ArrayList<ActualText>(this.glyphs.size());
            for (int i = 0; i < this.glyphs.size(); ++i) {
                this.actualText.add(null);
            }
        }
        ActualText actualText = new ActualText(text);
        for (int i = left; i < right; ++i) {
            this.actualText.set(i, actualText);
        }
    }

    public Iterator<GlyphLinePart> iterator() {
        return new ActualTextIterator(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GlyphLine other = (GlyphLine)obj;
        if (this.end - this.start != other.end - other.start) {
            return false;
        }
        if (this.actualText == null && other.actualText != null || this.actualText != null && other.actualText == null) {
            return false;
        }
        for (int i = this.start; i < this.end; ++i) {
            ActualText otherAT;
            int otherPos = other.start + i - this.start;
            Glyph myGlyph = this.get(i);
            Glyph otherGlyph = other.get(otherPos);
            if (myGlyph == null && otherGlyph != null || myGlyph != null && !myGlyph.equals(otherGlyph)) {
                return false;
            }
            ActualText myAT = this.actualText == null ? null : this.actualText.get(i);
            ActualText actualText = otherAT = other.actualText == null ? null : other.actualText.get(otherPos);
            if ((myAT != null || otherAT == null) && (myAT == null || myAT.equals(otherAT))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int i;
        int result = 0;
        result = 31 * result + this.start;
        result = 31 * result + this.end;
        for (i = this.start; i < this.end; ++i) {
            result = 31 * result + this.glyphs.get(i).hashCode();
        }
        if (null != this.actualText) {
            for (i = this.start; i < this.end; ++i) {
                result = 31 * result;
                if (null == this.actualText.get(i)) continue;
                result += this.actualText.get(i).hashCode();
            }
        }
        return result;
    }

    private void removeGlyph(int index) {
        this.glyphs.remove(index);
        if (this.actualText != null) {
            this.actualText.remove(index);
        }
    }

    private void addAllGlyphs(int index, List<Glyph> additionalGlyphs) {
        this.glyphs.addAll(index, additionalGlyphs);
        if (this.actualText != null) {
            for (int i = 0; i < additionalGlyphs.size(); ++i) {
                this.actualText.add(index, null);
            }
        }
    }

    protected static class ActualText {
        private final String value;

        public ActualText(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ActualText other = (ActualText)obj;
            return this.value == null && other.getValue() == null || this.value.equals(other.getValue());
        }

        public int hashCode() {
            return 31 * this.value.hashCode();
        }
    }

    public static class GlyphLinePart {
        private int start;
        private int end;
        private String actualText;
        private boolean reversed;

        public GlyphLinePart(int start, int end) {
            this(start, end, null);
        }

        public GlyphLinePart(int start, int end, String actualText) {
            this.start = start;
            this.end = end;
            this.actualText = actualText;
        }

        public int getStart() {
            return this.start;
        }

        public GlyphLinePart setStart(int start) {
            this.start = start;
            return this;
        }

        public int getEnd() {
            return this.end;
        }

        public GlyphLinePart setEnd(int end) {
            this.end = end;
            return this;
        }

        public String getActualText() {
            return this.actualText;
        }

        public GlyphLinePart setActualText(String actualText) {
            this.actualText = actualText;
            return this;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public GlyphLinePart setReversed(boolean reversed) {
            this.reversed = reversed;
            return this;
        }
    }

    public static interface IGlyphLineFilter {
        public boolean accept(Glyph var1);
    }
}

