/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.LanguageRecord;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import com.itextpdf.io.font.otf.ScriptRecord;
import com.itextpdf.io.font.otf.TagAndLocation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OpenTypeScript {
    public static final String DEFAULT_SCRIPT = "DFLT";
    private OpenTypeFontTableReader openTypeReader;
    private List<ScriptRecord> records;

    public OpenTypeScript(OpenTypeFontTableReader openTypeReader, int locationScriptTable) throws IOException {
        TagAndLocation[] tagsLocs;
        this.openTypeReader = openTypeReader;
        this.records = new ArrayList<ScriptRecord>();
        openTypeReader.rf.seek(locationScriptTable);
        for (TagAndLocation tagLoc : tagsLocs = openTypeReader.readTagAndLocations(locationScriptTable)) {
            this.readScriptRecord(tagLoc);
        }
    }

    public List<ScriptRecord> getScriptRecords() {
        return this.records;
    }

    public LanguageRecord getLanguageRecord(String[] scripts, String language) {
        ScriptRecord scriptFound = null;
        ScriptRecord scriptDefault = null;
        for (ScriptRecord sr : this.records) {
            if (!DEFAULT_SCRIPT.equals(sr.getTag())) continue;
            scriptDefault = sr;
            break;
        }
        for (String script : scripts) {
            for (ScriptRecord sr : this.records) {
                if (sr.getTag().equals(script)) {
                    scriptFound = sr;
                    break;
                }
                if (!DEFAULT_SCRIPT.equals(script)) continue;
                scriptDefault = sr;
            }
            if (scriptFound != null) break;
        }
        if (scriptFound == null) {
            scriptFound = scriptDefault;
        }
        if (scriptFound == null) {
            return null;
        }
        LanguageRecord lang = null;
        for (LanguageRecord lr : scriptFound.getLanguages()) {
            if (!lr.getTag().equals(language)) continue;
            lang = lr;
            break;
        }
        if (lang == null) {
            lang = scriptFound.getDefaultLanguage();
        }
        return lang;
    }

    private void readScriptRecord(TagAndLocation tagLoc) throws IOException {
        this.openTypeReader.rf.seek(tagLoc.getLocation());
        int locationDefaultLanguage = this.openTypeReader.rf.readUnsignedShort();
        if (locationDefaultLanguage > 0) {
            locationDefaultLanguage += tagLoc.getLocation();
        }
        TagAndLocation[] tagsLocs = this.openTypeReader.readTagAndLocations(tagLoc.getLocation());
        ScriptRecord srec = new ScriptRecord();
        srec.setTag(tagLoc.getTag());
        srec.setLanguages(new LanguageRecord[tagsLocs.length]);
        for (int k = 0; k < tagsLocs.length; ++k) {
            LanguageRecord[] languages = srec.getLanguages();
            languages[k] = this.readLanguageRecord(tagsLocs[k]);
            srec.setLanguages(languages);
        }
        if (locationDefaultLanguage > 0) {
            TagAndLocation t = new TagAndLocation();
            t.setTag("");
            t.setLocation(locationDefaultLanguage);
            srec.setDefaultLanguage(this.readLanguageRecord(t));
        }
        this.records.add(srec);
    }

    private LanguageRecord readLanguageRecord(TagAndLocation tagLoc) throws IOException {
        LanguageRecord rec = new LanguageRecord();
        this.openTypeReader.rf.seek((long)tagLoc.getLocation() + 2L);
        rec.setFeatureRequired(this.openTypeReader.rf.readUnsignedShort());
        int count = this.openTypeReader.rf.readUnsignedShort();
        rec.setFeatures(this.openTypeReader.readUShortArray(count));
        rec.setTag(tagLoc.getTag());
        return rec;
    }
}

