/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.source;

import com.itextpdf.io.source.BufferCleaner;
import com.itextpdf.io.source.IRandomAccessSource;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ByteBufferRandomAccessSource
implements IRandomAccessSource {
    private static boolean allowUnmapping = true;
    private final ByteBuffer byteBuffer;
    public static final boolean UNMAP_SUPPORTED;
    private static final BufferCleaner CLEANER;

    public ByteBufferRandomAccessSource(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public static void enableByteBufferMemoryUnmapping() {
        allowUnmapping = false;
    }

    public static void disableByteBufferMemoryUnmapping() {
        allowUnmapping = false;
    }

    @Override
    public int get(long position) {
        if (position > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Position must be less than Integer.MAX_VALUE");
        }
        try {
            if (position >= (long)this.byteBuffer.limit()) {
                return -1;
            }
            return this.byteBuffer.duplicate().get((int)position) & 0xFF;
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    @Override
    public int get(long position, byte[] bytes, int off, int len) {
        if (position > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Position must be less than Integer.MAX_VALUE");
        }
        if (position >= (long)this.byteBuffer.limit()) {
            return -1;
        }
        ByteBuffer byteBufferCopy = this.byteBuffer.duplicate();
        byteBufferCopy.position((int)position);
        int bytesFromThisBuffer = Math.min(len, byteBufferCopy.remaining());
        byteBufferCopy.get(bytes, off, bytesFromThisBuffer);
        return bytesFromThisBuffer;
    }

    @Override
    public long length() {
        return this.byteBuffer.limit();
    }

    @Override
    public void close() throws IOException {
        if (allowUnmapping) {
            ByteBufferRandomAccessSource.clean(this.byteBuffer);
        }
    }

    private static boolean clean(ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect()) {
            return false;
        }
        return AccessController.doPrivileged(() -> ByteBufferRandomAccessSource.cleanByUnmapping(buffer));
    }

    private static boolean cleanByUnmapping(ByteBuffer buffer) {
        Boolean success = Boolean.FALSE;
        try {
            if (UNMAP_SUPPORTED) {
                CLEANER.freeBuffer(buffer.toString(), buffer);
            } else {
                Method getCleanerMethod = buffer.getClass().getMethod("cleaner", null);
                getCleanerMethod.setAccessible(true);
                Object cleaner = getCleanerMethod.invoke((Object)buffer, (Object[])null);
                Method clean = cleaner.getClass().getMethod("clean", null);
                clean.invoke(cleaner, (Object[])null);
            }
            success = Boolean.TRUE;
        }
        catch (Exception e) {
            Logger logger = LoggerFactory.getLogger(ByteBufferRandomAccessSource.class);
            logger.debug(e.getMessage());
        }
        return success;
    }

    static {
        Object hack = AccessController.doPrivileged(BufferCleaner::unmapHackImpl);
        if (hack instanceof BufferCleaner) {
            CLEANER = (BufferCleaner)hack;
            UNMAP_SUPPORTED = true;
        } else {
            CLEANER = null;
            UNMAP_SUPPORTED = false;
        }
    }
}

