/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel;

import com.itextpdf.kernel.LicenseVersionException;
import com.itextpdf.kernel.VersionInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class Version {
    private static final Object staticLock = new Object();
    private static final String AGPL = " (AGPL-version)";
    private static volatile Version version = null;
    private static final String iTextProductName = "iText\u00ae";
    private static final String release = "7.1.5";
    private static final String producerLine = "iText\u00ae 7.1.5 \u00a92000-2019 iText Group NV";
    private final VersionInfo info;
    private boolean expired;

    @Deprecated
    public Version() {
        this.info = new VersionInfo(iTextProductName, release, producerLine, null);
    }

    private Version(VersionInfo info, boolean expired) {
        this.info = info;
        this.expired = expired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getInstance() {
        Version localVersion;
        Object object = staticLock;
        synchronized (object) {
            if (version != null) {
                return version;
            }
        }
        String key = null;
        try {
            String coreVersion = release;
            String[] info = Version.getLicenseeInfoFromLicenseKey(coreVersion);
            if (info != null) {
                if (info[3] != null && info[3].trim().length() > 0) {
                    key = info[3];
                } else {
                    key = "Trial version ";
                    key = info[5] == null ? key + "unauthorised" : key + info[5];
                }
                if (info.length > 6 && info[6] != null && info[6].trim().length() > 0) {
                    Version.checkLicenseVersion(coreVersion, info[6]);
                }
                localVersion = info[4] != null && info[4].trim().length() > 0 ? Version.initVersion(info[4], key, false) : (info[2] != null && info[2].trim().length() > 0 ? Version.initDefaultLicensedVersion(info[2], key) : (info[0] != null && info[0].trim().length() > 0 ? Version.initDefaultLicensedVersion(info[0], key) : Version.initAGPLVersion(null, key)));
            } else {
                localVersion = Version.initAGPLVersion(null, key);
            }
        }
        catch (LicenseVersionException lve) {
            throw lve;
        }
        catch (ClassNotFoundException cnfe) {
            localVersion = Version.initAGPLVersion(null, key);
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause().getMessage().equals("License file not loaded.") && Version.isiText5licenseLoaded()) {
                throw new LicenseVersionException("No iText7 License is loaded but an iText5 license is loaded.");
            }
            localVersion = Version.initAGPLVersion(e.getCause(), key);
        }
        return Version.atomicSetVersion(localVersion);
    }

    public static boolean isAGPLVersion() {
        return Version.getInstance().getVersion().indexOf(AGPL) > 0;
    }

    public static boolean isExpired() {
        return Version.getInstance().expired;
    }

    public String getProduct() {
        return this.info.getProduct();
    }

    public String getRelease() {
        return this.info.getRelease();
    }

    public String getVersion() {
        return this.info.getVersion();
    }

    public String getKey() {
        return this.info.getKey();
    }

    public VersionInfo getInfo() {
        return this.info;
    }

    private static Version initDefaultLicensedVersion(String ownerName, String key) {
        String producer = "iText\u00ae 7.1.5 \u00a92000-2019 iText Group NV (" + ownerName;
        producer = !key.toLowerCase().startsWith("trial") ? producer + "; licensed version)" : producer + "; " + key + ")";
        return Version.initVersion(producer, key, false);
    }

    private static Version initAGPLVersion(Throwable cause, String key) {
        String producer = "iText\u00ae 7.1.5 \u00a92000-2019 iText Group NV (AGPL-version)";
        boolean expired = cause != null && cause.getMessage() != null && cause.getMessage().contains("expired");
        return Version.initVersion(producer, key, expired);
    }

    private static Version initVersion(String producer, String key, boolean expired) {
        return new Version(new VersionInfo(iTextProductName, release, producer, key), expired);
    }

    private static Class<?> getLicenseKeyClass() throws ClassNotFoundException {
        String licenseKeyClassFullName = "com.itextpdf.licensekey.LicenseKey";
        return Class.forName(licenseKeyClassFullName);
    }

    private static void checkLicenseVersion(String coreVersionString, String licenseVersionString) {
        String[] coreVersions = Version.parseVersionString(coreVersionString);
        String[] licenseVersions = Version.parseVersionString(licenseVersionString);
        int coreMajor = Integer.parseInt(coreVersions[0]);
        int coreMinor = Integer.parseInt(coreVersions[1]);
        int licenseMajor = Integer.parseInt(licenseVersions[0]);
        int licenseMinor = Integer.parseInt(licenseVersions[1]);
        if (licenseMajor < coreMajor) {
            throw new LicenseVersionException("The major version of the license ({0}) is lower than the major version ({1}) of the Core library.").setMessageParams(licenseMajor, coreMajor);
        }
        if (licenseMajor > coreMajor) {
            throw new LicenseVersionException("The major version of the license ({0}) is higher than the major version ({1}) of the Core library.").setMessageParams(licenseMajor, coreMajor);
        }
        if (licenseMinor < coreMinor) {
            throw new LicenseVersionException("The minor version of the license ({0}) is lower than the minor version ({1}) of the Core library.").setMessageParams(licenseMinor, coreMinor);
        }
    }

    private static String[] parseVersionString(String version) {
        String splitRegex = "\\.";
        String[] split = version.split(splitRegex);
        if (split.length == 0) {
            throw new LicenseVersionException("Version string is empty and cannot be parsed.");
        }
        String major = split[0];
        String minor = "0";
        if (split.length > 1) {
            minor = split[1].substring(0);
        }
        if (!Version.isVersionNumeric(major)) {
            throw new LicenseVersionException("Major version is not numeric");
        }
        if (!Version.isVersionNumeric(minor)) {
            throw new LicenseVersionException("Minor version is not numeric");
        }
        return new String[]{major, minor};
    }

    private static String[] getLicenseeInfoFromLicenseKey(String validatorKey) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        String licenseeInfoMethodName = "getLicenseeInfoForVersion";
        Class<?> klass = Version.getLicenseKeyClass();
        if (klass != null) {
            Class[] cArg = new Class[]{String.class};
            Method m = klass.getMethod(licenseeInfoMethodName, cArg);
            Object[] args = new Object[]{validatorKey};
            String[] info = (String[])m.invoke(klass.newInstance(), args);
            return info;
        }
        return null;
    }

    private static boolean isiText5licenseLoaded() {
        String validatorKey5 = "5";
        boolean result = false;
        try {
            String[] info = Version.getLicenseeInfoFromLicenseKey(validatorKey5);
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static boolean isVersionNumeric(String version) {
        try {
            Double.parseDouble(version);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Version atomicSetVersion(Version newVersion) {
        Object object = staticLock;
        synchronized (object) {
            version = newVersion;
            return version;
        }
    }
}

