/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas;

import com.itextpdf.commons.datastructures.Tuple2;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.otf.ActualTextIterator;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageType;
import com.itextpdf.io.source.ByteUtils;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceGray;
import com.itextpdf.kernel.colors.PatternColor;
import com.itextpdf.kernel.exceptions.MemoryLimitsAwareException;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfType0Font;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.geom.Vector;
import com.itextpdf.kernel.pdf.IsoKey;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfResources;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import com.itextpdf.kernel.pdf.canvas.CanvasTag;
import com.itextpdf.kernel.pdf.canvas.wmf.WmfImageHelper;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.colorspace.PdfDeviceCs;
import com.itextpdf.kernel.pdf.colorspace.PdfPattern;
import com.itextpdf.kernel.pdf.colorspace.PdfShading;
import com.itextpdf.kernel.pdf.colorspace.PdfSpecialCs;
import com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import com.itextpdf.kernel.pdf.layer.IPdfOCG;
import com.itextpdf.kernel.pdf.layer.PdfLayer;
import com.itextpdf.kernel.pdf.layer.PdfLayerMembership;
import com.itextpdf.kernel.pdf.tagutils.TagReference;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class PdfCanvas {
    private static final byte[] B = ByteUtils.getIsoBytes((String)"B\n");
    private static final byte[] b = ByteUtils.getIsoBytes((String)"b\n");
    private static final byte[] BDC = ByteUtils.getIsoBytes((String)"BDC\n");
    private static final byte[] BI = ByteUtils.getIsoBytes((String)"BI\n");
    private static final byte[] BMC = ByteUtils.getIsoBytes((String)"BMC\n");
    private static final byte[] BStar = ByteUtils.getIsoBytes((String)"B*\n");
    private static final byte[] bStar = ByteUtils.getIsoBytes((String)"b*\n");
    private static final byte[] BT = ByteUtils.getIsoBytes((String)"BT\n");
    private static final byte[] c = ByteUtils.getIsoBytes((String)"c\n");
    private static final byte[] cm = ByteUtils.getIsoBytes((String)"cm\n");
    private static final byte[] cs = ByteUtils.getIsoBytes((String)"cs\n");
    private static final byte[] CS = ByteUtils.getIsoBytes((String)"CS\n");
    private static final byte[] d = ByteUtils.getIsoBytes((String)"d\n");
    private static final byte[] Do = ByteUtils.getIsoBytes((String)"Do\n");
    private static final byte[] EI = ByteUtils.getIsoBytes((String)"EI\n");
    private static final byte[] EMC = ByteUtils.getIsoBytes((String)"EMC\n");
    private static final byte[] ET = ByteUtils.getIsoBytes((String)"ET\n");
    private static final byte[] f = ByteUtils.getIsoBytes((String)"f\n");
    private static final byte[] fStar = ByteUtils.getIsoBytes((String)"f*\n");
    private static final byte[] G = ByteUtils.getIsoBytes((String)"G\n");
    private static final byte[] g = ByteUtils.getIsoBytes((String)"g\n");
    private static final byte[] gs = ByteUtils.getIsoBytes((String)"gs\n");
    private static final byte[] h = ByteUtils.getIsoBytes((String)"h\n");
    private static final byte[] i = ByteUtils.getIsoBytes((String)"i\n");
    private static final byte[] ID = ByteUtils.getIsoBytes((String)"ID\n");
    private static final byte[] j = ByteUtils.getIsoBytes((String)"j\n");
    private static final byte[] J = ByteUtils.getIsoBytes((String)"J\n");
    private static final byte[] K = ByteUtils.getIsoBytes((String)"K\n");
    private static final byte[] k = ByteUtils.getIsoBytes((String)"k\n");
    private static final byte[] l = ByteUtils.getIsoBytes((String)"l\n");
    private static final byte[] m = ByteUtils.getIsoBytes((String)"m\n");
    private static final byte[] M = ByteUtils.getIsoBytes((String)"M\n");
    private static final byte[] n = ByteUtils.getIsoBytes((String)"n\n");
    private static final byte[] q = ByteUtils.getIsoBytes((String)"q\n");
    private static final byte[] Q = ByteUtils.getIsoBytes((String)"Q\n");
    private static final byte[] re = ByteUtils.getIsoBytes((String)"re\n");
    private static final byte[] rg = ByteUtils.getIsoBytes((String)"rg\n");
    private static final byte[] RG = ByteUtils.getIsoBytes((String)"RG\n");
    private static final byte[] ri = ByteUtils.getIsoBytes((String)"ri\n");
    private static final byte[] S = ByteUtils.getIsoBytes((String)"S\n");
    private static final byte[] s = ByteUtils.getIsoBytes((String)"s\n");
    private static final byte[] scn = ByteUtils.getIsoBytes((String)"scn\n");
    private static final byte[] SCN = ByteUtils.getIsoBytes((String)"SCN\n");
    private static final byte[] sh = ByteUtils.getIsoBytes((String)"sh\n");
    private static final byte[] Tc = ByteUtils.getIsoBytes((String)"Tc\n");
    private static final byte[] Td = ByteUtils.getIsoBytes((String)"Td\n");
    private static final byte[] TD = ByteUtils.getIsoBytes((String)"TD\n");
    private static final byte[] Tf = ByteUtils.getIsoBytes((String)"Tf\n");
    private static final byte[] TJ = ByteUtils.getIsoBytes((String)"TJ\n");
    private static final byte[] Tj = ByteUtils.getIsoBytes((String)"Tj\n");
    private static final byte[] TL = ByteUtils.getIsoBytes((String)"TL\n");
    private static final byte[] Tm = ByteUtils.getIsoBytes((String)"Tm\n");
    private static final byte[] Tr = ByteUtils.getIsoBytes((String)"Tr\n");
    private static final byte[] Ts = ByteUtils.getIsoBytes((String)"Ts\n");
    private static final byte[] TStar = ByteUtils.getIsoBytes((String)"T*\n");
    private static final byte[] Tw = ByteUtils.getIsoBytes((String)"Tw\n");
    private static final byte[] Tz = ByteUtils.getIsoBytes((String)"Tz\n");
    private static final byte[] v = ByteUtils.getIsoBytes((String)"v\n");
    private static final byte[] W = ByteUtils.getIsoBytes((String)"W\n");
    private static final byte[] w = ByteUtils.getIsoBytes((String)"w\n");
    private static final byte[] WStar = ByteUtils.getIsoBytes((String)"W*\n");
    private static final byte[] y = ByteUtils.getIsoBytes((String)"y\n");
    private static final PdfDeviceCs.Gray gray = new PdfDeviceCs.Gray();
    private static final PdfDeviceCs.Rgb rgb = new PdfDeviceCs.Rgb();
    private static final PdfDeviceCs.Cmyk cmyk = new PdfDeviceCs.Cmyk();
    private static final PdfSpecialCs.Pattern pattern = new PdfSpecialCs.Pattern();
    private static final float IDENTITY_MATRIX_EPS = 1.0E-4f;
    private boolean defaultDeviceGrayBlackColorCheckRequired = true;
    protected Stack<CanvasGraphicsState> gsStack = new Stack();
    protected CanvasGraphicsState currentGs = new CanvasGraphicsState();
    protected PdfStream contentStream;
    protected PdfResources resources;
    protected PdfDocument document;
    protected int mcDepth;
    protected List<Integer> layerDepth;
    private Stack<Tuple2<PdfName, PdfDictionary>> tagStructureStack = new Stack();
    protected boolean drawingOnPage = false;

    public PdfCanvas(PdfStream contentStream, PdfResources resources, PdfDocument document) {
        this.contentStream = this.ensureStreamDataIsReadyToBeProcessed(contentStream);
        this.resources = resources;
        this.document = document;
    }

    public PdfCanvas(PdfPage page) {
        this(page, page.getDocument().getReader() != null && page.getDocument().getWriter() != null && page.getContentStreamCount() > 0 && page.getLastContentStream().getLength() > 0 || page.getRotation() != 0 && page.isIgnorePageRotationForContent());
    }

    public PdfCanvas(PdfPage page, boolean wrapOldContent) {
        this(PdfCanvas.getPageStream(page), page.getResources(), page.getDocument());
        if (wrapOldContent) {
            page.newContentStreamBefore().getOutputStream().writeBytes(ByteUtils.getIsoBytes((String)"q\n"));
            this.contentStream.getOutputStream().writeBytes(ByteUtils.getIsoBytes((String)"Q\n"));
        }
        if (page.getRotation() != 0 && page.isIgnorePageRotationForContent() && (wrapOldContent || !page.isPageRotationInverseMatrixWritten())) {
            this.applyRotation(page);
            page.setPageRotationInverseMatrixWritten();
        }
        this.drawingOnPage = true;
    }

    public PdfCanvas(PdfFormXObject xObj, PdfDocument document) {
        this((PdfStream)xObj.getPdfObject(), xObj.getResources(), document);
    }

    public PdfCanvas(PdfDocument doc, int pageNum) {
        this(doc.getPage(pageNum));
    }

    public PdfResources getResources() {
        return this.resources;
    }

    public PdfDocument getDocument() {
        return this.document;
    }

    public void attachContentStream(PdfStream contentStream) {
        this.contentStream = contentStream;
    }

    public CanvasGraphicsState getGraphicsState() {
        return this.currentGs;
    }

    public void release() {
        this.gsStack = null;
        this.currentGs = null;
        this.contentStream = null;
        this.resources = null;
    }

    public PdfCanvas saveState() {
        this.document.checkIsoConformance(Character.valueOf('q'), IsoKey.CANVAS_STACK);
        this.gsStack.push(this.currentGs);
        this.currentGs = new CanvasGraphicsState(this.currentGs);
        this.contentStream.getOutputStream().writeBytes(q);
        return this;
    }

    public PdfCanvas restoreState() {
        this.document.checkIsoConformance(Character.valueOf('Q'), IsoKey.CANVAS_STACK);
        if (this.gsStack.isEmpty()) {
            throw new PdfException("Unbalanced save restore state operators.");
        }
        this.currentGs = this.gsStack.pop();
        this.contentStream.getOutputStream().writeBytes(Q);
        return this;
    }

    public PdfCanvas concatMatrix(double a, double b, double c, double d, double e, double f) {
        this.currentGs.updateCtm((float)a, (float)b, (float)c, (float)d, (float)e, (float)f);
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeDouble(a))).writeSpace())).writeDouble(b))).writeSpace())).writeDouble(c))).writeSpace())).writeDouble(d))).writeSpace())).writeDouble(e))).writeSpace())).writeDouble(f))).writeSpace())).writeBytes(cm);
        return this;
    }

    public PdfCanvas concatMatrix(PdfArray array) {
        if (array.size() != 6) {
            return this;
        }
        for (int i = 0; i < array.size(); ++i) {
            if (array.get(i).isNumber()) continue;
            return this;
        }
        return this.concatMatrix(array.getAsNumber(0).doubleValue(), array.getAsNumber(1).doubleValue(), array.getAsNumber(2).doubleValue(), array.getAsNumber(3).doubleValue(), array.getAsNumber(4).doubleValue(), array.getAsNumber(5).doubleValue());
    }

    public PdfCanvas concatMatrix(AffineTransform transform) {
        float[] matrix = new float[6];
        transform.getMatrix(matrix);
        return this.concatMatrix(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
    }

    public PdfCanvas beginText() {
        this.contentStream.getOutputStream().writeBytes(BT);
        return this;
    }

    public PdfCanvas endText() {
        this.contentStream.getOutputStream().writeBytes(ET);
        return this;
    }

    public PdfCanvas beginVariableText() {
        return this.beginMarkedContent(PdfName.Tx);
    }

    public PdfCanvas endVariableText() {
        return this.endMarkedContent();
    }

    public PdfCanvas setFontAndSize(PdfFont font, float size) {
        this.currentGs.setFontSize(size);
        PdfName fontName = this.resources.addFont(this.document, font);
        this.currentGs.setFont(font);
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().write((PdfObject)fontName).writeSpace())).writeFloat(size))).writeSpace())).writeBytes(Tf);
        return this;
    }

    public PdfCanvas moveText(double x, double y) {
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeDouble(x))).writeSpace())).writeDouble(y))).writeSpace())).writeBytes(Td);
        return this;
    }

    public PdfCanvas setLeading(float leading) {
        this.currentGs.setLeading(leading);
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloat(leading))).writeSpace())).writeBytes(TL);
        return this;
    }

    public PdfCanvas moveTextWithLeading(float x, float y) {
        this.currentGs.setLeading(-y);
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloat(x))).writeSpace())).writeFloat(y))).writeSpace())).writeBytes(TD);
        return this;
    }

    public PdfCanvas newlineText() {
        this.contentStream.getOutputStream().writeBytes(TStar);
        return this;
    }

    public PdfCanvas newlineShowText(String text) {
        this.checkDefaultDeviceGrayBlackColor(this.getColorKeyForText());
        this.showTextInt(text);
        ((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeByte(39))).writeNewLine();
        return this;
    }

    public PdfCanvas newlineShowText(float wordSpacing, float charSpacing, String text) {
        this.checkDefaultDeviceGrayBlackColor(this.getColorKeyForText());
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloat(wordSpacing))).writeSpace())).writeFloat(charSpacing);
        this.showTextInt(text);
        ((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeByte(34))).writeNewLine();
        this.currentGs.setCharSpacing(charSpacing);
        this.currentGs.setWordSpacing(wordSpacing);
        return this;
    }

    public PdfCanvas setTextRenderingMode(int textRenderingMode) {
        this.currentGs.setTextRenderingMode(textRenderingMode);
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeInteger(textRenderingMode))).writeSpace())).writeBytes(Tr);
        return this;
    }

    public PdfCanvas setTextRise(float textRise) {
        this.currentGs.setTextRise(textRise);
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloat(textRise))).writeSpace())).writeBytes(Ts);
        return this;
    }

    public PdfCanvas setWordSpacing(float wordSpacing) {
        this.currentGs.setWordSpacing(wordSpacing);
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloat(wordSpacing))).writeSpace())).writeBytes(Tw);
        return this;
    }

    public PdfCanvas setCharacterSpacing(float charSpacing) {
        this.currentGs.setCharSpacing(charSpacing);
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloat(charSpacing))).writeSpace())).writeBytes(Tc);
        return this;
    }

    public PdfCanvas setHorizontalScaling(float scale) {
        this.currentGs.setHorizontalScaling(scale);
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloat(scale))).writeSpace())).writeBytes(Tz);
        return this;
    }

    public PdfCanvas setTextMatrix(float a, float b, float c, float d, float x, float y) {
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloat(a))).writeSpace())).writeFloat(b))).writeSpace())).writeFloat(c))).writeSpace())).writeFloat(d))).writeSpace())).writeFloat(x))).writeSpace())).writeFloat(y))).writeSpace())).writeBytes(Tm);
        return this;
    }

    public PdfCanvas setTextMatrix(AffineTransform transform) {
        float[] matrix = new float[6];
        transform.getMatrix(matrix);
        return this.setTextMatrix(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
    }

    public PdfCanvas setTextMatrix(float x, float y) {
        return this.setTextMatrix(1.0f, 0.0f, 0.0f, 1.0f, x, y);
    }

    public PdfCanvas showText(String text) {
        this.checkDefaultDeviceGrayBlackColor(this.getColorKeyForText());
        this.showTextInt(text);
        this.contentStream.getOutputStream().writeBytes(Tj);
        return this;
    }

    public PdfCanvas showText(GlyphLine text) {
        return this.showText(text, (Iterator<GlyphLine.GlyphLinePart>)new ActualTextIterator(text));
    }

    public PdfCanvas showText(GlyphLine text, Iterator<GlyphLine.GlyphLinePart> iterator) {
        this.checkDefaultDeviceGrayBlackColor(this.getColorKeyForText());
        this.document.checkIsoConformance(this.currentGs, IsoKey.FONT_GLYPHS, null, this.contentStream);
        this.checkIsoConformanceWritingOnContent();
        PdfFont font = this.currentGs.getFont();
        if (font == null) {
            throw new PdfException("Font and size must be set before writing any text.", this.currentGs);
        }
        this.document.checkIsoConformance(text.toString(), IsoKey.FONT, null, null, this.currentGs.getFont());
        float fontSize = FontProgram.convertTextSpaceToGlyphSpace((float)this.currentGs.getFontSize());
        float charSpacing = this.currentGs.getCharSpacing();
        float scaling = this.currentGs.getHorizontalScaling() / 100.0f;
        List<GlyphLine.GlyphLinePart> glyphLineParts = PdfCanvas.iteratorToList(iterator);
        for (int partIndex = 0; partIndex < glyphLineParts.size(); ++partIndex) {
            GlyphLine.GlyphLinePart glyphLinePart = glyphLineParts.get(partIndex);
            if (glyphLinePart.actualText != null) {
                PdfDictionary properties = new PdfDictionary();
                properties.put(PdfName.ActualText, new PdfString(glyphLinePart.actualText, "UnicodeBig").setHexWriting(true));
                this.beginMarkedContent(PdfName.Span, properties);
            } else if (glyphLinePart.reversed) {
                this.beginMarkedContent(PdfName.ReversedChars);
            }
            int sub = glyphLinePart.start;
            for (int i = glyphLinePart.start; i < glyphLinePart.end; ++i) {
                Glyph glyph = text.get(i);
                if (!glyph.hasOffsets()) continue;
                if (i - 1 - sub >= 0) {
                    font.writeText(text, sub, i - 1, this.contentStream.getOutputStream());
                    this.contentStream.getOutputStream().writeBytes(Tj);
                    ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloat(this.getSubrangeWidth(text, sub, i - 1), true))).writeSpace())).writeFloat(0.0f))).writeSpace())).writeBytes(Td);
                }
                float xPlacement = Float.NaN;
                float yPlacement = Float.NaN;
                if (glyph.hasPlacement()) {
                    float xPlacementAddition = 0.0f;
                    int currentGlyphIndex = i;
                    Glyph currentGlyph = text.get(i);
                    while (currentGlyph != null && currentGlyph.getAnchorDelta() != 0) {
                        xPlacementAddition += (float)currentGlyph.getXPlacement();
                        if (currentGlyph.getAnchorDelta() == 0) break;
                        currentGlyph = text.get(currentGlyphIndex += currentGlyph.getAnchorDelta());
                    }
                    xPlacement = -this.getSubrangeWidth(text, currentGlyphIndex, i) + xPlacementAddition * fontSize * scaling;
                    float yPlacementAddition = 0.0f;
                    currentGlyphIndex = i;
                    currentGlyph = text.get(i);
                    while (currentGlyph != null && currentGlyph.getYPlacement() != 0) {
                        yPlacementAddition += (float)currentGlyph.getYPlacement();
                        if (currentGlyph.getAnchorDelta() == 0) break;
                        currentGlyph = text.get(currentGlyphIndex += currentGlyph.getAnchorDelta());
                    }
                    yPlacement = -this.getSubrangeYDelta(text, currentGlyphIndex, i) + yPlacementAddition * fontSize;
                    ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloat(xPlacement, true))).writeSpace())).writeFloat(yPlacement, true))).writeSpace())).writeBytes(Td);
                }
                font.writeText(text, i, i, this.contentStream.getOutputStream());
                this.contentStream.getOutputStream().writeBytes(Tj);
                if (!Float.isNaN(xPlacement)) {
                    ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloat(-xPlacement, true))).writeSpace())).writeFloat(-yPlacement, true))).writeSpace())).writeBytes(Td);
                }
                if (glyph.hasAdvance()) {
                    ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloat(((float)((glyph.hasPlacement() ? 0 : glyph.getWidth()) + glyph.getXAdvance()) * fontSize + charSpacing + this.getWordSpacingAddition(glyph)) * scaling, true))).writeSpace())).writeFloat((float)glyph.getYAdvance() * fontSize, true))).writeSpace())).writeBytes(Td);
                }
                sub = i + 1;
            }
            if (glyphLinePart.end - sub > 0) {
                font.writeText(text, sub, glyphLinePart.end - 1, this.contentStream.getOutputStream());
                this.contentStream.getOutputStream().writeBytes(Tj);
            }
            if (glyphLinePart.actualText != null) {
                this.endMarkedContent();
            } else if (glyphLinePart.reversed) {
                this.endMarkedContent();
            }
            if (glyphLinePart.end <= sub || partIndex + 1 >= glyphLineParts.size()) continue;
            ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloat(this.getSubrangeWidth(text, sub, glyphLinePart.end - 1), true))).writeSpace())).writeFloat(0.0f))).writeSpace())).writeBytes(Td);
        }
        return this;
    }

    public void setDrawingOnPage(boolean drawingOnPage) {
        this.drawingOnPage = drawingOnPage;
    }

    private float getSubrangeWidth(GlyphLine text, int from, int to) {
        float fontSize = FontProgram.convertTextSpaceToGlyphSpace((float)this.currentGs.getFontSize());
        float charSpacing = this.currentGs.getCharSpacing();
        float scaling = this.currentGs.getHorizontalScaling() / 100.0f;
        float width = 0.0f;
        for (int iter = from; iter <= to; ++iter) {
            Glyph glyph = text.get(iter);
            if (!glyph.hasPlacement()) {
                width += ((float)glyph.getWidth() * fontSize + charSpacing + this.getWordSpacingAddition(glyph)) * scaling;
            }
            if (iter <= from) continue;
            width += (float)text.get(iter - 1).getXAdvance() * fontSize * scaling;
        }
        return width;
    }

    private float getSubrangeYDelta(GlyphLine text, int from, int to) {
        float fontSize = FontProgram.convertTextSpaceToGlyphSpace((float)this.currentGs.getFontSize());
        float yDelta = 0.0f;
        for (int iter = from; iter < to; ++iter) {
            yDelta += (float)text.get(iter).getYAdvance() * fontSize;
        }
        return yDelta;
    }

    private float getWordSpacingAddition(Glyph glyph) {
        return !(this.currentGs.getFont() instanceof PdfType0Font) && glyph.hasValidUnicode() && glyph.getCode() == 32 ? this.currentGs.getWordSpacing() : 0.0f;
    }

    public PdfCanvas showText(PdfArray textArray) {
        this.checkDefaultDeviceGrayBlackColor(this.getColorKeyForText());
        this.document.checkIsoConformance(this.currentGs, IsoKey.FONT_GLYPHS, null, this.contentStream);
        this.checkIsoConformanceWritingOnContent();
        if (this.currentGs.getFont() == null) {
            throw new PdfException("Font and size must be set before writing any text.", this.currentGs);
        }
        StringBuilder text = new StringBuilder();
        for (PdfObject obj : textArray) {
            if (!(obj instanceof PdfString)) continue;
            text.append(obj);
        }
        this.document.checkIsoConformance(text.toString(), IsoKey.FONT, null, null, this.currentGs.getFont());
        this.contentStream.getOutputStream().writeBytes(ByteUtils.getIsoBytes((String)"["));
        for (PdfObject obj : textArray) {
            if (obj.isString()) {
                StreamUtil.writeEscapedString((OutputStream)((Object)this.contentStream.getOutputStream()), (byte[])((PdfString)obj).getValueBytes());
                continue;
            }
            if (!obj.isNumber()) continue;
            this.contentStream.getOutputStream().writeFloat(((PdfNumber)obj).floatValue());
        }
        this.contentStream.getOutputStream().writeBytes(ByteUtils.getIsoBytes((String)"]"));
        this.contentStream.getOutputStream().writeBytes(TJ);
        return this;
    }

    public PdfCanvas moveTo(double x, double y) {
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeDouble(x))).writeSpace())).writeDouble(y))).writeSpace())).writeBytes(m);
        return this;
    }

    public PdfCanvas lineTo(double x, double y) {
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeDouble(x))).writeSpace())).writeDouble(y))).writeSpace())).writeBytes(l);
        return this;
    }

    public PdfCanvas curveTo(double x1, double y1, double x2, double y2, double x3, double y3) {
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeDouble(x1))).writeSpace())).writeDouble(y1))).writeSpace())).writeDouble(x2))).writeSpace())).writeDouble(y2))).writeSpace())).writeDouble(x3))).writeSpace())).writeDouble(y3))).writeSpace())).writeBytes(c);
        return this;
    }

    public PdfCanvas curveTo(double x2, double y2, double x3, double y3) {
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeDouble(x2))).writeSpace())).writeDouble(y2))).writeSpace())).writeDouble(x3))).writeSpace())).writeDouble(y3))).writeSpace())).writeBytes(v);
        return this;
    }

    public PdfCanvas curveFromTo(double x1, double y1, double x3, double y3) {
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeDouble(x1))).writeSpace())).writeDouble(y1))).writeSpace())).writeDouble(x3))).writeSpace())).writeDouble(y3))).writeSpace())).writeBytes(y);
        return this;
    }

    public PdfCanvas arc(double x1, double y1, double x2, double y2, double startAng, double extent) {
        return this.drawArc(x1, y1, x2, y2, startAng, extent, false);
    }

    public PdfCanvas arcContinuous(double x1, double y1, double x2, double y2, double startAng, double extent) {
        return this.drawArc(x1, y1, x2, y2, startAng, extent, true);
    }

    public PdfCanvas ellipse(double x1, double y1, double x2, double y2) {
        return this.arc(x1, y1, x2, y2, 0.0, 360.0);
    }

    public static List<double[]> bezierArc(double x1, double y1, double x2, double y2, double startAng, double extent) {
        int Nfrag;
        double fragAngle;
        double tmp;
        if (x1 > x2) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y2 > y1) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        if (Math.abs(extent) <= 90.0) {
            fragAngle = extent;
            Nfrag = 1;
        } else {
            Nfrag = (int)Math.ceil(Math.abs(extent) / 90.0);
            fragAngle = extent / (double)Nfrag;
        }
        double x_cen = (x1 + x2) / 2.0;
        double y_cen = (y1 + y2) / 2.0;
        double rx = (x2 - x1) / 2.0;
        double ry = (y2 - y1) / 2.0;
        double halfAng = fragAngle * Math.PI / 360.0;
        double kappa = Math.abs(1.3333333333333333 * (1.0 - Math.cos(halfAng)) / Math.sin(halfAng));
        ArrayList<double[]> pointList = new ArrayList<double[]>();
        for (int iter = 0; iter < Nfrag; ++iter) {
            double theta0 = (startAng + (double)iter * fragAngle) * Math.PI / 180.0;
            double theta1 = (startAng + (double)(iter + 1) * fragAngle) * Math.PI / 180.0;
            double cos0 = Math.cos(theta0);
            double cos1 = Math.cos(theta1);
            double sin0 = Math.sin(theta0);
            double sin1 = Math.sin(theta1);
            if (fragAngle > 0.0) {
                pointList.add(new double[]{x_cen + rx * cos0, y_cen - ry * sin0, x_cen + rx * (cos0 - kappa * sin0), y_cen - ry * (sin0 + kappa * cos0), x_cen + rx * (cos1 + kappa * sin1), y_cen - ry * (sin1 - kappa * cos1), x_cen + rx * cos1, y_cen - ry * sin1});
                continue;
            }
            pointList.add(new double[]{x_cen + rx * cos0, y_cen - ry * sin0, x_cen + rx * (cos0 + kappa * sin0), y_cen - ry * (sin0 - kappa * cos0), x_cen + rx * (cos1 - kappa * sin1), y_cen - ry * (sin1 + kappa * cos1), x_cen + rx * cos1, y_cen - ry * sin1});
        }
        return pointList;
    }

    public PdfCanvas rectangle(double x, double y, double width, double height) {
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeDouble(x))).writeSpace())).writeDouble(y))).writeSpace())).writeDouble(width))).writeSpace())).writeDouble(height))).writeSpace())).writeBytes(re);
        return this;
    }

    public PdfCanvas rectangle(Rectangle rectangle) {
        return this.rectangle(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public PdfCanvas roundRectangle(double x, double y, double width, double height, double radius) {
        if (width < 0.0) {
            x += width;
            width = -width;
        }
        if (height < 0.0) {
            y += height;
            height = -height;
        }
        if (radius < 0.0) {
            radius = -radius;
        }
        double curv = 0.4477f;
        this.moveTo(x + radius, y);
        this.lineTo(x + width - radius, y);
        this.curveTo(x + width - radius * (double)0.4477f, y, x + width, y + radius * (double)0.4477f, x + width, y + radius);
        this.lineTo(x + width, y + height - radius);
        this.curveTo(x + width, y + height - radius * (double)0.4477f, x + width - radius * (double)0.4477f, y + height, x + width - radius, y + height);
        this.lineTo(x + radius, y + height);
        this.curveTo(x + radius * (double)0.4477f, y + height, x, y + height - radius * (double)0.4477f, x, y + height - radius);
        this.lineTo(x, y + radius);
        this.curveTo(x, y + radius * (double)0.4477f, x + radius * (double)0.4477f, y, x + radius, y);
        return this;
    }

    public PdfCanvas circle(double x, double y, double r) {
        double curve = 0.5523f;
        this.moveTo(x + r, y);
        this.curveTo(x + r, y + r * (double)0.5523f, x + r * (double)0.5523f, y + r, x, y + r);
        this.curveTo(x - r * (double)0.5523f, y + r, x - r, y + r * (double)0.5523f, x - r, y);
        this.curveTo(x - r, y - r * (double)0.5523f, x - r * (double)0.5523f, y - r, x, y - r);
        this.curveTo(x + r * (double)0.5523f, y - r, x + r, y - r * (double)0.5523f, x + r, y);
        return this;
    }

    public PdfCanvas paintShading(PdfShading shading) {
        PdfName shadingName = this.resources.addShading(shading);
        ((PdfOutputStream)((Object)this.contentStream.getOutputStream().write((PdfObject)shadingName).writeSpace())).writeBytes(sh);
        return this;
    }

    public PdfCanvas closePath() {
        this.contentStream.getOutputStream().writeBytes(h);
        return this;
    }

    public PdfCanvas closePathEoFillStroke() {
        this.checkIsoConformanceWritingOnContent();
        this.checkDefaultDeviceGrayBlackColor(CheckColorMode.FILL_AND_STROKE);
        this.contentStream.getOutputStream().writeBytes(bStar);
        return this;
    }

    public PdfCanvas closePathFillStroke() {
        this.checkDefaultDeviceGrayBlackColor(CheckColorMode.FILL_AND_STROKE);
        this.contentStream.getOutputStream().writeBytes(b);
        return this;
    }

    public PdfCanvas endPath() {
        this.contentStream.getOutputStream().writeBytes(n);
        return this;
    }

    public PdfCanvas stroke() {
        this.checkDefaultDeviceGrayBlackColor(CheckColorMode.STROKE);
        this.contentStream.getOutputStream().writeBytes(S);
        return this;
    }

    public PdfCanvas clip() {
        this.contentStream.getOutputStream().writeBytes(W);
        return this;
    }

    public PdfCanvas eoClip() {
        this.contentStream.getOutputStream().writeBytes(WStar);
        return this;
    }

    public PdfCanvas closePathStroke() {
        this.checkIsoConformanceWritingOnContent();
        this.contentStream.getOutputStream().writeBytes(s);
        return this;
    }

    public PdfCanvas fill() {
        this.checkIsoConformanceWritingOnContent();
        this.checkDefaultDeviceGrayBlackColor(CheckColorMode.FILL);
        this.contentStream.getOutputStream().writeBytes(f);
        return this;
    }

    public PdfCanvas fillStroke() {
        this.checkIsoConformanceWritingOnContent();
        this.checkDefaultDeviceGrayBlackColor(CheckColorMode.FILL_AND_STROKE);
        this.contentStream.getOutputStream().writeBytes(B);
        return this;
    }

    public PdfCanvas eoFill() {
        this.checkIsoConformanceWritingOnContent();
        this.checkDefaultDeviceGrayBlackColor(CheckColorMode.FILL);
        this.contentStream.getOutputStream().writeBytes(fStar);
        return this;
    }

    public PdfCanvas eoFillStroke() {
        this.checkIsoConformanceWritingOnContent();
        this.checkDefaultDeviceGrayBlackColor(CheckColorMode.FILL_AND_STROKE);
        this.contentStream.getOutputStream().writeBytes(BStar);
        return this;
    }

    public PdfCanvas setLineWidth(float lineWidth) {
        if (this.currentGs.getLineWidth() == lineWidth) {
            return this;
        }
        this.currentGs.setLineWidth(lineWidth);
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloat(lineWidth))).writeSpace())).writeBytes(w);
        return this;
    }

    public PdfCanvas setLineCapStyle(int lineCapStyle) {
        if (this.currentGs.getLineCapStyle() == lineCapStyle) {
            return this;
        }
        this.currentGs.setLineCapStyle(lineCapStyle);
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeInteger(lineCapStyle))).writeSpace())).writeBytes(J);
        return this;
    }

    public PdfCanvas setLineJoinStyle(int lineJoinStyle) {
        if (this.currentGs.getLineJoinStyle() == lineJoinStyle) {
            return this;
        }
        this.currentGs.setLineJoinStyle(lineJoinStyle);
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeInteger(lineJoinStyle))).writeSpace())).writeBytes(j);
        return this;
    }

    public PdfCanvas setMiterLimit(float miterLimit) {
        if (this.currentGs.getMiterLimit() == miterLimit) {
            return this;
        }
        this.currentGs.setMiterLimit(miterLimit);
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloat(miterLimit))).writeSpace())).writeBytes(M);
        return this;
    }

    public PdfCanvas setLineDash(float phase) {
        this.currentGs.setDashPattern(this.getDashPatternArray(phase));
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeByte(91))).writeByte(93))).writeSpace())).writeFloat(phase))).writeSpace())).writeBytes(d);
        return this;
    }

    public PdfCanvas setLineDash(float unitsOn, float phase) {
        this.currentGs.setDashPattern(this.getDashPatternArray(new float[]{unitsOn}, phase));
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeByte(91))).writeFloat(unitsOn))).writeByte(93))).writeSpace())).writeFloat(phase))).writeSpace())).writeBytes(d);
        return this;
    }

    public PdfCanvas setLineDash(float unitsOn, float unitsOff, float phase) {
        this.currentGs.setDashPattern(this.getDashPatternArray(new float[]{unitsOn, unitsOff}, phase));
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeByte(91))).writeFloat(unitsOn))).writeSpace())).writeFloat(unitsOff))).writeByte(93))).writeSpace())).writeFloat(phase))).writeSpace())).writeBytes(d);
        return this;
    }

    public PdfCanvas setLineDash(float[] array, float phase) {
        this.currentGs.setDashPattern(this.getDashPatternArray(array, phase));
        PdfOutputStream out = this.contentStream.getOutputStream();
        out.writeByte(91);
        for (int iter = 0; iter < array.length; ++iter) {
            out.writeFloat(array[iter]);
            if (iter >= array.length - 1) continue;
            out.writeSpace();
        }
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)out.writeByte(93))).writeSpace())).writeFloat(phase))).writeSpace())).writeBytes(d);
        return this;
    }

    public PdfCanvas setRenderingIntent(PdfName renderingIntent) {
        this.document.checkIsoConformance(renderingIntent, IsoKey.RENDERING_INTENT);
        if (renderingIntent.equals(this.currentGs.getRenderingIntent())) {
            return this;
        }
        this.currentGs.setRenderingIntent(renderingIntent);
        ((PdfOutputStream)((Object)this.contentStream.getOutputStream().write((PdfObject)renderingIntent).writeSpace())).writeBytes(ri);
        return this;
    }

    public PdfCanvas setFlatnessTolerance(float flatnessTolerance) {
        if (this.currentGs.getFlatnessTolerance() == flatnessTolerance) {
            return this;
        }
        this.currentGs.setFlatnessTolerance(flatnessTolerance);
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloat(flatnessTolerance))).writeSpace())).writeBytes(i);
        return this;
    }

    public PdfCanvas setFillColor(Color color) {
        return this.setColor(color, true);
    }

    public PdfCanvas setStrokeColor(Color color) {
        return this.setColor(color, false);
    }

    public PdfCanvas setColor(Color color, boolean fill) {
        if (color instanceof PatternColor) {
            return this.setColor(color.getColorSpace(), color.getColorValue(), ((PatternColor)color).getPattern(), fill);
        }
        return this.setColor(color.getColorSpace(), color.getColorValue(), fill);
    }

    public PdfCanvas setColor(PdfColorSpace colorSpace, float[] colorValue, boolean fill) {
        return this.setColor(colorSpace, colorValue, null, fill);
    }

    public PdfCanvas setColor(PdfColorSpace colorSpace, float[] colorValue, PdfPattern pattern, boolean fill) {
        Color newColor;
        boolean setColorValueOnly = false;
        Color oldColor = fill ? this.currentGs.getFillColor() : this.currentGs.getStrokeColor();
        if (oldColor.equals(newColor = this.createColor(colorSpace, colorValue, pattern))) {
            return this;
        }
        if (fill) {
            this.currentGs.setFillColor(newColor);
        } else {
            this.currentGs.setStrokeColor(newColor);
        }
        if (oldColor.getColorSpace().getPdfObject().equals(colorSpace.getPdfObject())) {
            setColorValueOnly = true;
        }
        if (colorSpace instanceof PdfDeviceCs.Gray) {
            ((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloats(colorValue))).writeSpace())).writeBytes(fill ? g : G);
        } else if (colorSpace instanceof PdfDeviceCs.Rgb) {
            ((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloats(colorValue))).writeSpace())).writeBytes(fill ? rg : RG);
        } else if (colorSpace instanceof PdfDeviceCs.Cmyk) {
            ((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloats(colorValue))).writeSpace())).writeBytes(fill ? k : K);
        } else if (colorSpace instanceof PdfSpecialCs.UncoloredTilingPattern) {
            ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().write((PdfObject)this.resources.addColorSpace(colorSpace)).writeSpace())).writeBytes(fill ? cs : CS))).writeNewLine())).writeFloats(colorValue))).writeSpace())).write((PdfObject)this.resources.addPattern(pattern)).writeSpace())).writeBytes(fill ? scn : SCN);
        } else if (colorSpace instanceof PdfSpecialCs.Pattern) {
            ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().write((PdfObject)PdfName.Pattern).writeSpace())).writeBytes(fill ? cs : CS))).writeNewLine())).write((PdfObject)this.resources.addPattern(pattern)).writeSpace())).writeBytes(fill ? scn : SCN);
        } else if (((PdfObject)colorSpace.getPdfObject()).isIndirect()) {
            if (!setColorValueOnly) {
                PdfName name = this.resources.addColorSpace(colorSpace);
                ((PdfOutputStream)((Object)this.contentStream.getOutputStream().write((PdfObject)name).writeSpace())).writeBytes(fill ? cs : CS);
            }
            ((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeFloats(colorValue))).writeSpace())).writeBytes(fill ? scn : SCN);
        }
        this.document.checkIsoConformance(this.currentGs, fill ? IsoKey.FILL_COLOR : IsoKey.STROKE_COLOR, this.resources, this.contentStream);
        return this;
    }

    public PdfCanvas setFillColorGray(float g) {
        return this.setColor(gray, new float[]{g}, true);
    }

    public PdfCanvas setStrokeColorGray(float g) {
        return this.setColor(gray, new float[]{g}, false);
    }

    public PdfCanvas resetFillColorGray() {
        return this.setFillColorGray(0.0f);
    }

    public PdfCanvas resetStrokeColorGray() {
        return this.setStrokeColorGray(0.0f);
    }

    public PdfCanvas setFillColorRgb(float r, float g, float b) {
        return this.setColor(rgb, new float[]{r, g, b}, true);
    }

    public PdfCanvas setStrokeColorRgb(float r, float g, float b) {
        return this.setColor(rgb, new float[]{r, g, b}, false);
    }

    public PdfCanvas setFillColorShading(PdfPattern.Shading shading) {
        return this.setColor(pattern, null, shading, true);
    }

    public PdfCanvas setStrokeColorShading(PdfPattern.Shading shading) {
        return this.setColor(pattern, null, shading, false);
    }

    public PdfCanvas resetFillColorRgb() {
        return this.resetFillColorGray();
    }

    public PdfCanvas resetStrokeColorRgb() {
        return this.resetStrokeColorGray();
    }

    public PdfCanvas setFillColorCmyk(float c, float m, float y, float k) {
        return this.setColor(cmyk, new float[]{c, m, y, k}, true);
    }

    public PdfCanvas setStrokeColorCmyk(float c, float m, float y, float k) {
        return this.setColor(cmyk, new float[]{c, m, y, k}, false);
    }

    public PdfCanvas resetFillColorCmyk() {
        return this.setFillColorCmyk(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public PdfCanvas resetStrokeColorCmyk() {
        return this.setStrokeColorCmyk(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public PdfCanvas beginLayer(IPdfOCG layer) {
        if (layer instanceof PdfLayer && ((PdfLayer)layer).getTitle() != null) {
            throw new IllegalArgumentException("Illegal layer argument.");
        }
        if (this.layerDepth == null) {
            this.layerDepth = new ArrayList<Integer>();
        }
        if (layer instanceof PdfLayerMembership) {
            this.layerDepth.add(1);
            this.addToPropertiesAndBeginLayer(layer);
        } else if (layer instanceof PdfLayer) {
            int num = 0;
            for (PdfLayer la = (PdfLayer)layer; la != null; la = la.getParent()) {
                if (la.getTitle() != null) continue;
                this.addToPropertiesAndBeginLayer(la);
                ++num;
            }
            this.layerDepth.add(num);
        } else {
            throw new UnsupportedOperationException("Unsupported type for operand: layer");
        }
        return this;
    }

    public PdfCanvas endLayer() {
        int num;
        if (this.layerDepth != null && !this.layerDepth.isEmpty()) {
            num = this.layerDepth.get(this.layerDepth.size() - 1);
            this.layerDepth.remove(this.layerDepth.size() - 1);
        } else {
            throw new PdfException("Unbalanced layer operators.");
        }
        while (num-- > 0) {
            ((PdfOutputStream)((Object)this.contentStream.getOutputStream().writeBytes(EMC))).writeNewLine();
        }
        return this;
    }

    public PdfXObject addImageWithTransformationMatrix(ImageData image, float a, float b, float c, float d, float e, float f) {
        return this.addImageWithTransformationMatrix(image, a, b, c, d, e, f, false);
    }

    public PdfXObject addImageWithTransformationMatrix(ImageData image, float a, float b, float c, float d, float e, float f, boolean asInline) {
        if (image.getOriginalType() == ImageType.WMF) {
            WmfImageHelper wmf = new WmfImageHelper(image);
            PdfXObject xObject = wmf.createFormXObject(this.document);
            this.addXObjectWithTransformationMatrix(xObject, a, b, c, d, e, f);
            return xObject;
        }
        PdfImageXObject imageXObject = new PdfImageXObject(image);
        if (asInline && image.canImageBeInline()) {
            this.addInlineImage(imageXObject, a, b, c, d, e, f);
            return null;
        }
        this.addImageWithTransformationMatrix(imageXObject, a, b, c, d, e, f);
        return imageXObject;
    }

    public PdfXObject addImageFittedIntoRectangle(ImageData image, Rectangle rect, boolean asInline) {
        return this.addImageWithTransformationMatrix(image, rect.getWidth(), 0.0f, 0.0f, rect.getHeight(), rect.getX(), rect.getY(), asInline);
    }

    public PdfXObject addImageAt(ImageData image, float x, float y, boolean asInline) {
        if (image.getOriginalType() == ImageType.WMF) {
            WmfImageHelper wmf = new WmfImageHelper(image);
            PdfXObject xObject = wmf.createFormXObject(this.document);
            this.addXObjectWithTransformationMatrix(xObject, 1.0f, 0.0f, 0.0f, 1.0f, x, y);
            return xObject;
        }
        PdfImageXObject imageXObject = new PdfImageXObject(image);
        if (asInline && image.canImageBeInline()) {
            this.addInlineImage(imageXObject, image.getWidth(), 0.0f, 0.0f, image.getHeight(), x, y);
            return null;
        }
        this.addImageWithTransformationMatrix(imageXObject, image.getWidth(), 0.0f, 0.0f, image.getHeight(), x, y);
        return imageXObject;
    }

    public PdfCanvas addXObjectWithTransformationMatrix(PdfXObject xObject, float a, float b, float c, float d, float e, float f) {
        if (xObject instanceof PdfFormXObject) {
            return this.addFormWithTransformationMatrix((PdfFormXObject)xObject, a, b, c, d, e, f, true);
        }
        if (xObject instanceof PdfImageXObject) {
            return this.addImageWithTransformationMatrix(xObject, a, b, c, d, e, f);
        }
        throw new IllegalArgumentException("PdfFormXObject or PdfImageXObject expected.");
    }

    public PdfCanvas addXObjectAt(PdfXObject xObject, float x, float y) {
        if (xObject instanceof PdfFormXObject) {
            return this.addFormAt((PdfFormXObject)xObject, x, y);
        }
        if (xObject instanceof PdfImageXObject) {
            return this.addImageAt((PdfImageXObject)xObject, x, y);
        }
        throw new IllegalArgumentException("PdfFormXObject or PdfImageXObject expected.");
    }

    public PdfCanvas addXObjectFittedIntoRectangle(PdfXObject xObject, Rectangle rect) {
        if (xObject instanceof PdfFormXObject) {
            return this.addFormFittedIntoRectangle((PdfFormXObject)xObject, rect);
        }
        if (xObject instanceof PdfImageXObject) {
            return this.addImageFittedIntoRectangle((PdfImageXObject)xObject, rect);
        }
        throw new IllegalArgumentException("PdfFormXObject or PdfImageXObject expected.");
    }

    public PdfCanvas addXObject(PdfXObject xObject) {
        if (xObject instanceof PdfFormXObject) {
            return this.addFormWithTransformationMatrix((PdfFormXObject)xObject, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, false);
        }
        if (xObject instanceof PdfImageXObject) {
            return this.addImageAt((PdfImageXObject)xObject, 0.0f, 0.0f);
        }
        throw new IllegalArgumentException("PdfFormXObject or PdfImageXObject expected.");
    }

    public PdfCanvas setExtGState(PdfExtGState extGState) {
        if (!extGState.isFlushed()) {
            this.currentGs.updateFromExtGState(extGState, this.document);
        }
        PdfName name = this.resources.addExtGState(extGState);
        ((PdfOutputStream)((Object)this.contentStream.getOutputStream().write((PdfObject)name).writeSpace())).writeBytes(gs);
        this.document.checkIsoConformance(this.currentGs, IsoKey.EXTENDED_GRAPHICS_STATE, null, this.contentStream);
        return this;
    }

    public PdfExtGState setExtGState(PdfDictionary extGState) {
        PdfExtGState egs = new PdfExtGState(extGState);
        this.setExtGState(egs);
        return egs;
    }

    public PdfCanvas beginMarkedContent(PdfName tag) {
        return this.beginMarkedContent(tag, null);
    }

    public PdfCanvas beginMarkedContent(PdfName tag, PdfDictionary properties) {
        ++this.mcDepth;
        PdfOutputStream out = (PdfOutputStream)((Object)this.contentStream.getOutputStream().write((PdfObject)tag).writeSpace());
        if (properties == null) {
            out.writeBytes(BMC);
        } else if (properties.getIndirectReference() == null) {
            ((PdfOutputStream)((Object)out.write((PdfObject)properties).writeSpace())).writeBytes(BDC);
        } else {
            ((PdfOutputStream)((Object)out.write((PdfObject)this.resources.addProperties(properties)).writeSpace())).writeBytes(BDC);
        }
        Tuple2 tuple2 = new Tuple2((Object)tag, (Object)properties);
        if (this.drawingOnPage) {
            this.document.checkIsoConformance(this.tagStructureStack, IsoKey.CANVAS_BEGIN_MARKED_CONTENT, null, null, tuple2);
        }
        this.tagStructureStack.push((Tuple2<PdfName, PdfDictionary>)tuple2);
        return this;
    }

    public PdfCanvas endMarkedContent() {
        if (--this.mcDepth < 0) {
            throw new PdfException("Unbalanced begin/end marked content operators.");
        }
        this.contentStream.getOutputStream().writeBytes(EMC);
        this.tagStructureStack.pop();
        return this;
    }

    public PdfCanvas openTag(CanvasTag tag) {
        if (tag.getRole() == null) {
            return this;
        }
        return this.beginMarkedContent(tag.getRole(), tag.getProperties());
    }

    public PdfCanvas openTag(TagReference tagReference) {
        if (tagReference.getRole() == null) {
            return this;
        }
        CanvasTag tag = new CanvasTag(tagReference.getRole());
        tag.setProperties(tagReference.getProperties()).addProperty(PdfName.MCID, new PdfNumber(tagReference.createNextMcid()));
        return this.openTag(tag);
    }

    public PdfCanvas closeTag() {
        return this.endMarkedContent();
    }

    public PdfCanvas writeLiteral(String s) {
        this.contentStream.getOutputStream().writeString(s);
        return this;
    }

    public PdfCanvas writeLiteral(char c) {
        this.contentStream.getOutputStream().writeInteger(c);
        return this;
    }

    public PdfCanvas writeLiteral(float n) {
        this.contentStream.getOutputStream().writeFloat(n);
        return this;
    }

    public PdfStream getContentStream() {
        return this.contentStream;
    }

    protected void addInlineImage(PdfImageXObject imageXObject, float a, float b, float c, float d, float e, float f) {
        this.document.checkIsoConformance(imageXObject.getPdfObject(), IsoKey.INLINE_IMAGE, this.resources, this.contentStream);
        this.saveState();
        this.concatMatrix(a, b, c, d, e, f);
        PdfOutputStream os = this.contentStream.getOutputStream();
        os.writeBytes(BI);
        byte[] imageBytes = ((PdfStream)imageXObject.getPdfObject()).getBytes(false);
        for (Map.Entry<PdfName, PdfObject> entry : ((PdfStream)imageXObject.getPdfObject()).entrySet()) {
            PdfName key = entry.getKey();
            if (PdfName.Type.equals(key) || PdfName.Subtype.equals(key) || PdfName.Length.equals(key)) continue;
            os.write((PdfObject)entry.getKey()).writeSpace();
            os.write(entry.getValue()).writeNewLine();
        }
        if (this.document.getPdfVersion().compareTo(PdfVersion.PDF_2_0) >= 0) {
            os.write((PdfObject)PdfName.Length).writeSpace();
            os.write((PdfObject)new PdfNumber(imageBytes.length)).writeNewLine();
        }
        os.writeBytes(ID);
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)os.writeBytes(imageBytes))).writeNewLine())).writeBytes(EI))).writeNewLine();
        this.restoreState();
    }

    private PdfCanvas addFormWithTransformationMatrix(PdfFormXObject form, float a, float b, float c, float d, float e, float f, boolean writeIdentityMatrix) {
        this.saveState();
        if (writeIdentityMatrix || !PdfCanvas.isIdentityMatrix(a, b, c, d, e, f)) {
            this.concatMatrix(a, b, c, d, e, f);
        }
        PdfName name = this.resources.addForm(form);
        ((PdfOutputStream)((Object)this.contentStream.getOutputStream().write((PdfObject)name).writeSpace())).writeBytes(Do);
        this.restoreState();
        return this;
    }

    private PdfCanvas addFormAt(PdfFormXObject form, float x, float y) {
        Rectangle bBox = PdfFormXObject.calculateBBoxMultipliedByMatrix(form);
        Vector bBoxMin = new Vector(bBox.getLeft(), bBox.getBottom(), 1.0f);
        Vector bBoxMax = new Vector(bBox.getRight(), bBox.getTop(), 1.0f);
        Vector rectMin = new Vector(x, y, 1.0f);
        Vector rectMax = new Vector(x + bBoxMax.get(0) - bBoxMin.get(0), y + bBoxMax.get(1) - bBoxMin.get(1), 1.0f);
        float[] result = PdfCanvas.calculateTransformationMatrix(rectMin, rectMax, bBoxMin, bBoxMax);
        return this.addFormWithTransformationMatrix(form, result[0], result[1], result[2], result[3], result[4], result[5], false);
    }

    private PdfCanvas addFormFittedIntoRectangle(PdfFormXObject form, Rectangle rect) {
        Rectangle bBox = PdfFormXObject.calculateBBoxMultipliedByMatrix(form);
        Vector bBoxMin = new Vector(bBox.getLeft(), bBox.getBottom(), 1.0f);
        Vector bBoxMax = new Vector(bBox.getRight(), bBox.getTop(), 1.0f);
        Vector rectMin = new Vector(rect.getLeft(), rect.getBottom(), 1.0f);
        Vector rectMax = new Vector(rect.getRight(), rect.getTop(), 1.0f);
        float[] result = PdfCanvas.calculateTransformationMatrix(rectMin, rectMax, bBoxMin, bBoxMax);
        return this.addFormWithTransformationMatrix(form, result[0], result[1], result[2], result[3], result[4], result[5], false);
    }

    private PdfCanvas addImageWithTransformationMatrix(PdfXObject xObject, float a, float b, float c, float d, float e, float f) {
        this.saveState();
        this.concatMatrix(a, b, c, d, e, f);
        PdfName name = xObject instanceof PdfImageXObject ? this.resources.addImage((PdfImageXObject)xObject) : this.resources.addImage((PdfStream)xObject.getPdfObject());
        ((PdfOutputStream)((Object)this.contentStream.getOutputStream().write((PdfObject)name).writeSpace())).writeBytes(Do);
        this.restoreState();
        return this;
    }

    private PdfCanvas addImageAt(PdfImageXObject image, float x, float y) {
        return this.addImageWithTransformationMatrix(image, image.getWidth(), 0.0f, 0.0f, image.getHeight(), x, y);
    }

    private PdfCanvas addImageFittedIntoRectangle(PdfImageXObject image, Rectangle rect) {
        return this.addImageWithTransformationMatrix(image, rect.getWidth(), 0.0f, 0.0f, rect.getHeight(), rect.getX(), rect.getY());
    }

    private PdfStream ensureStreamDataIsReadyToBeProcessed(PdfStream stream) {
        if (!stream.isFlushed() && (stream.getOutputStream() == null || stream.containsKey(PdfName.Filter))) {
            try {
                stream.setData(stream.getBytes());
            }
            catch (MemoryLimitsAwareException e) {
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stream;
    }

    private void showTextInt(String text) {
        this.document.checkIsoConformance(this.currentGs, IsoKey.FONT_GLYPHS, null, this.contentStream);
        if (this.currentGs.getFont() == null) {
            throw new PdfException("Font and size must be set before writing any text.", this.currentGs);
        }
        this.checkIsoConformanceWritingOnContent();
        this.document.checkIsoConformance(text, IsoKey.FONT, null, null, this.currentGs.getFont());
        this.currentGs.getFont().writeText(text, this.contentStream.getOutputStream());
    }

    private void checkIsoConformanceWritingOnContent() {
        if (this.drawingOnPage) {
            this.document.checkIsoConformance(this.tagStructureStack, IsoKey.CANVAS_WRITING_CONTENT);
        }
    }

    private void addToPropertiesAndBeginLayer(IPdfOCG layer) {
        PdfName name = this.resources.addProperties(layer.getPdfObject());
        ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.contentStream.getOutputStream().write((PdfObject)PdfName.OC).writeSpace())).write((PdfObject)name).writeSpace())).writeBytes(BDC))).writeNewLine();
    }

    private Color createColor(PdfColorSpace colorSpace, float[] colorValue, PdfPattern pattern) {
        if (colorSpace instanceof PdfSpecialCs.UncoloredTilingPattern) {
            return new PatternColor((PdfPattern.Tiling)pattern, ((PdfSpecialCs.UncoloredTilingPattern)colorSpace).getUnderlyingColorSpace(), colorValue);
        }
        if (colorSpace instanceof PdfSpecialCs.Pattern) {
            return new PatternColor(pattern);
        }
        return Color.makeColor(colorSpace, colorValue);
    }

    private PdfArray getDashPatternArray(float phase) {
        return this.getDashPatternArray(null, phase);
    }

    private PdfArray getDashPatternArray(float[] dashArray, float phase) {
        PdfArray dashPatternArray = new PdfArray();
        PdfArray dArray = new PdfArray();
        if (dashArray != null) {
            for (float fl : dashArray) {
                dArray.add(new PdfNumber(fl));
            }
        }
        dashPatternArray.add(dArray);
        dashPatternArray.add(new PdfNumber(phase));
        return dashPatternArray;
    }

    private void applyRotation(PdfPage page) {
        Rectangle rectangle = page.getPageSizeWithRotation();
        int rotation = page.getRotation();
        switch (rotation) {
            case 90: {
                this.concatMatrix(0.0, 1.0, -1.0, 0.0, rectangle.getTop(), 0.0);
                break;
            }
            case 180: {
                this.concatMatrix(-1.0, 0.0, 0.0, -1.0, rectangle.getRight(), rectangle.getTop());
                break;
            }
            case 270: {
                this.concatMatrix(0.0, -1.0, 1.0, 0.0, 0.0, rectangle.getRight());
            }
        }
    }

    private PdfCanvas drawArc(double x1, double y1, double x2, double y2, double startAng, double extent, boolean continuous) {
        List<double[]> ar = PdfCanvas.bezierArc(x1, y1, x2, y2, startAng, extent);
        if (ar.isEmpty()) {
            return this;
        }
        double[] pt = ar.get(0);
        if (continuous) {
            this.lineTo(pt[0], pt[1]);
        } else {
            this.moveTo(pt[0], pt[1]);
        }
        for (int index = 0; index < ar.size(); ++index) {
            pt = ar.get(index);
            this.curveTo(pt[2], pt[3], pt[4], pt[5], pt[6], pt[7]);
        }
        return this;
    }

    private void checkDefaultDeviceGrayBlackColor(CheckColorMode checkColorMode) {
        if (this.defaultDeviceGrayBlackColorCheckRequired) {
            if (this.currentGs.getFillColor() == DeviceGray.BLACK && (checkColorMode == CheckColorMode.FILL || checkColorMode == CheckColorMode.FILL_AND_STROKE)) {
                this.document.checkIsoConformance(this.currentGs, IsoKey.FILL_COLOR, this.resources, this.contentStream);
                this.defaultDeviceGrayBlackColorCheckRequired = false;
            } else if (this.currentGs.getStrokeColor() == DeviceGray.BLACK && (checkColorMode == CheckColorMode.STROKE || checkColorMode == CheckColorMode.FILL_AND_STROKE)) {
                this.document.checkIsoConformance(this.currentGs, IsoKey.STROKE_COLOR, this.resources, this.contentStream);
                this.defaultDeviceGrayBlackColorCheckRequired = false;
            }
        }
    }

    private CheckColorMode getColorKeyForText() {
        switch (this.currentGs.getTextRenderingMode()) {
            case 0: 
            case 4: {
                return CheckColorMode.FILL;
            }
            case 1: 
            case 5: {
                return CheckColorMode.STROKE;
            }
            case 2: 
            case 6: {
                return CheckColorMode.FILL_AND_STROKE;
            }
        }
        return CheckColorMode.NONE;
    }

    private static PdfStream getPageStream(PdfPage page) {
        PdfStream stream = page.getLastContentStream();
        return stream == null || stream.getOutputStream() == null || stream.containsKey(PdfName.Filter) ? page.newContentStreamAfter() : stream;
    }

    private static <T> List<T> iteratorToList(Iterator<T> iterator) {
        ArrayList<T> list = new ArrayList<T>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static float[] calculateTransformationMatrix(Vector expectedMin, Vector expectedMax, Vector actualMin, Vector actualMax) {
        float[] result;
        result = new float[]{(expectedMin.get(0) - expectedMax.get(0)) / (actualMin.get(0) - actualMax.get(0)), 0.0f, 0.0f, (expectedMin.get(1) - expectedMax.get(1)) / (actualMin.get(1) - actualMax.get(1)), expectedMin.get(0) - actualMin.get(0) * result[0], expectedMin.get(1) - actualMin.get(1) * result[3]};
        return result;
    }

    private static boolean isIdentityMatrix(float a, float b, float c, float d, float e, float f) {
        return Math.abs(1.0f - a) < 1.0E-4f && Math.abs(b) < 1.0E-4f && Math.abs(c) < 1.0E-4f && Math.abs(1.0f - d) < 1.0E-4f && Math.abs(e) < 1.0E-4f && Math.abs(f) < 1.0E-4f;
    }

    private static enum CheckColorMode {
        NONE,
        FILL,
        STROKE,
        FILL_AND_STROKE;

    }
}

