/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfObject;

public abstract class PdfObjectWrapper<T extends PdfObject> {
    private T pdfObject = null;

    protected PdfObjectWrapper(T pdfObject) {
        this.pdfObject = pdfObject;
        if (this.isWrappedObjectMustBeIndirect()) {
            PdfObjectWrapper.markObjectAsIndirect(this.pdfObject);
        }
    }

    public T getPdfObject() {
        return this.pdfObject;
    }

    public PdfObjectWrapper<T> makeIndirect(PdfDocument document, PdfIndirectReference reference) {
        ((PdfObject)this.getPdfObject()).makeIndirect(document, reference);
        return this;
    }

    public PdfObjectWrapper<T> makeIndirect(PdfDocument document) {
        return this.makeIndirect(document, null);
    }

    public PdfObjectWrapper<T> setModified() {
        ((PdfObject)this.pdfObject).setModified();
        return this;
    }

    public void flush() {
        ((PdfObject)this.pdfObject).flush();
    }

    public boolean isFlushed() {
        return ((PdfObject)this.pdfObject).isFlushed();
    }

    protected abstract boolean isWrappedObjectMustBeIndirect();

    protected void setPdfObject(T pdfObject) {
        this.pdfObject = pdfObject;
    }

    protected void setForbidRelease() {
        if (this.pdfObject != null) {
            ((PdfObject)this.pdfObject).setState((short)128);
        }
    }

    protected void unsetForbidRelease() {
        if (this.pdfObject != null) {
            ((PdfObject)this.pdfObject).clearState((short)128);
        }
    }

    protected void ensureUnderlyingObjectHasIndirectReference() {
        if (((PdfObject)this.getPdfObject()).getIndirectReference() == null) {
            throw new PdfException("To manually flush this wrapper, you have to ensure that the object behind this wrapper is added to the document, i.e. it has an indirect reference.");
        }
    }

    protected static void markObjectAsIndirect(PdfObject pdfObject) {
        if (pdfObject.getIndirectReference() == null) {
            pdfObject.setState((short)64);
        }
    }

    protected static void ensureObjectIsAddedToDocument(PdfObject object) {
        if (object.getIndirectReference() == null) {
            throw new PdfException("Object must be indirect to work with this wrapper.");
        }
    }
}

