/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.source.ByteBuffer;
import com.itextpdf.io.source.ByteUtils;
import com.itextpdf.io.source.IRandomAccessSource;
import com.itextpdf.io.source.PdfTokenizer;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.io.source.RandomAccessSourceFactory;
import com.itextpdf.io.source.WindowRandomAccessSource;
import com.itextpdf.kernel.crypto.securityhandler.UnsupportedSecurityHandlerException;
import com.itextpdf.kernel.exceptions.InvalidXRefPrevException;
import com.itextpdf.kernel.exceptions.MemoryLimitsAwareException;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.exceptions.XrefCycledReferencesException;
import com.itextpdf.kernel.pdf.IndirectFilterUtils;
import com.itextpdf.kernel.pdf.MemoryLimitsAwareHandler;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfConformance;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfEncryption;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNull;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.PdfXrefTable;
import com.itextpdf.kernel.pdf.ReaderProperties;
import com.itextpdf.kernel.pdf.filters.FilterHandlers;
import com.itextpdf.kernel.pdf.filters.IFilterHandler;
import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfReader
implements Closeable {
    public static final StrictnessLevel DEFAULT_STRICTNESS_LEVEL = StrictnessLevel.LENIENT;
    private static final String endstream1 = "endstream";
    private static final String endstream2 = "\nendstream";
    private static final String endstream3 = "\r\nendstream";
    private static final String endstream4 = "\rendstream";
    private static final byte[] endstream = ByteUtils.getIsoBytes((String)"endstream");
    private static final byte[] endobj = ByteUtils.getIsoBytes((String)"endobj");
    protected static boolean correctStreamLength = true;
    private boolean unethicalReading;
    private boolean memorySavingMode;
    private StrictnessLevel strictnessLevel = DEFAULT_STRICTNESS_LEVEL;
    private PdfIndirectReference currentIndirectReference;
    private XrefProcessor xrefProcessor = new XrefProcessor();
    protected PdfTokenizer tokens;
    protected PdfEncryption decrypt;
    protected PdfVersion headerPdfVersion;
    protected long lastXref;
    protected long eofPos;
    protected PdfDictionary trailer;
    protected PdfDocument pdfDocument;
    protected ReaderProperties properties;
    protected boolean encrypted = false;
    protected boolean rebuiltXref = false;
    protected boolean hybridXref = false;
    protected boolean fixedXref = false;
    protected boolean xrefStm = false;
    private XMPMeta xmpMeta;
    private PdfConformance pdfConformance;

    public PdfReader(IRandomAccessSource byteSource, ReaderProperties properties) throws IOException {
        this(byteSource, properties, false);
    }

    public PdfReader(InputStream is, ReaderProperties properties) throws IOException {
        this(new RandomAccessSourceFactory().extractOrCreateSource(is), properties, true);
    }

    public PdfReader(File file) throws FileNotFoundException, IOException {
        this(file.getAbsolutePath());
    }

    public PdfReader(InputStream is) throws IOException {
        this(is, new ReaderProperties());
    }

    public PdfReader(String filename, ReaderProperties properties) throws IOException {
        this(new RandomAccessSourceFactory().setForceRead(false).createBestSource(filename), properties, true);
    }

    public PdfReader(String filename) throws IOException {
        this(filename, new ReaderProperties());
    }

    public PdfReader(File file, ReaderProperties properties) throws IOException {
        this(file.getAbsolutePath(), properties);
    }

    PdfReader(IRandomAccessSource byteSource, ReaderProperties properties, boolean closeStream) throws IOException {
        this.properties = properties;
        this.tokens = PdfReader.getOffsetTokeniser(byteSource, closeStream);
    }

    @Override
    public void close() throws IOException {
        this.tokens.close();
    }

    public PdfReader setUnethicalReading(boolean unethicalReading) {
        this.unethicalReading = unethicalReading;
        return this;
    }

    public PdfReader setMemorySavingMode(boolean memorySavingMode) {
        this.memorySavingMode = memorySavingMode;
        return this;
    }

    public StrictnessLevel getStrictnessLevel() {
        return this.strictnessLevel;
    }

    public PdfReader setStrictnessLevel(StrictnessLevel strictnessLevel) {
        this.strictnessLevel = strictnessLevel == null ? DEFAULT_STRICTNESS_LEVEL : strictnessLevel;
        return this;
    }

    public boolean isCloseStream() {
        return this.tokens.isCloseStream();
    }

    public void setCloseStream(boolean closeStream) {
        this.tokens.setCloseStream(closeStream);
    }

    public boolean hasRebuiltXref() {
        if (this.pdfDocument == null || !this.pdfDocument.getXref().isReadingCompleted()) {
            throw new PdfException("The PDF document has not been read yet. Document reading occurs in PdfDocument class constructor");
        }
        return this.rebuiltXref;
    }

    public boolean hasHybridXref() {
        if (this.pdfDocument == null || !this.pdfDocument.getXref().isReadingCompleted()) {
            throw new PdfException("The PDF document has not been read yet. Document reading occurs in PdfDocument class constructor");
        }
        return this.hybridXref;
    }

    public boolean hasXrefStm() {
        if (this.pdfDocument == null || !this.pdfDocument.getXref().isReadingCompleted()) {
            throw new PdfException("The PDF document has not been read yet. Document reading occurs in PdfDocument class constructor");
        }
        return this.xrefStm;
    }

    public boolean hasFixedXref() {
        if (this.pdfDocument == null || !this.pdfDocument.getXref().isReadingCompleted()) {
            throw new PdfException("The PDF document has not been read yet. Document reading occurs in PdfDocument class constructor");
        }
        return this.fixedXref;
    }

    public long getLastXref() {
        if (this.pdfDocument == null || !this.pdfDocument.getXref().isReadingCompleted()) {
            throw new PdfException("The PDF document has not been read yet. Document reading occurs in PdfDocument class constructor");
        }
        return this.lastXref;
    }

    public byte[] readStreamBytes(PdfStream stream, boolean decode) throws IOException {
        byte[] b = this.readStreamBytesRaw(stream);
        if (decode && b != null) {
            return PdfReader.decodeBytes(b, stream);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readStreamBytesRaw(PdfStream stream) throws IOException {
        long offset;
        if (stream == null) {
            throw new PdfException("Unable to read stream bytes because stream is null.");
        }
        PdfName type = stream.getAsName(PdfName.Type);
        if (!PdfName.XRef.equals(type) && !PdfName.ObjStm.equals(type)) {
            this.checkPdfStreamLength(stream);
        }
        if ((offset = stream.getOffset()) <= 0L) {
            return null;
        }
        int length = stream.getLength();
        if (length <= 0) {
            return new byte[0];
        }
        RandomAccessFileOrArray file = this.tokens.getSafeFile();
        byte[] bytes = null;
        try {
            file.seek(offset);
            bytes = new byte[length];
            file.readFully(bytes);
            boolean embeddedStream = this.pdfDocument.doesStreamBelongToEmbeddedFile(stream);
            if (this.decrypt != null && (!this.decrypt.isEmbeddedFilesOnly() || embeddedStream)) {
                PdfObject filter = stream.get(PdfName.Filter, true);
                boolean skip = false;
                if (filter != null) {
                    if (filter.isFlushed()) {
                        IndirectFilterUtils.throwFlushedFilterException(stream);
                    }
                    if (PdfName.Crypt.equals(filter)) {
                        skip = true;
                    } else if (filter.getType() == 1) {
                        PdfArray filters = (PdfArray)filter;
                        for (int k = 0; k < filters.size(); ++k) {
                            if (filters.get(k).isFlushed()) {
                                IndirectFilterUtils.throwFlushedFilterException(stream);
                            }
                            if (filters.isEmpty() || !PdfName.Crypt.equals(filters.get(k, true))) continue;
                            skip = true;
                            break;
                        }
                    }
                    filter.release();
                }
                if (!skip) {
                    this.decrypt.setHashKeyForNextObject(stream.getIndirectReference().getObjNumber(), stream.getIndirectReference().getGenNumber());
                    bytes = this.decrypt.decryptByteArray(bytes);
                }
            }
        }
        finally {
            try {
                file.close();
            }
            catch (Exception exception) {}
        }
        return bytes;
    }

    public InputStream readStream(PdfStream stream, boolean decode) throws IOException {
        byte[] bytes = this.readStreamBytes(stream, decode);
        return bytes != null ? new ByteArrayInputStream(bytes) : null;
    }

    public static byte[] decodeBytes(byte[] b, PdfDictionary streamDictionary) {
        return PdfReader.decodeBytes(b, streamDictionary, FilterHandlers.getDefaultFilterHandlers());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] decodeBytes(byte[] b, PdfDictionary streamDictionary, Map<PdfName, IFilterHandler> filterHandlers) {
        boolean memoryLimitsAwarenessRequired;
        if (b == null) {
            return null;
        }
        PdfObject filter = streamDictionary.get(PdfName.Filter);
        PdfArray filters = new PdfArray();
        if (filter != null) {
            if (filter.getType() == 6) {
                filters.add(filter);
            } else if (filter.getType() == 1) {
                filters = (PdfArray)filter;
            }
        }
        MemoryLimitsAwareHandler memoryLimitsAwareHandler = null;
        if (null != streamDictionary.getIndirectReference()) {
            memoryLimitsAwareHandler = streamDictionary.getIndirectReference().getDocument().memoryLimitsAwareHandler;
        }
        boolean bl = memoryLimitsAwarenessRequired = null != memoryLimitsAwareHandler && memoryLimitsAwareHandler.isMemoryLimitsAwarenessRequiredOnDecompression(filters);
        if (memoryLimitsAwarenessRequired) {
            memoryLimitsAwareHandler.beginDecompressedPdfStreamProcessing();
        }
        PdfArray dp = new PdfArray();
        PdfObject dpo = streamDictionary.get(PdfName.DecodeParms);
        if (dpo == null || dpo.getType() != 3 && dpo.getType() != 1) {
            if (dpo != null) {
                dpo.release();
            }
            dpo = streamDictionary.get(PdfName.DP);
        }
        if (dpo != null) {
            if (dpo.getType() == 3) {
                dp.add(dpo);
            } else if (dpo.getType() == 1) {
                dp = (PdfArray)dpo;
            }
            dpo.release();
        }
        for (int j = 0; j < filters.size(); ++j) {
            PdfDictionary decodeParams;
            PdfName filterName = (PdfName)filters.get(j);
            IFilterHandler filterHandler = filterHandlers.get(filterName);
            if (filterHandler == null) {
                throw new PdfException("Filter {0} is not supported.").setMessageParams(filterName);
            }
            if (j < dp.size()) {
                PdfObject dpEntry = dp.get(j, true);
                if (dpEntry == null || dpEntry.getType() == 7) {
                    decodeParams = null;
                } else {
                    if (dpEntry.getType() != 3) throw new PdfException("Decode parameter type {0} is not supported.").setMessageParams(dpEntry.getClass().toString());
                    decodeParams = (PdfDictionary)dpEntry;
                }
            } else {
                decodeParams = null;
            }
            b = filterHandler.decode(b, filterName, decodeParams, streamDictionary);
            if (!memoryLimitsAwarenessRequired) continue;
            memoryLimitsAwareHandler.considerBytesOccupiedByDecompressedPdfStream(b.length);
        }
        if (!memoryLimitsAwarenessRequired) return b;
        memoryLimitsAwareHandler.endDecompressedPdfStreamProcessing();
        return b;
    }

    public RandomAccessFileOrArray getSafeFile() {
        return this.tokens.getSafeFile();
    }

    public long getFileLength() {
        return this.tokens.getSafeFile().length();
    }

    public boolean isOpenedWithFullPermission() {
        if (this.pdfDocument == null || !this.pdfDocument.getXref().isReadingCompleted()) {
            throw new PdfException("The PDF document has not been read yet. Document reading occurs in PdfDocument class constructor");
        }
        return !this.encrypted || this.decrypt.isOpenedWithFullPermission() || this.unethicalReading;
    }

    public int getPermissions() {
        if (this.pdfDocument == null || !this.pdfDocument.getXref().isReadingCompleted()) {
            throw new PdfException("The PDF document has not been read yet. Document reading occurs in PdfDocument class constructor");
        }
        int perm = 0;
        if (this.encrypted && this.decrypt.getPermissions() != null) {
            perm = this.decrypt.getPermissions();
        }
        return perm;
    }

    public int getCryptoMode() {
        if (this.pdfDocument == null || !this.pdfDocument.getXref().isReadingCompleted()) {
            throw new PdfException("The PDF document has not been read yet. Document reading occurs in PdfDocument class constructor");
        }
        if (this.decrypt == null) {
            return -1;
        }
        return this.decrypt.getCryptoMode();
    }

    public PdfConformance getPdfConformance() {
        if (this.pdfConformance == null) {
            if (this.pdfDocument == null || !this.pdfDocument.getXref().isReadingCompleted()) {
                throw new PdfException("The PDF document has not been read yet. Document reading occurs in PdfDocument class constructor");
            }
            try {
                if (this.xmpMeta == null && this.pdfDocument.getXmpMetadata() != null) {
                    this.xmpMeta = this.pdfDocument.getXmpMetadata();
                }
                this.pdfConformance = PdfConformance.getConformance(this.xmpMeta);
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return this.pdfConformance;
    }

    public byte[] computeUserPassword() {
        if (this.pdfDocument == null || !this.pdfDocument.getXref().isReadingCompleted()) {
            throw new PdfException("The PDF document has not been read yet. Document reading occurs in PdfDocument class constructor");
        }
        if (!this.encrypted || !this.decrypt.isOpenedWithFullPermission()) {
            return null;
        }
        return this.decrypt.computeUserPassword(this.properties.password);
    }

    public byte[] getOriginalFileId() {
        if (this.pdfDocument == null || !this.pdfDocument.getXref().isReadingCompleted()) {
            throw new PdfException("The PDF document has not been read yet. Document reading occurs in PdfDocument class constructor");
        }
        PdfArray id = this.trailer.getAsArray(PdfName.ID);
        if (id != null && id.size() == 2) {
            return ByteUtils.getIsoBytes((String)id.getAsString(0).getValue());
        }
        return new byte[0];
    }

    public byte[] getModifiedFileId() {
        if (this.pdfDocument == null || !this.pdfDocument.getXref().isReadingCompleted()) {
            throw new PdfException("The PDF document has not been read yet. Document reading occurs in PdfDocument class constructor");
        }
        PdfArray id = this.trailer.getAsArray(PdfName.ID);
        if (id != null && id.size() == 2) {
            return ByteUtils.getIsoBytes((String)id.getAsString(1).getValue());
        }
        return new byte[0];
    }

    public boolean isEncrypted() {
        if (this.pdfDocument == null || !this.pdfDocument.getXref().isReadingCompleted()) {
            throw new PdfException("The PDF document has not been read yet. Document reading occurs in PdfDocument class constructor");
        }
        return this.encrypted;
    }

    public ReaderProperties getPropertiesCopy() {
        return new ReaderProperties(this.properties);
    }

    protected void readPdf() throws IOException {
        String version = this.tokens.checkPdfHeader();
        try {
            this.headerPdfVersion = PdfVersion.fromString(version);
        }
        catch (IllegalArgumentException exc) {
            throw new PdfException("PDF version is not valid.", version);
        }
        try {
            this.readXref();
        }
        catch (InvalidXRefPrevException | MemoryLimitsAwareException | XrefCycledReferencesException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            if (StrictnessLevel.CONSERVATIVE.isStricter(this.getStrictnessLevel())) {
                PdfReader.logXrefException(ex);
                this.rebuildXref();
            }
            throw ex;
        }
        this.pdfDocument.getXref().markReadingCompleted();
        this.readDecryptObj();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readObjectStream(PdfStream objectStream) throws IOException {
        if (objectStream == null) {
            throw new PdfException("Unable to read object stream.");
        }
        int objectStreamNumber = objectStream.getIndirectReference().getObjNumber();
        int first = objectStream.getAsNumber(PdfName.First).intValue();
        int n = objectStream.getAsNumber(PdfName.N).intValue();
        byte[] bytes = this.readStreamBytes(objectStream, true);
        PdfTokenizer saveTokens = this.tokens;
        try {
            int k;
            this.tokens = new PdfTokenizer(new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(bytes)));
            int[] address = new int[n];
            int[] objNumber = new int[n];
            boolean ok = true;
            for (k = 0; k < n && (ok = this.tokens.nextToken()); ++k) {
                if (this.tokens.getTokenType() != PdfTokenizer.TokenType.Number) {
                    ok = false;
                    break;
                }
                objNumber[k] = this.tokens.getIntValue();
                ok = this.tokens.nextToken();
                if (!ok) break;
                if (this.tokens.getTokenType() != PdfTokenizer.TokenType.Number) {
                    ok = false;
                    break;
                }
                address[k] = this.tokens.getIntValue() + first;
            }
            if (!ok) {
                throw new PdfException("Error while reading Object Stream.");
            }
            for (k = 0; k < n; ++k) {
                PdfObject obj;
                this.tokens.seek((long)address[k]);
                this.tokens.nextToken();
                PdfIndirectReference reference = this.pdfDocument.getXref().get(objNumber[k]);
                if (reference.refersTo != null || reference.getObjStreamNumber() != objectStreamNumber) continue;
                if (this.tokens.getTokenType() == PdfTokenizer.TokenType.Number) {
                    obj = new PdfNumber(this.tokens.getByteContent());
                } else {
                    this.tokens.seek((long)address[k]);
                    obj = this.readObject(false, true);
                }
                reference.setRefersTo(obj);
                ((PdfObject)obj).setIndirectReference(reference);
            }
            objectStream.getIndirectReference().setState((short)16);
        }
        finally {
            this.tokens = saveTokens;
        }
    }

    protected PdfObject readObject(PdfIndirectReference reference) {
        return this.readObject(reference, true);
    }

    protected PdfObject readObject(boolean readAsDirect) throws IOException {
        return this.readObject(readAsDirect, false);
    }

    protected PdfObject readReference(boolean readAsDirect) {
        int num = this.tokens.getObjNr();
        if (num < 0) {
            return this.createPdfNullInstance(readAsDirect);
        }
        PdfXrefTable table = this.pdfDocument.getXref();
        PdfIndirectReference reference = table.get(num);
        if (reference != null) {
            if (reference.isFree()) {
                Logger logger = LoggerFactory.getLogger(PdfReader.class);
                logger.warn(MessageFormatUtil.format((String)"Invalid indirect reference {0} {1} R", (Object[])new Object[]{this.tokens.getObjNr(), this.tokens.getGenNr()}));
                return this.createPdfNullInstance(readAsDirect);
            }
            if (reference.getGenNumber() != this.tokens.getGenNr()) {
                if (this.fixedXref) {
                    Logger logger = LoggerFactory.getLogger(PdfReader.class);
                    logger.warn(MessageFormatUtil.format((String)"Invalid indirect reference {0} {1} R", (Object[])new Object[]{this.tokens.getObjNr(), this.tokens.getGenNr()}));
                    return this.createPdfNullInstance(readAsDirect);
                }
                throw new PdfException(MessageFormatUtil.format((String)"Invalid indirect reference {0} {1} R.", (Object[])new Object[]{reference.getObjNumber(), reference.getGenNumber()}), reference);
            }
        } else {
            if (table.isReadingCompleted()) {
                Logger logger = LoggerFactory.getLogger(PdfReader.class);
                logger.warn(MessageFormatUtil.format((String)"Invalid indirect reference {0} {1} R", (Object[])new Object[]{this.tokens.getObjNr(), this.tokens.getGenNr()}));
                return this.createPdfNullInstance(readAsDirect);
            }
            reference = table.add((PdfIndirectReference)new PdfIndirectReference(this.pdfDocument, num, this.tokens.getGenNr(), 0L).setState((short)4));
        }
        return reference;
    }

    protected PdfObject readObject(boolean readAsDirect, boolean objStm) throws IOException {
        this.tokens.nextValidToken();
        PdfTokenizer.TokenType type = this.tokens.getTokenType();
        switch (type) {
            case StartDic: {
                boolean hasNext;
                PdfDictionary dict = this.readDictionary(objStm);
                long pos = this.tokens.getPosition();
                while ((hasNext = this.tokens.nextToken()) && this.tokens.getTokenType() == PdfTokenizer.TokenType.Comment) {
                }
                if (hasNext && this.tokens.tokenValueEqualsTo(PdfTokenizer.Stream)) {
                    int ch;
                    while ((ch = this.tokens.read()) == 32 || ch == 9 || ch == 0 || ch == 12) {
                    }
                    if (ch != 10) {
                        ch = this.tokens.read();
                    }
                    if (ch != 10) {
                        this.tokens.backOnePosition(ch);
                    }
                    PdfStream pdfStream = new PdfStream(this.tokens.getPosition(), dict);
                    this.tokens.seek(pdfStream.getOffset() + (long)pdfStream.getLength());
                    return pdfStream;
                }
                this.tokens.seek(pos);
                return dict;
            }
            case StartArray: {
                return this.readArray(objStm);
            }
            case Number: {
                return new PdfNumber(this.tokens.getByteContent());
            }
            case String: {
                PdfString pdfString = new PdfString(this.tokens.getByteContent(), this.tokens.isHexString());
                if (this.encrypted && !this.decrypt.isEmbeddedFilesOnly() && !objStm) {
                    pdfString.setDecryption(this.currentIndirectReference.getObjNumber(), this.currentIndirectReference.getGenNumber(), this.decrypt);
                }
                return pdfString;
            }
            case Name: {
                return this.readPdfName(readAsDirect);
            }
            case Ref: {
                return this.readReference(readAsDirect);
            }
            case EndOfFile: {
                throw new PdfException("Unexpected end of file.");
            }
        }
        if (this.tokens.tokenValueEqualsTo(PdfTokenizer.Null)) {
            return this.createPdfNullInstance(readAsDirect);
        }
        if (this.tokens.tokenValueEqualsTo(PdfTokenizer.True)) {
            if (readAsDirect) {
                return PdfBoolean.TRUE;
            }
            return new PdfBoolean(true);
        }
        if (this.tokens.tokenValueEqualsTo(PdfTokenizer.False)) {
            if (readAsDirect) {
                return PdfBoolean.FALSE;
            }
            return new PdfBoolean(false);
        }
        return null;
    }

    protected PdfName readPdfName(boolean readAsDirect) {
        PdfName cachedName;
        if (readAsDirect && (cachedName = PdfName.staticNames.get(this.tokens.getStringValue())) != null) {
            return cachedName;
        }
        return new PdfName(this.tokens.getByteContent());
    }

    protected PdfDictionary readDictionary(boolean objStm) throws IOException {
        PdfDictionary dic = new PdfDictionary();
        while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() == PdfTokenizer.TokenType.EndDic) break;
            if (this.tokens.getTokenType() != PdfTokenizer.TokenType.Name) {
                this.tokens.throwError("Dictionary key {0} is not a name.", new Object[]{this.tokens.getStringValue()});
            }
            PdfName name = this.readPdfName(true);
            PdfObject obj = this.readObject(true, objStm);
            if (obj == null) {
                if (this.tokens.getTokenType() == PdfTokenizer.TokenType.EndDic) {
                    this.tokens.throwError(MessageFormatUtil.format((String)"unexpected {0} was encountered.", (Object[])new Object[]{">>"}), new Object[0]);
                }
                if (this.tokens.getTokenType() == PdfTokenizer.TokenType.EndArray) {
                    this.tokens.throwError(MessageFormatUtil.format((String)"unexpected {0} was encountered.", (Object[])new Object[]{"]"}), new Object[0]);
                }
            }
            dic.put(name, obj);
        }
        return dic;
    }

    protected PdfArray readArray(boolean objStm) throws IOException {
        PdfArray array = new PdfArray();
        while (true) {
            PdfObject obj;
            if ((obj = this.readObject(true, objStm)) == null) {
                if (this.tokens.getTokenType() == PdfTokenizer.TokenType.EndArray) break;
                this.processArrayReadError();
                break;
            }
            array.add(obj);
        }
        return array;
    }

    protected void readXref() throws IOException {
        long startxref;
        this.tokens.seek(this.tokens.getStartxref());
        this.tokens.nextToken();
        if (!this.tokens.tokenValueEqualsTo(PdfTokenizer.Startxref)) {
            throw new PdfException("PDF startxref not found.", this.tokens);
        }
        this.tokens.nextToken();
        if (this.tokens.getTokenType() != PdfTokenizer.TokenType.Number) {
            throw new PdfException("PDF startxref is not followed by a number.", this.tokens);
        }
        this.lastXref = startxref = this.tokens.getLongValue();
        this.eofPos = this.tokens.getPosition();
        try {
            if (this.readXrefStream(startxref)) {
                this.xrefStm = true;
                return;
            }
        }
        catch (InvalidXRefPrevException | MemoryLimitsAwareException | XrefCycledReferencesException exceptionWhileReadingXrefStream) {
            throw exceptionWhileReadingXrefStream;
        }
        catch (Exception exceptionWhileReadingXrefStream) {
            // empty catch block
        }
        this.pdfDocument.getXref().clear();
        this.tokens.seek(startxref);
        PdfDictionary trailer2 = this.trailer = this.readXrefSection();
        HashSet<Long> alreadyVisitedXrefTables = new HashSet<Long>();
        while (true) {
            alreadyVisitedXrefTables.add(startxref);
            PdfNumber prev = this.getXrefPrev(trailer2.get(PdfName.Prev, false));
            if (prev == null) break;
            long prevXrefOffset = prev.longValue();
            if (alreadyVisitedXrefTables.contains(prevXrefOffset)) {
                if (StrictnessLevel.CONSERVATIVE.isStricter(this.getStrictnessLevel())) {
                    throw new PdfException("Trailer prev entry points to its own cross reference section.");
                }
                throw new XrefCycledReferencesException("Xref table has cycled references. Prev pointer indicates an already visited xref table.");
            }
            startxref = prevXrefOffset;
            this.tokens.seek(startxref);
            trailer2 = this.readXrefSection();
        }
        Integer xrefSize = this.trailer.getAsInt(PdfName.Size);
        if (xrefSize == null) {
            throw new PdfException("Invalid xref table.");
        }
    }

    protected PdfDictionary readXrefSection() throws IOException {
        this.tokens.nextValidToken();
        if (!this.tokens.tokenValueEqualsTo(PdfTokenizer.Xref)) {
            this.tokens.throwError("xref subsection not found.", new Object[0]);
        }
        PdfXrefTable xref = this.pdfDocument.getXref();
        block2: while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.tokenValueEqualsTo(PdfTokenizer.Trailer)) break;
            if (this.tokens.getTokenType() != PdfTokenizer.TokenType.Number) {
                this.tokens.throwError("Object number of the first object in this xref subsection not found.", new Object[0]);
            }
            int start = this.tokens.getIntValue();
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != PdfTokenizer.TokenType.Number) {
                this.tokens.throwError("Number of entries in this xref subsection not found.", new Object[0]);
            }
            int end = this.tokens.getIntValue() + start;
            int num = start;
            while (true) {
                block19: {
                    boolean refFirstEncountered;
                    PdfIndirectReference reference;
                    long pos;
                    block21: {
                        boolean refReadingState;
                        block20: {
                            int gen;
                            block18: {
                                if (num >= end) continue block2;
                                this.tokens.nextValidToken();
                                pos = this.tokens.getLongValue();
                                this.tokens.nextValidToken();
                                gen = this.tokens.getIntValue();
                                this.tokens.nextValidToken();
                                if (pos != 0L || gen != 65535 || num != 1 || start == 0) break block18;
                                num = 0;
                                --end;
                                break block19;
                            }
                            reference = xref.get(num);
                            refReadingState = reference != null && reference.checkState((short)4) && reference.getGenNumber() == gen;
                            boolean bl = refFirstEncountered = reference == null || !refReadingState && reference.getDocument() == null;
                            if (!refFirstEncountered) break block20;
                            reference = new PdfIndirectReference(this.pdfDocument, num, gen, pos);
                            break block21;
                        }
                        if (!refReadingState) break block19;
                        reference.setOffset(pos);
                        reference.clearState((short)4);
                    }
                    if (this.tokens.tokenValueEqualsTo(PdfTokenizer.N)) {
                        if (pos == 0L) {
                            this.tokens.throwError("file position 0 cross reference entry in this xref subsection.", new Object[0]);
                        }
                    } else if (this.tokens.tokenValueEqualsTo(PdfTokenizer.F)) {
                        if (refFirstEncountered) {
                            reference.setState((short)2);
                        }
                    } else {
                        this.tokens.throwError("Invalid cross reference entry in this xref subsection.", new Object[0]);
                    }
                    if (refFirstEncountered) {
                        xref.add(reference);
                    }
                }
                ++num;
            }
            break;
        }
        this.processXref(xref);
        PdfDictionary trailer = (PdfDictionary)this.readObject(false);
        PdfObject xrs = trailer.get(PdfName.XRefStm);
        if (xrs != null && xrs.getType() == 8) {
            int loc = ((PdfNumber)xrs).intValue();
            try {
                this.readXrefStream(loc);
                this.xrefStm = true;
                this.hybridXref = true;
            }
            catch (IOException e) {
                xref.clear();
                throw e;
            }
        }
        return trailer;
    }

    protected boolean readXrefStream(long ptr) throws IOException {
        HashSet<Long> alreadyVisitedXrefStreams = new HashSet<Long>();
        while (ptr != -1L) {
            PdfArray index;
            PdfStream xrefStream;
            this.tokens.seek(ptr);
            if (!this.tokens.nextToken()) {
                return false;
            }
            if (this.tokens.getTokenType() != PdfTokenizer.TokenType.Number) {
                return false;
            }
            if (!this.tokens.nextToken() || this.tokens.getTokenType() != PdfTokenizer.TokenType.Number) {
                return false;
            }
            if (!this.tokens.nextToken() || !this.tokens.tokenValueEqualsTo(PdfTokenizer.Obj)) {
                return false;
            }
            alreadyVisitedXrefStreams.add(ptr);
            PdfXrefTable xref = this.pdfDocument.getXref();
            PdfObject object = this.readObject(false);
            if (object.getType() == 9) {
                xrefStream = (PdfStream)object;
                if (!PdfName.XRef.equals(xrefStream.get(PdfName.Type))) {
                    return false;
                }
            } else {
                return false;
            }
            if (this.trailer == null) {
                this.trailer = new PdfDictionary();
                this.trailer.putAll(xrefStream);
                this.trailer.remove(PdfName.DecodeParms);
                this.trailer.remove(PdfName.Filter);
                this.trailer.remove(PdfName.Prev);
                this.trailer.remove(PdfName.Length);
            }
            int size = ((PdfNumber)xrefStream.get(PdfName.Size)).intValue();
            PdfObject obj = xrefStream.get(PdfName.Index);
            if (obj == null) {
                index = new PdfArray();
                index.add(new PdfNumber(0));
                index.add(new PdfNumber(size));
            } else {
                index = (PdfArray)obj;
            }
            PdfArray w = xrefStream.getAsArray(PdfName.W);
            long prev = -1L;
            obj = this.getXrefPrev(xrefStream.get(PdfName.Prev, false));
            if (obj != null) {
                prev = ((PdfNumber)obj).longValue();
            }
            xref.setCapacity(size);
            byte[] b = this.readStreamBytes(xrefStream, true);
            int bptr = 0;
            int[] wc = new int[3];
            for (int k = 0; k < 3; ++k) {
                wc[k] = w.getAsNumber(k).intValue();
            }
            for (int idx = 0; idx < index.size(); idx += 2) {
                int start = index.getAsNumber(idx).intValue();
                int length = index.getAsNumber(idx + 1).intValue();
                xref.setCapacity(start + length);
                while (length-- > 0) {
                    boolean refFirstEncountered;
                    PdfIndirectReference newReference;
                    int type = 1;
                    if (wc[0] > 0) {
                        type = 0;
                        for (int k = 0; k < wc[0]; ++k) {
                            type = (type << 8) + (b[bptr++] & 0xFF);
                        }
                    }
                    long field2 = 0L;
                    for (int k = 0; k < wc[1]; ++k) {
                        field2 = (field2 << 8) + (long)(b[bptr++] & 0xFF);
                    }
                    int field3 = 0;
                    for (int k = 0; k < wc[2]; ++k) {
                        field3 = (field3 << 8) + (b[bptr++] & 0xFF);
                    }
                    int base = start;
                    switch (type) {
                        case 0: {
                            newReference = (PdfIndirectReference)new PdfIndirectReference(this.pdfDocument, base, field3, field2).setState((short)2);
                            break;
                        }
                        case 1: {
                            newReference = new PdfIndirectReference(this.pdfDocument, base, field3, field2);
                            break;
                        }
                        case 2: {
                            newReference = new PdfIndirectReference(this.pdfDocument, base, 0, field3);
                            newReference.setObjStreamNumber((int)field2);
                            break;
                        }
                        default: {
                            throw new PdfException("Invalid xref stream.");
                        }
                    }
                    PdfIndirectReference reference = xref.get(base);
                    boolean refReadingState = reference != null && reference.checkState((short)4) && reference.getGenNumber() == newReference.getGenNumber();
                    boolean bl = refFirstEncountered = reference == null || !refReadingState && reference.getDocument() == null;
                    if (refFirstEncountered) {
                        xref.add(newReference);
                    } else if (refReadingState) {
                        reference.setOffset(newReference.getOffset());
                        reference.setObjStreamNumber(newReference.getObjStreamNumber());
                        reference.clearState((short)4);
                    }
                    ++start;
                }
            }
            this.processXref(xref);
            ptr = prev;
            if (!alreadyVisitedXrefStreams.contains(ptr)) continue;
            throw new XrefCycledReferencesException("Xref stream has cycled references. Prev pointer indicates an already visited xref stream.");
        }
        return true;
    }

    protected void fixXref() throws IOException {
        this.fixedXref = true;
        PdfXrefTable xref = this.pdfDocument.getXref();
        this.tokens.seek(0L);
        ByteBuffer buffer = new ByteBuffer(24);
        PdfTokenizer lineTokeniser = new PdfTokenizer(new RandomAccessFileOrArray((IRandomAccessSource)new ReusableRandomAccessSource(buffer)));
        while (true) {
            int[] obj;
            long pos = this.tokens.getPosition();
            buffer.reset();
            if (!this.tokens.readLineSegment(buffer, true)) break;
            if (buffer.get(0) < 48 || buffer.get(0) > 57 || (obj = PdfTokenizer.checkObjectStart((PdfTokenizer)lineTokeniser)) == null) continue;
            int num = obj[0];
            int gen = obj[1];
            PdfIndirectReference reference = xref.get(num);
            if (reference == null || reference.getGenNumber() != gen) continue;
            reference.fixOffset(pos);
        }
    }

    protected void rebuildXref() throws IOException {
        this.xrefStm = false;
        this.hybridXref = false;
        this.rebuiltXref = true;
        PdfXrefTable xref = this.pdfDocument.getXref();
        xref.clear();
        this.tokens.seek(0L);
        this.trailer = null;
        ByteBuffer buffer = new ByteBuffer(24);
        try (PdfTokenizer lineTokenizer = new PdfTokenizer(new RandomAccessFileOrArray((IRandomAccessSource)new ReusableRandomAccessSource(buffer)));){
            Long trailerIndex = null;
            while (true) {
                int[] obj;
                long pos = this.tokens.getPosition();
                buffer.reset();
                if (!this.tokens.readLineSegment(buffer, true)) break;
                if (buffer.get(0) == 116) {
                    if (!PdfTokenizer.checkTrailer((ByteBuffer)buffer)) continue;
                    this.tokens.seek(pos);
                    this.tokens.nextToken();
                    pos = this.tokens.getPosition();
                    if (this.isCurrentObjectATrailer()) {
                        trailerIndex = pos;
                        continue;
                    }
                    this.tokens.seek(pos);
                    continue;
                }
                if (buffer.get(0) < 48 || buffer.get(0) > 57 || (obj = PdfTokenizer.checkObjectStart((PdfTokenizer)lineTokenizer)) == null) continue;
                int num = obj[0];
                int gen = obj[1];
                if (xref.get(num) != null && xref.get(num).getGenNumber() > gen) continue;
                xref.add(new PdfIndirectReference(this.pdfDocument, num, gen, pos));
            }
            this.setTrailerFromTrailerIndex(trailerIndex);
        }
    }

    private boolean isCurrentObjectATrailer() {
        try {
            PdfDictionary dic = (PdfDictionary)this.readObject(false);
            return dic.get(PdfName.Root, false) != null;
        }
        catch (MemoryLimitsAwareException e) {
            throw e;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void setTrailerFromTrailerIndex(Long trailerIndex) throws IOException {
        if (trailerIndex == null) {
            throw new PdfException("Trailer not found.");
        }
        this.tokens.seek(trailerIndex.longValue());
        PdfDictionary dic = (PdfDictionary)this.readObject(false);
        if (dic.get(PdfName.Root, false) != null) {
            this.trailer = dic;
        }
        if (this.trailer == null) {
            throw new PdfException("Trailer not found.");
        }
    }

    protected PdfNumber getXrefPrev(PdfObject prevObjectToCheck) {
        PdfObject value;
        if (prevObjectToCheck == null) {
            return null;
        }
        if (prevObjectToCheck.getType() == 8) {
            return (PdfNumber)prevObjectToCheck;
        }
        if (prevObjectToCheck.getType() == 5 && StrictnessLevel.CONSERVATIVE.isStricter(this.getStrictnessLevel()) && (value = ((PdfIndirectReference)prevObjectToCheck).getRefersTo(true)) != null && value.getType() == 8) {
            return (PdfNumber)value;
        }
        throw new InvalidXRefPrevException("Prev pointer in xref structure shall be direct number object.");
    }

    boolean isMemorySavingMode() {
        return this.memorySavingMode;
    }

    void setXrefProcessor(XrefProcessor xrefProcessor) {
        this.xrefProcessor = xrefProcessor;
    }

    private void processArrayReadError() {
        String error = MessageFormatUtil.format((String)"unexpected {0} was encountered.", (Object[])new Object[]{new String(this.tokens.getByteContent(), StandardCharsets.UTF_8)});
        if (StrictnessLevel.CONSERVATIVE.isStricter(this.getStrictnessLevel())) {
            Logger logger = LoggerFactory.getLogger(PdfReader.class);
            logger.error(error);
        } else {
            this.tokens.throwError(error, new Object[0]);
        }
    }

    private void readDecryptObj() {
        if (this.encrypted) {
            return;
        }
        PdfDictionary enc = this.trailer.getAsDictionary(PdfName.Encrypt);
        if (enc == null) {
            return;
        }
        this.encrypted = true;
        PdfName filter = enc.getAsName(PdfName.Filter);
        if (PdfName.Adobe_PubSec.equals(filter)) {
            if (this.properties.certificate == null) {
                throw new PdfException("Certificate is not provided. Document is encrypted with public key certificate, it should be passed to PdfReader constructor with properties. See ReaderProperties#setPublicKeySecurityParams() method.");
            }
            this.decrypt = new PdfEncryption(enc, this.properties.certificateKey, this.properties.certificate, this.properties.certificateKeyProvider, this.properties.externalDecryptionProcess);
        } else if (PdfName.Standard.equals(filter)) {
            this.decrypt = new PdfEncryption(enc, this.properties.password, this.getOriginalFileId());
        } else {
            throw new UnsupportedSecurityHandlerException(MessageFormatUtil.format((String)"Failed to open the document. Security handler {0} is not supported", (Object[])new Object[]{filter}));
        }
        this.decrypt.configureEncryptionParametersFromReader(this.pdfDocument, this.trailer);
    }

    private PdfObject readObject(PdfIndirectReference reference, boolean fixXref) {
        if (reference == null) {
            return null;
        }
        if (reference.refersTo != null) {
            return reference.refersTo;
        }
        try {
            this.currentIndirectReference = reference;
            if (reference.getObjStreamNumber() > 0) {
                PdfStream objectStream = (PdfStream)this.pdfDocument.getXref().get(reference.getObjStreamNumber()).getRefersTo(false);
                if (objectStream == null) {
                    throw new PdfException(MessageFormatUtil.format((String)"Unable to read object {0} with object stream number {1} and index {2} from object stream.", (Object[])new Object[]{reference.getObjNumber(), reference.getObjStreamNumber(), reference.getIndex()}));
                }
                this.readObjectStream(objectStream);
                return reference.refersTo;
            }
            if (reference.getOffset() > 0L) {
                PdfObject object;
                try {
                    this.tokens.seek(reference.getOffset());
                    this.tokens.nextValidToken();
                    if (this.tokens.getTokenType() != PdfTokenizer.TokenType.Obj || this.tokens.getObjNr() != reference.getObjNumber() || this.tokens.getGenNr() != reference.getGenNumber()) {
                        this.tokens.throwError("Invalid offset for object {0}.", new Object[]{reference.toString()});
                    }
                    object = this.readObject(false);
                }
                catch (RuntimeException ex) {
                    if (fixXref && reference.getObjStreamNumber() == 0) {
                        this.fixXref();
                        object = this.readObject(reference, false);
                    }
                    throw ex;
                }
                return object != null ? object.setIndirectReference(reference) : null;
            }
            return null;
        }
        catch (IOException e) {
            throw new PdfException("Cannot read PdfObject.", e);
        }
    }

    private void checkPdfStreamLength(PdfStream pdfStream) throws IOException {
        Object line;
        if (!correctStreamLength) {
            return;
        }
        long fileLength = this.tokens.length();
        long start = pdfStream.getOffset();
        boolean calc = false;
        int streamLength = 0;
        PdfNumber pdfNumber = pdfStream.getAsNumber(PdfName.Length);
        if (pdfNumber != null) {
            streamLength = pdfNumber.intValue();
            if ((long)streamLength + start > fileLength - 20L) {
                calc = true;
            } else {
                this.tokens.seek(start + (long)streamLength);
                line = this.tokens.readString(20);
                if (!(((String)line).startsWith(endstream2) || ((String)line).startsWith(endstream3) || ((String)line).startsWith(endstream4) || ((String)line).startsWith(endstream1))) {
                    calc = true;
                }
            }
        } else {
            pdfNumber = new PdfNumber(0);
            pdfStream.put(PdfName.Length, pdfNumber);
            calc = true;
        }
        if (calc) {
            long pos;
            block13: {
                line = new ByteBuffer(16);
                this.tokens.seek(start);
                do {
                    pos = this.tokens.getPosition();
                    line.reset();
                    if (!this.tokens.readLineSegment((ByteBuffer)line, false)) {
                        if (!StrictnessLevel.CONSERVATIVE.isStricter(this.strictnessLevel)) {
                            throw new PdfException("Stream shall end with endstream keyword.");
                        }
                        break block13;
                    }
                    if (line.startsWith(endstream)) break block13;
                } while (!line.startsWith(endobj));
                this.tokens.seek(pos - 16L);
                String s = this.tokens.readString(16);
                int index = s.indexOf(endstream1);
                if (index >= 0) {
                    pos = pos - 16L + (long)index;
                }
            }
            streamLength = (int)(pos - start);
            this.tokens.seek(pos - 2L);
            if (this.tokens.read() == 13) {
                --streamLength;
            }
            this.tokens.seek(pos - 1L);
            if (this.tokens.read() == 10) {
                --streamLength;
            }
            pdfNumber.setValue(streamLength);
            pdfStream.updateLength(streamLength);
        }
    }

    private PdfObject createPdfNullInstance(boolean readAsDirect) {
        if (readAsDirect) {
            return PdfNull.PDF_NULL;
        }
        return new PdfNull();
    }

    private static PdfTokenizer getOffsetTokeniser(IRandomAccessSource byteSource, boolean closeStream) throws IOException {
        int offset;
        PdfTokenizer tok = new PdfTokenizer(new RandomAccessFileOrArray(byteSource));
        try {
            offset = tok.getHeaderOffset();
        }
        catch (com.itextpdf.io.exceptions.IOException ex) {
            if (closeStream) {
                tok.close();
            }
            throw ex;
        }
        if (offset != 0) {
            WindowRandomAccessSource offsetSource = new WindowRandomAccessSource(byteSource, (long)offset);
            tok = new PdfTokenizer(new RandomAccessFileOrArray((IRandomAccessSource)offsetSource));
        }
        return tok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processXref(PdfXrefTable xrefTable) throws IOException {
        long currentPosition = this.tokens.getPosition();
        try {
            this.xrefProcessor.processXref(xrefTable, this.tokens);
        }
        finally {
            this.tokens.seek(currentPosition);
        }
    }

    private static void logXrefException(RuntimeException ex) {
        Logger logger = LoggerFactory.getLogger(PdfReader.class);
        if (ex.getCause() != null) {
            logger.error(MessageFormatUtil.format((String)"Error occurred while reading cross reference table. Cross reference table will be rebuilt. Reason: {0}", (Object[])new Object[]{ex.getCause().getMessage()}));
        } else if (ex.getMessage() != null) {
            logger.error(MessageFormatUtil.format((String)"Error occurred while reading cross reference table. Cross reference table will be rebuilt. Reason: {0}", (Object[])new Object[]{ex.getMessage()}));
        } else {
            logger.error("Error occurred while reading cross reference table. Cross reference table will be rebuilt. No additional information available");
        }
    }

    static class XrefProcessor {
        XrefProcessor() {
        }

        void processXref(PdfXrefTable xrefTable, PdfTokenizer tokenizer) throws IOException {
        }
    }

    public static enum StrictnessLevel {
        CONSERVATIVE(5000),
        LENIENT(3000);

        private final int levelValue;

        private StrictnessLevel(int levelValue) {
            this.levelValue = levelValue;
        }

        public boolean isStricter(StrictnessLevel compareWith) {
            return compareWith == null || this.levelValue > compareWith.levelValue;
        }
    }

    protected static class ReusableRandomAccessSource
    implements IRandomAccessSource {
        private ByteBuffer buffer;

        public ReusableRandomAccessSource(ByteBuffer buffer) {
            if (buffer == null) {
                throw new IllegalArgumentException("Passed byte buffer can not be null.");
            }
            this.buffer = buffer;
        }

        public int get(long offset) {
            if (offset >= (long)this.buffer.size()) {
                return -1;
            }
            return 0xFF & this.buffer.getInternalBuffer()[(int)offset];
        }

        public int get(long offset, byte[] bytes, int off, int len) {
            if (this.buffer == null) {
                throw new IllegalStateException("Already closed");
            }
            if (offset >= (long)this.buffer.size()) {
                return -1;
            }
            if (offset + (long)len > (long)this.buffer.size()) {
                len = (int)((long)this.buffer.size() - offset);
            }
            System.arraycopy(this.buffer.getInternalBuffer(), (int)offset, bytes, off, len);
            return len;
        }

        public long length() {
            return this.buffer.size();
        }

        public void close() {
            this.buffer = null;
        }
    }
}

