/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.mac;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.commons.bouncycastle.asn1.IASN1InputStream;
import com.itextpdf.commons.bouncycastle.asn1.IASN1ObjectIdentifier;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Sequence;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Set;
import com.itextpdf.commons.bouncycastle.asn1.IASN1TaggedObject;
import com.itextpdf.commons.bouncycastle.asn1.IDEROctetString;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.mac.MacContainerReader;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

class MacSignatureContainerReader
extends MacContainerReader {
    private static final IBouncyCastleFactory BC_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private static final String ID_ATTR_PDF_MAC_DATA = "1.0.32004.1.2";

    MacSignatureContainerReader(PdfDictionary authDictionary) {
        super(authDictionary);
    }

    @Override
    byte[] parseSignature(PdfDictionary authDictionary) {
        PdfDictionary signatureDictionary = MacSignatureContainerReader.getSignatureDictionary(authDictionary);
        PdfString contentsString = signatureDictionary.getAsString(PdfName.Contents);
        contentsString.markAsUnencryptedObject();
        return MacSignatureContainerReader.parseSignatureValueFromSignatureContainer(contentsString.getValueBytes());
    }

    @Override
    long[] parseByteRange(PdfDictionary authDictionary) {
        PdfDictionary signatureDictionary = MacSignatureContainerReader.getSignatureDictionary(authDictionary);
        return signatureDictionary.getAsArray(PdfName.ByteRange).toLongArray();
    }

    @Override
    byte[] parseMacContainer(PdfDictionary authDictionary) {
        PdfDictionary signatureDictionary = MacSignatureContainerReader.getSignatureDictionary(authDictionary);
        PdfString contentsString = signatureDictionary.getAsString(PdfName.Contents);
        contentsString.markAsUnencryptedObject();
        return MacSignatureContainerReader.parseMacContainerFromSignatureContainer(contentsString.getValueBytes());
    }

    private static byte[] parseSignatureValueFromSignatureContainer(byte[] signature) {
        try {
            IASN1Sequence signerInfoSeq = MacSignatureContainerReader.parseSignerInfoSequence(signature);
            int signatureValueIndex = 3;
            IASN1TaggedObject taggedSignedAttributes = BC_FACTORY.createASN1TaggedObject(signerInfoSeq.getObjectAt(signatureValueIndex));
            if (taggedSignedAttributes != null) {
                ++signatureValueIndex;
            }
            IDEROctetString signatureDataOS = BC_FACTORY.createDEROctetString(signerInfoSeq.getObjectAt(++signatureValueIndex));
            return signatureDataOS.getOctets();
        }
        catch (Exception e) {
            throw new PdfException("Exception occurred during signature parsing. It is not possible to extract MAC.", e);
        }
    }

    private static byte[] parseMacContainerFromSignatureContainer(byte[] signature) {
        try {
            IASN1Sequence signerInfoSeq = MacSignatureContainerReader.parseSignerInfoSequence(signature);
            int unsignedAttributesIndex = 3;
            IASN1TaggedObject taggedSignedAttributes = BC_FACTORY.createASN1TaggedObject(signerInfoSeq.getObjectAt(unsignedAttributesIndex));
            if (taggedSignedAttributes != null) {
                ++unsignedAttributesIndex;
            }
            if (signerInfoSeq.size() > (unsignedAttributesIndex += 2)) {
                IASN1Set unsignedAttributes = BC_FACTORY.createASN1Set(BC_FACTORY.createASN1TaggedObject(signerInfoSeq.getObjectAt(unsignedAttributesIndex)), false);
                for (int i = 0; i < unsignedAttributes.size(); ++i) {
                    IASN1Sequence attrSeq = BC_FACTORY.createASN1Sequence(unsignedAttributes.getObjectAt(i));
                    IASN1ObjectIdentifier attrType = BC_FACTORY.createASN1ObjectIdentifier(attrSeq.getObjectAt(0));
                    if (!ID_ATTR_PDF_MAC_DATA.equals(attrType.getId())) continue;
                    IASN1Set macSet = BC_FACTORY.createASN1Set(attrSeq.getObjectAt(1));
                    return macSet.getObjectAt(0).toASN1Primitive().getEncoded();
                }
            }
        }
        catch (Exception e) {
            throw new PdfException("Exception occurred during signature parsing. It is not possible to extract MAC.", e);
        }
        throw new PdfException("Signature doesn't contain unsigned MAC attribute, which is required in \"attached to signature\" mode.");
    }

    private static PdfDictionary getSignatureDictionary(PdfDictionary authDictionary) {
        if (authDictionary.getAsDictionary(PdfName.SigObjRef) == null) {
            throw new PdfException("AuthCode dictionary doesn't contain SigObjRef entry, which is required in signature mode.");
        }
        return authDictionary.getAsDictionary(PdfName.SigObjRef);
    }

    private static IASN1Sequence parseSignerInfoSequence(byte[] signature) throws IOException {
        try (IASN1InputStream is = BC_FACTORY.createASN1InputStream((InputStream)new ByteArrayInputStream(signature));){
            IASN1Sequence contentInfo = BC_FACTORY.createASN1Sequence((IASN1Encodable)is.readObject());
            IASN1Sequence signedData = BC_FACTORY.createASN1Sequence((IASN1Encodable)BC_FACTORY.createASN1TaggedObject(contentInfo.getObjectAt(1)).getObject());
            int signerInfoIndex = 4;
            IASN1TaggedObject taggedObj = BC_FACTORY.createASN1TaggedObject(signedData.getObjectAt(signerInfoIndex));
            if (taggedObj != null) {
                ++signerInfoIndex;
            }
            IASN1Sequence iASN1Sequence = BC_FACTORY.createASN1Sequence(BC_FACTORY.createASN1Set(signedData.getObjectAt(signerInfoIndex)).getObjectAt(0));
            return iASN1Sequence;
        }
    }
}

